"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.QueryInsightsPlugin = void 0;
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const QueryInsightsPlugin = function (Client, config, components) {
  const ca = components.clientAction.factory;
  Client.prototype.queryInsights = components.clientAction.namespaceFactory();
  const queryInsights = Client.prototype.queryInsights.prototype;
  queryInsights.getTopNQueries = ca({
    url: {
      fmt: `/_insights/top_queries`
    },
    method: 'GET'
  });
  queryInsights.getTopNQueriesLatency = ca({
    url: {
      fmt: `/_insights/top_queries?type=latency&from=<%=from%>&to=<%=to%>&verbose=<%=verbose%>`,
      req: {
        from: {
          type: 'string',
          required: true
        },
        to: {
          type: 'string',
          required: true
        },
        verbose: {
          type: 'boolean',
          required: true
        }
      }
    },
    method: 'GET'
  });
  queryInsights.getTopNQueriesCpu = ca({
    url: {
      fmt: `/_insights/top_queries?type=cpu&from=<%=from%>&to=<%=to%>&verbose=<%=verbose%>`,
      req: {
        from: {
          type: 'string',
          required: true
        },
        to: {
          type: 'string',
          required: true
        },
        verbose: {
          type: 'boolean',
          required: true
        }
      }
    },
    method: 'GET'
  });
  queryInsights.getTopNQueriesMemory = ca({
    url: {
      fmt: `/_insights/top_queries?type=memory&from=<%=from%>&to=<%=to%>&verbose=<%=verbose%>`,
      req: {
        from: {
          type: 'string',
          required: true
        },
        to: {
          type: 'string',
          required: true
        },
        verbose: {
          type: 'boolean',
          required: true
        }
      }
    },
    method: 'GET'
  });
  queryInsights.getTopNQueriesLatencyForId = ca({
    url: {
      fmt: `/_insights/top_queries?type=latency&from=<%=from%>&to=<%=to%><% if (id) { %>&id=<%=id%><% } %>&verbose=<%=verbose%>`,
      req: {
        from: {
          type: 'string',
          required: true
        },
        to: {
          type: 'string',
          required: true
        },
        id: {
          type: 'string',
          required: true
        },
        verbose: {
          type: 'boolean',
          required: true
        }
      }
    },
    method: 'GET'
  });
  queryInsights.getTopNQueriesCpuForId = ca({
    url: {
      fmt: `/_insights/top_queries?type=cpu&from=<%=from%>&to=<%=to%><% if (id) { %>&id=<%=id%><% } %>&verbose=<%=verbose%>`,
      req: {
        from: {
          type: 'string',
          required: true
        },
        to: {
          type: 'string',
          required: true
        },
        id: {
          type: 'string',
          required: true
        },
        verbose: {
          type: 'boolean',
          required: true
        }
      }
    },
    method: 'GET'
  });
  queryInsights.getTopNQueriesMemoryForId = ca({
    url: {
      fmt: `/_insights/top_queries?type=memory&from=<%=from%>&to=<%=to%><% if (id) { %>&id=<%=id%><% } %>&verbose=<%=verbose%>`,
      req: {
        from: {
          type: 'string',
          required: true
        },
        to: {
          type: 'string',
          required: true
        },
        id: {
          type: 'string',
          required: true
        },
        verbose: {
          type: 'boolean',
          required: true
        }
      }
    },
    method: 'GET'
  });
  queryInsights.getSettings = ca({
    url: {
      fmt: `_cluster/settings?include_defaults=true`
    },
    method: 'GET'
  });
  queryInsights.setSettings = ca({
    url: {
      fmt: `_cluster/settings`
    },
    method: 'PUT',
    needBody: true
  });
  queryInsights.getLiveQueries = ca({
    url: {
      fmt: `/_insights/live_queries`
    },
    method: 'GET'
  });
  queryInsights.getLiveQueriesWLMGroup = ca({
    url: {
      fmt: `/_insights/live_queries?wlmGroupId=<%=wlmGroupId%>`,
      req: {
        wlmGroupId: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'GET'
  });
  queryInsights.cancelTask = ca({
    url: {
      fmt: `/_tasks/<%=taskId%>/_cancel`,
      req: {
        taskId: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'POST'
  });
};
exports.QueryInsightsPlugin = QueryInsightsPlugin;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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