"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MLAgentRouterFactory = void 0;
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

/**
 * Abstract interface for ML agent routing strategies
 * This allows different environments to implement their own ML agent communication
 * while keeping the route handler logic identical
 */

/**
 * Factory for managing the ML agent router
 * Simplified to handle a single router since only one is ever registered
 */
class MLAgentRouterFactory {
  /**
   * Register a router implementation
   * @param router The router to register
   */
  static registerRouter(router) {
    this.router = router;
  }

  /**
   * Get the registered router
   * @returns The registered router or undefined if none available
   */
  static getRouter() {
    return this.router;
  }

  /**
   * Clear the registered router (primarily for testing)
   */
  static clearRouters() {
    this.router = undefined;
  }
}
exports.MLAgentRouterFactory = MLAgentRouterFactory;
_defineProperty(MLAgentRouterFactory, "router", void 0);