/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.phoenix;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.sax.SAXSource;
import net.sf.mpxj.ChildTaskContainer;
import net.sf.mpxj.Day;
import net.sf.mpxj.Duration;
import net.sf.mpxj.EventManager;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectCalendarHours;
import net.sf.mpxj.ProjectCalendarWeek;
import net.sf.mpxj.ProjectConfig;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ProjectProperties;
import net.sf.mpxj.Rate;
import net.sf.mpxj.RelationType;
import net.sf.mpxj.Resource;
import net.sf.mpxj.Task;
import net.sf.mpxj.TaskField;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.common.AlphanumComparator;
import net.sf.mpxj.common.DateHelper;
import net.sf.mpxj.common.NumberHelper;
import net.sf.mpxj.listener.ProjectListener;
import net.sf.mpxj.phoenix.SkipNulInputStream;
import net.sf.mpxj.phoenix.schema.Project;
import net.sf.mpxj.reader.AbstractProjectReader;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public final class PhoenixReader
extends AbstractProjectReader {
    private ProjectFile m_projectFile;
    private Map<String, Task> m_activityMap;
    private Map<UUID, String> m_activityCodeValues;
    Map<UUID, Integer> m_activityCodeSequence;
    private Map<Project.Storepoints.Storepoint.Activities.Activity, Map<UUID, UUID>> m_activityCodeCache;
    private EventManager m_eventManager;
    private List<ProjectListener> m_projectListeners;
    List<UUID> m_codeSequence;
    private static JAXBContext CONTEXT;
    private static JAXBException CONTEXT_EXCEPTION;

    @Override
    public void addProjectListener(ProjectListener projectListener) {
        if (this.m_projectListeners == null) {
            this.m_projectListeners = new LinkedList<ProjectListener>();
        }
        this.m_projectListeners.add(projectListener);
    }

    @Override
    public ProjectFile read(InputStream inputStream) throws MPXJException {
        try {
            this.m_projectFile = new ProjectFile();
            this.m_activityMap = new HashMap<String, Task>();
            this.m_activityCodeValues = new HashMap<UUID, String>();
            this.m_activityCodeSequence = new HashMap<UUID, Integer>();
            this.m_activityCodeCache = new HashMap<Project.Storepoints.Storepoint.Activities.Activity, Map<UUID, UUID>>();
            this.m_codeSequence = new ArrayList<UUID>();
            this.m_eventManager = this.m_projectFile.getEventManager();
            ProjectConfig projectConfig = this.m_projectFile.getProjectConfig();
            projectConfig.setAutoResourceUniqueID(true);
            projectConfig.setAutoOutlineLevel(false);
            projectConfig.setAutoOutlineNumber(false);
            projectConfig.setAutoWBS(false);
            this.m_projectFile.getProjectProperties().setFileApplication("Phoenix");
            this.m_projectFile.getProjectProperties().setFileType("PPX");
            this.m_projectFile.getCustomFields().getCustomField(TaskField.TEXT1).setAlias("Code");
            this.m_eventManager.addProjectListeners(this.m_projectListeners);
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            XMLReader xMLReader = sAXParser.getXMLReader();
            SAXSource sAXSource = new SAXSource(xMLReader, new InputSource(new SkipNulInputStream(inputStream)));
            if (CONTEXT == null) {
                throw CONTEXT_EXCEPTION;
            }
            Unmarshaller unmarshaller = CONTEXT.createUnmarshaller();
            Project project = (Project)unmarshaller.unmarshal(sAXSource);
            Project.Storepoints.Storepoint storepoint = this.getCurrentStorepoint(project);
            this.readProjectProperties(project.getSettings());
            this.readCalendars(storepoint);
            this.readTasks(project, storepoint);
            this.readResources(storepoint);
            this.readRelationships(storepoint);
            projectConfig.updateUniqueCounters();
            ProjectFile projectFile = this.m_projectFile;
            return projectFile;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new MPXJException("Failed to parse file", parserConfigurationException);
        }
        catch (JAXBException jAXBException) {
            throw new MPXJException("Failed to parse file", jAXBException);
        }
        catch (SAXException sAXException) {
            throw new MPXJException("Failed to parse file", sAXException);
        }
        finally {
            this.m_projectFile = null;
            this.m_activityMap = null;
            this.m_activityCodeValues = null;
            this.m_activityCodeSequence = null;
            this.m_activityCodeCache = null;
            this.m_codeSequence = null;
        }
    }

    private void readProjectProperties(Project.Settings settings) {
        ProjectProperties projectProperties = this.m_projectFile.getProjectProperties();
        projectProperties.setName(settings.getTitle());
        projectProperties.setDefaultDurationUnits(settings.getBaseunit());
    }

    private void readCalendars(Project.Storepoints.Storepoint storepoint) {
        Project.Storepoints.Storepoint.Calendars calendars = storepoint.getCalendars();
        if (calendars != null) {
            for (Project.Storepoints.Storepoint.Calendars.Calendar calendar : calendars.getCalendar()) {
                this.readCalendar(calendar);
            }
            ProjectCalendar projectCalendar = this.m_projectFile.getCalendarByName(storepoint.getDefaultCalendar());
            if (projectCalendar != null) {
                this.m_projectFile.getProjectProperties().setDefaultCalendarName(projectCalendar.getName());
            }
        }
    }

    private void readCalendar(Project.Storepoints.Storepoint.Calendars.Calendar calendar) {
        ProjectCalendar projectCalendar = this.m_projectFile.addCalendar();
        projectCalendar.setName(calendar.getName());
        for (Day day : Day.values()) {
            projectCalendar.setWorkingDay(day, true);
        }
        List<Project.Storepoints.Storepoint.Calendars.Calendar.NonWork> list = calendar.getNonWork();
        Day[] dayArray = list.iterator();
        while (dayArray.hasNext()) {
            Project.Storepoints.Storepoint.Calendars.Calendar.NonWork nonWork = (Project.Storepoints.Storepoint.Calendars.Calendar.NonWork)dayArray.next();
            if (!nonWork.getType().equals("internal_weekly")) continue;
            projectCalendar.setWorkingDay(nonWork.getWeekday(), false);
        }
        for (Day day : Day.values()) {
            if (!projectCalendar.isWorkingDay(day)) continue;
            ProjectCalendarHours projectCalendarHours = projectCalendar.addCalendarHours(day);
            projectCalendarHours.addRange(ProjectCalendarWeek.DEFAULT_WORKING_MORNING);
            projectCalendarHours.addRange(ProjectCalendarWeek.DEFAULT_WORKING_AFTERNOON);
        }
    }

    private void readResources(Project.Storepoints.Storepoint storepoint) {
        Project.Storepoints.Storepoint.Resources resources = storepoint.getResources();
        if (resources != null) {
            for (Project.Storepoints.Storepoint.Resources.Resource resource : resources.getResource()) {
                Resource resource2 = this.readResource(resource);
                this.readAssignments(resource2, resource);
            }
        }
    }

    private Resource readResource(Project.Storepoints.Storepoint.Resources.Resource resource) {
        Resource resource2 = this.m_projectFile.addResource();
        TimeUnit timeUnit = resource.getMonetarybase();
        if (timeUnit == null) {
            timeUnit = TimeUnit.HOURS;
        }
        resource2.setCostPerUse(resource.getMonetarycostperuse());
        resource2.setStandardRate(new Rate(resource.getMonetaryrate(), timeUnit));
        resource2.setStandardRateUnits(timeUnit);
        resource2.setName(resource.getName());
        resource2.setType(resource.getType());
        resource2.setMaterialLabel(resource.getUnitslabel());
        resource2.setGUID(resource.getUuid());
        this.m_eventManager.fireResourceReadEvent(resource2);
        return resource2;
    }

    private void readTasks(Project project, Project.Storepoints.Storepoint storepoint) {
        this.processLayouts(project);
        this.processActivityCodes(storepoint);
        this.processActivities(storepoint);
        this.updateDates();
    }

    private void processActivityCodes(Project.Storepoints.Storepoint storepoint) {
        for (Project.Storepoints.Storepoint.ActivityCodes.Code code : storepoint.getActivityCodes().getCode()) {
            int n = 0;
            for (Project.Storepoints.Storepoint.ActivityCodes.Code.Value value : code.getValue()) {
                UUID uUID = this.getUUID(value.getUuid(), value.getName());
                this.m_activityCodeValues.put(uUID, value.getName());
                this.m_activityCodeSequence.put(uUID, ++n);
            }
        }
    }

    private void processLayouts(Project project) {
        Project.Layouts.Layout layout = this.getActiveLayout(project);
        for (Project.Layouts.Layout.CodeOptions.CodeOption codeOption : layout.getCodeOptions().getCodeOption()) {
            if (!codeOption.isShown().booleanValue()) continue;
            this.m_codeSequence.add(this.getUUID(codeOption.getCodeUuid(), codeOption.getCode()));
        }
    }

    private Project.Layouts.Layout getActiveLayout(Project project) {
        Project.Layouts.Layout layout = project.getLayouts().getLayout().get(0);
        if (!layout.isActive().booleanValue()) {
            for (Project.Layouts.Layout layout2 : project.getLayouts().getLayout()) {
                if (!layout2.isActive().booleanValue()) continue;
                layout = layout2;
                break;
            }
        }
        return layout;
    }

    private void processActivities(Project.Storepoints.Storepoint storepoint) {
        final AlphanumComparator alphanumComparator = new AlphanumComparator();
        List<Project.Storepoints.Storepoint.Activities.Activity> list = storepoint.getActivities().getActivity();
        Collections.sort(list, new Comparator<Project.Storepoints.Storepoint.Activities.Activity>(){
            final /* synthetic */ PhoenixReader this$0;
            {
                this.this$0 = phoenixReader;
            }

            @Override
            public int compare(Project.Storepoints.Storepoint.Activities.Activity activity, Project.Storepoints.Storepoint.Activities.Activity activity2) {
                Map<UUID, UUID> map = this.this$0.getActivityCodes(activity);
                Map<UUID, UUID> map2 = this.this$0.getActivityCodes(activity2);
                for (UUID uUID : this.this$0.m_codeSequence) {
                    UUID uUID2 = map.get(uUID);
                    UUID uUID3 = map2.get(uUID);
                    if (uUID2 == null || uUID3 == null) {
                        if (uUID2 == null && uUID3 == null) continue;
                        if (uUID2 == null) {
                            return -1;
                        }
                        if (uUID3 == null) {
                            return 1;
                        }
                    }
                    if (uUID2.equals(uUID3)) continue;
                    Integer n = this.this$0.m_activityCodeSequence.get(uUID2);
                    Integer n2 = this.this$0.m_activityCodeSequence.get(uUID3);
                    return NumberHelper.compare(n, n2);
                }
                return alphanumComparator.compare(activity.getId(), activity2.getId());
            }
        });
        for (Project.Storepoints.Storepoint.Activities.Activity activity : list) {
            this.processActivity(activity);
        }
    }

    private void processActivity(Project.Storepoints.Storepoint.Activities.Activity activity) {
        Task task = this.getParentTask(activity).addTask();
        task.setText(1, activity.getId());
        task.setActualDuration(activity.getActualDuration());
        task.setActualFinish(activity.getActualFinish());
        task.setActualStart(activity.getActualStart());
        task.setCreateDate(activity.getCreationTime());
        task.setFinish(activity.getCurrentFinish());
        task.setStart(activity.getCurrentStart());
        task.setName(activity.getDescription());
        task.setDuration(activity.getDurationAtCompletion());
        task.setEarlyFinish(activity.getEarlyFinish());
        task.setEarlyStart(activity.getEarlyStart());
        task.setFreeSlack(activity.getFreeFloat());
        task.setLateFinish(activity.getLateFinish());
        task.setLateStart(activity.getLateStart());
        task.setNotes(activity.getNotes());
        task.setBaselineDuration(activity.getOriginalDuration());
        task.setPhysicalPercentComplete(activity.getPhysicalPercentComplete());
        task.setRemainingDuration(activity.getRemainingDuration());
        task.setCost(activity.getTotalCost());
        task.setTotalSlack(activity.getTotalFloat());
        task.setMilestone(this.activityIsMilestone(activity));
        task.setGUID(activity.getUuid());
        if (task.getMilestone()) {
            if (this.activityIsStartMilestone(activity)) {
                task.setFinish(task.getStart());
            } else {
                task.setStart(task.getFinish());
            }
        }
        if (task.getActualStart() == null) {
            task.setPercentageComplete(0);
        } else if (task.getActualFinish() != null) {
            task.setPercentageComplete(100);
        } else {
            Duration duration = activity.getRemainingDuration();
            Duration duration2 = activity.getDurationAtCompletion();
            if (duration != null && duration2 != null && duration2.getDuration() != 0.0) {
                double d = (duration2.getDuration() - duration.getDuration()) * 100.0 / duration2.getDuration();
                task.setPercentageComplete(d);
            }
        }
        this.m_activityMap.put(activity.getId(), task);
    }

    private boolean activityIsMilestone(Project.Storepoints.Storepoint.Activities.Activity activity) {
        String string = activity.getType();
        return string != null && string.indexOf("Milestone") != -1;
    }

    private boolean activityIsStartMilestone(Project.Storepoints.Storepoint.Activities.Activity activity) {
        String string = activity.getType();
        return string != null && string.indexOf("StartMilestone") != -1;
    }

    private ChildTaskContainer getParentTask(Project.Storepoints.Storepoint.Activities.Activity activity) {
        Map<UUID, UUID> map = this.getActivityCodes(activity);
        ChildTaskContainer childTaskContainer = this.m_projectFile;
        StringBuilder stringBuilder = new StringBuilder();
        for (UUID uUID : this.m_codeSequence) {
            UUID uUID2 = map.get(uUID);
            String string = this.m_activityCodeValues.get(uUID2);
            if (string == null) continue;
            if (stringBuilder.length() != 0) {
                stringBuilder.append('>');
            }
            stringBuilder.append(uUID2.toString());
            UUID uUID3 = UUID.nameUUIDFromBytes(stringBuilder.toString().getBytes());
            Task task = this.findChildTaskByUUID(childTaskContainer, uUID3);
            if (task == null) {
                task = childTaskContainer.addTask();
                task.setGUID(uUID3);
                task.setName(string);
            }
            childTaskContainer = task;
        }
        return childTaskContainer;
    }

    private Task findChildTaskByUUID(ChildTaskContainer childTaskContainer, UUID uUID) {
        Task task = null;
        for (Task task2 : childTaskContainer.getChildTasks()) {
            if (!uUID.equals(task2.getGUID())) continue;
            task = task2;
            break;
        }
        return task;
    }

    private void readAssignments(Resource resource, Project.Storepoints.Storepoint.Resources.Resource resource2) {
        for (Project.Storepoints.Storepoint.Resources.Resource.Assignment assignment : resource2.getAssignment()) {
            this.readAssignment(resource, assignment);
        }
    }

    private void readAssignment(Resource resource, Project.Storepoints.Storepoint.Resources.Resource.Assignment assignment) {
        Task task = this.m_activityMap.get(assignment.getActivity());
        if (task != null) {
            task.addResourceAssignment(resource);
        }
    }

    private void readRelationships(Project.Storepoints.Storepoint storepoint) {
        for (Project.Storepoints.Storepoint.Relationships.Relationship relationship : storepoint.getRelationships().getRelationship()) {
            this.readRelation(relationship);
        }
    }

    private void readRelation(Project.Storepoints.Storepoint.Relationships.Relationship relationship) {
        Task task = this.m_projectFile.getTaskByUniqueID(relationship.getPredecessor());
        Task task2 = this.m_projectFile.getTaskByUniqueID(relationship.getSuccessor());
        if (task != null && task2 != null) {
            Duration duration = relationship.getLag();
            RelationType relationType = relationship.getType();
            task2.addPredecessor(task, relationType, duration);
        }
    }

    Map<UUID, UUID> getActivityCodes(Project.Storepoints.Storepoint.Activities.Activity activity) {
        Map<UUID, UUID> map = this.m_activityCodeCache.get(activity);
        if (map == null) {
            map = new HashMap<UUID, UUID>();
            this.m_activityCodeCache.put(activity, map);
            for (Project.Storepoints.Storepoint.Activities.Activity.CodeAssignment codeAssignment : activity.getCodeAssignment()) {
                UUID uUID = this.getUUID(codeAssignment.getCodeUuid(), codeAssignment.getCode());
                UUID uUID2 = this.getUUID(codeAssignment.getValueUuid(), codeAssignment.getValue());
                map.put(uUID, uUID2);
            }
        }
        return map;
    }

    private Project.Storepoints.Storepoint getCurrentStorepoint(Project project) {
        List<Project.Storepoints.Storepoint> list = project.getStorepoints().getStorepoint();
        Collections.sort(list, new Comparator<Project.Storepoints.Storepoint>(this){

            @Override
            public int compare(Project.Storepoints.Storepoint storepoint, Project.Storepoints.Storepoint storepoint2) {
                return DateHelper.compare(storepoint2.getCreationTime(), storepoint.getCreationTime());
            }
        });
        return list.get(0);
    }

    private UUID getUUID(UUID uUID, String string) {
        return uUID == null ? UUID.nameUUIDFromBytes(string.getBytes()) : uUID;
    }

    private void updateDates() {
        for (Task task : this.m_projectFile.getChildTasks()) {
            this.updateDates(task);
        }
    }

    private void updateDates(Task task) {
        if (task.getSummary()) {
            int n = 0;
            Date date = task.getStart();
            Date date2 = task.getFinish();
            Date date3 = task.getActualStart();
            Date date4 = task.getActualFinish();
            Date date5 = task.getEarlyStart();
            Date date6 = task.getEarlyFinish();
            Date date7 = task.getLateStart();
            Date date8 = task.getLateFinish();
            for (Task task2 : task.getChildTasks()) {
                this.updateDates(task2);
                date = DateHelper.min(date, task2.getStart());
                date2 = DateHelper.max(date2, task2.getFinish());
                date3 = DateHelper.min(date3, task2.getActualStart());
                date4 = DateHelper.max(date4, task2.getActualFinish());
                date5 = DateHelper.min(date5, task2.getEarlyStart());
                date6 = DateHelper.max(date6, task2.getEarlyFinish());
                date7 = DateHelper.min(date7, task2.getLateStart());
                date8 = DateHelper.max(date8, task2.getLateFinish());
                if (task2.getActualFinish() == null) continue;
                ++n;
            }
            task.setStart(date);
            task.setFinish(date2);
            task.setActualStart(date3);
            task.setEarlyStart(date5);
            task.setEarlyFinish(date6);
            task.setLateStart(date7);
            task.setLateFinish(date8);
            if (n == task.getChildTasks().size()) {
                task.setActualFinish(date4);
            }
            Object object = null;
            if (date != null && date2 != null) {
                object = this.m_projectFile.getDefaultCalendar().getWork(date, date2, TimeUnit.DAYS);
                task.setDuration((Duration)object);
            }
        }
    }

    static {
        try {
            System.setProperty("com.sun.xml.bind.v2.runtime.JAXBContextImpl.fastBoot", "true");
            CONTEXT = JAXBContext.newInstance("net.sf.mpxj.phoenix.schema", PhoenixReader.class.getClassLoader());
        }
        catch (JAXBException jAXBException) {
            CONTEXT_EXCEPTION = jAXBException;
            CONTEXT = null;
        }
    }
}

