/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema.keyword;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.ExecutionContext;
import com.networknt.schema.MessageSourceError;
import com.networknt.schema.Schema;
import com.networknt.schema.SchemaContext;
import com.networknt.schema.SchemaLocation;
import com.networknt.schema.SpecificationVersionRange;
import com.networknt.schema.annotation.Annotation;
import com.networknt.schema.keyword.BaseKeywordValidator;
import com.networknt.schema.keyword.KeywordType;
import com.networknt.schema.path.NodePath;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class UnevaluatedItemsValidator
extends BaseKeywordValidator {
    private final Schema schema;
    private final boolean isMinV202012;

    public UnevaluatedItemsValidator(SchemaLocation schemaLocation, JsonNode schemaNode, Schema parentSchema, SchemaContext schemaContext) {
        super(KeywordType.UNEVALUATED_ITEMS, schemaNode, schemaLocation, parentSchema, schemaContext);
        this.isMinV202012 = SpecificationVersionRange.MIN_DRAFT_2020_12.getVersions().contains((Object)schemaContext.getDialect().getSpecificationVersion());
        if (!schemaNode.isObject() && !schemaNode.isBoolean()) {
            throw new IllegalArgumentException("The value of 'unevaluatedItems' MUST be a valid JSON Schema.");
        }
        this.schema = schemaContext.newSchema(schemaLocation, schemaNode, parentSchema);
    }

    @Override
    public void validate(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, NodePath instanceLocation) {
        if (!node.isArray()) {
            return;
        }
        String itemsKeyword = this.isMinV202012 ? "prefixItems" : "items";
        String additionalItemsKeyword = this.isMinV202012 ? "items" : "additionalItems";
        boolean valid = false;
        int validCount = 0;
        boolean evaluated = false;
        Predicate<Annotation> validEvaluationPathFilter = a -> a.isValid();
        Predicate<Annotation> adjacentEvaluationPathFilter = a -> a.getEvaluationPath().startsWith(executionContext.getEvaluationPath().getParent());
        List instanceLocationAnnotations = executionContext.getAnnotations().asMap().getOrDefault(instanceLocation, Collections.emptyList());
        if (this.getSchemaNode().isBoolean() && this.getSchemaNode().booleanValue()) {
            valid = true;
            if (!node.isEmpty()) {
                evaluated = true;
            }
        } else {
            List items = instanceLocationAnnotations.stream().filter(a -> itemsKeyword.equals(a.getKeyword())).filter(adjacentEvaluationPathFilter).filter(validEvaluationPathFilter).collect(Collectors.toList());
            if (items.isEmpty()) {
                valid = false;
            } else {
                for (Object annotation : items) {
                    if (((Annotation)annotation).getValue() instanceof Number) {
                        Number value = (Number)((Annotation)annotation).getValue();
                        int existing = value.intValue();
                        if (existing <= validCount) continue;
                        validCount = existing;
                        continue;
                    }
                    if (!(((Annotation)annotation).getValue() instanceof Boolean)) continue;
                    valid = true;
                }
            }
            if (!valid) {
                List additionalItems = instanceLocationAnnotations.stream().filter(a -> additionalItemsKeyword.equals(a.getKeyword())).filter(adjacentEvaluationPathFilter).filter(validEvaluationPathFilter).collect(Collectors.toList());
                for (Annotation annotation : additionalItems) {
                    if (!(annotation.getValue() instanceof Boolean) || !Boolean.TRUE.equals(annotation.getValue())) continue;
                    valid = true;
                }
            }
            if (!valid) {
                List unevaluatedItems = instanceLocationAnnotations.stream().filter(a -> "unevaluatedItems".equals(a.getKeyword())).filter(adjacentEvaluationPathFilter).filter(validEvaluationPathFilter).collect(Collectors.toList());
                for (Annotation annotation : unevaluatedItems) {
                    if (!(annotation.getValue() instanceof Boolean) || !Boolean.TRUE.equals(annotation.getValue())) continue;
                    valid = true;
                }
            }
        }
        if (!valid) {
            int currentErrors = executionContext.getErrors().size();
            List contains = instanceLocationAnnotations.stream().filter(a -> "contains".equals(a.getKeyword())).filter(adjacentEvaluationPathFilter).filter(validEvaluationPathFilter).collect(Collectors.toList());
            HashSet containsEvaluated = new HashSet();
            boolean containsEvaluatedAll = false;
            for (Annotation a2 : contains) {
                if (a2.getValue() instanceof List) {
                    List values = (List)a2.getValue();
                    containsEvaluated.addAll(values);
                    continue;
                }
                if (!(a2.getValue() instanceof Boolean)) continue;
                containsEvaluatedAll = true;
            }
            if (!containsEvaluatedAll) {
                for (int x = validCount; x < node.size(); ++x) {
                    if (containsEvaluated.contains(x)) continue;
                    if (this.schemaNode.isBoolean() && !this.schemaNode.booleanValue()) {
                        executionContext.addError(((MessageSourceError.Builder)((MessageSourceError.Builder)((MessageSourceError.Builder)((MessageSourceError.Builder)((MessageSourceError.Builder)this.error().instanceNode(node)).instanceLocation(instanceLocation)).arguments(x)).evaluationPath(executionContext.getEvaluationPath())).locale(executionContext.getExecutionConfig().getLocale())).build());
                    } else {
                        this.schema.validate(executionContext, node.get(x), node, instanceLocation.append(x));
                    }
                    evaluated = true;
                }
            }
            if (currentErrors == executionContext.getErrors().size()) {
                valid = true;
            }
        }
        if (evaluated) {
            executionContext.getAnnotations().put(Annotation.builder().instanceLocation(instanceLocation).evaluationPath(executionContext.getEvaluationPath()).schemaLocation(this.schemaLocation).keyword("unevaluatedItems").value(true).build());
        }
    }
}

