/**
*
* Jquery Mapael - Dynamic maps jQuery plugin (based on raphael.js)
* Requires jQuery and raphael.js
*
* Map of Guyane
* Equirectangular projection

* @author CCM Benchmark Group
* @source http://commons.wikimedia.org/wiki/File:Guyane_department_location_map.svg
*/
(function($) {
	$.extend(true, $.fn.mapael, 
		{
			maps :  {
				france_region_03 : {
					width : 44.022598,
					height : 49.128056,
					getCoords : function (lat, lon) {
						var xfactor = 14.877907532954;
						var xoffset = 811.95256630287;
						var x = (lon * xfactor) + xoffset;
						
						var yfactor = -13.494388491278;
						var yoffset = 77.65459868297;
						var y = (lat * yfactor) + yoffset;
						return {x : x, y : y};
					},
					elems : {
					    "department-973" : "m 6.78,33.65 c 0.01,0 0.02,-0 0.04,-0.02 0.05,-0.04 0.06,-0.13 0.13,-0.13 0.06,-0.04 0.18,-0.02 0.17,-0.12 -0.02,-0.1 0.08,-0.13 0.16,-0.15 0.05,-0.05 0.1,-0.1 0.13,-0.15 0.05,0 0.03,0.09 0.1,0.11 0.08,0.01 0.18,-0.01 0.27,-0.01 0.14,0.01 0.05,0.13 -0.03,0.15 -0.05,0.07 -0.16,0.06 -0.2,0.13 -0.06,0.09 0.13,0.14 0.07,0.02 0.02,-0.04 0.08,-0.09 0.11,-0.1 0.08,-0.02 0.14,-0.12 0.2,-0.17 -0.06,-0.03 -0.08,-0.11 -0.06,-0.18 -0.02,-0.11 0.17,-0.1 0.13,-0.23 0.03,-0.08 -0.08,-0.07 -0.08,-0.13 0.04,-0.05 0.13,-0.08 0.05,-0.15 -0.04,-0.09 0.11,-0.13 0.1,-0.22 0.02,-0.06 0.1,-0.11 0.07,-0.18 -0.07,-0.04 -0.04,-0.1 -1.5e-4,-0.15 -0.06,-0.08 0.02,-0.03 0.07,-0.04 0.04,-0.03 0.06,-0.1 0.09,-0.15 0.03,-0.11 0.16,-0.14 0.26,-0.18 0.1,-0.06 0.13,-0.18 0.21,-0.26 0.03,-0.06 0.13,-0.07 0.14,-0.14 0.05,-0.07 -0.07,-0.11 -0.05,-0.02 -0.11,0.01 0.03,-0.07 0.01,-0.11 0.05,-0.04 0.02,-0.1 0,-0.15 -0.02,-0.06 -0.1,-0.1 -0.08,-0.17 0,-0.06 -2e-5,-0.12 -0,-0.19 -0.01,-0.07 0.01,-0.14 0,-0.2 -0,-0.07 0.02,-0.15 0.05,-0.21 0.02,-0.05 0.08,-0.09 0.07,-0.15 -0.04,-0.04 -0.09,-0.06 -0.13,-0.11 -0.03,-0.06 0.12,-0.08 0.06,-0.15 0.03,-0.08 -0.03,-0.16 0.01,-0.24 0.06,-0.02 0.05,-0.07 0.09,-0.1 0.03,-0.07 0.16,-0.03 0.17,-0.11 0.05,-0.07 0.02,-0.15 0.05,-0.22 -0.01,-0.07 0.09,-0.11 0.04,-0.19 -0.01,-0.09 -0.09,-0.04 -0.14,-0.08 -0.06,-0.05 -0,-0.13 -0.05,-0.18 -0.04,-0.06 -0.06,-0.12 -0.1,-0.18 -0.05,-0.03 -0.05,-0.09 -0.12,-0.11 -0.07,-0.05 -0.15,-0.01 -0.22,0.02 -0.07,0.02 -0.11,0.09 -0.07,0.15 -0.04,0.08 -0.13,0.03 -0.21,0.03 -0.06,0.02 -0.2,0.02 -0.15,-0.07 0.04,-0.05 0.05,-0.13 0.01,-0.18 -0.03,-0.06 -0.09,-0.09 -0.15,-0.11 -0.06,-0.03 -0.11,-0.07 -0.17,-0.1 -0.06,-0.02 -0.12,-0.05 -0.12,-0.12 -0.02,-0.06 -0.12,-0.1 -0.08,-0.17 0.09,-0.01 0.06,-0.13 0.1,-0.18 0.03,-0.05 0.02,-0.12 -0.01,-0.17 -0.03,-0.05 -0.06,-0.1 -0.13,-0.14 -0.04,-0.03 -0.1,-0.06 -0.12,-0.11 -0.02,-0.06 -0.04,-0.12 -0.05,-0.18 -0.01,-0.08 -0.07,-0.12 -0.11,-0.18 -0.04,-0.04 -0.09,-0.09 -0.09,-0.15 -0.01,-0.06 -0.03,-0.12 -0.07,-0.17 0.01,-0.08 -0.08,-0.11 -0.12,-0.16 -0.04,-0.06 -0.12,-0.04 -0.18,-0.07 -0.06,-0.02 -0.13,-0.05 -0.19,-0.04 -0.07,0.01 -0.14,-0.04 -0.21,-0.02 -0.06,3.8e-4 -0.1,0.04 -0.16,0.05 -0.07,0.01 -0.15,0.04 -0.2,-0.01 -0.06,-0.02 -0.11,-0.07 -0.13,-0.12 -0,-0.05 -0.02,-0.12 0.06,-0.14 0.01,-0.06 0.05,-0.11 0.08,-0.17 0.03,-0.06 0.01,-0.12 -0.04,-0.17 -0.04,-0.04 -0.11,-0.08 -0.18,-0.06 -0.06,-0.03 -0.11,-0.07 -0.16,-0.12 -0.07,-0.03 -0.15,0.02 -0.22,-0.02 -0.05,-0.03 -0.09,-0.09 -0.07,-0.14 -0.03,-0.07 -0.15,-0.01 -0.15,-0.11 -0.02,-0.06 -0.07,-0.09 -0.07,-0.16 0.03,-0.06 0.01,-0.13 -0.05,-0.14 -0.07,-0.02 -0.03,-0.05 -0.07,-0.07 -0.02,-0.04 -0.03,-0.08 -0.1,-0.07 -0.07,0.02 -0.11,-0.09 -0.17,-0.01 -0.09,0.05 -0.03,-0.05 -0.02,-0.09 0.06,0.01 0.02,-0.1 -0,-0.06 0.01,0.09 -0.04,-0.03 -0.07,-0.02 -0.02,-0.06 -0.1,-0.06 -0.12,-0.12 -0.03,-0.04 -0,-0.09 -0.04,-0.13 -0.05,-0.01 -0.04,-0.09 -0.06,-0.15 -0.01,-0.06 0.04,-0.14 0.06,-0.19 0.02,-0.05 -0.01,-0.11 0.02,-0.15 -0.03,-0.07 4.2e-4,-0.13 0.01,-0.19 0.04,-0.06 -0.06,-0.08 -0.07,-0.14 -0.07,-0.03 -0.02,0.01 0,0.04 0.05,0.06 0.06,0.1 0.02,0.18 0.03,0.08 -0.05,0.03 -0.06,-0.01 0,-0.06 -0.05,-0.1 -0.08,-0.13 -0.04,-0.04 -0.05,-0.07 -0.09,-0.1 0.03,-0.06 -0.02,-0.07 -0.06,-0.11 -0.05,-0.03 -0.15,0.01 -0.14,-0.09 0.05,-0.13 -0.14,-0.16 -0.23,-0.19 -0,-0.02 -0.03,-0.09 -0.08,-0.09 -0.03,-0.01 -0.06,-0.07 -0.1,-0.04 -10e-4,0.07 -0.03,0.02 -0.06,-3.7e-4 -0.04,-0.04 0.01,-0.09 0.02,-0.13 0.01,-0.04 0,-0.08 0.04,-0.12 0.04,-0.04 -0.06,-0.11 0.03,-0.12 0.06,-0.02 0.04,-0.07 0.08,-0.1 0.05,-0.04 0.01,-0.12 0.01,-0.16 -0.01,-0.04 0.01,-0.09 0.05,-0.12 0.02,-0.06 -0.01,-0.1 -0.07,-0.12 -0.01,-0.08 0.08,0.02 0.08,-0.06 0.02,-0.06 0.13,-0.04 0.12,-0.09 -0.03,-0.07 0.05,-0.09 0.08,-0.13 0.07,-0.03 0.03,-0.09 0.04,-0.14 0.01,-0.06 -0.02,-0.12 -0.08,-0.15 -0.04,-0.03 -0.1,-0 -0.14,-0.04 -0.03,-0.03 -0.06,-0.09 -0.01,-0.13 -0.06,-0.04 -0.02,-0.13 -0.09,-0.12 -0.03,-0.06 -0.09,-0.02 -0.13,-0.07 -0.05,-0.01 -0.1,0.04 -0.14,0.07 -0.06,0.01 -0.12,-0.06 -0.2,-0.04 -0.05,0.01 -0.11,0.01 -0.16,-0.02 -0.01,-0.04 -0.04,-0.09 -0.06,-0.13 -0.03,-0.05 -0.07,-0.11 -0.07,-0.17 -0.02,-0.05 0.03,-0.1 0.03,-0.16 0.04,-0.03 0.02,-0.09 0.08,-0.1 0.02,0.04 0.04,-0.01 0.07,-0.03 0.03,-0.05 0.06,-0.09 0.05,-0.15 -0.01,-0.05 -0.06,-0.09 -0.09,-0.13 -0.01,-0.04 -0,-0.08 0.01,-0.12 0.02,-0.05 0.06,-0.1 0.06,-0.15 0.01,-0.05 8.3e-4,-0.12 -0.06,-0.15 -0.02,-0.04 -0.06,-0.07 -0.08,-0.11 -0.01,-0.06 -0.01,-0.12 -0.02,-0.19 10e-4,-0.05 -0.04,-0.1 -0.01,-0.15 0.02,-0.05 0.02,-0.11 0.05,-0.16 0.03,-0.06 -0.02,-0.13 -0.01,-0.19 0.02,-0.05 0.04,-0.1 0.04,-0.15 0.04,-0.05 0.02,-0.12 -0.03,-0.16 -0.01,-0.05 -0.04,-0.09 -0.08,-0.13 -0.05,-0.04 -0.1,-0.08 -0.17,-0.05 -0.06,0 -0.06,-0.05 -0.09,-0.07 -0.04,-0.03 -0.11,9.4e-4 -0.11,-0.06 0,-0.03 0.08,-0.03 0.06,-0.07 0.01,-0.04 -0.07,-0.09 -0.01,-0.12 0.02,-0.04 0.06,-0.07 0.1,-0.09 0.06,0.02 0.08,-0.11 0.02,-0.12 -0.02,-0.02 -0.08,-0.1 -0.09,-0.06 -0.04,0.03 -0.02,-0.07 -0.08,-0.06 -0.03,-0.02 -0.07,-0.06 -0.11,-0.03 -0.05,0.04 -0.07,0.01 -0.07,-0.04 -0.05,-0.02 -0.06,-0.08 -0.08,-0.12 0.06,-0.03 -0.04,-0.08 0.02,-0.13 0.05,-0.03 0.05,-0.1 0.02,-0.14 0.04,-0.05 0.02,-0.1 0.04,-0.15 0.01,-0.04 0,-0.07 -0.02,-0.12 0.01,-0.05 -0.04,-0.09 -0.06,-0.12 0.07,-0.04 -0.02,-0.06 0.01,-0.11 -0.03,-0.06 -0.02,-0.12 -0.04,-0.18 -0.03,-0.04 -0.08,-0.08 -0.07,-0.13 -0.01,-0.05 -0.08,-0.06 -0.07,-0.12 0.02,-0.05 0.05,-0.08 0.06,-0.12 0,-0.05 0.08,-0.06 0.04,-0.01 -0.03,0.08 0.01,-0 0.03,-0.01 0.02,-0.02 0.08,-0.03 0.07,-0.07 -0.02,-0.05 0.14,-0.01 0.06,0.01 -0.08,-0.03 -0.04,0.02 0.01,0.03 0.02,-0.07 0.1,-0.01 0.12,-0.04 0.01,-0.04 0.1,-0.04 0.1,-0.08 -0,-0.03 -0.01,-0.09 0.04,-0.11 -0,-0.06 0.08,-0.07 0.08,-0.13 0.05,-0.02 0.04,-0.08 0.07,-0.12 0.06,-0.03 0.05,-0.1 0.04,-0.15 -0,-0.06 -0.02,-0.12 -0.04,-0.17 -0.06,-0.02 -0.01,-0.1 -0.05,-0.14 -0.02,-0.04 -0.02,-0.08 -0.05,-0.12 -0.03,-0.04 -0.05,-0.09 -0.11,-0.09 -0.05,-2e-5 -0.04,-0.07 -0.09,-0.09 -0.05,-0.02 -0.04,-0.07 -0.04,-0.11 0.03,-0.02 0.06,-0.06 0.05,-0.1 0.05,0.03 0.02,-0.01 0.05,-0.02 0.04,-0.02 0.1,-0.04 0.13,-0.06 0.04,-0.04 -0,-0.07 -0.03,-0.1 -0.02,-0.04 0.1,-0.05 0.02,-0.09 -0.05,0.02 -0.09,-0.01 -0.13,0.02 -0.07,0.01 -0.06,-0.07 -0.03,-0.09 -0.04,-0.03 -0.11,-0.03 -0.08,-0.08 0,-0.06 0.03,-0.11 0.03,-0.17 -0.01,-0.06 0.06,-0.08 0.09,-0.13 0.06,-0.07 0.05,-0.15 0.05,-0.24 -0.01,-0.06 -0.08,-0.09 -0.12,-0.13 -0.04,-0.03 -0.09,-0.04 -0.13,-0.06 -0.06,-0.03 -0.14,-0.02 -0.19,-0.04 -0.04,-0.04 -0.09,-0.03 -0.13,0 -0.06,0.05 -0.09,-0.01 -0.11,-0.05 -0.05,-0.04 0.01,-0.12 -0.05,-0.16 0.02,-0.06 -0.02,-0.14 0.04,-0.18 0.02,-0.07 -0.03,-0.14 0.02,-0.2 0.01,-0.06 0.01,-0.12 -0.04,-0.16 -0.04,-0.07 -0.01,-0.13 0.01,-0.2 -0.05,0.01 -0.11,-0.05 -0.12,-0.09 0.02,-0.05 0.06,-0.07 0.07,-0.12 0.02,-0.07 -2.1e-4,-0.14 -0,-0.21 -0.03,-0.06 0.01,-0.14 -0.01,-0.2 -0.02,-0.05 0.01,-0.1 0.03,-0.14 0.03,-0.05 -0.02,-0.09 -0.01,-0.15 0.03,-0.06 -0.03,-0.09 -0.05,-0.14 -0.02,-0.05 0.01,-0.11 -0.01,-0.16 -0.02,-0.05 -0.11,-0.03 -0.1,-0.1 -0.03,-0.06 0.04,-0.09 0.07,-0.13 0.03,-0.05 0.07,-0.08 0.13,-0.09 0.05,7.7e-4 0.09,0.05 0.12,-0.01 0.01,-0.06 0.09,-0.07 0.09,-0.13 -0,-0.05 0.05,-0.12 0.07,-0.15 0.03,-0.03 -0,-0.08 0.03,-0.11 0.04,-0.03 0.06,-0.09 0.05,-0.15 0,-0.06 -0,-0.12 0.01,-0.18 -0.01,-0.06 -0,-0.12 -0.07,-0.14 0.01,-0.06 0.07,-0.11 0.06,-0.17 0.02,-0.06 -0.01,-0.13 -0.02,-0.19 6.3e-4,-0.05 -0.01,-0.1 -0,-0.15 0.02,-0.04 0.04,-0.06 0.07,-0.1 0.03,-0.02 0.07,-0.05 0.09,-0.09 0.02,-0.04 0.06,-0.08 0.07,-0.13 0.01,-0.04 0.05,-0.07 0.04,-0.11 0.02,-0.04 0.04,-0.08 0.03,-0.12 0.03,-0.03 0.01,-0.08 0.04,-0.11 0.02,-0.04 0.06,-0.07 0.09,-0.11 -0,-0.07 -0.07,0.03 -0.09,0.04 -0.01,-0.03 -0.01,-0.06 -0.03,-0.08 -0.01,-0.05 0.01,-0.1 0.05,-0.13 0.02,-0.02 0.07,-0.07 0.1,-0.04 -0.04,0.06 0.05,0.07 0.07,0.01 0.04,-0.03 0.09,-0.05 0.14,-0.07 0.03,-0.04 0.09,-0.06 0.13,-0.09 0.04,-0.01 0.07,-0.05 0.11,-0.07 0.04,-0.03 0.06,-0.06 0.1,-0.09 -0.02,-0.05 0.05,-0.06 0.04,-0.11 -0.03,-0.05 0.02,-0.1 0.01,-0.14 -0.01,-0.01 0.01,-0.08 0.04,-0.06 0.04,-0.02 0.07,-0.03 0.12,-0.06 0.04,-0.03 0.08,-0.05 0.12,-0.07 0.05,-0.04 0.03,-0.1 0.03,-0.15 -0.02,-0.05 0.01,-0.09 0.06,-0.12 0.03,-0.04 0.09,-0.05 0.11,-0.1 0.04,-0.04 0.06,-0.09 0.09,-0.14 0.02,-0.05 0.04,-0.1 0.06,-0.14 0.02,-0.05 0.07,-0.07 0.1,-0.12 0.02,-0.04 0.08,-0.07 0.09,-0.12 0.02,-0.04 0.03,-0.08 0.05,-0.12 0.01,-0.04 0.03,-0.09 0.06,-0.12 0.03,-0.02 0.04,-0.06 0.08,-0.07 0.03,-0.03 0.07,-0.05 0.11,-0.09 0.04,-0.02 0.06,-0.06 0.08,-0.09 0.04,-0.04 0.07,-0.08 0.1,-0.13 0.01,-0.05 0.06,-0.08 0.08,-0.12 0.04,-0.03 0.1,-0.03 0.13,-0.07 0.05,-0.02 0.06,-0.06 0.09,-0.09 0.05,-0.03 0.09,-0.06 0.15,-0.07 0.05,-0.02 0.12,-0.02 0.19,-0.01 0.07,-0.02 0.14,-0.01 0.19,-0.05 0.05,-0.01 0.08,-0.04 0.11,-0.08 0.05,-0.01 0.06,-0.07 0.1,-0.09 0.02,-0.04 0.07,-0.06 0.12,-0.07 0.06,-0.01 0.06,-0.07 0.12,-0.08 0.05,-0.01 0.1,-0.02 0.13,-0.07 0.03,-0.05 0.02,-0.11 0.07,-0.15 0.02,-0.03 0.04,-0.07 0.07,-0.11 0.02,-0.04 0.04,-0.1 0.08,-0.12 0.04,-0.02 0.08,-0.03 0.12,-0.05 0.05,-0.03 0.12,-0.04 0.16,-0.07 0.03,-0.03 0.07,-0.05 0.11,-0.08 0.04,-0.04 0.08,-0.08 0.12,-0.12 0.03,-0.03 0.06,-0.07 0.08,-0.11 0.03,-0.04 0.05,-0.07 0.07,-0.11 0.01,-0.06 0.06,-0.08 0.1,-0.12 0.05,-0.04 0.14,-0.01 0.19,-0.04 0.05,-0.01 0.07,-0.05 0.12,-0.07 0.03,-0.03 0.07,-0.06 0.1,-0.1 0.05,-0.02 0.09,-0.06 0.13,-0.08 0.04,-0.03 0.04,-0.07 0.07,-0.1 0.03,-0.05 0.08,-0.07 0.14,-0.07 0.06,-9.2e-4 0.11,-0.03 0.16,-0.05 0.03,-0.02 0.06,-0.05 0.05,-0.09 0.01,-0.05 0.03,-0.1 0.03,-0.15 0.01,-0.04 -0.02,-0.08 -0.04,-0.11 -0.01,-0.06 -0.07,-0.11 -0.13,-0.12 -0.1,-0.02 0,-0.09 0.06,-0.07 0.05,-0.01 0.09,-0 0.12,-0.04 0.05,-0.02 0.04,-0.08 0.07,-0.11 0.01,-0.04 0.03,-0.07 0.05,-0.11 0.05,-0.03 0.08,-0.07 0.11,-0.12 0.03,-0.04 0.03,-0.09 0.04,-0.14 0.01,-0.03 0.06,-0.02 0.09,-0.04 0.05,0 0.1,-0 0.14,-0.03 0.05,-0.02 0.08,-0.06 0.11,-0.1 0.04,-0.04 0.05,-0.09 0.06,-0.13 0.01,-0.05 0.02,-0.07 0.03,-0.12 0.01,-0.05 0.01,-0.1 0,-0.15 0.01,-0.06 0.01,-0.12 0.02,-0.18 0.01,-0.04 0.04,-0.08 0.05,-0.12 0.03,-0.06 0.03,-0.12 0.02,-0.18 -0.02,-0.04 -0.04,-0.08 -0.06,-0.13 8e-5,-0.07 -0.01,-0.13 10e-4,-0.2 -0.02,-0.06 0.07,-0.1 0.04,-0.14 -0.03,-0.04 -0.06,-0.11 -0.02,-0.15 -0,-0.05 0.04,-0.09 0.04,-0.14 0.01,-0.05 -1.5e-4,-0.1 0.01,-0.15 -0.01,-0.06 0.02,-0.11 0.04,-0.17 0.02,-0.05 0.05,-0.1 0.08,-0.14 0.02,-0.05 0.04,-0.08 0.09,-0.11 0.04,-0.02 0.09,-0.04 0.12,-0.08 0.04,-0.04 0.11,-0.01 0.16,0 0.04,0.01 0.04,0.06 0.08,0.08 0.01,0.03 0.05,0.08 0.09,0.09 0.05,0.04 0.16,-0.02 0.17,0.06 -0.01,0.04 0.01,0.08 -0.01,0.12 -2e-4,0.04 -0.04,0.08 -0.06,0.11 -0.01,0.04 0.02,0.1 0.07,0.09 0.03,-0.02 0.12,-0.08 0.13,-0.02 -0.01,0.07 0.06,0.11 0.14,0.09 0.04,-0.03 0.09,-0.04 0.12,-0.08 -0.05,-0 -0.08,0.04 -0.11,0.05 -0.04,0.03 -0.11,0.03 -0.14,-0.02 0.04,-0.06 -0.04,-0.11 -0.09,-0.06 -0.04,0.06 -0.14,-0.01 -0.1,-0.05 0.04,-0.03 0.06,-0.07 0.07,-0.12 -10e-4,-0.05 0.02,-0.1 -0.01,-0.15 -0.03,-0.05 -0.1,-0.02 -0.14,-0.03 -0.05,-0.01 -0.07,-0.06 -0.1,-0.09 -0.03,-0.03 -0.05,-0.07 -0.07,-0.1 -0.05,-0.01 -0.1,-0.03 -0.14,-0.05 -0.04,-0.06 0.01,-0.12 0.03,-0.18 0.03,-0.04 0.02,-0.08 0.05,-0.11 0,-0.05 0.07,-0.07 0.1,-0.1 0.05,-0.03 0.08,-0.08 0.09,-0.14 0.03,-0.04 0.03,-0.09 0.04,-0.14 0.03,-0.04 0.07,-0.06 0.12,-0.06 0.04,-0 0.1,0 0.14,0 0.05,0.03 0.11,0.02 0.17,0.04 0.05,0.01 0.09,0.02 0.14,0.04 0.05,0.03 0.1,0.04 0.15,0.07 0.04,0.01 0.09,0.04 0.14,0.04 0.09,7.5e-4 0.18,0.01 0.27,0.01 0.08,0.01 0.18,3e-5 0.27,-3.9e-4 0.06,0 0.12,0.02 0.17,0.04 0.04,0.02 0.09,0.04 0.14,0.06 0.06,0.03 0.12,0.04 0.18,0.07 0.06,0.02 0.12,0.03 0.17,0.07 0.04,0.03 0.09,0.05 0.13,0.08 0.04,0.02 0.08,0.05 0.12,0.07 0.05,0.02 0.1,0.05 0.14,0.07 0.03,0.02 0.06,0.05 0.09,0.07 0.03,0.04 0.05,0.09 0.05,0.14 0.01,0.08 0.02,0.16 -4.1e-4,0.25 -0,0.05 0.01,0.1 0.04,0.15 -0.02,0.04 -0.04,0.13 0.05,0.09 0.02,-0.05 0.09,-0.03 0.1,0.02 0.01,0.05 -0.05,0.07 -0.07,0.11 -0.04,0.05 0.02,0.07 0.03,0.11 -0.01,0.06 -0.1,0.03 -0.12,0.08 0,0.07 0.1,0.07 0.16,0.06 0.05,-0.01 0.13,0.01 0.15,-0.03 0.04,-0.04 6.4e-4,-0.1 0,-0.14 -0,-0.04 0.07,-0.09 0.11,-0.05 -0.02,0.05 -0.04,0.13 0.03,0.15 0.05,0.03 0.09,-0.01 0.13,3.7e-4 0.06,-3.7e-4 0.1,0.05 0.16,0.06 0.04,0.02 0.11,0.01 0.1,0.07 -2.2e-4,0.05 -0.06,0.07 -0.09,0.1 -0.05,0.04 -0.02,0.12 0.05,0.12 0.07,0.02 0.02,0.08 0,0.12 -0.02,0.05 -0.03,0.13 0.04,0.15 0.06,0.01 0.13,-0.01 0.2,0.02 0.06,0.01 0.06,0.06 0.08,0.09 0.01,0.06 -0.03,0.1 -0.05,0.15 -0.02,0.08 0.03,0.03 0.03,-0.02 0.02,-0.06 0.08,-0.12 0.02,-0.18 -0.02,-0.04 -0.07,-0.07 -0.12,-0.09 -0.06,-0.02 -0.13,9.4e-4 -0.18,-0.03 -0.06,-0.05 0.05,-0.11 0.03,-0.18 -0.01,-0.06 -0.07,-0.06 -0.11,-0.1 -0.02,-0.07 0.07,-0.08 0.1,-0.12 0.03,-0.03 0.01,-0.09 -0.03,-0.11 -0.05,-0.03 -0.11,-0.03 -0.15,-0.07 -0.05,-0.04 -0.12,-0.03 -0.18,-0.02 -0.08,0.01 -0.07,-0.08 -0.06,-0.13 -0.01,-0.04 -0.06,-0.05 -0.1,-0.02 -0.07,0.01 -0.07,0.08 -0.04,0.12 -0,0.07 -0.04,0.14 -0.13,0.1 -0.05,-0 -0.1,0.02 -0.14,-0.01 -0.05,-0.05 0.03,-0.04 0.06,-0.05 0.07,-0.03 0.03,-0.09 -2.1e-4,-0.13 0.01,-0.04 0.08,-0.06 0.08,-0.12 0.02,-0.06 -0.05,-0.09 -0.1,-0.09 -0.09,0.04 -0.04,-0.04 -0.05,-0.09 -0.03,-0.06 0.02,-0.12 0,-0.17 0.01,-0.05 -0.02,-0.09 -0,-0.14 0.02,-0.06 -0.01,-0.12 -0.03,-0.18 -0.03,-0.04 -0.04,-0.07 -0.09,-0.1 -0.04,-0.04 -0.09,-0.06 -0.13,-0.1 -0.03,-0.03 -0.08,-0.05 -0.12,-0.08 -0.04,-0.02 -0.08,-0.04 -0.11,-0.06 -0.05,-0.02 -0.1,-0.04 -0.15,-0.07 -0.06,-0.01 -0.1,-0.04 -0.16,-0.06 -0.05,-0.02 -0.09,-0.04 -0.13,-0.05 -0.02,-0.01 -0.11,-0.05 -0.05,-0.04 0.05,0.03 0.12,0.01 0.17,0.04 0.06,-0.02 0.11,0.02 0.16,0.02 0.06,0.02 0.11,0.03 0.17,0.04 0.06,0.01 0.11,0.03 0.16,0.06 0.04,0.02 0.08,0.03 0.12,0.05 0.06,0.02 0.11,0.07 0.17,0.09 0.04,0.03 0.09,0.08 0.15,0.08 0.05,0.02 0.09,0.05 0.14,0.07 0.03,0.03 0.08,0.05 0.12,0.08 0.06,0.02 0.1,0.05 0.15,0.07 0.04,0.03 0.1,0.05 0.14,0.08 0.03,0.03 0.08,0.05 0.12,0.07 0.04,0.03 0.09,0.03 0.13,0.06 0.03,0.03 0.08,0.03 0.11,0.06 0.06,0.01 0.11,0.05 0.16,0.08 0.05,0.02 0.1,0.06 0.15,0.09 0.05,0.02 0.09,0.04 0.13,0.05 0.05,0.02 0.09,0.02 0.14,0.05 0.06,0.03 0.12,0.03 0.18,0.05 0.05,0.03 0.09,0.06 0.15,0.07 0.06,-0 0.11,0.03 0.16,0.05 0.04,0.02 0.08,0.02 0.12,0.05 0.04,0.02 0.08,0.05 0.13,0.06 0.05,0.01 0.08,0.04 0.13,0.06 0.05,0.02 0.11,0.05 0.17,0.06 0.06,0.01 0.12,0.03 0.17,0.05 0.05,0.02 0.1,0.03 0.15,0.05 0.04,0.03 0.09,0.04 0.12,0.07 0.04,0.03 0.08,0.06 0.14,0.06 0.03,0.03 0.08,0.07 0.12,0.08 0.04,0.03 0.07,0.07 0.12,0.06 0.01,0.04 0.04,0.03 0.06,0.04 0.04,0.03 0.08,0.05 0.13,0.07 0.04,0.03 0.09,0.05 0.14,0.07 0.05,0.02 0.09,0.04 0.14,0.06 0.07,0.01 0.13,0.03 0.19,0.06 0.07,0.02 0.14,0.03 0.2,0.06 0.04,0.01 0.08,0.03 0.12,0.04 0.04,0.04 0.1,0.04 0.15,0.05 0.08,-0.01 0.14,0.02 0.21,0.01 0.06,-0.01 0.13,-0.01 0.2,3e-5 0.08,-0.01 0.15,-0.02 0.23,-0.02 0.07,-0 0.13,0 0.18,-0.02 0.06,0.01 0.12,0.01 0.18,0.03 0.06,0.02 0.13,0.05 0.19,0.04 0.06,0.01 0.13,0.03 0.18,0.05 0.03,0.02 0.08,0.02 0.12,0.04 0.06,0.02 0.13,0.02 0.17,0.03 0.05,0.01 0.11,0 0.15,0.03 0.04,0.01 0.09,0.01 0.12,0.03 0.05,0.02 0.1,0.04 0.16,0.06 0.04,0.01 0.08,0.02 0.11,0.03 0.07,-0.01 0.13,0.04 0.19,0.01 0.07,-0.01 0.14,-0.04 0.21,-0.05 0.05,-0.01 0.11,-0.04 0.16,-0.02 0.04,0.03 0.1,0.05 0.14,0.08 0.04,0.03 0.06,0.06 0.09,0.1 0.03,0.04 0.06,0.07 0.09,0.1 0.03,0.03 0.06,0.06 0.08,0.1 0,-0.04 0.03,-0.07 0.09,-0.08 0.05,-0.02 0.1,10e-5 0.14,0.02 0.03,0.02 0.05,0.05 0.08,0.06 0.02,0.03 0.06,0.04 0.09,0.06 0.04,0.03 0.09,0.04 0.14,0.06 0.02,-0.01 0.12,-0.01 0.07,-0.03 -0.04,0.01 -0.09,0.01 -0.13,-0.01 -0.04,-0.03 -0.09,-0.05 -0.13,-0.09 -0.05,-0.03 -0.08,-0.07 -0.14,-0.09 -0.06,-0.03 -0.13,-0.02 -0.18,-0.01 -0.07,0.01 -0.08,-0.05 -0.1,-0.09 -0.03,-0.05 -0.06,-0.09 -0.1,-0.12 -0.03,-0.03 -0.08,-0.04 -0.11,-0.07 -0.04,-0.03 -0.09,-0.05 -0.14,-0.06 -0.06,-0.01 -0.12,-0.04 -0.15,-0.07 0.02,-0.06 0.07,-0.08 0.12,-0.1 0.04,9.4e-4 0.08,-0.02 0.11,-0.05 0.04,-0.01 0.1,0.03 0.11,-0.01 0.03,0.04 0.09,0.02 0.13,0.06 0.05,0.04 0.13,0.04 0.19,0.07 0.05,0.02 0.09,0.06 0.14,0.07 0.04,0.03 0.1,0.03 0.15,0.05 0.07,0.05 0.16,0.07 0.23,0.11 0.06,0 0.1,0.04 0.16,0.05 0.05,0 0.1,0.04 0.14,0.05 0.05,0.04 0.11,0.04 0.18,0.05 0.05,0.02 0.12,0.02 0.14,0.06 0.04,0.04 0.09,0.01 0.12,0.03 0.05,0.02 0.1,0.04 0.15,0.04 0.03,0.04 0.06,0.02 0.1,0.06 0.05,-0.02 0.08,0.07 0.14,0.04 0.03,0.03 0.08,0.04 0.09,0.1 -0,0.08 0.11,0.06 0.11,0.13 0.05,0.05 0.14,0 0.17,0.07 0.03,0.04 0.08,0.09 0.13,0.11 0.05,0.01 0.09,0.03 0.14,0.05 0.04,0.02 0.09,0.04 0.12,0.07 0.03,0.04 0.09,0.04 0.13,0.06 0.04,0.01 0.07,0.04 0.12,0.05 0.05,0.03 0.11,0.05 0.17,0.06 0.05,-0 0.1,-0.01 0.16,-0.01 0.05,-0.01 0.1,-0.01 0.15,-0.03 0.07,0 0.14,-0.01 0.21,0.01 0.05,0.01 0.08,0.05 0.11,0.09 0.03,0.03 0.05,0.08 0.08,0.11 0.03,0.04 0.08,0.08 0.12,0.11 0.03,0.03 0.07,0.07 0.11,0.09 0.04,0.02 0.07,0.05 0.11,0.06 0.05,0.02 0.11,0.03 0.15,0.06 0.04,0.01 0.1,0.04 0.13,0.07 0.02,0.05 0.05,0.1 0.06,0.14 0,0.05 0.01,0.11 -0.01,0.16 -0.02,0.05 -0.09,0.07 -0.12,0.11 -0.03,0.08 0.07,0.08 0.12,0.06 0.04,0.06 -0.1,0.02 -0.11,0.08 -0.02,0.04 -0.07,0.07 -0.09,0.12 -0.01,0.06 0.08,0.07 0.11,0.03 0.06,-0.01 0.13,0.01 0.19,0.02 0.03,0.03 0.04,0.08 0.08,0.11 0.05,0.04 -0.04,0.1 -0.06,0.04 -0.01,-0.04 -0.05,-0.1 -0.1,-0.09 -0.06,0.01 -0.08,0.07 -0.08,0.12 0.03,0.04 0.03,0.09 0.04,0.13 0.04,0.02 0.01,-0.1 -0.01,-0.14 -0.03,-0.05 0.04,-0.13 0.1,-0.09 0.03,0.03 0.04,0.13 0.11,0.09 0.06,-0.05 -0.04,-0.09 -0.04,-0.14 -0.01,-0.07 -0.1,-0.05 -0.15,-0.07 -0.06,-0.04 -0.11,0.04 -0.17,0.02 -0.03,-0.07 0.06,-0.1 0.09,-0.15 0.04,-0.02 0.17,-0.05 0.08,-0.09 -0.05,0.02 -0.15,-0.01 -0.08,-0.07 0.03,-0.02 0.07,-0.03 0.09,-0.06 0.04,-0.03 0.03,-0.08 0.04,-0.12 -10e-4,-0.04 0.02,-0.1 -2.1e-4,-0.14 -0.01,-0.03 -0.04,-0.06 -0.05,-0.09 -0.03,-0.01 -0.06,-0.07 -0.11,-0.07 -0.04,-0.03 -0.08,-0.04 -0.12,-0.06 -0.05,-0.02 -0.1,-0.03 -0.13,-0.05 -0.04,-0.02 -0.08,-0.04 -0.11,-0.07 -0.01,-0.05 -0.06,-0.09 -0.06,-0.14 6.3e-4,-0.06 0.08,-0 0.11,-0.02 0.04,0.02 0.1,0.03 0.15,0.05 0.05,0.02 0.11,0.04 0.16,0.07 0.04,0.03 0.11,0.03 0.14,0.07 0.04,0.03 0.08,0.05 0.13,0.07 0.05,0.03 0.1,0.06 0.16,0.08 0.05,0.02 0.08,0.04 0.13,0.06 0.02,0.03 0.06,0.04 0.09,0.06 0.04,0.03 0.1,0.05 0.13,0.09 0.05,-0.02 0.09,0.04 0.13,0.06 0.05,0.02 0.11,0.04 0.15,0.07 0.06,0.01 0.02,0.04 0.08,0.04 0.04,0.02 0.08,0.05 0.11,0.07 0.02,0.02 0.06,0.07 0.09,0.04 0.06,0 0.11,0 0.14,0.06 0,0.04 0.06,0.07 0.09,0.1 0,-0.03 -0.06,-0.07 -0,-0.11 0.05,-0.07 0.09,0.03 0.15,0.04 0.05,0.04 0.1,0.07 0.12,0.12 0.06,0.02 -0.06,0.11 0.02,0.05 0.06,0.01 0.08,0.05 0.13,0.07 0.04,0.03 0.08,0.07 0.1,0.11 0.04,0.03 0.09,0.07 0.05,0.12 -0.03,0.04 -0.08,0.05 -0.12,0.03 0.03,0.04 0.12,0.04 0.15,0.06 0.05,-0.04 0.1,0.01 0.13,0.04 0.05,0.01 0.12,0.02 0.16,0.05 0.04,0.05 0.09,0.05 0.14,0.08 0.01,0.04 0.07,0.04 0.06,0.09 0.01,0.08 0.02,-0.04 0.02,-0.07 0.07,-0.03 0.13,0.04 0.14,0.09 0.04,0.03 0.07,0.07 0.06,0.11 0.05,-0.01 0.09,0.03 0.11,0.08 0.05,0.03 0.03,0.1 0.06,0.15 0.01,0.03 0.06,0.11 0.09,0.06 0.04,0.01 0.05,0.08 0.11,0.08 0.03,0.04 0.03,0.1 0.06,0.14 0.01,0.04 -0.01,0.09 -0,0.13 0.04,0.03 0.06,0.08 0.11,0.08 0.05,0 0.1,0.02 0.13,0.07 0.03,0.04 0.05,0.1 0.08,0.13 0.03,0.06 0.11,0.05 0.15,0.1 0.03,0.04 0.07,0.06 0.11,0.08 0.04,0.02 0.06,0.06 0.1,0.08 0.05,0.04 0.11,0.05 0.15,0.09 0.05,0.01 0.09,0.04 0.13,0.07 0.04,0.04 0.11,0.03 0.14,0.08 0.04,0.05 0.12,-0.04 0.15,0.04 0.02,0.04 0.01,0.08 0.03,0.12 0.02,0.04 0.05,0.07 0.09,0.11 0.04,0.03 0.07,0.08 0.11,0.11 0.03,0.04 0.07,0.08 0.11,0.12 0.04,0.06 0.12,0.02 0.16,0.08 0.04,0.08 -0.07,-0.02 -0.09,0.04 -0.02,0.04 -0.07,0.07 -0.1,0.1 -0.04,0.04 -0.08,0.02 -0.12,0.02 -0.05,-0.01 -0.1,-0.02 -0.15,-0.03 -0.06,-0.03 -0.12,-0.02 -0.17,-0.01 -0.04,0.01 -0.08,0.02 -0.09,0.06 -0.03,0.04 -0.02,0.08 -0.05,0.12 -0.02,0.05 -0.05,0.08 -0.07,0.12 -0.02,0.04 0.02,0.11 0.07,0.1 0.04,-0.02 0.12,-0.04 0.13,0.01 -0.01,0.05 -0.02,0.09 -0.04,0.13 0,0.04 -0.08,0.1 -0.05,0.11 0.05,-0.04 0.07,-0.09 0.08,-0.14 0.01,-0.04 0.05,-0.08 0.01,-0.12 -0.03,-0.05 -0.12,-0.01 -0.17,-0.02 -0.05,-0.04 -0.01,-0.08 0.04,-0.1 0.02,-0.04 0.06,-0.08 0.06,-0.12 0.02,-0.04 0.02,-0.08 0.05,-0.11 0.07,-0.03 0.12,0.02 0.18,0.03 0.06,0.01 0.13,0.02 0.19,0.02 0.05,0.02 0.1,-0.02 0.15,-0.02 0.02,-0.06 0.08,-0.04 0.11,0.01 0.05,0.03 0.1,0.06 0.16,0.08 0.04,0.02 0.09,0.06 0.14,0.06 0.06,0.04 0.11,0.09 0.17,0.12 0.01,0.05 0.08,0.06 0.09,0.11 0.04,0.02 0.05,0.07 0.09,0.09 0.02,0.04 0.07,0.06 0.09,0.1 0.05,0.03 0.08,0.07 0.13,0.11 0.05,0.02 0.08,0.08 0.14,0.09 0.01,0.03 0.06,0.07 0.09,0.09 0.05,0.04 0.12,0.04 0.17,0.06 0.06,0.01 0.11,0.02 0.16,0.04 0.05,0.02 0.08,0.05 0.12,0.09 0,0.05 0.05,0.07 0.08,0.1 0.03,0.05 0.11,0.06 0.16,0.08 0.03,0.03 0.07,0.05 0.1,0.08 0.03,-7.6e-4 0.05,0.05 0.1,0.07 0.04,0.03 0.09,0.04 0.13,0.07 0.04,-0.01 0.02,-0.05 0.06,-9.4e-4 0.03,0.03 0.08,0.05 0.08,0.09 -0.07,0.03 0.05,0.02 0.06,0.05 0.06,0.01 0.02,0.07 0.09,0.07 0.03,0.03 0.09,0.03 0.1,0.08 -0.01,0.06 0.07,0.08 0.11,0.12 0.03,0.02 0.08,0.04 0.1,0.07 0.02,0.03 0.08,0.09 0.1,0.04 0.01,0.01 0.09,0.03 0.08,0.07 -0.01,0.07 0.11,0.01 0.14,0.03 0,0.04 -0.04,0.09 0.03,0.1 0.04,0.05 0.09,-0.03 0.12,0.02 0.05,0.04 0.04,0.09 0.03,0.14 0.03,0.05 0.13,0.04 0.13,0.1 0.05,-0.03 0.08,0.07 0.11,0.1 0.02,0.03 0.05,0.06 0.07,0.1 0.03,0.05 0.04,0.12 0.1,0.17 0.03,0.03 0.04,0.06 0.07,0.08 0.03,0.03 0.07,0.06 0.11,0.09 0.04,0.03 0.08,0.06 0.12,0.09 0.03,0.05 0.15,0.02 0.13,0.07 -0.03,0.05 -0.1,0.04 -0.15,0.06 -0.07,0.01 -0.15,0.03 -0.22,0.06 -0.05,0.02 -0.11,0.04 -0.16,0.06 -0.06,0.02 -0.12,-0.03 -0.15,-0.06 -0.04,-0.04 -0.09,-0.07 -0.14,-0.1 -0.06,-0.01 -0.13,1.4e-4 -0.18,0.03 -0.04,0.02 -0.06,0.07 -0.08,0.11 -0.01,0.06 0.01,0.14 -0.04,0.2 -0.04,0.01 -0.09,-0.02 -0.13,-0.04 -0.06,-0.03 -0.12,-0.04 -0.19,-0.03 -0.06,0.02 -0.12,0 -0.17,-0.01 -0.07,-0.02 -0.14,-0.01 -0.2,0.01 -0.03,-0.04 -0.1,-0.09 -0.15,-0.03 -0.02,0.03 -0.11,0.04 -0.05,0.06 0.04,-0.01 0.09,-0.07 0.12,-0.04 0.03,0.04 0.08,0.05 0.13,0.04 0.07,-0.01 0.13,-0 0.19,0.02 0.05,-0.02 0.08,0.08 0.08,0 0.05,-0.04 0.13,-0.01 0.19,0.01 0.03,0.04 0.11,0.04 0.16,0.04 0.05,-0.02 0.09,-0.05 0.1,-0.1 0.02,-0.05 0.02,-0.1 0.03,-0.16 0,-0.05 0.05,-0.07 0.1,-0.08 0.07,-0.01 0.13,0.04 0.16,0.09 0.03,0.04 0.06,0.07 0.11,0.09 0.07,0.03 0.14,3.7e-4 0.21,0.01 0.11,-0.01 0.04,0.06 0,0.09 -0.05,0.03 -0.09,0.07 -0.12,0.11 -0.02,0.05 0.01,0.1 0.04,0.14 0.03,0.05 0.05,-0.01 0,-0.04 -0.06,-0.04 -0.01,-0.1 0.03,-0.13 0.04,-0.03 0.07,-0.05 0.1,-0.09 0.05,-0.02 0.06,-0.07 0.11,-0.09 0.06,-0.02 0.1,-0.05 0.15,-0.07 -0.05,-0.01 0.03,-0.03 0.07,-0.04 -0.01,0.02 0.02,0.04 0.06,0.03 0.06,-0.01 0.12,-0.04 0.15,-0.09 0.03,-0.04 0.05,-0.09 0.1,-0.13 0.01,-0.04 0.03,-0.08 0.04,-0.12 0.02,-0.07 -0.06,-0.08 -0.06,-0.13 0.06,-0 0.01,-0.08 0.07,-0.05 0.03,-0.03 0.07,-5.6e-4 0.11,-0.02 -0.02,-0.06 0.04,0.03 0.07,-0.02 0.03,0.03 0.08,0 0.11,-0.03 0.06,-0.03 0.08,-0.05 0.15,-0.03 0.08,-0.05 0.05,0.07 0.1,0.09 0.05,0.02 0.1,0.08 0.15,0.04 0.03,-0.04 0.06,0.01 0.08,0.04 -0.04,0.05 -0.01,0.1 0.04,0.13 0.06,0.02 0.1,0.05 0.15,0.09 0.03,0.03 0.06,0.07 0.1,0.09 0.03,0.03 0.11,0.05 0.08,0.1 -0.06,-0.03 -0.08,0.01 -0.08,0.06 0.02,0.03 -0,0.07 0.05,0.09 0.04,0.03 0.09,0.06 0.12,0.09 0.05,0.03 0.1,0.04 0.1,0.11 0.04,0.04 0.01,0.09 -0.01,0.13 -0.02,0.03 -0.05,0.06 -0.07,0.09 -0.05,0.02 -0.09,0.07 -0.09,0.11 -0.05,0.03 -0.1,0.05 -0.15,0.08 -0.02,-0.04 -0.08,-0.04 -0.11,-0.01 -0.05,-0.03 -0.11,-0.01 -0.16,0.01 -0.05,0.04 -0.06,0.1 -0.1,0.14 -0.03,0.05 -0.06,0.09 -0.07,0.14 -0.01,0.04 -0.03,0.09 -0.04,0.13 8.3e-4,0.04 -0.01,0.08 -0.01,0.11 1.6e-4,0.05 -0.02,0.1 -0.03,0.15 -0.02,0.05 -0.04,0.1 -0.06,0.14 -0.02,0.04 -0.04,0.08 -0.06,0.12 -0.02,0.05 -0.04,0.09 -0.05,0.14 -0.03,0.05 -0.07,0.1 -0.12,0.15 -0.04,0.03 -0.06,0.07 -0.08,0.12 0.01,0.04 -0.01,0.03 -0.03,0.07 -0.02,0.06 -0.1,0.03 -0.13,0.08 -0.05,0.04 0,0.15 0.07,0.15 0.05,0.02 0.08,0.09 0.05,0.14 -0.03,0.03 -0.05,0.07 -0.07,0.11 0.02,0.04 0.05,-0.07 0.07,-0.08 0.04,-0.05 0.01,-0.11 -0.02,-0.15 -0.03,-0.04 -0.08,-0.05 -0.1,-0.09 0,-0.06 0.1,-0.05 0.14,-0.08 0.05,-0.03 0.08,-0.08 0.08,-0.13 0.02,-0.04 0.05,-0.09 0.1,-0.12 0.05,-0.04 0.09,-0.09 0.11,-0.15 0.03,-0.04 0.02,-0.09 0.04,-0.13 0.01,-0.03 0.04,-0.05 0.05,-0.09 0.03,-0.04 0.05,-0.08 0.07,-0.11 0.02,-0.05 0.03,-0.11 0.05,-0.16 0.02,-0.06 0.01,-0.13 0.02,-0.19 0.01,-0.04 0.03,-0.09 0.04,-0.13 0.02,-0.04 0.05,-0.08 0.07,-0.12 0.02,-0.03 0.03,-0.06 0.06,-0.08 0.04,-0.02 0.06,0.06 0.11,0.06 0.05,0.04 0.12,0.02 0.18,0.04 0.05,-9.4e-4 0.12,0.01 0.16,-0.03 0.04,-0.02 0.09,-0.03 0.13,-0.06 0.04,-0.04 0.09,-0.06 0.13,-0.09 -0,-0.05 0.07,-0.06 0.1,-0.04 0.06,-0.01 0.12,-0.01 0.18,0.01 0.06,-0.01 0.1,0.03 0.14,0.06 0.08,0.01 0.09,0.06 0.13,0.12 0.04,0.05 0.09,0.07 0.09,0.13 -0.02,0.06 0.03,0.06 0.08,0.1 0.01,0.03 0.1,0.08 0.09,0.02 0.01,-0.06 0.04,0.06 0.08,0.06 0.06,0.02 0.13,-0.06 0.13,0.01 0.05,0.03 0.11,0.05 0.16,0.09 0.01,0.06 0.05,0.1 0.04,0.16 -0.01,0.03 0.03,0.07 0.06,0.1 0.03,0.05 0.1,0.03 0.13,0.07 0.04,0.03 0.06,0.08 0.06,0.13 0.04,-0.01 -0.02,-0.08 -0.02,-0.12 -0.01,-0.05 -0.07,-0.08 -0.09,-0.12 -0,-0.08 0.06,0.04 0.1,0.02 0.04,0.02 0.06,0.05 0.1,0.08 0.01,0.04 0.11,0.02 0.07,0.1 -0.05,0.01 0.01,0.07 0.03,0.07 -0,-0.07 0.06,-0.03 0.09,-0.01 0.05,0.02 0.07,0.07 0.11,0.1 -0.05,-0.02 -0.01,0.04 0.01,0.05 0.06,-0.05 0.05,0.06 0.09,0.07 0.03,0.03 0.04,0.06 0.08,0.06 -0,-0.05 -0.08,-0.09 -0.06,-0.11 0.05,-0.03 0.06,0.06 0.1,0.06 0.05,0.02 0.08,0.07 0.14,0.09 0.03,0.04 0.12,0.03 0.13,0.09 0.05,-0.01 0.07,0.05 0.12,0.07 0.08,-0.02 0.1,0.04 0.16,0.07 0.05,0.04 0.11,0.04 0.17,0.08 0.06,0.02 0.08,0.05 0.11,0.08 0.02,-0.04 0.11,-0.02 0.09,0.02 0.05,0.02 -0.01,0.02 0,0.03 0.05,0.02 0.07,0.08 0.07,0.12 -0.04,-0.01 -0.07,-0.04 -0.03,0.01 0.02,0.04 0.08,0.03 0.12,0.05 0.06,0.01 0.09,0.06 0.12,0.1 0.02,-0.07 0.05,0.02 0.04,0.05 0.04,0.02 0.06,0.07 0.07,0.11 0.01,0.04 0.02,0.09 0.04,0.12 0.03,0.05 0.03,0.12 0.03,0.18 -0.01,0.06 6.3e-4,0.13 0.02,0.18 -0,0.06 0,0.13 0.03,0.2 0,0.06 0.01,0.13 0.02,0.19 0.02,0.05 0.02,0.11 0.07,0.14 0.03,0.03 0.06,0.06 0.06,0.09 0.05,0.03 0.08,0.08 0.11,0.12 0.01,0.04 0.04,0.08 0.08,0.11 0.01,0.05 0.04,0.08 0.06,0.13 0.04,0.05 0.05,0.11 0.07,0.16 -0.01,0.06 0.02,0.12 0.02,0.18 0,0.06 0.03,0.11 0.06,0.17 0.02,0.05 0.04,0.11 0.05,0.16 0.01,0.05 0.02,0.11 0.03,0.15 -0,0.04 0.01,0.08 -0,0.13 -0.01,0.06 -0.03,0.12 -0.03,0.18 -0.02,0.07 -4.3e-4,0.13 0.02,0.2 0.01,0.08 0.05,0.16 0.06,0.24 0.02,0.05 0.02,0.11 0.03,0.16 0.02,0.06 0.02,0.12 0.02,0.17 0.01,0.08 0.02,0.17 0.01,0.26 -0.01,0.06 -0.02,0.12 -0.04,0.17 -0.02,0.05 -0.05,0.1 -0.08,0.14 -0.03,0.04 -0.05,0.07 -0.08,0.11 -0.03,0.04 -0.07,0.08 -0.1,0.11 -0.03,0.05 -0.08,0.06 -0.13,0.09 -0.04,0.02 -0.08,0.05 -0.12,0.06 -0.06,0.03 -0.12,0.06 -0.18,0.09 -0.05,0.02 -0.1,0.03 -0.15,0.06 -0.04,0.02 -0.09,0.05 -0.13,0.08 -0.04,0.03 -0.06,0.08 -0.09,0.1 -0.04,0.03 -0.07,0.07 -0.12,0.09 -0.02,0.03 -0.08,0.03 -0.1,0.07 -0.03,0.05 -0.1,0.06 -0.16,0.05 -0.06,-1.9e-4 -0.13,0 -0.18,0 -0.05,0.02 -0.1,0.02 -0.16,0.03 -0.06,-0 -0.13,0.05 -0.17,-1.9e-4 -0.05,-0.04 -0.12,-0.01 -0.18,-0.04 -0.04,-0.02 -0.1,-0.02 -0.13,-0.06 -0.05,-0.04 -0.11,-0.04 -0.16,-0.01 -0.04,0.02 -0.09,0.05 -0.12,0.09 -0.02,0.03 -0.07,0.05 -0.09,0.09 -0.03,0.05 -0.02,0.12 -0.05,0.17 -0.04,0.03 -0.05,0.09 -0.06,0.14 -0.04,0.05 -0.02,0.11 -0.04,0.17 -0.01,0.04 -0.04,0.08 -0.07,0.1 -0.04,0.04 -0.1,0.03 -0.16,0.04 -0.06,0 -0.12,-0 -0.18,0.01 -0.05,0.04 -0.11,0.04 -0.14,-0.02 -0.06,-0.02 -0.09,0.05 -0.15,0.05 -0.05,0.03 -0.12,0.04 -0.19,0.05 -0.06,0.02 -0.11,0.02 -0.16,0.05 -0.03,0.03 -0.06,0.06 -0.07,0.11 -0.03,0.04 -0.05,0.08 -0.09,0.12 -0.03,0.04 0.02,0.11 -0.02,0.15 -0.03,0.03 -0.07,0.05 -0.11,0.05 -0.05,-9.3e-4 -0.08,-0.04 -0.13,-0.04 -0.06,-0.03 -0.1,0.03 -0.16,0.03 -0.05,0.06 0.04,0 0.07,0.03 0.06,0.05 0.11,-0.04 0.16,-0.01 0.06,0.03 0.12,0.01 0.18,-0.02 0.06,-0.03 0.03,-0.12 0.04,-0.17 0.02,-0.04 0.06,-0.07 0.08,-0.11 0.03,-0.04 0.04,-0.11 0.09,-0.12 0.05,-0.03 0.11,-0.04 0.18,-0.04 0.08,9.4e-4 0.13,-0.07 0.21,-0.06 0.06,4e-5 0.11,0 0.17,0.01 0.04,-0.03 0.08,-0.06 0.14,-0.04 0.07,0 0.14,0.01 0.2,-0.02 0.04,-0.02 0.07,-0.04 0.1,-0.08 0.03,-0.03 0.05,-0.07 0.05,-0.12 0.01,-0.05 0.01,-0.1 0.04,-0.15 0.02,-0.05 0.06,-0.09 0.07,-0.14 0.02,-0.05 0.03,-0.1 0.07,-0.14 0.02,-0.03 0.05,-0.07 0.07,-0.1 0.04,-0.03 0.07,-0.07 0.12,-0.09 0.05,0 0.08,0.04 0.11,0.07 0.03,0.04 0.08,0.06 0.12,0.07 0.03,0.03 0.08,0.05 0.12,0.06 0.06,0.02 0.14,0.01 0.18,-0.04 0.07,-0.02 0.13,0.01 0.21,0 0.08,-0.01 0.15,0.02 0.22,-0.01 0.05,-0.01 0.1,-0.05 0.15,-0.07 0.05,-0.03 0.09,-0.07 0.13,-0.1 0.04,-0.03 0.08,-0.07 0.14,-0.09 0.06,-0.02 0.13,-0.02 0.2,-0.04 0.06,-0.01 0.12,-0.03 0.17,-0.06 0.07,-0.04 0.14,-0.07 0.19,-0.13 0.05,-0.03 0.1,-0.06 0.15,-0.08 0.03,-0.03 0.09,-0.04 0.13,-0.08 0.04,-0.02 0.06,-0.06 0.11,-0.08 0.04,-0.05 0.08,-0.1 0.1,-0.15 0.01,-0.05 0.07,-0.06 0.09,-0.1 0.03,-0.02 0.05,-0.07 0.09,-0.09 8.4e-4,-0.02 0.01,-0.1 0.04,-0.13 0.01,-0.05 0.03,-0.1 0.06,-0.15 0.02,-0.05 0.03,-0.1 0.04,-0.15 0.01,-0.08 0.02,-0.15 0.01,-0.23 0.01,-0.09 0.01,-0.19 -0.01,-0.28 -0.01,-0.06 -0.03,-0.13 -0.04,-0.19 -0.02,-0.07 -0.02,-0.13 -0.02,-0.21 -0.01,-0.08 6.2e-4,-0.16 -0.01,-0.24 -0.01,-0.04 -8.4e-4,-0.08 -0.01,-0.13 0,-0.05 -0.01,-0.09 0.01,-0.14 0,-0.05 0.01,-0.11 0.02,-0.16 0.01,-0.08 0,-0.17 0.01,-0.26 -0,-0.05 -0.01,-0.1 4.1e-4,-0.14 0,-0.06 0.01,-0.11 0,-0.17 0,-0.07 10e-4,-0.14 0,-0.21 -0.01,-0.09 0.01,-0.17 0.02,-0.26 0.02,-0.05 -0.01,-0.12 0.06,-0.16 -0.02,-0.06 0.05,-0.1 0.08,-0.15 0.03,-0.03 0.04,-0.08 0.05,-0.12 10e-4,-0.05 0.01,-0.11 0.08,-0.12 -0.03,-0.01 -0.02,-0.05 0.03,-0.07 0.05,-0 0.15,-0.04 0.17,0.02 0.07,0.02 0.14,5.7e-4 0.21,0.03 0.04,0.02 0.09,0.04 0.13,0.07 0.08,-0.02 0.05,0.06 0.11,0.06 0.07,-0.01 0.07,0.05 0.12,0.07 0.05,0.01 0.09,0.05 0.14,0.07 0.04,0.04 0.12,0.03 0.14,0.08 0.04,0.04 0.08,0.04 0.12,0.08 0.03,0.05 0.07,0.09 0.13,0.11 0.08,0.02 -0.03,0.06 0.03,0.08 0.04,0.02 0.07,0.06 0.13,0.06 0.08,0.02 0.02,0.06 0.07,0.09 0.04,0.04 0.07,0.09 0.1,0.14 0.05,0.06 0.06,0.02 0.03,-0.03 0.01,-0.03 0.07,0.07 0.07,0.11 0.01,0.04 0.04,0.06 0.05,0.1 0.04,0.08 -0.04,-0.04 -0.05,-7e-5 4.2e-4,0.06 0.07,0.08 0.07,0.12 -0.02,0.07 0.1,0.05 0.08,0.12 -0.01,0.05 -0.03,0.1 -0.03,0.14 0.03,0.04 0.03,0.09 0.06,0.13 -10e-4,0.06 0.03,0.12 0.03,0.17 -0.01,0.07 0.06,0.11 0.04,0.17 0.01,0.05 0.05,0.08 0.04,0.13 0.03,0.05 0.01,0.08 0.01,0.12 -0.01,0.05 -0,0.11 0.01,0.16 0.01,0.05 -0.05,0.11 -0,0.15 0.03,0.05 0.02,0.08 0.02,0.13 0.02,0.04 0.03,0.09 0.06,0.12 0.02,0.04 0.05,0.07 0.08,0.11 0.02,0.04 0.08,0.05 0.09,0.1 0.03,0.05 0.08,0.06 0.12,0.09 -0.01,0.03 -0.03,0.06 -0.02,0.11 -0.03,0.03 -0.11,0.03 -0.06,0.1 0.03,0.04 -0.06,0.08 -0,0.13 -0.02,0.06 0.04,0.04 0.07,0.03 -0.04,0.05 0.03,0.02 0.05,0.07 0.04,0.03 0.06,0.08 0.09,0.12 0.04,0.02 0.07,0.04 0.11,0.07 0.04,0.04 0.09,0.05 0.14,0.1 0.04,0.01 0.09,0.01 0.12,0.05 0.02,0.06 0.1,0.01 0.15,0.01 0.02,-0.04 0.03,-0.09 0.08,-0.08 0.03,0.03 0.12,-0.01 0.09,0.08 -0.05,0.04 0.02,0.11 -0.04,0.11 -0.04,-0.04 -0.09,-0 -0.13,0.02 -0.04,0.02 -0.08,0.05 -0.09,0.09 -0.02,0.05 -0.03,0.12 -0.07,0.14 0.05,0.03 -0.06,0.01 -0.06,0.06 -0.01,0.05 -0.05,0.11 -0.01,0.17 0,0.06 -0.01,0.1 0.02,0.15 0.01,0.05 0.03,0.1 0.04,0.14 0.03,0.04 0.03,0.1 0.06,0.15 0.04,0.03 0.03,0.08 0.06,0.12 0.03,0.04 0.06,0.09 0.08,0.14 0.03,0.03 0.05,0.07 0.09,0.1 0.03,0.04 0.05,0.09 0.09,0.12 0.03,0.04 0.08,0.1 0.12,0.11 0.08,0.01 0.01,0.05 0.02,0.09 0.02,0.05 0.05,0.1 0.09,0.14 0.04,0.04 0.11,0.05 0.15,0.08 0.06,0.02 0.06,0.09 0.07,0.13 0.06,0.03 -0,0.09 -0.02,0.13 0.02,0.01 0.09,-0 0.13,0.03 0.05,0.03 0.09,0.07 0.13,0.12 0.04,0.03 0.07,0.07 0.09,0.12 0.03,0.05 0.06,0.09 0.04,0.14 -0.02,0.03 -0.05,0.07 -0.06,0.11 -0.03,0.05 -0.04,0.1 -0.07,0.15 -0.02,0.05 -0.03,0.09 -0.05,0.13 -0.02,0.06 -0.03,0.11 -0.06,0.17 -0.02,0.07 -0.02,0.14 -0.05,0.21 -0.01,0.06 -0.04,0.11 -0.06,0.17 -0.01,0.04 -0.03,0.08 -0.02,0.13 -0,0.05 -0.01,0.12 -0,0.17 0.01,0.04 -0.01,0.09 -0.01,0.13 -0.01,0.05 -0.02,0.09 -0.01,0.14 -0,0.06 -0.02,0.11 -0.01,0.17 0.01,0.05 0.01,0.1 0.03,0.15 0,0.03 -0.04,0.07 -0.07,0.09 -0.03,0.03 -0.06,0.07 -0.1,0.09 -0.03,0.03 -0.07,0.05 -0.12,0.08 -0.05,0.02 -0.09,0.05 -0.13,0.09 -0.05,0.04 -0.07,-0.04 -0.13,-0.03 -0.06,0.01 -0.13,0.02 -0.17,0.07 -0.04,0.03 -0.07,0.06 -0.09,0.1 -0.03,0.02 -0.06,0.04 -0.09,0.06 -0.03,0.04 -0.08,0.04 -0.12,0.06 -0.04,0.02 -0.06,0.07 -0.11,0.05 -0.06,0.01 -0.12,0.01 -0.18,0.03 -0.04,0.03 -0.08,0.06 -0.12,0.08 -0.04,0.01 -0.07,0.05 -0.1,0.07 -0.03,0.05 -0.01,0.11 -0.07,0.13 -0.03,0.03 -0.07,0.06 -0.1,0.08 -0.04,0.03 -0.07,0.08 -0.1,0.11 -0.04,0.05 -0.05,0.1 -0.09,0.15 -0.03,0.05 -0.02,0.12 -0.01,0.18 0,0.04 10e-4,0.08 0.02,0.12 0.02,0.04 0,0.09 0.01,0.12 -0,0.04 0.01,0.09 -0.01,0.13 -0.04,0.04 -0.04,0.09 -0.07,0.14 -0.02,0.06 -0.05,0.11 -0.09,0.16 -0.02,0.04 -0.04,0.06 -0.05,0.11 -0.01,0.04 -0.04,0.08 -0.08,0.11 -0.04,0.05 -0.1,0.07 -0.15,0.12 -0.02,0.05 -0.07,0.03 -0.1,0.05 -0.04,0.02 -0.07,0.08 -0.06,0.13 0.01,0.06 -0.07,0.11 -0.12,0.11 -0.05,-0 -0.1,0.03 -0.15,0.04 -0.05,0.01 -0.09,0.05 -0.12,0.08 -0.05,0.02 -0.06,0.07 -0.06,0.12 -0.01,0.05 -0.06,0.05 -0.1,0.07 -0.04,0.04 -0.05,0.1 -0.07,0.14 -0.05,0.03 -0.06,0.08 -0.08,0.12 -0.02,0.04 -0.07,0.09 -0.06,0.14 -0.04,0.03 -0.05,-0.1 -0.09,-0.04 -0.07,-0.03 -0.03,0.06 -0.08,0.03 -0.01,0.06 -0.07,0.01 -0.1,0.05 -0.05,-0.01 -0.03,-0.07 -0.09,-0.08 -0.08,-0.03 -0.09,0.07 -0.09,0.11 0.01,0.05 0.02,0.11 -0.05,0.09 -0.06,-0.06 -0.04,0.02 -0.07,0.05 -0.04,0.02 -0.09,0.03 -0.1,0.07 -0.08,0.02 -0.01,0.12 -0.08,0.15 -0.04,0.04 0.02,0.07 0.04,0.1 0.03,0.04 0.03,0.1 0.04,0.14 -0.02,0.04 0.06,0.05 0.05,0.09 -0.01,0.03 -0.04,0.07 -0.05,0.1 0,0.05 0.05,0.09 -0.01,0.13 0.01,0.06 -0.07,0.07 -0.11,0.05 -0.05,0.01 -0.11,-0.03 -0.16,-0 0.02,0.08 -0.06,-0.01 -0.1,3.8e-4 -0.02,0.05 -0.04,0 -0.09,-0.01 -0.02,0.05 -0.05,-0.01 -0.07,0.04 0.01,0.04 -0.03,0.07 -0.07,0.03 -0.05,0.03 -0.04,0.05 0.03,0.04 0.07,-0.01 0.05,0.08 -0,0.01 -0.04,0.06 -0.07,-0.02 -0.1,0.02 0.01,0.07 -0.04,0.06 -0.09,0.06 -0.03,-0.05 -0.04,0.07 -0.01,0.08 -0.06,0.02 -0.05,0.09 -0.07,0.14 0,0.05 -10e-4,0.09 -0.01,0.13 -0.01,0.04 -0.04,0.06 -0.08,0.06 0,0.05 -0.08,0.07 -0.05,0.13 0.02,0.05 -0.07,0.07 -0.04,0.13 0.04,0.04 0.04,0.1 0,0.14 -0.05,0.04 -0.05,0.11 -0.04,0.16 -0,0.06 -0.03,0.1 -0.05,0.15 -0.05,0.03 -0.04,0.1 -0.05,0.15 -0.02,0.05 -0.06,0.08 -0.1,0.11 -0.04,0.04 -0.08,0.08 -0.12,0.12 -0.04,0.04 -0.08,0.08 -0.14,0.08 -0.06,0.01 0.01,0.09 -0.03,0.12 -0.04,0.03 -0.07,0.06 -0.05,0.1 -0.05,0.02 -0.08,0.07 -0.08,0.12 -0.04,0.04 -0.06,0.09 -0.08,0.14 -0.04,0.04 -0.08,0.07 -0.08,0.13 -0.04,0.03 -0.06,0.07 -0.08,0.11 -0.02,0.05 -0.07,0.09 -0.08,0.14 -0.02,0.04 -0.04,0.09 -0.07,0.12 -0.05,0.04 -0.11,-0.02 -0.16,0.03 -0.05,0.03 -0.05,0.1 -0.01,0.13 0.04,0.04 -0.04,0.07 -0.05,0.11 -0.04,0.04 -0.06,0.11 -0.12,0.12 -0.05,0.03 -0.09,0.02 -0.12,0.07 -0.01,0.04 -0.08,0.05 -0.05,0.1 0.02,0.05 0.05,0.1 0.01,0.16 0.01,0.06 -0.05,0.08 -0.09,0.11 0.04,-0 0.04,0.02 -0,0.05 l -0.05,0.03 c 4.1e-4,-0 -0.01,-0.01 -0.03,-0.01 -0.05,0.04 -0.05,0.11 -0.1,0.16 -0.02,0.06 -0.08,0.09 -0.08,0.15 -0.06,0.01 -0.03,0.07 -0.07,0.1 -0.04,0.04 -0.06,0.1 -0.11,0.13 0,0.07 -0.05,0.12 -0.08,0.18 -0.01,0.05 -0.05,0.09 -0.08,0.14 -0.06,0.04 -0.1,0.1 -0.14,0.16 0.01,0.07 -0.05,0.12 -0.07,0.19 -0.03,0.05 -0.08,0.09 -0.1,0.15 -0.02,0.06 -0.1,0.06 -0.12,0.12 -0.03,0.05 -0.06,0.08 -0.1,0.12 -0.06,0.04 -0.07,0.1 -0.1,0.16 -0.04,0.04 -0.06,0.08 -0.11,0.09 -0.09,0.03 -0.04,0.12 -0.04,0.18 0.08,0.05 -0,0.08 -0.04,0.12 -0.03,0.04 -0.1,0.05 -0.11,0.09 -0.09,-3.8e-4 -0.07,0.09 -0.12,0.14 -0.02,0.07 -0.07,0.08 -0.07,0.15 -0.06,0.03 -0.08,0.09 -0.12,0.14 -0.06,0.03 -0.07,0.14 -0.15,0.12 -0.06,-0.06 -0.07,0.07 -0.14,0.05 -0.01,-0.07 -0.06,-0.1 -0.08,-0.15 -0.05,-0.03 -0.14,-0.06 -0.19,-0.02 -0.1,0.02 0.03,0.14 -0.05,0.17 0.05,-0.01 0.04,0.02 -0,0.03 -0.03,9.4e-4 -0.08,-0.04 -0.1,0.04 -0.03,0.08 -0.11,-0.03 -0.16,0.01 -0.05,0.05 -0.14,-0.05 -0.14,0.04 0.03,0.07 -0.01,0.14 -0,0.21 -0.02,0.08 -0.06,0.14 -0.12,0.19 -0.12,-0.04 -0.1,0.11 -0.08,0.17 2.2e-4,0.09 0.08,0.09 0.1,0.16 0.01,0.07 -0.05,0.12 -0.11,0.07 -0.09,-0.05 -0.13,0.06 -0.2,0.06 -0.06,3.9e-4 -0.12,-0.05 -0.16,0.01 0.01,0.07 -0.03,0.11 -0.02,0.17 4.1e-4,0.05 -0.04,0.11 -0.1,0.14 -0.06,0.06 0.05,0.09 0.04,0.12 -0.05,0.07 -0.1,0.04 -0.16,0.02 -0.04,0.05 -0.1,0.12 -0.05,0.19 0.04,0.05 0.11,0.05 0.18,0.04 0.06,0.02 -0.04,0.1 -0.06,0.14 -0.06,0.05 -0.03,0.13 -0.01,0.19 0.01,0.06 0.08,0.06 0.11,0.11 0.07,0.01 0.1,0.07 0.14,0.11 0.05,0.05 8.3e-4,0.13 -0.05,0.17 -0.03,0.05 -0.06,0.11 -0.1,0.17 -0.05,0.04 -0.08,0.11 -0.11,0.17 -0.02,0.07 -0.06,0.12 -0.09,0.18 -0.01,0.07 -0.05,0.12 -0.13,0.14 -0.06,0.04 -0.05,0.11 -0.05,0.17 -0.05,0.05 -0.02,0.14 -0.1,0.18 -0.06,0.06 0.07,0.14 -0.01,0.21 -0.02,0.05 -0.06,0.11 -0.08,0.16 -0.04,0.06 -0.07,0.13 -0.11,0.19 -0.05,0.04 -0.16,0 -0.15,0.09 0.09,0.03 0.05,0.13 -0.01,0.17 -0.05,0.06 0.02,0.09 0.07,0.12 -0.01,0.08 0.05,0.1 0.12,0.08 0.05,-0.06 0.1,-0.04 0.05,0.03 -0.04,0.04 -0.07,0.08 -0.11,0.12 -0.04,0.06 -0.06,0.15 -0.17,0.12 -0.06,-0.02 -0.13,-0.09 -0.17,-0.01 -0,0.05 -0.04,0.09 -0.1,0.05 -0.07,0 -0.11,0.06 -0.12,0.12 -0.03,0.07 -0.07,0.12 -0.11,0.19 -0.05,0.05 -0.07,0.13 -0.12,0.18 -0.01,0.02 -0,0.02 8e-5,0.02 -0.01,0.01 -0.03,0.03 -0.05,0.06 -0.09,0.11 -0.12,0.26 -0.2,0.38 -0.08,0.14 -0.16,0.29 -0.26,0.42 0,0.09 -0.07,0.14 -0.09,0.22 0.06,0.09 0.07,0.2 -0.05,0.25 -0.01,0.06 0.05,0.12 -0.01,0.19 -0.04,0.1 -0.08,0.2 -0.18,0.26 -0.08,0.09 -0.1,0.21 -0.16,0.31 -0.04,0.1 -0.11,0.19 -0.19,0.26 0.03,0.12 -0.11,0.21 -0.11,0.32 -10e-4,0.05 -0.07,0.09 -0.09,0.14 -0.07,-0.07 -0.27,-0.07 -0.28,0.04 -0.04,0.08 -0.08,0.16 0.01,0.23 0.13,-0 0.14,0.22 0.02,0.23 -0.04,0.1 0.17,0.06 0.2,0.15 0.09,0.09 0.12,0.26 0.03,0.36 -0.08,0.07 -0.1,0.15 -0.1,0.23 -0.08,0.02 -0.15,-0.14 -0.2,-0.01 -0.05,0.08 -0.14,0.16 -0.04,0.25 0.02,0.06 0.02,0.13 0.1,0.13 0.04,0.09 -0.03,0.21 -0.15,0.24 -0.13,0.07 -0.21,0.18 -0.32,0.28 -0.09,0.05 -0.1,0.13 -0.16,0.21 -0.03,0.13 -0.19,0 -0.28,0.06 -0.11,-0.03 -0.19,0.12 -0.11,0.19 0.11,0.04 0.19,0.14 0.04,0.2 -0.08,3.8e-4 -0.15,0.02 -0.22,0.05 -0.04,-0.12 -0.12,0.06 -0.17,0.09 -0.12,0.06 0.06,0.2 -0.08,0.27 -0.08,0.07 -0.22,0.18 -0.11,0.28 -0.05,0.08 -0.06,0.2 -0.12,0.27 -0.11,-0.03 -0.16,0.1 -0.27,0.04 -0.13,0 -0.23,0.09 -0.35,0.12 -0.13,0.02 -0.21,0.12 -0.21,0.23 -0.13,0.04 -0.25,0.09 -0.36,0.1 -0.09,0.07 -0.2,0.11 -0.3,0.15 -0.03,0.07 -0.13,0 -0.14,0.1 -0.04,0.03 -0.1,-0.07 -0.11,0.03 -0.02,0.06 -0.12,0.02 -0.11,0.11 -0.06,0.03 -0.12,0.06 -0.17,0.1 -0.13,-0.01 -0.23,0.1 -0.37,0.08 -0.08,-0.01 -0.13,0.05 -0.21,0.03 -0.06,0.04 0.11,0.15 -0.03,0.15 -0.08,0.03 -0.16,-0.03 -0.23,0 -0.01,0.04 0.06,0.04 0.03,0.09 0.02,0.04 0.11,0.04 0.04,0.09 -0.04,0.1 -0.19,0.07 -0.27,0.1 4.2e-4,0.1 -0.12,0.16 -0.15,0.23 0.05,0.01 0.14,0.04 0.04,0.06 -0.06,0.03 -0.22,-0.04 -0.14,0.07 -0.01,0.09 0.02,0.2 -0.09,0.25 -1.7e-4,0.11 -0.14,0.18 -0.17,0.29 0.01,0.16 -0.15,-0.02 -0.25,0.01 -0.1,0.08 -0.23,-0.1 -0.28,0.05 0.05,0.12 -0.09,0.17 -0.2,0.19 -0.08,0.03 -0.17,-0.01 -0.26,0.05 -0.11,-0.03 -0.26,0.12 -0.34,-0.02 -0.08,-0.02 -0.11,-0.09 -0.19,-0.05 -0.08,-0.03 -0.16,-0.02 -0.25,-0.06 -0.09,-0.02 -0.17,-0.09 -0.27,-0.05 -0.11,-0.03 -0.19,-0.07 -0.28,-0.13 -0.07,-0.08 -0.11,-0.19 -0.19,-0.26 -0.07,-0.07 -0.14,-0.15 -0.25,-0.09 -0.11,-0.04 -0.21,-0.06 -0.33,-0.04 -0.12,-0.02 -0.24,0.03 -0.35,-0.02 -0.1,0.06 -0.2,0.11 -0.33,0.07 -0.09,0.08 -0.21,0.02 -0.31,0.08 -0.1,0.07 -0.24,0.01 -0.36,0.04 -0.13,-0.03 -0.16,0.16 -0.27,0.11 -0.14,0.09 -0.18,-0.14 -0.31,-0.11 -0.1,-0.04 -0.13,0.05 -0.11,0.12 -0.08,0.02 -0.17,0.03 -0.18,0.13 -0.07,0.06 -0.19,0.16 -0.29,0.07 10e-4,-0.11 0.16,-0.17 0.17,-0.28 0.02,-0.12 0.1,-0.2 0.16,-0.3 0.03,-0.13 0.19,-0.14 0.28,-0.23 0.16,-0.06 0.23,-0.26 0.13,-0.39 -0.07,-0.09 -0.2,-0.13 -0.32,-0.13 -0.14,-0.01 -0.24,-0.09 -0.34,-0.17 -0.12,-0.06 -0.26,-0.07 -0.36,-0.16 -0.11,-0.06 -0.14,-0.18 -0.22,-0.26 0.02,-0.1 -0.03,-0.23 -0.15,-0.15 -0.16,0.07 -0.09,-0.19 -0.26,-0.14 -0.1,-0 -0.26,-0.02 -0.29,0.09 0.03,0.1 0.01,0.2 -0.09,0.27 -0.03,0.1 -0.12,0.13 -0.22,0.12 -0.11,0.05 -0.28,0.06 -0.31,0.2 -0.04,0.13 -0.19,0.18 -0.32,0.15 -0.16,-0.06 -0.22,0.16 -0.36,0.11 -0.08,-0.02 -0.26,-0.17 -0.28,-0.02 -0.03,0.14 0.21,0.12 0.2,0.23 -0.08,0.11 -0.23,0.15 -0.36,0.08 -0.15,-0.04 -0.3,0.01 -0.44,0.03 -0.09,0.03 -0.17,-0.01 -0.25,-0.04 -0.1,-0 -0.18,0.19 -0.24,0.05 -0.08,0.06 -0.2,0.01 -0.28,-0.04 -0.05,-0.1 -0.22,-0.1 -0.33,-0.12 -0.03,0.04 -0.11,0.12 -0.13,0.02 -0.06,-0.09 -0.14,-0.18 -0.25,-0.18 2.1e-4,-0.05 -0.05,-0.09 -0.05,-0.02 -0.08,0.04 -0.22,0.22 -0.25,0.04 -0.09,-0.05 -0.17,0.08 -0.24,-0.02 -0.07,-0.03 -0.19,0.07 -0.24,-0.02 0.03,-0.07 0.14,-0.2 0.08,-0.25 -0.05,0.01 -0.12,0.08 -0.14,-0.01 -0.03,-0.11 -0.22,-0.09 -0.16,0.04 -0.06,0.02 -0.14,0.06 -0.14,-0.03 -0.06,0.06 -0.14,0.03 -0.12,-0.05 0.03,-0.09 -0.17,-0.17 -0.21,-0.07 -0.11,0.02 -0.2,-0.12 -0.29,-0.02 -0.05,0.11 -0.2,0.04 -0.28,0.01 0.07,-0.08 -0.12,-0.09 -0.05,-0.18 0.06,-0.04 0.19,0.08 0.23,-0.01 -0.03,-0.06 -0.14,-0.1 -0.03,-0.15 0.1,0.01 0.27,-0.16 0.11,-0.18 -0.03,-0.06 -0.11,-0.08 -0.11,-0.16 -0.1,-0.04 -0.12,0.14 -0.21,0.03 -0.14,-0.09 0.22,-0.07 0.15,-0.18 0.02,-0.09 -0.11,0.05 -0.17,0.03 -0.09,0.02 -0.1,-0.08 -0.18,-0.06 -0.08,-0.09 -0.16,0.09 -0.26,0.03 -0.08,0.01 -0.05,0.11 -0.15,0.09 -0.13,-0.01 -0.13,0.15 -0.26,0.14 -0.09,0.04 -0.01,0.18 -0.14,0.2 -0.09,0.05 -0.27,0.04 -0.28,0.16 0.04,0.1 0.2,0.05 0.25,0.06 -0.02,0.07 0.11,0.16 -0.04,0.17 -0.08,0.03 -0.17,-0.04 -0.19,0.07 -0.05,0.07 -0.15,-0.05 -0.23,0.02 -0.08,0.05 -0.03,-0.18 -0.14,-0.1 -0.04,0.04 -0.07,0.11 -0.13,0.03 -0.07,0 -0.14,-0.01 -0.2,-0 -0.1,0.07 0.02,0.22 -0.07,0.31 -0.06,0.08 0.08,0.12 -0.03,0.18 -0.04,0.01 -0.03,-0.1 -0.09,-0.03 0.02,0.1 -0.12,0.07 -0.13,0.16 -0.1,0.1 -0.22,-0.02 -0.15,-0.12 0.04,-0.13 -0.11,-0.09 -0.17,-0.03 -0.06,-0.01 -0.09,-0.03 -0.11,-0.07 -0.14,0.02 -0.05,0.15 -0.11,0.23 0.02,0.09 0.01,0.17 -0.02,0.25 0.06,0.05 0.14,0.11 0.02,0.16 -0.02,0.06 0.02,0.2 -0.11,0.15 -0.08,-0.03 -0.11,0.09 -0.2,0.02 -0.11,0.02 -0.15,0.16 -0.28,0.13 -0.06,0.03 -0.12,-0.05 -0.17,0.03 -0.06,0.04 -0.14,0.1 -0.19,0.03 -0.07,0.1 -0.08,0.25 -0.22,0.31 -0.1,0.09 -0.13,-0.12 -0.2,-0.03 -0.09,-0.09 -0.26,-0.02 -0.36,-0.1 -0.03,-0.1 -0.2,-0.04 -0.19,0.05 -0.13,0.01 -0.03,0.21 -0.17,0.18 -0.1,0.04 -0.06,0.19 -0.12,0.27 0.02,0.08 0.02,0.16 0.09,0.22 -0.04,0.09 -0.19,-0.13 -0.19,0.02 0.03,0.11 -0.19,0.12 -0.19,0.22 0.05,0.04 0.12,0.15 -10e-4,0.1 -0.12,-0.04 -0.23,-0.24 -0.35,-0.12 -0.1,-0.02 -0.14,0.14 -0.22,0.03 -0.07,-0.01 -0.12,-0.07 -0.18,-0.03 0.03,-0.12 -0.1,-0.19 -0.2,-0.22 -0.02,-0.11 -0.14,-0.18 -0.16,-0.28 -0.05,-0.07 -0.01,-0.27 -0.13,-0.18 -0.06,0.05 -0.15,0.02 -0.16,0.09 -0.11,0.08 -0.24,0.1 -0.33,0.2 -0.12,0.08 -0.2,-0.02 -0.27,-0.1 -0.07,0.09 -0.14,-0.02 -0.21,0.02 -0.04,0.07 -0.14,0.11 -0.21,0.13 -0.22,-0.07 -0.44,-0.11 -0.65,-0.2 -0.11,-0.07 -0.12,0.12 -0.24,0.07 -0.09,0.02 -0.26,-0.02 -0.15,-0.12 0.1,-0.06 0.03,-0.11 -0.05,-0.13 -0.07,-0.04 -0.09,0.06 -0.17,-0.01 -0.1,-0.02 -0.09,-0.14 -0.12,-0.21 0.1,-0.01 0.03,-0.09 0.1,-0.12 0.01,-0.06 0.12,-0.11 0.01,-0.15 -0.1,-0.14 -0.13,0.12 -0.26,0.06 -0.15,-0.05 -0.26,0.07 -0.39,0.09 -0.08,-0.04 -0.32,0.06 -0.24,-0.09 0.02,-0.08 -0.02,-0.16 -0.12,-0.12 -0.13,-0.02 -0.22,0.11 -0.35,0.11 -0.12,-0.05 -0.26,-0.06 -0.35,-0.14 -0.16,0.06 0.02,-0.18 -0.11,-0.18 -0.05,-0.13 -0.28,0.04 -0.25,-0.13 0.03,-0.08 -0.07,-0.26 -0.17,-0.19 -0.14,0.08 -0.23,-0.08 -0.34,-0.13 -0.06,-0.01 -0.27,-0.07 -0.16,-0.14 0.12,-0.01 0.23,-0.09 0.35,-0.07 0.14,-0.03 -0.01,-0.18 -0.11,-0.16 -0.11,-0.03 -0.2,-0.19 -0.11,-0.28 0.06,-0.1 -0.06,-0.25 -0.18,-0.24 -0.09,0.02 -0.18,-0.04 -0.27,0.01 -0.12,-0.02 -0.22,0.06 -0.34,0.07 -0.1,-0.04 -0.25,-0.2 -0.09,-0.26 0.06,-0.05 0.11,-0.1 0.2,-0.08 0.1,-0.09 0.23,-0.06 0.34,-0.03 0.13,0.04 0.24,0.11 0.37,0.14 -0.02,0.1 0.13,0.12 0.21,0.05 0.09,0.03 0.28,3.8e-4 0.18,-0.12 -0.05,-0.1 -0.06,-0.2 -0.03,-0.3 0.05,-0.11 0.07,-0.23 0.11,-0.34 0.04,-0.09 0.1,-0.17 0.18,-0.23 0.04,-0.11 0.18,-0.14 0.23,-0.24 0.06,-0.1 0.21,-0.09 0.31,-0.05 0.12,-0.04 0.25,0.06 0.35,-0.04 0.13,0.02 0.24,-0.06 0.28,-0.17 0.14,-0.05 0.12,-0.24 0.27,-0.26 0.1,-0.03 0.1,-0.11 0.09,-0.18 0.02,-0.1 0.26,-0.04 0.21,-0.19 -0.02,-0.11 0.08,-0.17 0.18,-0.18 -0.02,-0.08 0.05,-0.09 0.11,-0.11 0.06,-0.08 0.04,-0.18 0.14,-0.24 0.02,-0.09 -0.02,-0.18 -0.01,-0.26 -0.11,-0.03 0.04,-0.05 -0.01,-0.11 0.08,-0.03 0.19,-0.03 0.21,-0.13 0.01,-0.1 0.02,-0.2 0.1,-0.29 -0.01,-0.08 0.04,-0.15 0.08,-0.19 -0.08,-0.07 0.18,-0.07 0.05,-0.14 -0.05,-0.06 -0.04,-0.17 0.04,-0.19 0.05,-0.09 0.08,-0.21 0.18,-0.26 0.09,-0.07 0.12,-0.18 0.25,-0.2 0.04,-0.08 0.14,-0.13 0.1,-0.23 0.01,-0.06 0.22,-0.02 0.13,-0.1 -0.13,-0.02 -0.01,-0.18 0,-0.25 0.03,-0.12 0.08,-0.27 0.24,-0.29 0.15,0.02 0.08,-0.14 0.2,-0.17 0.06,-0.05 0.07,-0.13 0.17,-0.11 0.14,-0.01 -0.02,-0.16 0.1,-0.18 0.07,0.08 0.12,-0.09 0.16,-0.14 0.11,-0.08 -0.06,-0.25 0.11,-0.29 0.09,-0.06 0.08,-0.15 0.01,-0.21 -0.04,-0.07 -0,-0.13 0.01,-0.19 -0.08,0.03 -0.11,-0.06 -0.04,-0.08 0.06,0.04 0.13,-0.11 0.15,0.01 0.09,-0.06 0.16,-0.13 0.17,-0.24 -0.04,-0.07 0.12,-0.15 -0.01,-0.2 -0.14,-0.03 -0.13,-0.21 -0.16,-0.31 0.02,-0.13 0.14,-0.23 0.13,-0.37 -0.02,-0.06 -0.18,-0.13 -0.03,-0.17 0.12,0.03 0.27,-0.16 0.15,-0.22 -0.06,-0.02 -0.05,-0.11 0.01,-0.05 0.14,-0 -0.06,-0.12 0.02,-0.19 0,-0.12 0.24,-9.3e-4 0.17,-0.14 -0.12,0.01 -0.21,-0.06 -0.26,-0.15 0.03,-0.09 -0.08,-0.18 -0.05,-0.25 0.16,-0.02 0.08,-0.18 0.05,-0.27 -0.04,-0.13 -0.07,-0.26 -0.21,-0.32 -0.05,-0.11 0.06,-0.26 0.19,-0.26 0.13,-0.09 -0.13,-0.18 -0.02,-0.29 0.07,-0.09 0.12,-0.2 0.04,-0.3 0.06,-0.1 -0.05,-0.18 -0.04,-0.27 -0.03,-0.07 -0.13,3.8e-4 -0.18,-0.05 -0.07,0.04 -0.08,0.23 -0.19,0.12 -0.14,-0.04 -0.08,-0.18 0.02,-0.22 0.01,-0.07 -0.11,0.04 -0.12,-0.06 -0.09,-0.05 -0.03,-0.12 0.04,-0.14 0.05,-0.09 0.06,-0.19 0.08,-0.29 0.09,-0.1 0.05,-0.23 0.15,-0.33 -0,-0.06 6.3e-4,-0.16 0.08,-0.09 0.08,-0.03 0.2,0 0.17,-0.11 0.05,-0.06 0.13,-0.09 0.14,-0.18 0.09,-0.06 0.24,-0.12 0.19,-0.25 0.03,-0.04 0.08,-0.07 0.12,-0.1 0.02,-0.01 0.06,-0.04 0.08,-0.06 z"
					}
				}
			}
		}
	);
})(jQuery);