; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown-unknown | FileCheck %s

define void @test64(i64 inreg %x) {
; CHECK-LABEL: test64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    pushq %rax
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    testl $2048, %edi # imm = 0x800
; CHECK-NEXT:    jne .LBB0_2
; CHECK-NEXT:  # %bb.1: # %yes
; CHECK-NEXT:    callq bar
; CHECK-NEXT:  .LBB0_2: # %no
; CHECK-NEXT:    popq %rax
; CHECK-NEXT:    .cfi_def_cfa_offset 8
; CHECK-NEXT:    retq
  %t = and i64 %x, 2048
  %s = icmp eq i64 %t, 0
  br i1 %s, label %yes, label %no

yes:
  call void @bar()
  ret void
no:
  ret void
}

define void @test64_optsize(i64 inreg %x) optsize {
; CHECK-LABEL: test64_optsize:
; CHECK:       # %bb.0:
; CHECK-NEXT:    pushq %rax
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    btl $11, %edi
; CHECK-NEXT:    jb .LBB1_2
; CHECK-NEXT:  # %bb.1: # %yes
; CHECK-NEXT:    callq bar
; CHECK-NEXT:  .LBB1_2: # %no
; CHECK-NEXT:    popq %rax
; CHECK-NEXT:    .cfi_def_cfa_offset 8
; CHECK-NEXT:    retq
  %t = and i64 %x, 2048
  %s = icmp eq i64 %t, 0
  br i1 %s, label %yes, label %no

yes:
  call void @bar()
  ret void
no:
  ret void
}

; This test is identical to test64 above with only the destination of the br
; reversed. This somehow causes the two functions to get slightly different
; initial IR. One has an extra invert of the setcc. This previous caused one
; the functions to use a BT while the other used a TEST due to another DAG
; combine messing with an expected canonical form.
define void @test64_2(i64 inreg %x) {
; CHECK-LABEL: test64_2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    pushq %rax
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    testl $2048, %edi # imm = 0x800
; CHECK-NEXT:    je .LBB2_2
; CHECK-NEXT:  # %bb.1: # %yes
; CHECK-NEXT:    callq bar
; CHECK-NEXT:  .LBB2_2: # %no
; CHECK-NEXT:    popq %rax
; CHECK-NEXT:    .cfi_def_cfa_offset 8
; CHECK-NEXT:    retq
  %t = and i64 %x, 2048
  %s = icmp eq i64 %t, 0
  br i1 %s, label %no, label %yes

yes:
  call void @bar()
  ret void
no:
  ret void
}

define void @test64_optsize_2(i64 inreg %x) optsize {
; CHECK-LABEL: test64_optsize_2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    pushq %rax
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    btl $11, %edi
; CHECK-NEXT:    jae .LBB3_2
; CHECK-NEXT:  # %bb.1: # %yes
; CHECK-NEXT:    callq bar
; CHECK-NEXT:  .LBB3_2: # %no
; CHECK-NEXT:    popq %rax
; CHECK-NEXT:    .cfi_def_cfa_offset 8
; CHECK-NEXT:    retq
  %t = and i64 %x, 2048
  %s = icmp eq i64 %t, 0
  br i1 %s, label %no, label %yes

yes:
  call void @bar()
  ret void
no:
  ret void
}

define void @test64_3(i64 inreg %x) {
; CHECK-LABEL: test64_3:
; CHECK:       # %bb.0:
; CHECK-NEXT:    pushq %rax
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    btq $32, %rdi
; CHECK-NEXT:    jb .LBB4_2
; CHECK-NEXT:  # %bb.1: # %yes
; CHECK-NEXT:    callq bar
; CHECK-NEXT:  .LBB4_2: # %no
; CHECK-NEXT:    popq %rax
; CHECK-NEXT:    .cfi_def_cfa_offset 8
; CHECK-NEXT:    retq
  %t = and i64 %x, 4294967296
  %s = icmp eq i64 %t, 0
  br i1 %s, label %yes, label %no

yes:
  call void @bar()
  ret void
no:
  ret void
}

define void @test64_optsize_3(i64 inreg %x) optsize {
; CHECK-LABEL: test64_optsize_3:
; CHECK:       # %bb.0:
; CHECK-NEXT:    pushq %rax
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    btq $32, %rdi
; CHECK-NEXT:    jb .LBB5_2
; CHECK-NEXT:  # %bb.1: # %yes
; CHECK-NEXT:    callq bar
; CHECK-NEXT:  .LBB5_2: # %no
; CHECK-NEXT:    popq %rax
; CHECK-NEXT:    .cfi_def_cfa_offset 8
; CHECK-NEXT:    retq
  %t = and i64 %x, 4294967296
  %s = icmp eq i64 %t, 0
  br i1 %s, label %yes, label %no

yes:
  call void @bar()
  ret void
no:
  ret void
}

define void @test64_4(i64 inreg %x) {
; CHECK-LABEL: test64_4:
; CHECK:       # %bb.0:
; CHECK-NEXT:    pushq %rax
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    btq $32, %rdi
; CHECK-NEXT:    jae .LBB6_2
; CHECK-NEXT:  # %bb.1: # %yes
; CHECK-NEXT:    callq bar
; CHECK-NEXT:  .LBB6_2: # %no
; CHECK-NEXT:    popq %rax
; CHECK-NEXT:    .cfi_def_cfa_offset 8
; CHECK-NEXT:    retq
  %t = and i64 %x, 4294967296
  %s = icmp eq i64 %t, 0
  br i1 %s, label %no, label %yes

yes:
  call void @bar()
  ret void
no:
  ret void
}

define void @test64_optsize_4(i64 inreg %x) optsize {
; CHECK-LABEL: test64_optsize_4:
; CHECK:       # %bb.0:
; CHECK-NEXT:    pushq %rax
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    btq $32, %rdi
; CHECK-NEXT:    jae .LBB7_2
; CHECK-NEXT:  # %bb.1: # %yes
; CHECK-NEXT:    callq bar
; CHECK-NEXT:  .LBB7_2: # %no
; CHECK-NEXT:    popq %rax
; CHECK-NEXT:    .cfi_def_cfa_offset 8
; CHECK-NEXT:    retq
  %t = and i64 %x, 4294967296
  %s = icmp eq i64 %t, 0
  br i1 %s, label %no, label %yes

yes:
  call void @bar()
  ret void
no:
  ret void
}

define void @test32(i32 inreg %x) {
; CHECK-LABEL: test32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    pushq %rax
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    testl $2048, %edi # imm = 0x800
; CHECK-NEXT:    jne .LBB8_2
; CHECK-NEXT:  # %bb.1: # %yes
; CHECK-NEXT:    callq bar
; CHECK-NEXT:  .LBB8_2: # %no
; CHECK-NEXT:    popq %rax
; CHECK-NEXT:    .cfi_def_cfa_offset 8
; CHECK-NEXT:    retq
  %t = and i32 %x, 2048
  %s = icmp eq i32 %t, 0
  br i1 %s, label %yes, label %no

yes:
  call void @bar()
  ret void
no:
  ret void
}

define void @test32_optsize(i32 inreg %x) optsize {
; CHECK-LABEL: test32_optsize:
; CHECK:       # %bb.0:
; CHECK-NEXT:    pushq %rax
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    btl $11, %edi
; CHECK-NEXT:    jb .LBB9_2
; CHECK-NEXT:  # %bb.1: # %yes
; CHECK-NEXT:    callq bar
; CHECK-NEXT:  .LBB9_2: # %no
; CHECK-NEXT:    popq %rax
; CHECK-NEXT:    .cfi_def_cfa_offset 8
; CHECK-NEXT:    retq
  %t = and i32 %x, 2048
  %s = icmp eq i32 %t, 0
  br i1 %s, label %yes, label %no

yes:
  call void @bar()
  ret void
no:
  ret void
}

define void @test32_2(i32 inreg %x) {
; CHECK-LABEL: test32_2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    pushq %rax
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    testl $2048, %edi # imm = 0x800
; CHECK-NEXT:    je .LBB10_2
; CHECK-NEXT:  # %bb.1: # %yes
; CHECK-NEXT:    callq bar
; CHECK-NEXT:  .LBB10_2: # %no
; CHECK-NEXT:    popq %rax
; CHECK-NEXT:    .cfi_def_cfa_offset 8
; CHECK-NEXT:    retq
  %t = and i32 %x, 2048
  %s = icmp eq i32 %t, 0
  br i1 %s, label %no, label %yes

yes:
  call void @bar()
  ret void
no:
  ret void
}

define void @test32_optsize_2(i32 inreg %x) optsize {
; CHECK-LABEL: test32_optsize_2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    pushq %rax
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    btl $11, %edi
; CHECK-NEXT:    jae .LBB11_2
; CHECK-NEXT:  # %bb.1: # %yes
; CHECK-NEXT:    callq bar
; CHECK-NEXT:  .LBB11_2: # %no
; CHECK-NEXT:    popq %rax
; CHECK-NEXT:    .cfi_def_cfa_offset 8
; CHECK-NEXT:    retq
  %t = and i32 %x, 2048
  %s = icmp eq i32 %t, 0
  br i1 %s, label %no, label %yes

yes:
  call void @bar()
  ret void
no:
  ret void
}

define void @test16(i16 inreg %x) {
; CHECK-LABEL: test16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    pushq %rax
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    testl $2048, %edi # imm = 0x800
; CHECK-NEXT:    jne .LBB12_2
; CHECK-NEXT:  # %bb.1: # %yes
; CHECK-NEXT:    callq bar
; CHECK-NEXT:  .LBB12_2: # %no
; CHECK-NEXT:    popq %rax
; CHECK-NEXT:    .cfi_def_cfa_offset 8
; CHECK-NEXT:    retq
  %t = and i16 %x, 2048
  %s = icmp eq i16 %t, 0
  br i1 %s, label %yes, label %no

yes:
  call void @bar()
  ret void
no:
  ret void
}

define void @test16_optsize(i16 inreg %x) optsize {
; CHECK-LABEL: test16_optsize:
; CHECK:       # %bb.0:
; CHECK-NEXT:    pushq %rax
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    btl $11, %edi
; CHECK-NEXT:    jb .LBB13_2
; CHECK-NEXT:  # %bb.1: # %yes
; CHECK-NEXT:    callq bar
; CHECK-NEXT:  .LBB13_2: # %no
; CHECK-NEXT:    popq %rax
; CHECK-NEXT:    .cfi_def_cfa_offset 8
; CHECK-NEXT:    retq
  %t = and i16 %x, 2048
  %s = icmp eq i16 %t, 0
  br i1 %s, label %yes, label %no

yes:
  call void @bar()
  ret void
no:
  ret void
}

define void @test16_2(i16 inreg %x) {
; CHECK-LABEL: test16_2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    pushq %rax
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    testl $2048, %edi # imm = 0x800
; CHECK-NEXT:    je .LBB14_2
; CHECK-NEXT:  # %bb.1: # %yes
; CHECK-NEXT:    callq bar
; CHECK-NEXT:  .LBB14_2: # %no
; CHECK-NEXT:    popq %rax
; CHECK-NEXT:    .cfi_def_cfa_offset 8
; CHECK-NEXT:    retq
  %t = and i16 %x, 2048
  %s = icmp eq i16 %t, 0
  br i1 %s, label %no, label %yes

yes:
  call void @bar()
  ret void
no:
  ret void
}

define void @test16_optsize_2(i16 inreg %x) optsize {
; CHECK-LABEL: test16_optsize_2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    pushq %rax
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    btl $11, %edi
; CHECK-NEXT:    jae .LBB15_2
; CHECK-NEXT:  # %bb.1: # %yes
; CHECK-NEXT:    callq bar
; CHECK-NEXT:  .LBB15_2: # %no
; CHECK-NEXT:    popq %rax
; CHECK-NEXT:    .cfi_def_cfa_offset 8
; CHECK-NEXT:    retq
  %t = and i16 %x, 2048
  %s = icmp eq i16 %t, 0
  br i1 %s, label %no, label %yes

yes:
  call void @bar()
  ret void
no:
  ret void
}

declare void @bar()
