/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.impl;

import com.thaiopensource.relaxng.impl.ApplyAfterFunction;
import com.thaiopensource.relaxng.impl.FindElementFunction;
import com.thaiopensource.relaxng.impl.NameFormatter;
import com.thaiopensource.relaxng.impl.Pattern;
import com.thaiopensource.relaxng.impl.PatternMemo;
import com.thaiopensource.relaxng.impl.SchemaBuilderImpl;
import com.thaiopensource.relaxng.impl.ValidatorPatternBuilder;
import com.thaiopensource.relaxng.parse.sax.DtdContext;
import com.thaiopensource.validate.Validator;
import com.thaiopensource.xml.util.Name;
import java.util.Hashtable;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class PatternValidator
extends DtdContext
implements Validator,
ContentHandler,
DTDHandler {
    private final ValidatorPatternBuilder builder;
    private final Pattern start;
    private final ErrorHandler eh;
    private Hashtable recoverPatternTable;
    private PatternMemo memo;
    private boolean hadError;
    private boolean collectingCharacters;
    private final StringBuffer charBuf = new StringBuffer();
    private PrefixMapping prefixMapping = new PrefixMapping("xml", "http://www.w3.org/XML/1998/namespace", null);
    private Locator locator;

    private void startCollectingCharacters() {
        if (!this.collectingCharacters) {
            this.collectingCharacters = true;
            this.charBuf.setLength(0);
        }
    }

    private void flushCharacters() throws SAXException {
        this.collectingCharacters = false;
        int n = this.charBuf.length();
        block3: for (int i = 0; i < n; ++i) {
            switch (this.charBuf.charAt(i)) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block3;
                }
                default: {
                    this.text();
                    return;
                }
            }
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        Name name;
        if (this.collectingCharacters) {
            this.flushCharacters();
        }
        if (!this.setMemo(this.memo.startTagOpenDeriv(name = new Name(string, string2)))) {
            PatternMemo patternMemo = this.memo.startTagOpenRecoverDeriv(name);
            if (!patternMemo.isNotAllowed()) {
                this.error("required_elements_missing");
            } else {
                patternMemo = this.builder.getPatternMemo(this.builder.makeAfter(this.findElement(name), this.memo.getPattern()));
                this.error(patternMemo.isNotAllowed() ? "unknown_element" : "out_of_context_element", name);
            }
            this.memo = patternMemo;
        }
        int n = attributes.getLength();
        for (int i = 0; i < n; ++i) {
            Name name2 = new Name(attributes.getURI(i), attributes.getLocalName(i));
            if (!this.setMemo(this.memo.startAttributeDeriv(name2))) {
                this.error("impossible_attribute_ignored", name2);
                continue;
            }
            if (this.setMemo(this.memo.dataDeriv(attributes.getValue(i), this))) continue;
            this.error("bad_attribute_value", name2);
            this.memo = this.memo.recoverAfter();
        }
        if (!this.setMemo(this.memo.endAttributes())) {
            this.error("required_attributes_missing");
            this.memo = this.memo.ignoreMissingAttributes();
        }
        if (this.memo.getPattern().getContentType() == 3) {
            this.startCollectingCharacters();
        }
    }

    private PatternMemo fixAfter(PatternMemo patternMemo) {
        return this.builder.getPatternMemo(patternMemo.getPattern().applyForPattern(new ApplyAfterFunction(this.builder){

            Pattern apply(Pattern pattern) {
                return PatternValidator.this.builder.makeEmpty();
            }
        }));
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (this.collectingCharacters) {
            this.collectingCharacters = false;
            if (!this.setMemo(this.memo.textOnly())) {
                this.error("only_text_not_allowed");
                this.memo = this.memo.recoverAfter();
                return;
            }
            String string4 = this.charBuf.toString();
            if (!this.setMemo(this.memo.dataDeriv(string4, this))) {
                PatternMemo patternMemo = this.memo.recoverAfter();
                if (!(this.memo.isNotAllowed() || patternMemo.isNotAllowed() && !this.fixAfter(this.memo).dataDeriv(string4, this).isNotAllowed())) {
                    this.error("string_not_allowed");
                }
                this.memo = patternMemo;
            }
        } else if (!this.setMemo(this.memo.endTagDeriv())) {
            PatternMemo patternMemo = this.memo.recoverAfter();
            if (!(this.memo.isNotAllowed() || patternMemo.isNotAllowed() && !this.fixAfter(this.memo).endTagDeriv().isNotAllowed())) {
                this.error("unfinished_element");
            }
            this.memo = patternMemo;
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.collectingCharacters) {
            this.charBuf.append(cArray, n, n2);
            return;
        }
        block3: for (int i = 0; i < n2; ++i) {
            switch (cArray[n + i]) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block3;
                }
                default: {
                    this.text();
                    return;
                }
            }
        }
    }

    private void text() throws SAXException {
        if (!this.setMemo(this.memo.mixedTextDeriv())) {
            this.error("text_not_allowed");
        }
    }

    public void endDocument() {
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void startDocument() throws SAXException {
        if (this.memo.isNotAllowed()) {
            this.error("schema_allows_nothing");
        }
    }

    public void processingInstruction(String string, String string2) {
    }

    public void skippedEntity(String string) {
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) {
    }

    public void startPrefixMapping(String string, String string2) {
        this.prefixMapping = new PrefixMapping(string, string2, this.prefixMapping);
    }

    public void endPrefixMapping(String string) {
        this.prefixMapping = this.prefixMapping.getPrevious();
    }

    public PatternValidator(Pattern pattern, ValidatorPatternBuilder validatorPatternBuilder, ErrorHandler errorHandler) {
        this.start = pattern;
        this.builder = validatorPatternBuilder;
        this.eh = errorHandler;
        this.reset();
    }

    public void reset() {
        this.hadError = false;
        this.collectingCharacters = false;
        this.locator = null;
        this.memo = this.builder.getPatternMemo(this.start);
        this.prefixMapping = new PrefixMapping("xml", "http://www.w3.org/XML/1998/namespace", null);
        this.clearDtdContext();
    }

    public ContentHandler getContentHandler() {
        return this;
    }

    public DTDHandler getDTDHandler() {
        return this;
    }

    private void error(String string) throws SAXException {
        if (this.hadError && this.memo.isNotAllowed()) {
            return;
        }
        this.hadError = true;
        this.eh.error(new SAXParseException(SchemaBuilderImpl.localizer.message(string), this.locator));
    }

    private void error(String string, Name name) throws SAXException {
        this.error(string, NameFormatter.format(name));
    }

    private void error(String string, String string2) throws SAXException {
        if (this.hadError && this.memo.isNotAllowed()) {
            return;
        }
        this.hadError = true;
        this.eh.error(new SAXParseException(SchemaBuilderImpl.localizer.message(string, string2), this.locator));
    }

    private boolean setMemo(PatternMemo patternMemo) {
        if (patternMemo.isNotAllowed()) {
            return false;
        }
        this.memo = patternMemo;
        return true;
    }

    private Pattern findElement(Name name) {
        Pattern pattern;
        if (this.recoverPatternTable == null) {
            this.recoverPatternTable = new Hashtable();
        }
        if ((pattern = (Pattern)this.recoverPatternTable.get(name)) == null) {
            pattern = FindElementFunction.findElement(this.builder, name, this.start);
            this.recoverPatternTable.put(name, pattern);
        }
        return pattern;
    }

    public String resolveNamespacePrefix(String string) {
        PrefixMapping prefixMapping = this.prefixMapping;
        do {
            if (!prefixMapping.prefix.equals(string)) continue;
            return prefixMapping.namespaceURI;
        } while ((prefixMapping = prefixMapping.previous) != null);
        return null;
    }

    public String getBaseUri() {
        return null;
    }

    private static final class PrefixMapping {
        private final String prefix;
        private final String namespaceURI;
        private final PrefixMapping previous;

        PrefixMapping(String string, String string2, PrefixMapping prefixMapping) {
            this.prefix = string;
            this.namespaceURI = string2;
            this.previous = prefixMapping;
        }

        PrefixMapping getPrevious() {
            return this.previous;
        }
    }
}

