/* Copyright (C) 2024 Wildfire Games.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

/*
 * routines specific to AArch64
 */

#include "precompiled.h"

#include "lib/sysdep/cpu.h"
#include "lib/sysdep/os.h"

#if OS_MACOSX
#include <cstdlib>
#include <cstddef>
#include <sys/sysctl.h>
#endif

const char* cpu_IdentifierString()
{
#if OS_MACOSX
	size_t bufferSize = 0;

	if (sysctlbyname("machdep.cpu.brand_string", nullptr, &bufferSize, nullptr, 0) != 0) {
		return "unknown";
	}

	char* result = static_cast<char*>(malloc(bufferSize));
	if (!result) {
		return "unknown";
	}

	if (sysctlbyname("machdep.cpu.brand_string", result, &bufferSize, nullptr, 0) != 0) {
		free(result);
		return "unknown";
	}

	return result;
#else
	return "unknown"; // TODO
#endif
}
