{ -*- buffer-read-only: t -*-

  Copyright 2015-2021 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  strict private
    function GetBeginCap: Boolean;
    procedure SetBeginCap(const Value: Boolean);
    function GetCcw: Boolean;
    procedure SetCcw(const Value: Boolean);
    function GetConvex: Boolean;
    procedure SetConvex(const Value: Boolean);
    function GetCreaseAngle: Single;
    procedure SetCreaseAngle(const Value: Single);
    function GetEndCap: Boolean;
    procedure SetEndCap(const Value: Boolean);
  public
    { X3D field "beginCap". } { }
    property BeginCap: Boolean read GetBeginCap write SetBeginCap;
    { X3D field "ccw". } { }
    property Ccw: Boolean read GetCcw write SetCcw;
    { X3D field "convex". } { }
    property Convex: Boolean read GetConvex write SetConvex;
    { X3D field "creaseAngle". } { }
    property CreaseAngle: Single read GetCreaseAngle write SetCreaseAngle;
    { Set X3D field "crossSection". } { }
    procedure SetCrossSection(const Value: array of TVector2);
    { Set X3D field "crossSection". } { }
    procedure SetCrossSection(const Value: TVector2List);
    { X3D field "endCap". } { }
    property EndCap: Boolean read GetEndCap write SetEndCap;
    { Set X3D field "orientation". } { }
    procedure SetOrientation(const Value: array of TVector4);
    { Set X3D field "orientation". } { }
    procedure SetOrientation(const Value: TVector4List);
    { Set X3D field "scale". } { }
    procedure SetScale(const Value: array of TVector2);
    { Set X3D field "scale". } { }
    procedure SetScale(const Value: TVector2List);
    { Set X3D field "spine". } { }
    procedure SetSpine(const Value: array of TVector3);
    { Set X3D field "spine". } { }
    procedure SetSpine(const Value: TVector3List);

{$endif read_interface}

{$ifdef read_implementation}

{ TExtrusionNode ----------------------------------------------- }

function TExtrusionNode.GetBeginCap: Boolean;
begin
  Result := FdBeginCap.Value;
end;

procedure TExtrusionNode.SetBeginCap(const Value: Boolean);
begin
  FdBeginCap.Send(Value);
end;

function TExtrusionNode.GetCcw: Boolean;
begin
  Result := FdCcw.Value;
end;

procedure TExtrusionNode.SetCcw(const Value: Boolean);
begin
  FdCcw.Send(Value);
end;

function TExtrusionNode.GetConvex: Boolean;
begin
  Result := FdConvex.Value;
end;

procedure TExtrusionNode.SetConvex(const Value: Boolean);
begin
  FdConvex.Send(Value);
end;

function TExtrusionNode.GetCreaseAngle: Single;
begin
  Result := FdCreaseAngle.Value;
end;

procedure TExtrusionNode.SetCreaseAngle(const Value: Single);
begin
  FdCreaseAngle.Send(Value);
end;

procedure TExtrusionNode.SetCrossSection(const Value: array of TVector2);
begin
  FdCrossSection.Send(Value);
end;

procedure TExtrusionNode.SetCrossSection(const Value: TVector2List);
begin
  FdCrossSection.Send(Value);
end;

function TExtrusionNode.GetEndCap: Boolean;
begin
  Result := FdEndCap.Value;
end;

procedure TExtrusionNode.SetEndCap(const Value: Boolean);
begin
  FdEndCap.Send(Value);
end;

procedure TExtrusionNode.SetOrientation(const Value: array of TVector4);
begin
  FdOrientation.Send(Value);
end;

procedure TExtrusionNode.SetOrientation(const Value: TVector4List);
begin
  FdOrientation.Send(Value);
end;

procedure TExtrusionNode.SetScale(const Value: array of TVector2);
begin
  FdScale.Send(Value);
end;

procedure TExtrusionNode.SetScale(const Value: TVector2List);
begin
  FdScale.Send(Value);
end;

procedure TExtrusionNode.SetSpine(const Value: array of TVector3);
begin
  FdSpine.Send(Value);
end;

procedure TExtrusionNode.SetSpine(const Value: TVector3List);
begin
  FdSpine.Send(Value);
end;

{$endif read_implementation}
