{ -*- buffer-read-only: t -*-

  Copyright 2015-2021 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  strict private
    function GetAxis: TVector3;
    procedure SetAxis(const Value: TVector3);
    function GetMaxSeparation: Single;
    procedure SetMaxSeparation(const Value: Single);
    function GetMinSeparation: Single;
    procedure SetMinSeparation(const Value: Single);
    function GetStopBounce: Single;
    procedure SetStopBounce(const Value: Single);
    function GetStopErrorCorrection: Single;
    procedure SetStopErrorCorrection(const Value: Single);
  public
    procedure CreateNode; override;
    class function ClassX3DType: string; override;

    strict private FFdAxis: TSFVec3f;
    { X3D field "axis". } { }
    public property FdAxis: TSFVec3f read FFdAxis;
    { X3D field "axis". } { }
    property Axis: TVector3 read GetAxis write SetAxis;

    strict private FFdMaxSeparation: TSFFloat;
    { X3D field "maxSeparation". } { }
    public property FdMaxSeparation: TSFFloat read FFdMaxSeparation;
    { X3D field "maxSeparation". } { }
    property MaxSeparation: Single read GetMaxSeparation write SetMaxSeparation;

    strict private FFdMinSeparation: TSFFloat;
    { X3D field "minSeparation". } { }
    public property FdMinSeparation: TSFFloat read FFdMinSeparation;
    { X3D field "minSeparation". } { }
    property MinSeparation: Single read GetMinSeparation write SetMinSeparation;

    strict private FFdStopBounce: TSFFloat;
    { X3D field "stopBounce". } { }
    public property FdStopBounce: TSFFloat read FFdStopBounce;
    { X3D field "stopBounce". } { }
    property StopBounce: Single read GetStopBounce write SetStopBounce;

    strict private FFdStopErrorCorrection: TSFFloat;
    { X3D field "stopErrorCorrection". } { }
    public property FdStopErrorCorrection: TSFFloat read FFdStopErrorCorrection;
    { X3D field "stopErrorCorrection". } { }
    property StopErrorCorrection: Single read GetStopErrorCorrection write SetStopErrorCorrection;

    strict private FEventSeparation: TSFFloatEvent;
    { X3D out event "separation". } { }
    public property EventSeparation: TSFFloatEvent read FEventSeparation;

    strict private FEventSeparationRate: TSFFloatEvent;
    { X3D out event "separationRate". } { }
    public property EventSeparationRate: TSFFloatEvent read FEventSeparationRate;

{$endif read_interface}

{$ifdef read_implementation}

{ TSliderJointNode ----------------------------------------------- }

function TSliderJointNode.GetAxis: TVector3;
begin
  Result := FdAxis.Value;
end;

procedure TSliderJointNode.SetAxis(const Value: TVector3);
begin
  FdAxis.Send(Value);
end;

function TSliderJointNode.GetMaxSeparation: Single;
begin
  Result := FdMaxSeparation.Value;
end;

procedure TSliderJointNode.SetMaxSeparation(const Value: Single);
begin
  FdMaxSeparation.Send(Value);
end;

function TSliderJointNode.GetMinSeparation: Single;
begin
  Result := FdMinSeparation.Value;
end;

procedure TSliderJointNode.SetMinSeparation(const Value: Single);
begin
  FdMinSeparation.Send(Value);
end;

function TSliderJointNode.GetStopBounce: Single;
begin
  Result := FdStopBounce.Value;
end;

procedure TSliderJointNode.SetStopBounce(const Value: Single);
begin
  FdStopBounce.Send(Value);
end;

function TSliderJointNode.GetStopErrorCorrection: Single;
begin
  Result := FdStopErrorCorrection.Value;
end;

procedure TSliderJointNode.SetStopErrorCorrection(const Value: Single);
begin
  FdStopErrorCorrection.Send(Value);
end;

class function TSliderJointNode.ClassX3DType: String;
begin
  Result := 'SliderJoint';
end;

procedure TSliderJointNode.CreateNode;
begin
  inherited;

  FFdAxis := TSFVec3f.Create(Self, True, 'axis', Vector3(0, 1, 0));
   FdAxis.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdAxis);

  FFdMaxSeparation := TSFFloat.Create(Self, True, 'maxSeparation', 1);
   FdMaxSeparation.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdMaxSeparation);
  { X3D specification comment: [0,Inf) }

  FFdMinSeparation := TSFFloat.Create(Self, True, 'minSeparation', 0);
   FdMinSeparation.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdMinSeparation);
  { X3D specification comment: [0,Inf) }

  FFdStopBounce := TSFFloat.Create(Self, True, 'stopBounce', 0);
   FdStopBounce.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdStopBounce);
  { X3D specification comment: [0,1] }

  FFdStopErrorCorrection := TSFFloat.Create(Self, True, 'stopErrorCorrection', 1);
   FdStopErrorCorrection.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdStopErrorCorrection);
  { X3D specification comment: [0,1] }

  FEventSeparation := TSFFloatEvent.Create(Self, 'separation', false);
  AddEvent(FEventSeparation);

  FEventSeparationRate := TSFFloatEvent.Create(Self, 'separationRate', false);
  AddEvent(FEventSeparationRate);
end;

{$endif read_implementation}
