/*
 * FCML - Free Code Manipulation Library.
 * Copyright (C) 2010-2020 Slawomir Wojtasiak
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

/** @file fcml_gas_mnemonics.h
 * Declarations of AT&T mnemonics for C.
 *
 * @copyright Copyright (C) 2010-2020 Slawomir Wojtasiak. All rights reserved.
 * This project is released under the GNU Lesser General Public License.
 */

#ifndef FCML_GAS_MNEMONICS_H_
#define FCML_GAS_MNEMONICS_H_

#include "fcml_types.h"

#define M_AAA FCML_TEXT("aaa")
#define M_AAD FCML_TEXT("aad")
#define M_AAM FCML_TEXT("aam")
#define M_AAS FCML_TEXT("aas")
#define M_ADC FCML_TEXT("adc")
#define M_ADCB FCML_TEXT("adcb")
#define M_ADCL FCML_TEXT("adcl")
#define M_ADCQ FCML_TEXT("adcq")
#define M_ADCW FCML_TEXT("adcw")
#define M_ADCX FCML_TEXT("adcx")
#define M_ADD FCML_TEXT("add")
#define M_ADDB FCML_TEXT("addb")
#define M_ADDL FCML_TEXT("addl")
#define M_ADDPD FCML_TEXT("addpd")
#define M_ADDPS FCML_TEXT("addps")
#define M_ADDQ FCML_TEXT("addq")
#define M_ADDSD FCML_TEXT("addsd")
#define M_ADDSS FCML_TEXT("addss")
#define M_ADDSUBPD FCML_TEXT("addsubpd")
#define M_ADDSUBPS FCML_TEXT("addsubps")
#define M_ADDW FCML_TEXT("addw")
#define M_ADOX FCML_TEXT("adox")
#define M_AESDEC FCML_TEXT("aesdec")
#define M_AESDECLAST FCML_TEXT("aesdeclast")
#define M_AESENC FCML_TEXT("aesenc")
#define M_AESENCLAST FCML_TEXT("aesenclast")
#define M_AESIMC FCML_TEXT("aesimc")
#define M_AESKEYGENASSIST FCML_TEXT("aeskeygenassist")
#define M_AND FCML_TEXT("and")
#define M_ANDB FCML_TEXT("andb")
#define M_ANDL FCML_TEXT("andl")
#define M_ANDN FCML_TEXT("andn")
#define M_ANDNPD FCML_TEXT("andnpd")
#define M_ANDNPS FCML_TEXT("andnps")
#define M_ANDPD FCML_TEXT("andpd")
#define M_ANDPS FCML_TEXT("andps")
#define M_ANDQ FCML_TEXT("andq")
#define M_ANDW FCML_TEXT("andw")
#define M_ARPL FCML_TEXT("arpl")
#define M_BEXR FCML_TEXT("bexr")
#define M_BEXTR FCML_TEXT("bextr")
#define M_BLCFILL FCML_TEXT("blcfill")
#define M_BLCI FCML_TEXT("blci")
#define M_BLCIC FCML_TEXT("blcic")
#define M_BLCMSK FCML_TEXT("blcmsk")
#define M_BLCS FCML_TEXT("blcs")
#define M_BLENDPD FCML_TEXT("blendpd")
#define M_BLENDPS FCML_TEXT("blendps")
#define M_BLENDVPD FCML_TEXT("blendvpd")
#define M_BLENDVPS FCML_TEXT("blendvps")
#define M_BLSFILL FCML_TEXT("blsfill")
#define M_BLSI FCML_TEXT("blsi")
#define M_BLSIC FCML_TEXT("blsic")
#define M_BLSMSK FCML_TEXT("blsmsk")
#define M_BLSR FCML_TEXT("blsr")
#define M_BOUND FCML_TEXT("bound")
#define M_BSF FCML_TEXT("bsf")
#define M_BSR FCML_TEXT("bsr")
#define M_BSWAP FCML_TEXT("bswap")
#define M_BT FCML_TEXT("bt")
#define M_BTC FCML_TEXT("btc")
#define M_BTCL FCML_TEXT("btcl")
#define M_BTCQ FCML_TEXT("btcq")
#define M_BTCW FCML_TEXT("btcw")
#define M_BTL FCML_TEXT("btl")
#define M_BTQ FCML_TEXT("btq")
#define M_BTR FCML_TEXT("btr")
#define M_BTRL FCML_TEXT("btrl")
#define M_BTRQ FCML_TEXT("btrq")
#define M_BTRW FCML_TEXT("btrw")
#define M_BTS FCML_TEXT("bts")
#define M_BTSL FCML_TEXT("btsl")
#define M_BTSQ FCML_TEXT("btsq")
#define M_BTSW FCML_TEXT("btsw")
#define M_BTW FCML_TEXT("btw")
#define M_BZHI FCML_TEXT("bzhi")
#define M_CALL FCML_TEXT("call")
#define M_CALLQ FCML_TEXT("callq")
#define M_CALLW FCML_TEXT("callw")
#define M_CBTW FCML_TEXT("cbtw")
#define M_CLAC FCML_TEXT("clac")
#define M_CLC FCML_TEXT("clc")
#define M_CLD FCML_TEXT("cld")
#define M_CLFLUSH FCML_TEXT("clflush")
#define M_CLGI FCML_TEXT("clgi")
#define M_CLI FCML_TEXT("cli")
#define M_CLTD FCML_TEXT("cltd")
#define M_CLTQ FCML_TEXT("cltq")
#define M_CLTS FCML_TEXT("clts")
#define M_CMC FCML_TEXT("cmc")
#define M_CMOVA FCML_TEXT("cmova")
#define M_CMOVAE FCML_TEXT("cmovae")
#define M_CMOVB FCML_TEXT("cmovb")
#define M_CMOVBE FCML_TEXT("cmovbe")
#define M_CMOVC FCML_TEXT("cmovc")
#define M_CMOVENE FCML_TEXT("cmovene")
#define M_CMOVG FCML_TEXT("cmovg")
#define M_CMOVGE FCML_TEXT("cmovge")
#define M_CMOVL FCML_TEXT("cmovl")
#define M_CMOVLE FCML_TEXT("cmovle")
#define M_CMOVNA FCML_TEXT("cmovna")
#define M_CMOVNAE FCML_TEXT("cmovnae")
#define M_CMOVNB FCML_TEXT("cmovnb")
#define M_CMOVNBE FCML_TEXT("cmovnbe")
#define M_CMOVNC FCML_TEXT("cmovnc")
#define M_CMOVNG FCML_TEXT("cmovng")
#define M_CMOVNGE FCML_TEXT("cmovnge")
#define M_CMOVNL FCML_TEXT("cmovnl")
#define M_CMOVNLE FCML_TEXT("cmovnle")
#define M_CMOVNO FCML_TEXT("cmovno")
#define M_CMOVNP FCML_TEXT("cmovnp")
#define M_CMOVNS FCML_TEXT("cmovns")
#define M_CMOVNZ FCML_TEXT("cmovnz")
#define M_CMOVO FCML_TEXT("cmovo")
#define M_CMOVP FCML_TEXT("cmovp")
#define M_CMOVPE FCML_TEXT("cmovpe")
#define M_CMOVPO FCML_TEXT("cmovpo")
#define M_CMOVS FCML_TEXT("cmovs")
#define M_CMOVZ FCML_TEXT("cmovz")
#define M_CMP FCML_TEXT("cmp")
#define M_CMPB FCML_TEXT("cmpb")
#define M_CMPEQPD FCML_TEXT("cmpeqpd")
#define M_CMPEQPS FCML_TEXT("cmpeqps")
#define M_CMPEQSD FCML_TEXT("cmpeqsd")
#define M_CMPEQSS FCML_TEXT("cmpeqss")
#define M_CMPL FCML_TEXT("cmpl")
#define M_CMPLEPD FCML_TEXT("cmplepd")
#define M_CMPLEPS FCML_TEXT("cmpleps")
#define M_CMPLESD FCML_TEXT("cmplesd")
#define M_CMPLESS FCML_TEXT("cmpless")
#define M_CMPLTPD FCML_TEXT("cmpltpd")
#define M_CMPLTPS FCML_TEXT("cmpltps")
#define M_CMPLTSD FCML_TEXT("cmpltsd")
#define M_CMPLTSS FCML_TEXT("cmpltss")
#define M_CMPNEQPD FCML_TEXT("cmpneqpd")
#define M_CMPNEQPS FCML_TEXT("cmpneqps")
#define M_CMPNEQSD FCML_TEXT("cmpneqsd")
#define M_CMPNEQSS FCML_TEXT("cmpneqss")
#define M_CMPNLEPD FCML_TEXT("cmpnlepd")
#define M_CMPNLEPS FCML_TEXT("cmpnleps")
#define M_CMPNLESD FCML_TEXT("cmpnlesd")
#define M_CMPNLESS FCML_TEXT("cmpnless")
#define M_CMPNLTPD FCML_TEXT("cmpnltpd")
#define M_CMPNLTPS FCML_TEXT("cmpnltps")
#define M_CMPNLTSD FCML_TEXT("cmpnltsd")
#define M_CMPNLTSS FCML_TEXT("cmpnltss")
#define M_CMPORDPD FCML_TEXT("cmpordpd")
#define M_CMPORDPS FCML_TEXT("cmpordps")
#define M_CMPORDSD FCML_TEXT("cmpordsd")
#define M_CMPORDSS FCML_TEXT("cmpordss")
#define M_CMPPD FCML_TEXT("cmppd")
#define M_CMPPS FCML_TEXT("cmpps")
#define M_CMPQ FCML_TEXT("cmpq")
#define M_CMPSB FCML_TEXT("cmpsb")
#define M_CMPSD FCML_TEXT("cmpsd")
#define M_CMPSL FCML_TEXT("cmpsl")
#define M_CMPSQ FCML_TEXT("cmpsq")
#define M_CMPSS FCML_TEXT("cmpss")
#define M_CMPSW FCML_TEXT("cmpsw")
#define M_CMPUNORDPD FCML_TEXT("cmpunordpd")
#define M_CMPUNORDPS FCML_TEXT("cmpunordps")
#define M_CMPUNORDSD FCML_TEXT("cmpunordsd")
#define M_CMPUNORDSS FCML_TEXT("cmpunordss")
#define M_CMPW FCML_TEXT("cmpw")
#define M_CMPXCHG FCML_TEXT("cmpxchg")
#define M_CMPXCHG16B FCML_TEXT("cmpxchg16b")
#define M_CMPXCHG8B FCML_TEXT("cmpxchg8b")
#define M_COMISD FCML_TEXT("comisd")
#define M_COMISS FCML_TEXT("comiss")
#define M_CPUID FCML_TEXT("cpuid")
#define M_CQTO FCML_TEXT("cqto")
#define M_CRC32B FCML_TEXT("crc32b")
#define M_CRC32L FCML_TEXT("crc32l")
#define M_CRC32Q FCML_TEXT("crc32q")
#define M_CRC32W FCML_TEXT("crc32w")
#define M_CVTDQ2PD FCML_TEXT("cvtdq2pd")
#define M_CVTDQ2PS FCML_TEXT("cvtdq2ps")
#define M_CVTPD2DQ FCML_TEXT("cvtpd2dq")
#define M_CVTPD2PI FCML_TEXT("cvtpd2pi")
#define M_CVTPD2PS FCML_TEXT("cvtpd2ps")
#define M_CVTPI2PD FCML_TEXT("cvtpi2pd")
#define M_CVTPI2PS FCML_TEXT("cvtpi2ps")
#define M_CVTPS2DQ FCML_TEXT("cvtps2dq")
#define M_CVTPS2PD FCML_TEXT("cvtps2pd")
#define M_CVTPS2PI FCML_TEXT("cvtps2pi")
#define M_CVTSD2SI FCML_TEXT("cvtsd2si")
#define M_CVTSD2SS FCML_TEXT("cvtsd2ss")
#define M_CVTSI2SDL FCML_TEXT("cvtsi2sdl")
#define M_CVTSI2SDQ FCML_TEXT("cvtsi2sdq")
#define M_CVTSI2SSL FCML_TEXT("cvtsi2ssl")
#define M_CVTSI2SSQ FCML_TEXT("cvtsi2ssq")
#define M_CVTSS2SD FCML_TEXT("cvtss2sd")
#define M_CVTSS2SI FCML_TEXT("cvtss2si")
#define M_CVTTPD2DQ FCML_TEXT("cvttpd2dq")
#define M_CVTTPD2PI FCML_TEXT("cvttpd2pi")
#define M_CVTTPS2DQ FCML_TEXT("cvttps2dq")
#define M_CVTTPS2PI FCML_TEXT("cvttps2pi")
#define M_CVTTSD2SI FCML_TEXT("cvttsd2si")
#define M_CVTTSS2SI FCML_TEXT("cvttss2si")
#define M_CWTD FCML_TEXT("cwtd")
#define M_CWTL FCML_TEXT("cwtl")
#define M_DAA FCML_TEXT("daa")
#define M_DAS FCML_TEXT("das")
#define M_DEC FCML_TEXT("dec")
#define M_DECB FCML_TEXT("decb")
#define M_DECL FCML_TEXT("decl")
#define M_DECQ FCML_TEXT("decq")
#define M_DECW FCML_TEXT("decw")
#define M_DIV FCML_TEXT("div")
#define M_DIVB FCML_TEXT("divb")
#define M_DIVL FCML_TEXT("divl")
#define M_DIVPD FCML_TEXT("divpd")
#define M_DIVPS FCML_TEXT("divps")
#define M_DIVQ FCML_TEXT("divq")
#define M_DIVSD FCML_TEXT("divsd")
#define M_DIVSS FCML_TEXT("divss")
#define M_DIVW FCML_TEXT("divw")
#define M_DPPD FCML_TEXT("dppd")
#define M_DPPS FCML_TEXT("dpps")
#define M_EMMS FCML_TEXT("emms")
#define M_ENTER FCML_TEXT("enter")
#define M_ENTERQ FCML_TEXT("enterq")
#define M_EXTRACTPS FCML_TEXT("extractps")
#define M_EXTRQ FCML_TEXT("extrq")
#define M_F2XM1 FCML_TEXT("f2xm1")
#define M_FABS FCML_TEXT("fabs")
#define M_FADD FCML_TEXT("fadd")
#define M_FADDL FCML_TEXT("faddl")
#define M_FADDP FCML_TEXT("faddp")
#define M_FADDS FCML_TEXT("fadds")
#define M_FBLD FCML_TEXT("fbld")
#define M_FBSTP FCML_TEXT("fbstp")
#define M_FCHS FCML_TEXT("fchs")
#define M_FCLEX FCML_TEXT("fclex")
#define M_FCMOVB FCML_TEXT("fcmovb")
#define M_FCMOVBE FCML_TEXT("fcmovbe")
#define M_FCMOVE FCML_TEXT("fcmove")
#define M_FCMOVNB FCML_TEXT("fcmovnb")
#define M_FCMOVNBE FCML_TEXT("fcmovnbe")
#define M_FCMOVNE FCML_TEXT("fcmovne")
#define M_FCMOVNU FCML_TEXT("fcmovnu")
#define M_FCMOVU FCML_TEXT("fcmovu")
#define M_FCOM FCML_TEXT("fcom")
#define M_FCOMI FCML_TEXT("fcomi")
#define M_FCOMIP FCML_TEXT("fcomip")
#define M_FCOML FCML_TEXT("fcoml")
#define M_FCOMP FCML_TEXT("fcomp")
#define M_FCOMPL FCML_TEXT("fcompl")
#define M_FCOMPP FCML_TEXT("fcompp")
#define M_FCOMPS FCML_TEXT("fcomps")
#define M_FCOMS FCML_TEXT("fcoms")
#define M_FCOS FCML_TEXT("fcos")
#define M_FDECSTP FCML_TEXT("fdecstp")
#define M_FDIV FCML_TEXT("fdiv")
#define M_FDIVL FCML_TEXT("fdivl")
#define M_FDIVP FCML_TEXT("fdivp")
#define M_FDIVR FCML_TEXT("fdivr")
#define M_FDIVRL FCML_TEXT("fdivrl")
#define M_FDIVRP FCML_TEXT("fdivrp")
#define M_FDIVRS FCML_TEXT("fdivrs")
#define M_FDIVS FCML_TEXT("fdivs")
#define M_FEMMS FCML_TEXT("femms")
#define M_FFREE FCML_TEXT("ffree")
#define M_FIADD FCML_TEXT("fiadd")
#define M_FIADDL FCML_TEXT("fiaddl")
#define M_FICOM FCML_TEXT("ficom")
#define M_FICOML FCML_TEXT("ficoml")
#define M_FICOMP FCML_TEXT("ficomp")
#define M_FICOMPL FCML_TEXT("ficompl")
#define M_FIDIV FCML_TEXT("fidiv")
#define M_FIDIVL FCML_TEXT("fidivl")
#define M_FIDIVR FCML_TEXT("fidivr")
#define M_FIDIVRL FCML_TEXT("fidivrl")
#define M_FILD FCML_TEXT("fild")
#define M_FILDL FCML_TEXT("fildl")
#define M_FILDLL FCML_TEXT("fildll")
#define M_FIMUL FCML_TEXT("fimul")
#define M_FIMULL FCML_TEXT("fimull")
#define M_FINCSTP FCML_TEXT("fincstp")
#define M_FINIT FCML_TEXT("finit")
#define M_FIST FCML_TEXT("fist")
#define M_FISTL FCML_TEXT("fistl")
#define M_FISTP FCML_TEXT("fistp")
#define M_FISTPL FCML_TEXT("fistpl")
#define M_FISTPLL FCML_TEXT("fistpll")
#define M_FISTTP FCML_TEXT("fisttp")
#define M_FISTTPL FCML_TEXT("fisttpl")
#define M_FISTTPLL FCML_TEXT("fisttpll")
#define M_FISUB FCML_TEXT("fisub")
#define M_FISUBL FCML_TEXT("fisubl")
#define M_FISUBR FCML_TEXT("fisubr")
#define M_FISUBRL FCML_TEXT("fisubrl")
#define M_FLD FCML_TEXT("fld")
#define M_FLD1 FCML_TEXT("fld1")
#define M_FLDCW FCML_TEXT("fldcw")
#define M_FLDENV FCML_TEXT("fldenv")
#define M_FLDENVS FCML_TEXT("fldenvs")
#define M_FLDL FCML_TEXT("fldl")
#define M_FLDL2E FCML_TEXT("fldl2e")
#define M_FLDL2T FCML_TEXT("fldl2t")
#define M_FLDLG2 FCML_TEXT("fldlg2")
#define M_FLDLN2 FCML_TEXT("fldln2")
#define M_FLDPI FCML_TEXT("fldpi")
#define M_FLDS FCML_TEXT("flds")
#define M_FLDT FCML_TEXT("fldt")
#define M_FLDZ FCML_TEXT("fldz")
#define M_FMUL FCML_TEXT("fmul")
#define M_FMULL FCML_TEXT("fmull")
#define M_FMULP FCML_TEXT("fmulp")
#define M_FMULS FCML_TEXT("fmuls")
#define M_FNCLEX FCML_TEXT("fnclex")
#define M_FNINIT FCML_TEXT("fninit")
#define M_FNOP FCML_TEXT("fnop")
#define M_FNSAVE FCML_TEXT("fnsave")
#define M_FNSAVES FCML_TEXT("fnsaves")
#define M_FNSTCW FCML_TEXT("fnstcw")
#define M_FNSTENV FCML_TEXT("fnstenv")
#define M_FNSTENVS FCML_TEXT("fnstenvs")
#define M_FNSTSW FCML_TEXT("fnstsw")
#define M_FPATAN FCML_TEXT("fpatan")
#define M_FPREM FCML_TEXT("fprem")
#define M_FPREM1 FCML_TEXT("fprem1")
#define M_FPTAN FCML_TEXT("fptan")
#define M_FRNDINT FCML_TEXT("frndint")
#define M_FRSTOR FCML_TEXT("frstor")
#define M_FRSTORS FCML_TEXT("frstors")
#define M_FSAVE FCML_TEXT("fsave")
#define M_FSAVES FCML_TEXT("fsaves")
#define M_FSCALE FCML_TEXT("fscale")
#define M_FSIN FCML_TEXT("fsin")
#define M_FSINCOS FCML_TEXT("fsincos")
#define M_FSQRT FCML_TEXT("fsqrt")
#define M_FST FCML_TEXT("fst")
#define M_FSTCW FCML_TEXT("fstcw")
#define M_FSTENV FCML_TEXT("fstenv")
#define M_FSTENVS FCML_TEXT("fstenvs")
#define M_FSTL FCML_TEXT("fstl")
#define M_FSTP FCML_TEXT("fstp")
#define M_FSTPL FCML_TEXT("fstpl")
#define M_FSTPS FCML_TEXT("fstps")
#define M_FSTPT FCML_TEXT("fstpt")
#define M_FSTS FCML_TEXT("fsts")
#define M_FSTSW FCML_TEXT("fstsw")
#define M_FSUB FCML_TEXT("fsub")
#define M_FSUBL FCML_TEXT("fsubl")
#define M_FSUBP FCML_TEXT("fsubp")
#define M_FSUBR FCML_TEXT("fsubr")
#define M_FSUBRL FCML_TEXT("fsubrl")
#define M_FSUBRP FCML_TEXT("fsubrp")
#define M_FSUBRS FCML_TEXT("fsubrs")
#define M_FSUBS FCML_TEXT("fsubs")
#define M_FTST FCML_TEXT("ftst")
#define M_FUCOM FCML_TEXT("fucom")
#define M_FUCOMI FCML_TEXT("fucomi")
#define M_FUCOMIP FCML_TEXT("fucomip")
#define M_FUCOMP FCML_TEXT("fucomp")
#define M_FUCOMPP FCML_TEXT("fucompp")
#define M_FWAIT FCML_TEXT("fwait")
#define M_FXAM FCML_TEXT("fxam")
#define M_FXCH FCML_TEXT("fxch")
#define M_FXRSTOR FCML_TEXT("fxrstor")
#define M_FXRSTOR64 FCML_TEXT("fxrstor64")
#define M_FXSAVE FCML_TEXT("fxsave")
#define M_FXSAVE64 FCML_TEXT("fxsave64")
#define M_FXTRACT FCML_TEXT("fxtract")
#define M_FYL2X FCML_TEXT("fyl2x")
#define M_FYL2XP1 FCML_TEXT("fyl2xp1")
#define M_GETSEC FCML_TEXT("getsec")
#define M_HADDPD FCML_TEXT("haddpd")
#define M_HADDPS FCML_TEXT("haddps")
#define M_HLT FCML_TEXT("hlt")
#define M_HSUBPD FCML_TEXT("hsubpd")
#define M_HSUBPS FCML_TEXT("hsubps")
#define M_IDIV FCML_TEXT("idiv")
#define M_IDIVB FCML_TEXT("idivb")
#define M_IDIVL FCML_TEXT("idivl")
#define M_IDIVQ FCML_TEXT("idivq")
#define M_IDIVW FCML_TEXT("idivw")
#define M_IMUL FCML_TEXT("imul")
#define M_IMULB FCML_TEXT("imulb")
#define M_IMULL FCML_TEXT("imull")
#define M_IMULQ FCML_TEXT("imulq")
#define M_IMULW FCML_TEXT("imulw")
#define M_IN FCML_TEXT("in")
#define M_INC FCML_TEXT("inc")
#define M_INCB FCML_TEXT("incb")
#define M_INCL FCML_TEXT("incl")
#define M_INCQ FCML_TEXT("incq")
#define M_INCW FCML_TEXT("incw")
#define M_INSB FCML_TEXT("insb")
#define M_INSERTPS FCML_TEXT("insertps")
#define M_INSERTQ FCML_TEXT("insertq")
#define M_INSL FCML_TEXT("insl")
#define M_INSW FCML_TEXT("insw")
#define M_INT FCML_TEXT("int")
#define M_INT3 FCML_TEXT("int3")
#define M_INTO FCML_TEXT("into")
#define M_INVD FCML_TEXT("invd")
#define M_INVEPT FCML_TEXT("invept")
#define M_INVLPG FCML_TEXT("invlpg")
#define M_INVLPGA FCML_TEXT("invlpga")
#define M_INVPCID FCML_TEXT("invpcid")
#define M_INVVPID FCML_TEXT("invvpid")
#define M_IRET FCML_TEXT("iret")
#define M_IRETQ FCML_TEXT("iretq")
#define M_IRETW FCML_TEXT("iretw")
#define M_JA FCML_TEXT("ja")
#define M_JAE FCML_TEXT("jae")
#define M_JB FCML_TEXT("jb")
#define M_JBE FCML_TEXT("jbe")
#define M_JC FCML_TEXT("jc")
#define M_JCXZ FCML_TEXT("jcxz")
#define M_JECXZ FCML_TEXT("jecxz")
#define M_JENE FCML_TEXT("jene")
#define M_JG FCML_TEXT("jg")
#define M_JGE FCML_TEXT("jge")
#define M_JL FCML_TEXT("jl")
#define M_JLE FCML_TEXT("jle")
#define M_JMP FCML_TEXT("jmp")
#define M_JMPQ FCML_TEXT("jmpq")
#define M_JMPW FCML_TEXT("jmpw")
#define M_JNA FCML_TEXT("jna")
#define M_JNAE FCML_TEXT("jnae")
#define M_JNB FCML_TEXT("jnb")
#define M_JNBE FCML_TEXT("jnbe")
#define M_JNC FCML_TEXT("jnc")
#define M_JNG FCML_TEXT("jng")
#define M_JNGE FCML_TEXT("jnge")
#define M_JNL FCML_TEXT("jnl")
#define M_JNLE FCML_TEXT("jnle")
#define M_JNO FCML_TEXT("jno")
#define M_JNP FCML_TEXT("jnp")
#define M_JNS FCML_TEXT("jns")
#define M_JNZ FCML_TEXT("jnz")
#define M_JO FCML_TEXT("jo")
#define M_JP FCML_TEXT("jp")
#define M_JPE FCML_TEXT("jpe")
#define M_JPO FCML_TEXT("jpo")
#define M_JRCXZ FCML_TEXT("jrcxz")
#define M_JS FCML_TEXT("js")
#define M_JZ FCML_TEXT("jz")
#define M_KADDB FCML_TEXT("kaddb")
#define M_KADDD FCML_TEXT("kaddd")
#define M_KADDQ FCML_TEXT("kaddq")
#define M_KADDW FCML_TEXT("kaddw")
#define M_KANDB FCML_TEXT("kandb")
#define M_KANDD FCML_TEXT("kandd")
#define M_KANDNB FCML_TEXT("kandnb")
#define M_KANDND FCML_TEXT("kandnd")
#define M_KANDNQ FCML_TEXT("kandnq")
#define M_KANDNW FCML_TEXT("kandnw")
#define M_KANDQ FCML_TEXT("kandq")
#define M_KANDW FCML_TEXT("kandw")
#define M_KMOVB FCML_TEXT("kmovb")
#define M_KMOVD FCML_TEXT("kmovd")
#define M_KMOVQ FCML_TEXT("kmovq")
#define M_KMOVW FCML_TEXT("kmovw")
#define M_KNOTB FCML_TEXT("knotb")
#define M_KNOTD FCML_TEXT("knotd")
#define M_KNOTQ FCML_TEXT("knotq")
#define M_KNOTW FCML_TEXT("knotw")
#define M_KORB FCML_TEXT("korb")
#define M_KORD FCML_TEXT("kord")
#define M_KORQ FCML_TEXT("korq")
#define M_KORTESTB FCML_TEXT("kortestb")
#define M_KORTESTD FCML_TEXT("kortestd")
#define M_KORTESTQ FCML_TEXT("kortestq")
#define M_KORTESTW FCML_TEXT("kortestw")
#define M_KORW FCML_TEXT("korw")
#define M_KSHIFTLB FCML_TEXT("kshiftlb")
#define M_KSHIFTLD FCML_TEXT("kshiftld")
#define M_KSHIFTLQ FCML_TEXT("kshiftlq")
#define M_KSHIFTLW FCML_TEXT("kshiftlw")
#define M_KSHIFTRB FCML_TEXT("kshiftrb")
#define M_KSHIFTRD FCML_TEXT("kshiftrd")
#define M_KSHIFTRQ FCML_TEXT("kshiftrq")
#define M_KSHIFTRW FCML_TEXT("kshiftrw")
#define M_KTESTB FCML_TEXT("ktestb")
#define M_KTESTD FCML_TEXT("ktestd")
#define M_KTESTQ FCML_TEXT("ktestq")
#define M_KTESTW FCML_TEXT("ktestw")
#define M_KXNORB FCML_TEXT("kxnorb")
#define M_KXNORD FCML_TEXT("kxnord")
#define M_KXNORQ FCML_TEXT("kxnorq")
#define M_KXNORW FCML_TEXT("kxnorw")
#define M_KXORB FCML_TEXT("kxorb")
#define M_KXORD FCML_TEXT("kxord")
#define M_KXORQ FCML_TEXT("kxorq")
#define M_KXORW FCML_TEXT("kxorw")
#define M_LAHF FCML_TEXT("lahf")
#define M_LAR FCML_TEXT("lar")
#define M_LCALL FCML_TEXT("lcall")
#define M_LCALLQ FCML_TEXT("lcallq")
#define M_LCALLW FCML_TEXT("lcallw")
#define M_LDDQU FCML_TEXT("lddqu")
#define M_LDMXCSR FCML_TEXT("ldmxcsr")
#define M_LDS FCML_TEXT("lds")
#define M_LEA FCML_TEXT("lea")
#define M_LEAVE FCML_TEXT("leave")
#define M_LES FCML_TEXT("les")
#define M_LFENCE FCML_TEXT("lfence")
#define M_LFS FCML_TEXT("lfs")
#define M_LGDT FCML_TEXT("lgdt")
#define M_LGS FCML_TEXT("lgs")
#define M_LIDT FCML_TEXT("lidt")
#define M_LJMP FCML_TEXT("ljmp")
#define M_LJMPL FCML_TEXT("ljmpl")
#define M_LJMPQ FCML_TEXT("ljmpq")
#define M_LJMPW FCML_TEXT("ljmpw")
#define M_LLDT FCML_TEXT("lldt")
#define M_LLWPCB FCML_TEXT("llwpcb")
#define M_LMSW FCML_TEXT("lmsw")
#define M_LODS FCML_TEXT("lods")
#define M_LODSB FCML_TEXT("lodsb")
#define M_LODSL FCML_TEXT("lodsl")
#define M_LODSQ FCML_TEXT("lodsq")
#define M_LODSW FCML_TEXT("lodsw")
#define M_LOOP FCML_TEXT("loop")
#define M_LOOPE FCML_TEXT("loope")
#define M_LOOPNE FCML_TEXT("loopne")
#define M_LOOPNZ FCML_TEXT("loopnz")
#define M_LOOPZ FCML_TEXT("loopz")
#define M_LRET FCML_TEXT("lret")
#define M_LRETQ FCML_TEXT("lretq")
#define M_LRETW FCML_TEXT("lretw")
#define M_LSL FCML_TEXT("lsl")
#define M_LSS FCML_TEXT("lss")
#define M_LTR FCML_TEXT("ltr")
#define M_LWPINS FCML_TEXT("lwpins")
#define M_LWPVAL FCML_TEXT("lwpval")
#define M_LZCNT FCML_TEXT("lzcnt")
#define M_MASKMOVDQU FCML_TEXT("maskmovdqu")
#define M_MASKMOVQ FCML_TEXT("maskmovq")
#define M_MAXPD FCML_TEXT("maxpd")
#define M_MAXPS FCML_TEXT("maxps")
#define M_MAXSD FCML_TEXT("maxsd")
#define M_MAXSS FCML_TEXT("maxss")
#define M_MFENCE FCML_TEXT("mfence")
#define M_MINPD FCML_TEXT("minpd")
#define M_MINPS FCML_TEXT("minps")
#define M_MINSD FCML_TEXT("minsd")
#define M_MINSS FCML_TEXT("minss")
#define M_MONITOR FCML_TEXT("monitor")
#define M_MOV FCML_TEXT("mov")
#define M_MOVABS FCML_TEXT("movabs")
#define M_MOVAPD FCML_TEXT("movapd")
#define M_MOVAPS FCML_TEXT("movaps")
#define M_MOVB FCML_TEXT("movb")
#define M_MOVBE FCML_TEXT("movbe")
#define M_MOVD FCML_TEXT("movd")
#define M_MOVDDUP FCML_TEXT("movddup")
#define M_MOVDQ2Q FCML_TEXT("movdq2q")
#define M_MOVDQA FCML_TEXT("movdqa")
#define M_MOVDQU FCML_TEXT("movdqu")
#define M_MOVHLPS FCML_TEXT("movhlps")
#define M_MOVHPD FCML_TEXT("movhpd")
#define M_MOVHPS FCML_TEXT("movhps")
#define M_MOVL FCML_TEXT("movl")
#define M_MOVLHPS FCML_TEXT("movlhps")
#define M_MOVLPD FCML_TEXT("movlpd")
#define M_MOVLPS FCML_TEXT("movlps")
#define M_MOVMSKPD FCML_TEXT("movmskpd")
#define M_MOVMSKPS FCML_TEXT("movmskps")
#define M_MOVNTDQ FCML_TEXT("movntdq")
#define M_MOVNTDQA FCML_TEXT("movntdqa")
#define M_MOVNTI FCML_TEXT("movnti")
#define M_MOVNTPD FCML_TEXT("movntpd")
#define M_MOVNTPS FCML_TEXT("movntps")
#define M_MOVNTQ FCML_TEXT("movntq")
#define M_MOVNTSD FCML_TEXT("movntsd")
#define M_MOVNTSS FCML_TEXT("movntss")
#define M_MOVQ FCML_TEXT("movq")
#define M_MOVQ2DQ FCML_TEXT("movq2dq")
#define M_MOVS FCML_TEXT("movs")
#define M_MOVSB FCML_TEXT("movsb")
#define M_MOVSBL FCML_TEXT("movsbl")
#define M_MOVSBQ FCML_TEXT("movsbq")
#define M_MOVSBW FCML_TEXT("movsbw")
#define M_MOVSD FCML_TEXT("movsd")
#define M_MOVSHDUP FCML_TEXT("movshdup")
#define M_MOVSL FCML_TEXT("movsl")
#define M_MOVSLDUP FCML_TEXT("movsldup")
#define M_MOVSQ FCML_TEXT("movsq")
#define M_MOVSS FCML_TEXT("movss")
#define M_MOVSW FCML_TEXT("movsw")
#define M_MOVSWL FCML_TEXT("movswl")
#define M_MOVSWQ FCML_TEXT("movswq")
#define M_MOVSWW FCML_TEXT("movsww")
#define M_MOVSXD FCML_TEXT("movsxd")
#define M_MOVUPD FCML_TEXT("movupd")
#define M_MOVUPS FCML_TEXT("movups")
#define M_MOVW FCML_TEXT("movw")
#define M_MOVZBL FCML_TEXT("movzbl")
#define M_MOVZBQ FCML_TEXT("movzbq")
#define M_MOVZBW FCML_TEXT("movzbw")
#define M_MOVZWL FCML_TEXT("movzwl")
#define M_MOVZWQ FCML_TEXT("movzwq")
#define M_MOVZWW FCML_TEXT("movzww")
#define M_MPSADBW FCML_TEXT("mpsadbw")
#define M_MUL FCML_TEXT("mul")
#define M_MULB FCML_TEXT("mulb")
#define M_MULL FCML_TEXT("mull")
#define M_MULPD FCML_TEXT("mulpd")
#define M_MULPS FCML_TEXT("mulps")
#define M_MULQ FCML_TEXT("mulq")
#define M_MULSD FCML_TEXT("mulsd")
#define M_MULSS FCML_TEXT("mulss")
#define M_MULW FCML_TEXT("mulw")
#define M_MULX FCML_TEXT("mulx")
#define M_MWAIT FCML_TEXT("mwait")
#define M_NEG FCML_TEXT("neg")
#define M_NEGB FCML_TEXT("negb")
#define M_NEGL FCML_TEXT("negl")
#define M_NEGQ FCML_TEXT("negq")
#define M_NEGW FCML_TEXT("negw")
#define M_NOP FCML_TEXT("nop")
#define M_NOPL FCML_TEXT("nopl")
#define M_NOPQ FCML_TEXT("nopq")
#define M_NOPW FCML_TEXT("nopw")
#define M_NOT FCML_TEXT("not")
#define M_NOTB FCML_TEXT("notb")
#define M_NOTL FCML_TEXT("notl")
#define M_NOTQ FCML_TEXT("notq")
#define M_NOTW FCML_TEXT("notw")
#define M_OR FCML_TEXT("or")
#define M_ORB FCML_TEXT("orb")
#define M_ORL FCML_TEXT("orl")
#define M_ORPD FCML_TEXT("orpd")
#define M_ORPS FCML_TEXT("orps")
#define M_ORQ FCML_TEXT("orq")
#define M_ORW FCML_TEXT("orw")
#define M_OUT FCML_TEXT("out")
#define M_OUTSB FCML_TEXT("outsb")
#define M_OUTSL FCML_TEXT("outsl")
#define M_OUTSW FCML_TEXT("outsw")
#define M_PABSB FCML_TEXT("pabsb")
#define M_PABSD FCML_TEXT("pabsd")
#define M_PABSW FCML_TEXT("pabsw")
#define M_PACKSSDW FCML_TEXT("packssdw")
#define M_PACKSSWB FCML_TEXT("packsswb")
#define M_PACKUSDW FCML_TEXT("packusdw")
#define M_PACKUSWB FCML_TEXT("packuswb")
#define M_PADDB FCML_TEXT("paddb")
#define M_PADDD FCML_TEXT("paddd")
#define M_PADDQ FCML_TEXT("paddq")
#define M_PADDSB FCML_TEXT("paddsb")
#define M_PADDSW FCML_TEXT("paddsw")
#define M_PADDUSB FCML_TEXT("paddusb")
#define M_PADDUSW FCML_TEXT("paddusw")
#define M_PADDW FCML_TEXT("paddw")
#define M_PALIGNR FCML_TEXT("palignr")
#define M_PAND FCML_TEXT("pand")
#define M_PANDN FCML_TEXT("pandn")
#define M_PAUSE FCML_TEXT("pause")
#define M_PAVGB FCML_TEXT("pavgb")
#define M_PAVGUSB FCML_TEXT("pavgusb")
#define M_PAVGW FCML_TEXT("pavgw")
#define M_PBLENDVB FCML_TEXT("pblendvb")
#define M_PBLENDW FCML_TEXT("pblendw")
#define M_PCLMULQDQ FCML_TEXT("pclmulqdq")
#define M_PCMPEQB FCML_TEXT("pcmpeqb")
#define M_PCMPEQD FCML_TEXT("pcmpeqd")
#define M_PCMPEQQ FCML_TEXT("pcmpeqq")
#define M_PCMPEQW FCML_TEXT("pcmpeqw")
#define M_PCMPESTRI FCML_TEXT("pcmpestri")
#define M_PCMPESTRM FCML_TEXT("pcmpestrm")
#define M_PCMPGTB FCML_TEXT("pcmpgtb")
#define M_PCMPGTD FCML_TEXT("pcmpgtd")
#define M_PCMPGTQ FCML_TEXT("pcmpgtq")
#define M_PCMPGTW FCML_TEXT("pcmpgtw")
#define M_PCMPISTRI FCML_TEXT("pcmpistri")
#define M_PCMPISTRM FCML_TEXT("pcmpistrm")
#define M_PDEP FCML_TEXT("pdep")
#define M_PEXT FCML_TEXT("pext")
#define M_PEXTRB FCML_TEXT("pextrb")
#define M_PEXTRD FCML_TEXT("pextrd")
#define M_PEXTRQ FCML_TEXT("pextrq")
#define M_PEXTRW FCML_TEXT("pextrw")
#define M_PF2ID FCML_TEXT("pf2id")
#define M_PF2IW FCML_TEXT("pf2iw")
#define M_PFACC FCML_TEXT("pfacc")
#define M_PFADD FCML_TEXT("pfadd")
#define M_PFCMPEQ FCML_TEXT("pfcmpeq")
#define M_PFCMPGE FCML_TEXT("pfcmpge")
#define M_PFCMPGT FCML_TEXT("pfcmpgt")
#define M_PFMAX FCML_TEXT("pfmax")
#define M_PFMIN FCML_TEXT("pfmin")
#define M_PFMUL FCML_TEXT("pfmul")
#define M_PFNACC FCML_TEXT("pfnacc")
#define M_PFPNACC FCML_TEXT("pfpnacc")
#define M_PFRCP FCML_TEXT("pfrcp")
#define M_PFRCPIT1 FCML_TEXT("pfrcpit1")
#define M_PFRCPIT2 FCML_TEXT("pfrcpit2")
#define M_PFRSQIT1 FCML_TEXT("pfrsqit1")
#define M_PFRSQRT FCML_TEXT("pfrsqrt")
#define M_PFSUB FCML_TEXT("pfsub")
#define M_PFSUBR FCML_TEXT("pfsubr")
#define M_PHADDD FCML_TEXT("phaddd")
#define M_PHADDSW FCML_TEXT("phaddsw")
#define M_PHADDW FCML_TEXT("phaddw")
#define M_PHMINPOSUW FCML_TEXT("phminposuw")
#define M_PHSUBD FCML_TEXT("phsubd")
#define M_PHSUBSW FCML_TEXT("phsubsw")
#define M_PHSUBW FCML_TEXT("phsubw")
#define M_PI2FD FCML_TEXT("pi2fd")
#define M_PI2FW FCML_TEXT("pi2fw")
#define M_PINSRB FCML_TEXT("pinsrb")
#define M_PINSRD FCML_TEXT("pinsrd")
#define M_PINSRQ FCML_TEXT("pinsrq")
#define M_PINSRW FCML_TEXT("pinsrw")
#define M_PMADDUBSW FCML_TEXT("pmaddubsw")
#define M_PMADDWD FCML_TEXT("pmaddwd")
#define M_PMAXSB FCML_TEXT("pmaxsb")
#define M_PMAXSD FCML_TEXT("pmaxsd")
#define M_PMAXSW FCML_TEXT("pmaxsw")
#define M_PMAXUB FCML_TEXT("pmaxub")
#define M_PMAXUD FCML_TEXT("pmaxud")
#define M_PMAXUW FCML_TEXT("pmaxuw")
#define M_PMINSB FCML_TEXT("pminsb")
#define M_PMINSD FCML_TEXT("pminsd")
#define M_PMINSW FCML_TEXT("pminsw")
#define M_PMINUB FCML_TEXT("pminub")
#define M_PMINUD FCML_TEXT("pminud")
#define M_PMINUW FCML_TEXT("pminuw")
#define M_PMOVMSKB FCML_TEXT("pmovmskb")
#define M_PMOVSXBD FCML_TEXT("pmovsxbd")
#define M_PMOVSXBQ FCML_TEXT("pmovsxbq")
#define M_PMOVSXBW FCML_TEXT("pmovsxbw")
#define M_PMOVSXDQ FCML_TEXT("pmovsxdq")
#define M_PMOVSXWD FCML_TEXT("pmovsxwd")
#define M_PMOVSXWQ FCML_TEXT("pmovsxwq")
#define M_PMOVZXBD FCML_TEXT("pmovzxbd")
#define M_PMOVZXBQ FCML_TEXT("pmovzxbq")
#define M_PMOVZXBW FCML_TEXT("pmovzxbw")
#define M_PMOVZXDQ FCML_TEXT("pmovzxdq")
#define M_PMOVZXWD FCML_TEXT("pmovzxwd")
#define M_PMOVZXWQ FCML_TEXT("pmovzxwq")
#define M_PMULDQ FCML_TEXT("pmuldq")
#define M_PMULHRSW FCML_TEXT("pmulhrsw")
#define M_PMULHRW FCML_TEXT("pmulhrw")
#define M_PMULHUW FCML_TEXT("pmulhuw")
#define M_PMULHW FCML_TEXT("pmulhw")
#define M_PMULLD FCML_TEXT("pmulld")
#define M_PMULLW FCML_TEXT("pmullw")
#define M_PMULUDQ FCML_TEXT("pmuludq")
#define M_POP FCML_TEXT("pop")
#define M_POPA FCML_TEXT("popa")
#define M_POPAW FCML_TEXT("popaw")
#define M_POPCNT FCML_TEXT("popcnt")
#define M_POPF FCML_TEXT("popf")
#define M_POPFQ FCML_TEXT("popfq")
#define M_POPFW FCML_TEXT("popfw")
#define M_POPL FCML_TEXT("popl")
#define M_POPQ FCML_TEXT("popq")
#define M_POPW FCML_TEXT("popw")
#define M_POR FCML_TEXT("por")
#define M_PREFETCH FCML_TEXT("prefetch")
#define M_PREFETCHNTA FCML_TEXT("prefetchnta")
#define M_PREFETCHT0 FCML_TEXT("prefetcht0")
#define M_PREFETCHT1 FCML_TEXT("prefetcht1")
#define M_PREFETCHT2 FCML_TEXT("prefetcht2")
#define M_PREFETCHW FCML_TEXT("prefetchw")
#define M_PREFETCHWT1 FCML_TEXT("prefetchwt1")
#define M_PSADBW FCML_TEXT("psadbw")
#define M_PSHUFB FCML_TEXT("pshufb")
#define M_PSHUFD FCML_TEXT("pshufd")
#define M_PSHUFHW FCML_TEXT("pshufhw")
#define M_PSHUFLW FCML_TEXT("pshuflw")
#define M_PSHUFW FCML_TEXT("pshufw")
#define M_PSIGNB FCML_TEXT("psignb")
#define M_PSIGND FCML_TEXT("psignd")
#define M_PSIGNW FCML_TEXT("psignw")
#define M_PSLLD FCML_TEXT("pslld")
#define M_PSLLDQ FCML_TEXT("pslldq")
#define M_PSLLQ FCML_TEXT("psllq")
#define M_PSLLW FCML_TEXT("psllw")
#define M_PSRAD FCML_TEXT("psrad")
#define M_PSRAW FCML_TEXT("psraw")
#define M_PSRLD FCML_TEXT("psrld")
#define M_PSRLDQ FCML_TEXT("psrldq")
#define M_PSRLQ FCML_TEXT("psrlq")
#define M_PSRLW FCML_TEXT("psrlw")
#define M_PSUBB FCML_TEXT("psubb")
#define M_PSUBD FCML_TEXT("psubd")
#define M_PSUBQ FCML_TEXT("psubq")
#define M_PSUBSB FCML_TEXT("psubsb")
#define M_PSUBSW FCML_TEXT("psubsw")
#define M_PSUBUSB FCML_TEXT("psubusb")
#define M_PSUBUSW FCML_TEXT("psubusw")
#define M_PSUBW FCML_TEXT("psubw")
#define M_PSWAPD FCML_TEXT("pswapd")
#define M_PTEST FCML_TEXT("ptest")
#define M_PUNPCKHBW FCML_TEXT("punpckhbw")
#define M_PUNPCKHDQ FCML_TEXT("punpckhdq")
#define M_PUNPCKHQDQ FCML_TEXT("punpckhqdq")
#define M_PUNPCKHWD FCML_TEXT("punpckhwd")
#define M_PUNPCKLBW FCML_TEXT("punpcklbw")
#define M_PUNPCKLDQ FCML_TEXT("punpckldq")
#define M_PUNPCKLQDQ FCML_TEXT("punpcklqdq")
#define M_PUNPCKLWD FCML_TEXT("punpcklwd")
#define M_PUSH FCML_TEXT("push")
#define M_PUSHA FCML_TEXT("pusha")
#define M_PUSHAW FCML_TEXT("pushaw")
#define M_PUSHB FCML_TEXT("pushb")
#define M_PUSHF FCML_TEXT("pushf")
#define M_PUSHFQ FCML_TEXT("pushfq")
#define M_PUSHFW FCML_TEXT("pushfw")
#define M_PUSHL FCML_TEXT("pushl")
#define M_PUSHQ FCML_TEXT("pushq")
#define M_PUSHW FCML_TEXT("pushw")
#define M_PXOR FCML_TEXT("pxor")
#define M_RCL FCML_TEXT("rcl")
#define M_RCLB FCML_TEXT("rclb")
#define M_RCLL FCML_TEXT("rcll")
#define M_RCLQ FCML_TEXT("rclq")
#define M_RCLW FCML_TEXT("rclw")
#define M_RCPPS FCML_TEXT("rcpps")
#define M_RCPSS FCML_TEXT("rcpss")
#define M_RCR FCML_TEXT("rcr")
#define M_RCRB FCML_TEXT("rcrb")
#define M_RCRL FCML_TEXT("rcrl")
#define M_RCRQ FCML_TEXT("rcrq")
#define M_RCRW FCML_TEXT("rcrw")
#define M_RDFSBASE FCML_TEXT("rdfsbase")
#define M_RDGSBASE FCML_TEXT("rdgsbase")
#define M_RDMSR FCML_TEXT("rdmsr")
#define M_RDPMC FCML_TEXT("rdpmc")
#define M_RDRAND FCML_TEXT("rdrand")
#define M_RDSEED FCML_TEXT("rdseed")
#define M_RDTSC FCML_TEXT("rdtsc")
#define M_RDTSCP FCML_TEXT("rdtscp")
#define M_RET FCML_TEXT("ret")
#define M_RETQ FCML_TEXT("retq")
#define M_RETW FCML_TEXT("retw")
#define M_ROL FCML_TEXT("rol")
#define M_ROLB FCML_TEXT("rolb")
#define M_ROLL FCML_TEXT("roll")
#define M_ROLQ FCML_TEXT("rolq")
#define M_ROLW FCML_TEXT("rolw")
#define M_ROR FCML_TEXT("ror")
#define M_RORB FCML_TEXT("rorb")
#define M_RORL FCML_TEXT("rorl")
#define M_RORQ FCML_TEXT("rorq")
#define M_RORW FCML_TEXT("rorw")
#define M_RORX FCML_TEXT("rorx")
#define M_ROUNDPD FCML_TEXT("roundpd")
#define M_ROUNDPS FCML_TEXT("roundps")
#define M_ROUNDSD FCML_TEXT("roundsd")
#define M_ROUNDSS FCML_TEXT("roundss")
#define M_RSM FCML_TEXT("rsm")
#define M_RSQRTPS FCML_TEXT("rsqrtps")
#define M_RSQRTSS FCML_TEXT("rsqrtss")
#define M_SAHF FCML_TEXT("sahf")
#define M_SAL FCML_TEXT("sal")
#define M_SALB FCML_TEXT("salb")
#define M_SALL FCML_TEXT("sall")
#define M_SALQ FCML_TEXT("salq")
#define M_SALW FCML_TEXT("salw")
#define M_SAR FCML_TEXT("sar")
#define M_SARB FCML_TEXT("sarb")
#define M_SARL FCML_TEXT("sarl")
#define M_SARQ FCML_TEXT("sarq")
#define M_SARW FCML_TEXT("sarw")
#define M_SARX FCML_TEXT("sarx")
#define M_SBB FCML_TEXT("sbb")
#define M_SBBB FCML_TEXT("sbbb")
#define M_SBBL FCML_TEXT("sbbl")
#define M_SBBQ FCML_TEXT("sbbq")
#define M_SBBW FCML_TEXT("sbbw")
#define M_SCAS FCML_TEXT("scas")
#define M_SCASB FCML_TEXT("scasb")
#define M_SCASL FCML_TEXT("scasl")
#define M_SCASQ FCML_TEXT("scasq")
#define M_SCASW FCML_TEXT("scasw")
#define M_SETA FCML_TEXT("seta")
#define M_SETAE FCML_TEXT("setae")
#define M_SETB FCML_TEXT("setb")
#define M_SETBE FCML_TEXT("setbe")
#define M_SETC FCML_TEXT("setc")
#define M_SETENE FCML_TEXT("setene")
#define M_SETG FCML_TEXT("setg")
#define M_SETGE FCML_TEXT("setge")
#define M_SETL FCML_TEXT("setl")
#define M_SETLE FCML_TEXT("setle")
#define M_SETNA FCML_TEXT("setna")
#define M_SETNAE FCML_TEXT("setnae")
#define M_SETNB FCML_TEXT("setnb")
#define M_SETNBE FCML_TEXT("setnbe")
#define M_SETNC FCML_TEXT("setnc")
#define M_SETNG FCML_TEXT("setng")
#define M_SETNGE FCML_TEXT("setnge")
#define M_SETNL FCML_TEXT("setnl")
#define M_SETNLE FCML_TEXT("setnle")
#define M_SETNO FCML_TEXT("setno")
#define M_SETNP FCML_TEXT("setnp")
#define M_SETNS FCML_TEXT("setns")
#define M_SETNZ FCML_TEXT("setnz")
#define M_SETO FCML_TEXT("seto")
#define M_SETP FCML_TEXT("setp")
#define M_SETPE FCML_TEXT("setpe")
#define M_SETPO FCML_TEXT("setpo")
#define M_SETS FCML_TEXT("sets")
#define M_SETZ FCML_TEXT("setz")
#define M_SFENCE FCML_TEXT("sfence")
#define M_SGDT FCML_TEXT("sgdt")
#define M_SHL FCML_TEXT("shl")
#define M_SHLB FCML_TEXT("shlb")
#define M_SHLD FCML_TEXT("shld")
#define M_SHLL FCML_TEXT("shll")
#define M_SHLQ FCML_TEXT("shlq")
#define M_SHLW FCML_TEXT("shlw")
#define M_SHLX FCML_TEXT("shlx")
#define M_SHR FCML_TEXT("shr")
#define M_SHRB FCML_TEXT("shrb")
#define M_SHRD FCML_TEXT("shrd")
#define M_SHRL FCML_TEXT("shrl")
#define M_SHRQ FCML_TEXT("shrq")
#define M_SHRW FCML_TEXT("shrw")
#define M_SHRX FCML_TEXT("shrx")
#define M_SHUFPD FCML_TEXT("shufpd")
#define M_SHUFPS FCML_TEXT("shufps")
#define M_SIDT FCML_TEXT("sidt")
#define M_SKINIT FCML_TEXT("skinit")
#define M_SLDT FCML_TEXT("sldt")
#define M_SLWPCB FCML_TEXT("slwpcb")
#define M_SMSW FCML_TEXT("smsw")
#define M_SQRTPD FCML_TEXT("sqrtpd")
#define M_SQRTPS FCML_TEXT("sqrtps")
#define M_SQRTSD FCML_TEXT("sqrtsd")
#define M_SQRTSS FCML_TEXT("sqrtss")
#define M_STAC FCML_TEXT("stac")
#define M_STC FCML_TEXT("stc")
#define M_STD FCML_TEXT("std")
#define M_STGI FCML_TEXT("stgi")
#define M_STI FCML_TEXT("sti")
#define M_STMXCSR FCML_TEXT("stmxcsr")
#define M_STOS FCML_TEXT("stos")
#define M_STOSB FCML_TEXT("stosb")
#define M_STOSL FCML_TEXT("stosl")
#define M_STOSQ FCML_TEXT("stosq")
#define M_STOSW FCML_TEXT("stosw")
#define M_STR FCML_TEXT("str")
#define M_SUB FCML_TEXT("sub")
#define M_SUBB FCML_TEXT("subb")
#define M_SUBL FCML_TEXT("subl")
#define M_SUBPD FCML_TEXT("subpd")
#define M_SUBPS FCML_TEXT("subps")
#define M_SUBQ FCML_TEXT("subq")
#define M_SUBSD FCML_TEXT("subsd")
#define M_SUBSS FCML_TEXT("subss")
#define M_SUBW FCML_TEXT("subw")
#define M_SWAPGS FCML_TEXT("swapgs")
#define M_SYSCALL FCML_TEXT("syscall")
#define M_SYSENTER FCML_TEXT("sysenter")
#define M_SYSEXIT FCML_TEXT("sysexit")
#define M_SYSRET FCML_TEXT("sysret")
#define M_T1MSKC FCML_TEXT("t1mskc")
#define M_TEST FCML_TEXT("test")
#define M_TESTB FCML_TEXT("testb")
#define M_TESTL FCML_TEXT("testl")
#define M_TESTQ FCML_TEXT("testq")
#define M_TESTW FCML_TEXT("testw")
#define M_TZCNT FCML_TEXT("tzcnt")
#define M_TZMSK FCML_TEXT("tzmsk")
#define M_UCOMISD FCML_TEXT("ucomisd")
#define M_UCOMISS FCML_TEXT("ucomiss")
#define M_UD2 FCML_TEXT("ud2")
#define M_UNPCKHPD FCML_TEXT("unpckhpd")
#define M_UNPCKHPS FCML_TEXT("unpckhps")
#define M_UNPCKLPD FCML_TEXT("unpcklpd")
#define M_UNPCKLPS FCML_TEXT("unpcklps")
#define M_V4FMADDPS FCML_TEXT("v4fmaddps")
#define M_V4FMADDSS FCML_TEXT("v4fmaddss")
#define M_V4FNMADDPS FCML_TEXT("v4fnmaddps")
#define M_V4FNMADDSS FCML_TEXT("v4fnmaddss")
#define M_VADDPD FCML_TEXT("vaddpd")
#define M_VADDPS FCML_TEXT("vaddps")
#define M_VADDSD FCML_TEXT("vaddsd")
#define M_VADDSS FCML_TEXT("vaddss")
#define M_VADDSUBPD FCML_TEXT("vaddsubpd")
#define M_VADDSUBPS FCML_TEXT("vaddsubps")
#define M_VAESDEC FCML_TEXT("vaesdec")
#define M_VAESDECLAST FCML_TEXT("vaesdeclast")
#define M_VAESENC FCML_TEXT("vaesenc")
#define M_VAESENCLAST FCML_TEXT("vaesenclast")
#define M_VAESIMC FCML_TEXT("vaesimc")
#define M_VAESKEYGENASSIST FCML_TEXT("vaeskeygenassist")
#define M_VALIGND FCML_TEXT("valignd")
#define M_VALIGNQ FCML_TEXT("valignq")
#define M_VANDNPD FCML_TEXT("vandnpd")
#define M_VANDNPS FCML_TEXT("vandnps")
#define M_VANDPD FCML_TEXT("vandpd")
#define M_VANDPS FCML_TEXT("vandps")
#define M_VBLENDMPD FCML_TEXT("vblendmpd")
#define M_VBLENDMPS FCML_TEXT("vblendmps")
#define M_VBLENDPD FCML_TEXT("vblendpd")
#define M_VBLENDPS FCML_TEXT("vblendps")
#define M_VBLENDVPD FCML_TEXT("vblendvpd")
#define M_VBLENDVPS FCML_TEXT("vblendvps")
#define M_VBROADCASTF128 FCML_TEXT("vbroadcastf128")
#define M_VBROADCASTF32X2 FCML_TEXT("vbroadcastf32x2")
#define M_VBROADCASTF32X4 FCML_TEXT("vbroadcastf32x4")
#define M_VBROADCASTF32X8 FCML_TEXT("vbroadcastf32x8")
#define M_VBROADCASTF64X2 FCML_TEXT("vbroadcastf64x2")
#define M_VBROADCASTF64X4 FCML_TEXT("vbroadcastf64x4")
#define M_VBROADCASTI128 FCML_TEXT("vbroadcasti128")
#define M_VBROADCASTI32X2 FCML_TEXT("vbroadcasti32x2")
#define M_VBROADCASTI32X4 FCML_TEXT("vbroadcasti32x4")
#define M_VBROADCASTI32X8 FCML_TEXT("vbroadcasti32x8")
#define M_VBROADCASTI64X2 FCML_TEXT("vbroadcasti64x2")
#define M_VBROADCASTI64X4 FCML_TEXT("vbroadcasti64x4")
#define M_VBROADCASTSD FCML_TEXT("vbroadcastsd")
#define M_VBROADCASTSS FCML_TEXT("vbroadcastss")
#define M_VCMPEQ_OSPD FCML_TEXT("vcmpeq_ospd")
#define M_VCMPEQ_OSPS FCML_TEXT("vcmpeq_osps")
#define M_VCMPEQ_OSSD FCML_TEXT("vcmpeq_ossd")
#define M_VCMPEQ_OSSS FCML_TEXT("vcmpeq_osss")
#define M_VCMPEQ_UQPD FCML_TEXT("vcmpeq_uqpd")
#define M_VCMPEQ_UQPS FCML_TEXT("vcmpeq_uqps")
#define M_VCMPEQ_UQSD FCML_TEXT("vcmpeq_uqsd")
#define M_VCMPEQ_UQSS FCML_TEXT("vcmpeq_uqss")
#define M_VCMPEQ_USPD FCML_TEXT("vcmpeq_uspd")
#define M_VCMPEQ_USPS FCML_TEXT("vcmpeq_usps")
#define M_VCMPEQ_USSD FCML_TEXT("vcmpeq_ussd")
#define M_VCMPEQ_USSS FCML_TEXT("vcmpeq_usss")
#define M_VCMPEQPD FCML_TEXT("vcmpeqpd")
#define M_VCMPEQPS FCML_TEXT("vcmpeqps")
#define M_VCMPEQSD FCML_TEXT("vcmpeqsd")
#define M_VCMPEQSS FCML_TEXT("vcmpeqss")
#define M_VCMPFALSE_OSPD FCML_TEXT("vcmpfalse_ospd")
#define M_VCMPFALSE_OSPS FCML_TEXT("vcmpfalse_osps")
#define M_VCMPFALSE_OSSD FCML_TEXT("vcmpfalse_ossd")
#define M_VCMPFALSE_OSSS FCML_TEXT("vcmpfalse_osss")
#define M_VCMPFALSEPD FCML_TEXT("vcmpfalsepd")
#define M_VCMPFALSEPS FCML_TEXT("vcmpfalseps")
#define M_VCMPFALSESD FCML_TEXT("vcmpfalsesd")
#define M_VCMPFALSESS FCML_TEXT("vcmpfalsess")
#define M_VCMPGE_OQPD FCML_TEXT("vcmpge_oqpd")
#define M_VCMPGE_OQPS FCML_TEXT("vcmpge_oqps")
#define M_VCMPGE_OQSD FCML_TEXT("vcmpge_oqsd")
#define M_VCMPGE_OQSS FCML_TEXT("vcmpge_oqss")
#define M_VCMPGEPD FCML_TEXT("vcmpgepd")
#define M_VCMPGEPS FCML_TEXT("vcmpgeps")
#define M_VCMPGESD FCML_TEXT("vcmpgesd")
#define M_VCMPGESS FCML_TEXT("vcmpgess")
#define M_VCMPGT_OQPD FCML_TEXT("vcmpgt_oqpd")
#define M_VCMPGT_OQPS FCML_TEXT("vcmpgt_oqps")
#define M_VCMPGT_OQSD FCML_TEXT("vcmpgt_oqsd")
#define M_VCMPGT_OQSS FCML_TEXT("vcmpgt_oqss")
#define M_VCMPGTPD FCML_TEXT("vcmpgtpd")
#define M_VCMPGTPS FCML_TEXT("vcmpgtps")
#define M_VCMPGTSD FCML_TEXT("vcmpgtsd")
#define M_VCMPGTSS FCML_TEXT("vcmpgtss")
#define M_VCMPLE_OQPD FCML_TEXT("vcmple_oqpd")
#define M_VCMPLE_OQPS FCML_TEXT("vcmple_oqps")
#define M_VCMPLE_OQSD FCML_TEXT("vcmple_oqsd")
#define M_VCMPLE_OQSS FCML_TEXT("vcmple_oqss")
#define M_VCMPLEPD FCML_TEXT("vcmplepd")
#define M_VCMPLEPS FCML_TEXT("vcmpleps")
#define M_VCMPLESD FCML_TEXT("vcmplesd")
#define M_VCMPLESS FCML_TEXT("vcmpless")
#define M_VCMPLT_OQPD FCML_TEXT("vcmplt_oqpd")
#define M_VCMPLT_OQPS FCML_TEXT("vcmplt_oqps")
#define M_VCMPLT_OQSD FCML_TEXT("vcmplt_oqsd")
#define M_VCMPLT_OQSS FCML_TEXT("vcmplt_oqss")
#define M_VCMPLTPD FCML_TEXT("vcmpltpd")
#define M_VCMPLTPS FCML_TEXT("vcmpltps")
#define M_VCMPLTSD FCML_TEXT("vcmpltsd")
#define M_VCMPLTSS FCML_TEXT("vcmpltss")
#define M_VCMPNEQ_OQPD FCML_TEXT("vcmpneq_oqpd")
#define M_VCMPNEQ_OQPS FCML_TEXT("vcmpneq_oqps")
#define M_VCMPNEQ_OQSD FCML_TEXT("vcmpneq_oqsd")
#define M_VCMPNEQ_OQSS FCML_TEXT("vcmpneq_oqss")
#define M_VCMPNEQ_OSPD FCML_TEXT("vcmpneq_ospd")
#define M_VCMPNEQ_OSPS FCML_TEXT("vcmpneq_osps")
#define M_VCMPNEQ_OSSD FCML_TEXT("vcmpneq_ossd")
#define M_VCMPNEQ_OSSS FCML_TEXT("vcmpneq_osss")
#define M_VCMPNEQ_USPD FCML_TEXT("vcmpneq_uspd")
#define M_VCMPNEQ_USPS FCML_TEXT("vcmpneq_usps")
#define M_VCMPNEQ_USSD FCML_TEXT("vcmpneq_ussd")
#define M_VCMPNEQ_USSS FCML_TEXT("vcmpneq_usss")
#define M_VCMPNEQPD FCML_TEXT("vcmpneqpd")
#define M_VCMPNEQPS FCML_TEXT("vcmpneqps")
#define M_VCMPNEQSD FCML_TEXT("vcmpneqsd")
#define M_VCMPNEQSS FCML_TEXT("vcmpneqss")
#define M_VCMPNGE_UQPD FCML_TEXT("vcmpnge_uqpd")
#define M_VCMPNGE_UQPS FCML_TEXT("vcmpnge_uqps")
#define M_VCMPNGE_UQSD FCML_TEXT("vcmpnge_uqsd")
#define M_VCMPNGE_UQSS FCML_TEXT("vcmpnge_uqss")
#define M_VCMPNGEPD FCML_TEXT("vcmpngepd")
#define M_VCMPNGEPS FCML_TEXT("vcmpngeps")
#define M_VCMPNGESD FCML_TEXT("vcmpngesd")
#define M_VCMPNGESS FCML_TEXT("vcmpngess")
#define M_VCMPNGT_UQPD FCML_TEXT("vcmpngt_uqpd")
#define M_VCMPNGT_UQPS FCML_TEXT("vcmpngt_uqps")
#define M_VCMPNGT_UQSD FCML_TEXT("vcmpngt_uqsd")
#define M_VCMPNGT_UQSS FCML_TEXT("vcmpngt_uqss")
#define M_VCMPNGTPD FCML_TEXT("vcmpngtpd")
#define M_VCMPNGTPS FCML_TEXT("vcmpngtps")
#define M_VCMPNGTSD FCML_TEXT("vcmpngtsd")
#define M_VCMPNGTSS FCML_TEXT("vcmpngtss")
#define M_VCMPNLE_UQPD FCML_TEXT("vcmpnle_uqpd")
#define M_VCMPNLE_UQPS FCML_TEXT("vcmpnle_uqps")
#define M_VCMPNLE_UQSD FCML_TEXT("vcmpnle_uqsd")
#define M_VCMPNLE_UQSS FCML_TEXT("vcmpnle_uqss")
#define M_VCMPNLEPD FCML_TEXT("vcmpnlepd")
#define M_VCMPNLEPS FCML_TEXT("vcmpnleps")
#define M_VCMPNLESD FCML_TEXT("vcmpnlesd")
#define M_VCMPNLESS FCML_TEXT("vcmpnless")
#define M_VCMPNLT_UQPD FCML_TEXT("vcmpnlt_uqpd")
#define M_VCMPNLT_UQPS FCML_TEXT("vcmpnlt_uqps")
#define M_VCMPNLT_UQSD FCML_TEXT("vcmpnlt_uqsd")
#define M_VCMPNLT_UQSS FCML_TEXT("vcmpnlt_uqss")
#define M_VCMPNLTPD FCML_TEXT("vcmpnltpd")
#define M_VCMPNLTPS FCML_TEXT("vcmpnltps")
#define M_VCMPNLTSD FCML_TEXT("vcmpnltsd")
#define M_VCMPNLTSS FCML_TEXT("vcmpnltss")
#define M_VCMPORD_SPD FCML_TEXT("vcmpord_spd")
#define M_VCMPORD_SPS FCML_TEXT("vcmpord_sps")
#define M_VCMPORD_SSD FCML_TEXT("vcmpord_ssd")
#define M_VCMPORD_SSS FCML_TEXT("vcmpord_sss")
#define M_VCMPORDPD FCML_TEXT("vcmpordpd")
#define M_VCMPORDPS FCML_TEXT("vcmpordps")
#define M_VCMPORDSD FCML_TEXT("vcmpordsd")
#define M_VCMPORDSS FCML_TEXT("vcmpordss")
#define M_VCMPPD FCML_TEXT("vcmppd")
#define M_VCMPPS FCML_TEXT("vcmpps")
#define M_VCMPSD FCML_TEXT("vcmpsd")
#define M_VCMPSS FCML_TEXT("vcmpss")
#define M_VCMPTRUE_USPD FCML_TEXT("vcmptrue_uspd")
#define M_VCMPTRUE_USPS FCML_TEXT("vcmptrue_usps")
#define M_VCMPTRUE_USSD FCML_TEXT("vcmptrue_ussd")
#define M_VCMPTRUE_USSS FCML_TEXT("vcmptrue_usss")
#define M_VCMPTRUEPD FCML_TEXT("vcmptruepd")
#define M_VCMPTRUEPS FCML_TEXT("vcmptrueps")
#define M_VCMPTRUESD FCML_TEXT("vcmptruesd")
#define M_VCMPTRUESS FCML_TEXT("vcmptruess")
#define M_VCMPUNORD_SPD FCML_TEXT("vcmpunord_spd")
#define M_VCMPUNORD_SPS FCML_TEXT("vcmpunord_sps")
#define M_VCMPUNORD_SSD FCML_TEXT("vcmpunord_ssd")
#define M_VCMPUNORD_SSS FCML_TEXT("vcmpunord_sss")
#define M_VCMPUNORDPD FCML_TEXT("vcmpunordpd")
#define M_VCMPUNORDPS FCML_TEXT("vcmpunordps")
#define M_VCMPUNORDSD FCML_TEXT("vcmpunordsd")
#define M_VCMPUNORDSS FCML_TEXT("vcmpunordss")
#define M_VCOMISD FCML_TEXT("vcomisd")
#define M_VCOMISS FCML_TEXT("vcomiss")
#define M_VCOMPRESSPD FCML_TEXT("vcompresspd")
#define M_VCOMPRESSPS FCML_TEXT("vcompressps")
#define M_VCVTDQ2PD FCML_TEXT("vcvtdq2pd")
#define M_VCVTDQ2PS FCML_TEXT("vcvtdq2ps")
#define M_VCVTPD2DQ FCML_TEXT("vcvtpd2dq")
#define M_VCVTPD2DQX FCML_TEXT("vcvtpd2dqx")
#define M_VCVTPD2DQY FCML_TEXT("vcvtpd2dqy")
#define M_VCVTPD2PS FCML_TEXT("vcvtpd2ps")
#define M_VCVTPD2PSX FCML_TEXT("vcvtpd2psx")
#define M_VCVTPD2PSY FCML_TEXT("vcvtpd2psy")
#define M_VCVTPD2QQ FCML_TEXT("vcvtpd2qq")
#define M_VCVTPD2UDQ FCML_TEXT("vcvtpd2udq")
#define M_VCVTPD2UDQX FCML_TEXT("vcvtpd2udqx")
#define M_VCVTPD2UDQY FCML_TEXT("vcvtpd2udqy")
#define M_VCVTPD2UQQ FCML_TEXT("vcvtpd2uqq")
#define M_VCVTPH2PS FCML_TEXT("vcvtph2ps")
#define M_VCVTPS2DQ FCML_TEXT("vcvtps2dq")
#define M_VCVTPS2PD FCML_TEXT("vcvtps2pd")
#define M_VCVTPS2PH FCML_TEXT("vcvtps2ph")
#define M_VCVTPS2QQ FCML_TEXT("vcvtps2qq")
#define M_VCVTPS2UDQ FCML_TEXT("vcvtps2udq")
#define M_VCVTPS2UQQ FCML_TEXT("vcvtps2uqq")
#define M_VCVTQQ2PD FCML_TEXT("vcvtqq2pd")
#define M_VCVTQQ2PS FCML_TEXT("vcvtqq2ps")
#define M_VCVTQQ2PSX FCML_TEXT("vcvtqq2psx")
#define M_VCVTQQ2PSY FCML_TEXT("vcvtqq2psy")
#define M_VCVTSD2SI FCML_TEXT("vcvtsd2si")
#define M_VCVTSD2SS FCML_TEXT("vcvtsd2ss")
#define M_VCVTSD2USI FCML_TEXT("vcvtsd2usi")
#define M_VCVTSI2SDL FCML_TEXT("vcvtsi2sdl")
#define M_VCVTSI2SDQ FCML_TEXT("vcvtsi2sdq")
#define M_VCVTSI2SSL FCML_TEXT("vcvtsi2ssl")
#define M_VCVTSI2SSQ FCML_TEXT("vcvtsi2ssq")
#define M_VCVTSS2SD FCML_TEXT("vcvtss2sd")
#define M_VCVTSS2SI FCML_TEXT("vcvtss2si")
#define M_VCVTSS2USI FCML_TEXT("vcvtss2usi")
#define M_VCVTTPD2DQ FCML_TEXT("vcvttpd2dq")
#define M_VCVTTPD2DQX FCML_TEXT("vcvttpd2dqx")
#define M_VCVTTPD2DQY FCML_TEXT("vcvttpd2dqy")
#define M_VCVTTPD2QQ FCML_TEXT("vcvttpd2qq")
#define M_VCVTTPD2UDQ FCML_TEXT("vcvttpd2udq")
#define M_VCVTTPD2UDQX FCML_TEXT("vcvttpd2udqx")
#define M_VCVTTPD2UDQY FCML_TEXT("vcvttpd2udqy")
#define M_VCVTTPD2UQQ FCML_TEXT("vcvttpd2uqq")
#define M_VCVTTPS2DQ FCML_TEXT("vcvttps2dq")
#define M_VCVTTPS2QQ FCML_TEXT("vcvttps2qq")
#define M_VCVTTPS2UDQ FCML_TEXT("vcvttps2udq")
#define M_VCVTTPS2UQQ FCML_TEXT("vcvttps2uqq")
#define M_VCVTTSD2SI FCML_TEXT("vcvttsd2si")
#define M_VCVTTSD2USI FCML_TEXT("vcvttsd2usi")
#define M_VCVTTSS2SI FCML_TEXT("vcvttss2si")
#define M_VCVTTSS2USI FCML_TEXT("vcvttss2usi")
#define M_VCVTUDQ2PD FCML_TEXT("vcvtudq2pd")
#define M_VCVTUDQ2PS FCML_TEXT("vcvtudq2ps")
#define M_VCVTUQQ2PD FCML_TEXT("vcvtuqq2pd")
#define M_VCVTUQQ2PS FCML_TEXT("vcvtuqq2ps")
#define M_VCVTUQQ2PSX FCML_TEXT("vcvtuqq2psx")
#define M_VCVTUQQ2PSY FCML_TEXT("vcvtuqq2psy")
#define M_VCVTUSI2SD FCML_TEXT("vcvtusi2sd")
#define M_VCVTUSI2SS FCML_TEXT("vcvtusi2ss")
#define M_VDBPSADBW FCML_TEXT("vdbpsadbw")
#define M_VDIVPD FCML_TEXT("vdivpd")
#define M_VDIVPS FCML_TEXT("vdivps")
#define M_VDIVSD FCML_TEXT("vdivsd")
#define M_VDIVSS FCML_TEXT("vdivss")
#define M_VDPPD FCML_TEXT("vdppd")
#define M_VDPPS FCML_TEXT("vdpps")
#define M_VERR FCML_TEXT("verr")
#define M_VERW FCML_TEXT("verw")
#define M_VEXP2PD FCML_TEXT("vexp2pd")
#define M_VEXP2PS FCML_TEXT("vexp2ps")
#define M_VEXPANDPD FCML_TEXT("vexpandpd")
#define M_VEXPANDPS FCML_TEXT("vexpandps")
#define M_VEXTRACTF128 FCML_TEXT("vextractf128")
#define M_VEXTRACTF32X4 FCML_TEXT("vextractf32x4")
#define M_VEXTRACTF32X8 FCML_TEXT("vextractf32x8")
#define M_VEXTRACTF64X2 FCML_TEXT("vextractf64x2")
#define M_VEXTRACTF64X4 FCML_TEXT("vextractf64x4")
#define M_VEXTRACTI128 FCML_TEXT("vextracti128")
#define M_VEXTRACTI32X4 FCML_TEXT("vextracti32x4")
#define M_VEXTRACTI32X8 FCML_TEXT("vextracti32x8")
#define M_VEXTRACTI64X2 FCML_TEXT("vextracti64x2")
#define M_VEXTRACTI64X4 FCML_TEXT("vextracti64x4")
#define M_VEXTRACTPS FCML_TEXT("vextractps")
#define M_VFIXUPIMMPD FCML_TEXT("vfixupimmpd")
#define M_VFIXUPIMMPS FCML_TEXT("vfixupimmps")
#define M_VFIXUPIMMSD FCML_TEXT("vfixupimmsd")
#define M_VFIXUPIMMSS FCML_TEXT("vfixupimmss")
#define M_VFMADD132PD FCML_TEXT("vfmadd132pd")
#define M_VFMADD132PS FCML_TEXT("vfmadd132ps")
#define M_VFMADD132SD FCML_TEXT("vfmadd132sd")
#define M_VFMADD132SS FCML_TEXT("vfmadd132ss")
#define M_VFMADD213PD FCML_TEXT("vfmadd213pd")
#define M_VFMADD213PS FCML_TEXT("vfmadd213ps")
#define M_VFMADD213SD FCML_TEXT("vfmadd213sd")
#define M_VFMADD213SS FCML_TEXT("vfmadd213ss")
#define M_VFMADD231PD FCML_TEXT("vfmadd231pd")
#define M_VFMADD231PS FCML_TEXT("vfmadd231ps")
#define M_VFMADD231SD FCML_TEXT("vfmadd231sd")
#define M_VFMADD231SS FCML_TEXT("vfmadd231ss")
#define M_VFMADDPD FCML_TEXT("vfmaddpd")
#define M_VFMADDPS FCML_TEXT("vfmaddps")
#define M_VFMADDSD FCML_TEXT("vfmaddsd")
#define M_VFMADDSS FCML_TEXT("vfmaddss")
#define M_VFMADDSUB132PD FCML_TEXT("vfmaddsub132pd")
#define M_VFMADDSUB132PS FCML_TEXT("vfmaddsub132ps")
#define M_VFMADDSUB213PD FCML_TEXT("vfmaddsub213pd")
#define M_VFMADDSUB213PS FCML_TEXT("vfmaddsub213ps")
#define M_VFMADDSUB231PD FCML_TEXT("vfmaddsub231pd")
#define M_VFMADDSUB231PS FCML_TEXT("vfmaddsub231ps")
#define M_VFMADDSUBPD FCML_TEXT("vfmaddsubpd")
#define M_VFMADDSUBPS FCML_TEXT("vfmaddsubps")
#define M_VFMSUB132PD FCML_TEXT("vfmsub132pd")
#define M_VFMSUB132PS FCML_TEXT("vfmsub132ps")
#define M_VFMSUB132SD FCML_TEXT("vfmsub132sd")
#define M_VFMSUB132SS FCML_TEXT("vfmsub132ss")
#define M_VFMSUB213PD FCML_TEXT("vfmsub213pd")
#define M_VFMSUB213PS FCML_TEXT("vfmsub213ps")
#define M_VFMSUB213SD FCML_TEXT("vfmsub213sd")
#define M_VFMSUB213SS FCML_TEXT("vfmsub213ss")
#define M_VFMSUB231PD FCML_TEXT("vfmsub231pd")
#define M_VFMSUB231PS FCML_TEXT("vfmsub231ps")
#define M_VFMSUB231SD FCML_TEXT("vfmsub231sd")
#define M_VFMSUB231SS FCML_TEXT("vfmsub231ss")
#define M_VFMSUBADD132PD FCML_TEXT("vfmsubadd132pd")
#define M_VFMSUBADD132PS FCML_TEXT("vfmsubadd132ps")
#define M_VFMSUBADD213PD FCML_TEXT("vfmsubadd213pd")
#define M_VFMSUBADD213PS FCML_TEXT("vfmsubadd213ps")
#define M_VFMSUBADD231PD FCML_TEXT("vfmsubadd231pd")
#define M_VFMSUBADD231PS FCML_TEXT("vfmsubadd231ps")
#define M_VFMSUBADDPD FCML_TEXT("vfmsubaddpd")
#define M_VFMSUBADDPS FCML_TEXT("vfmsubaddps")
#define M_VFMSUBPD FCML_TEXT("vfmsubpd")
#define M_VFMSUBPS FCML_TEXT("vfmsubps")
#define M_VFMSUBSD FCML_TEXT("vfmsubsd")
#define M_VFMSUBSS FCML_TEXT("vfmsubss")
#define M_VFNMADD132PD FCML_TEXT("vfnmadd132pd")
#define M_VFNMADD132PS FCML_TEXT("vfnmadd132ps")
#define M_VFNMADD132SD FCML_TEXT("vfnmadd132sd")
#define M_VFNMADD132SS FCML_TEXT("vfnmadd132ss")
#define M_VFNMADD213PD FCML_TEXT("vfnmadd213pd")
#define M_VFNMADD213PS FCML_TEXT("vfnmadd213ps")
#define M_VFNMADD213SD FCML_TEXT("vfnmadd213sd")
#define M_VFNMADD213SS FCML_TEXT("vfnmadd213ss")
#define M_VFNMADD231PD FCML_TEXT("vfnmadd231pd")
#define M_VFNMADD231PS FCML_TEXT("vfnmadd231ps")
#define M_VFNMADD231SD FCML_TEXT("vfnmadd231sd")
#define M_VFNMADD231SS FCML_TEXT("vfnmadd231ss")
#define M_VFNMADDPD FCML_TEXT("vfnmaddpd")
#define M_VFNMADDPS FCML_TEXT("vfnmaddps")
#define M_VFNMADDSD FCML_TEXT("vfnmaddsd")
#define M_VFNMADDSS FCML_TEXT("vfnmaddss")
#define M_VFNMSUB132PD FCML_TEXT("vfnmsub132pd")
#define M_VFNMSUB132PS FCML_TEXT("vfnmsub132ps")
#define M_VFNMSUB132SD FCML_TEXT("vfnmsub132sd")
#define M_VFNMSUB132SS FCML_TEXT("vfnmsub132ss")
#define M_VFNMSUB213PD FCML_TEXT("vfnmsub213pd")
#define M_VFNMSUB213PS FCML_TEXT("vfnmsub213ps")
#define M_VFNMSUB213SD FCML_TEXT("vfnmsub213sd")
#define M_VFNMSUB213SS FCML_TEXT("vfnmsub213ss")
#define M_VFNMSUB231PD FCML_TEXT("vfnmsub231pd")
#define M_VFNMSUB231PS FCML_TEXT("vfnmsub231ps")
#define M_VFNMSUB231SD FCML_TEXT("vfnmsub231sd")
#define M_VFNMSUB231SS FCML_TEXT("vfnmsub231ss")
#define M_VFNMSUBPD FCML_TEXT("vfnmsubpd")
#define M_VFNMSUBPS FCML_TEXT("vfnmsubps")
#define M_VFNMSUBSD FCML_TEXT("vfnmsubsd")
#define M_VFNMSUBSS FCML_TEXT("vfnmsubss")
#define M_VFPCLASSPD FCML_TEXT("vfpclasspd")
#define M_VFPCLASSPS FCML_TEXT("vfpclassps")
#define M_VFPCLASSSD FCML_TEXT("vfpclasssd")
#define M_VFPCLASSSS FCML_TEXT("vfpclassss")
#define M_VFRCZPD FCML_TEXT("vfrczpd")
#define M_VFRCZPS FCML_TEXT("vfrczps")
#define M_VFRCZSD FCML_TEXT("vfrczsd")
#define M_VFRCZSS FCML_TEXT("vfrczss")
#define M_VGATHERDPD FCML_TEXT("vgatherdpd")
#define M_VGATHERDPS FCML_TEXT("vgatherdps")
#define M_VGATHERPF0DPD FCML_TEXT("vgatherpf0dpd")
#define M_VGATHERPF0DPS FCML_TEXT("vgatherpf0dps")
#define M_VGATHERPF0QPD FCML_TEXT("vgatherpf0qpd")
#define M_VGATHERPF0QPS FCML_TEXT("vgatherpf0qps")
#define M_VGATHERPF1DPD FCML_TEXT("vgatherpf1dpd")
#define M_VGATHERPF1DPS FCML_TEXT("vgatherpf1dps")
#define M_VGATHERPF1QPD FCML_TEXT("vgatherpf1qpd")
#define M_VGATHERPF1QPS FCML_TEXT("vgatherpf1qps")
#define M_VGATHERQPD FCML_TEXT("vgatherqpd")
#define M_VGATHERQPS FCML_TEXT("vgatherqps")
#define M_VGETEXPPD FCML_TEXT("vgetexppd")
#define M_VGETEXPPS FCML_TEXT("vgetexpps")
#define M_VGETEXPSD FCML_TEXT("vgetexpsd")
#define M_VGETEXPSS FCML_TEXT("vgetexpss")
#define M_VGETMANTPD FCML_TEXT("vgetmantpd")
#define M_VGETMANTPS FCML_TEXT("vgetmantps")
#define M_VGETMANTSD FCML_TEXT("vgetmantsd")
#define M_VGETMANTSS FCML_TEXT("vgetmantss")
#define M_VHADDPD FCML_TEXT("vhaddpd")
#define M_VHADDPS FCML_TEXT("vhaddps")
#define M_VHSUBPD FCML_TEXT("vhsubpd")
#define M_VHSUBPS FCML_TEXT("vhsubps")
#define M_VINSERTF128 FCML_TEXT("vinsertf128")
#define M_VINSERTF32X4 FCML_TEXT("vinsertf32x4")
#define M_VINSERTF32X8 FCML_TEXT("vinsertf32x8")
#define M_VINSERTF64X2 FCML_TEXT("vinsertf64x2")
#define M_VINSERTF64X4 FCML_TEXT("vinsertf64x4")
#define M_VINSERTI128 FCML_TEXT("vinserti128")
#define M_VINSERTI32X4 FCML_TEXT("vinserti32x4")
#define M_VINSERTI32X8 FCML_TEXT("vinserti32x8")
#define M_VINSERTI64X2 FCML_TEXT("vinserti64x2")
#define M_VINSERTI64X4 FCML_TEXT("vinserti64x4")
#define M_VINSERTPS FCML_TEXT("vinsertps")
#define M_VLDDQU FCML_TEXT("vlddqu")
#define M_VLDMXCSR FCML_TEXT("vldmxcsr")
#define M_VMASKMOVDQU FCML_TEXT("vmaskmovdqu")
#define M_VMASKMOVPD FCML_TEXT("vmaskmovpd")
#define M_VMASKMOVPS FCML_TEXT("vmaskmovps")
#define M_VMAXPD FCML_TEXT("vmaxpd")
#define M_VMAXPS FCML_TEXT("vmaxps")
#define M_VMAXSD FCML_TEXT("vmaxsd")
#define M_VMAXSS FCML_TEXT("vmaxss")
#define M_VMCALL FCML_TEXT("vmcall")
#define M_VMCLEAR FCML_TEXT("vmclear")
#define M_VMFUNC FCML_TEXT("vmfunc")
#define M_VMINPD FCML_TEXT("vminpd")
#define M_VMINPS FCML_TEXT("vminps")
#define M_VMINSD FCML_TEXT("vminsd")
#define M_VMINSS FCML_TEXT("vminss")
#define M_VMLAUNCH FCML_TEXT("vmlaunch")
#define M_VMLOAD FCML_TEXT("vmload")
#define M_VMMCALL FCML_TEXT("vmmcall")
#define M_VMOVAPD FCML_TEXT("vmovapd")
#define M_VMOVAPS FCML_TEXT("vmovaps")
#define M_VMOVD FCML_TEXT("vmovd")
#define M_VMOVDDUP FCML_TEXT("vmovddup")
#define M_VMOVDQA FCML_TEXT("vmovdqa")
#define M_VMOVDQA32 FCML_TEXT("vmovdqa32")
#define M_VMOVDQA64 FCML_TEXT("vmovdqa64")
#define M_VMOVDQU FCML_TEXT("vmovdqu")
#define M_VMOVDQU16 FCML_TEXT("vmovdqu16")
#define M_VMOVDQU32 FCML_TEXT("vmovdqu32")
#define M_VMOVDQU64 FCML_TEXT("vmovdqu64")
#define M_VMOVDQU8 FCML_TEXT("vmovdqu8")
#define M_VMOVHLPS FCML_TEXT("vmovhlps")
#define M_VMOVHPD FCML_TEXT("vmovhpd")
#define M_VMOVHPS FCML_TEXT("vmovhps")
#define M_VMOVLHPS FCML_TEXT("vmovlhps")
#define M_VMOVLPD FCML_TEXT("vmovlpd")
#define M_VMOVLPS FCML_TEXT("vmovlps")
#define M_VMOVMSKPD FCML_TEXT("vmovmskpd")
#define M_VMOVMSKPS FCML_TEXT("vmovmskps")
#define M_VMOVNTDQ FCML_TEXT("vmovntdq")
#define M_VMOVNTDQA FCML_TEXT("vmovntdqa")
#define M_VMOVNTPD FCML_TEXT("vmovntpd")
#define M_VMOVNTPS FCML_TEXT("vmovntps")
#define M_VMOVQ FCML_TEXT("vmovq")
#define M_VMOVSD FCML_TEXT("vmovsd")
#define M_VMOVSHDUP FCML_TEXT("vmovshdup")
#define M_VMOVSLDUP FCML_TEXT("vmovsldup")
#define M_VMOVSS FCML_TEXT("vmovss")
#define M_VMOVUPD FCML_TEXT("vmovupd")
#define M_VMOVUPS FCML_TEXT("vmovups")
#define M_VMPSADBW FCML_TEXT("vmpsadbw")
#define M_VMPTRLD FCML_TEXT("vmptrld")
#define M_VMPTRST FCML_TEXT("vmptrst")
#define M_VMREAD FCML_TEXT("vmread")
#define M_VMRESUME FCML_TEXT("vmresume")
#define M_VMRUN FCML_TEXT("vmrun")
#define M_VMSAVE FCML_TEXT("vmsave")
#define M_VMULPD FCML_TEXT("vmulpd")
#define M_VMULPS FCML_TEXT("vmulps")
#define M_VMULSD FCML_TEXT("vmulsd")
#define M_VMULSS FCML_TEXT("vmulss")
#define M_VMWRITE FCML_TEXT("vmwrite")
#define M_VMXOFF FCML_TEXT("vmxoff")
#define M_VMXON FCML_TEXT("vmxon")
#define M_VORPD FCML_TEXT("vorpd")
#define M_VORPS FCML_TEXT("vorps")
#define M_VP4DPWSSD FCML_TEXT("vp4dpwssd")
#define M_VP4DPWSSDS FCML_TEXT("vp4dpwssds")
#define M_VPABSB FCML_TEXT("vpabsb")
#define M_VPABSD FCML_TEXT("vpabsd")
#define M_VPABSQ FCML_TEXT("vpabsq")
#define M_VPABSW FCML_TEXT("vpabsw")
#define M_VPACKSSDW FCML_TEXT("vpackssdw")
#define M_VPACKSSWB FCML_TEXT("vpacksswb")
#define M_VPACKUSDW FCML_TEXT("vpackusdw")
#define M_VPACKUSWB FCML_TEXT("vpackuswb")
#define M_VPADDB FCML_TEXT("vpaddb")
#define M_VPADDD FCML_TEXT("vpaddd")
#define M_VPADDQ FCML_TEXT("vpaddq")
#define M_VPADDSB FCML_TEXT("vpaddsb")
#define M_VPADDSW FCML_TEXT("vpaddsw")
#define M_VPADDUSB FCML_TEXT("vpaddusb")
#define M_VPADDUSW FCML_TEXT("vpaddusw")
#define M_VPADDW FCML_TEXT("vpaddw")
#define M_VPALIGNR FCML_TEXT("vpalignr")
#define M_VPAND FCML_TEXT("vpand")
#define M_VPANDD FCML_TEXT("vpandd")
#define M_VPANDN FCML_TEXT("vpandn")
#define M_VPANDND FCML_TEXT("vpandnd")
#define M_VPANDNQ FCML_TEXT("vpandnq")
#define M_VPANDQ FCML_TEXT("vpandq")
#define M_VPAVGB FCML_TEXT("vpavgb")
#define M_VPAVGW FCML_TEXT("vpavgw")
#define M_VPBLENDD FCML_TEXT("vpblendd")
#define M_VPBLENDMB FCML_TEXT("vpblendmb")
#define M_VPBLENDMD FCML_TEXT("vpblendmd")
#define M_VPBLENDMQ FCML_TEXT("vpblendmq")
#define M_VPBLENDMW FCML_TEXT("vpblendmw")
#define M_VPBLENDVB FCML_TEXT("vpblendvb")
#define M_VPBLENDW FCML_TEXT("vpblendw")
#define M_VPBROADCASTB FCML_TEXT("vpbroadcastb")
#define M_VPBROADCASTD FCML_TEXT("vpbroadcastd")
#define M_VPBROADCASTMB2Q FCML_TEXT("vpbroadcastmb2q")
#define M_VPBROADCASTMW2D FCML_TEXT("vpbroadcastmw2d")
#define M_VPBROADCASTQ FCML_TEXT("vpbroadcastq")
#define M_VPBROADCASTW FCML_TEXT("vpbroadcastw")
#define M_VPCLMULQDQ FCML_TEXT("vpclmulqdq")
#define M_VPCMOV FCML_TEXT("vpcmov")
#define M_VPCMPB FCML_TEXT("vpcmpb")
#define M_VPCMPD FCML_TEXT("vpcmpd")
#define M_VPCMPEQB FCML_TEXT("vpcmpeqb")
#define M_VPCMPEQD FCML_TEXT("vpcmpeqd")
#define M_VPCMPEQQ FCML_TEXT("vpcmpeqq")
#define M_VPCMPEQW FCML_TEXT("vpcmpeqw")
#define M_VPCMPESTRI FCML_TEXT("vpcmpestri")
#define M_VPCMPESTRM FCML_TEXT("vpcmpestrm")
#define M_VPCMPGTB FCML_TEXT("vpcmpgtb")
#define M_VPCMPGTD FCML_TEXT("vpcmpgtd")
#define M_VPCMPGTQ FCML_TEXT("vpcmpgtq")
#define M_VPCMPGTW FCML_TEXT("vpcmpgtw")
#define M_VPCMPISTRI FCML_TEXT("vpcmpistri")
#define M_VPCMPISTRM FCML_TEXT("vpcmpistrm")
#define M_VPCMPQ FCML_TEXT("vpcmpq")
#define M_VPCMPUB FCML_TEXT("vpcmpub")
#define M_VPCMPUD FCML_TEXT("vpcmpud")
#define M_VPCMPUQ FCML_TEXT("vpcmpuq")
#define M_VPCMPUW FCML_TEXT("vpcmpuw")
#define M_VPCMPW FCML_TEXT("vpcmpw")
#define M_VPCOMB FCML_TEXT("vpcomb")
#define M_VPCOMD FCML_TEXT("vpcomd")
#define M_VPCOMEQB FCML_TEXT("vpcomeqb")
#define M_VPCOMEQD FCML_TEXT("vpcomeqd")
#define M_VPCOMEQQ FCML_TEXT("vpcomeqq")
#define M_VPCOMEQUB FCML_TEXT("vpcomequb")
#define M_VPCOMEQUD FCML_TEXT("vpcomequd")
#define M_VPCOMEQUQ FCML_TEXT("vpcomequq")
#define M_VPCOMEQUW FCML_TEXT("vpcomequw")
#define M_VPCOMEQW FCML_TEXT("vpcomeqw")
#define M_VPCOMFALSEB FCML_TEXT("vpcomfalseb")
#define M_VPCOMFALSED FCML_TEXT("vpcomfalsed")
#define M_VPCOMFALSEQ FCML_TEXT("vpcomfalseq")
#define M_VPCOMFALSEUB FCML_TEXT("vpcomfalseub")
#define M_VPCOMFALSEUD FCML_TEXT("vpcomfalseud")
#define M_VPCOMFALSEUQ FCML_TEXT("vpcomfalseuq")
#define M_VPCOMFALSEUW FCML_TEXT("vpcomfalseuw")
#define M_VPCOMFALSEW FCML_TEXT("vpcomfalsew")
#define M_VPCOMGEB FCML_TEXT("vpcomgeb")
#define M_VPCOMGED FCML_TEXT("vpcomged")
#define M_VPCOMGEQ FCML_TEXT("vpcomgeq")
#define M_VPCOMGEUB FCML_TEXT("vpcomgeub")
#define M_VPCOMGEUD FCML_TEXT("vpcomgeud")
#define M_VPCOMGEUQ FCML_TEXT("vpcomgeuq")
#define M_VPCOMGEUW FCML_TEXT("vpcomgeuw")
#define M_VPCOMGEW FCML_TEXT("vpcomgew")
#define M_VPCOMGTB FCML_TEXT("vpcomgtb")
#define M_VPCOMGTD FCML_TEXT("vpcomgtd")
#define M_VPCOMGTQ FCML_TEXT("vpcomgtq")
#define M_VPCOMGTUB FCML_TEXT("vpcomgtub")
#define M_VPCOMGTUD FCML_TEXT("vpcomgtud")
#define M_VPCOMGTUQ FCML_TEXT("vpcomgtuq")
#define M_VPCOMGTUW FCML_TEXT("vpcomgtuw")
#define M_VPCOMGTW FCML_TEXT("vpcomgtw")
#define M_VPCOMLEB FCML_TEXT("vpcomleb")
#define M_VPCOMLED FCML_TEXT("vpcomled")
#define M_VPCOMLEQ FCML_TEXT("vpcomleq")
#define M_VPCOMLEUB FCML_TEXT("vpcomleub")
#define M_VPCOMLEUD FCML_TEXT("vpcomleud")
#define M_VPCOMLEUQ FCML_TEXT("vpcomleuq")
#define M_VPCOMLEUW FCML_TEXT("vpcomleuw")
#define M_VPCOMLEW FCML_TEXT("vpcomlew")
#define M_VPCOMLTB FCML_TEXT("vpcomltb")
#define M_VPCOMLTD FCML_TEXT("vpcomltd")
#define M_VPCOMLTQ FCML_TEXT("vpcomltq")
#define M_VPCOMLTUB FCML_TEXT("vpcomltub")
#define M_VPCOMLTUD FCML_TEXT("vpcomltud")
#define M_VPCOMLTUQ FCML_TEXT("vpcomltuq")
#define M_VPCOMLTUW FCML_TEXT("vpcomltuw")
#define M_VPCOMLTW FCML_TEXT("vpcomltw")
#define M_VPCOMNEQB FCML_TEXT("vpcomneqb")
#define M_VPCOMNEQD FCML_TEXT("vpcomneqd")
#define M_VPCOMNEQQ FCML_TEXT("vpcomneqq")
#define M_VPCOMNEQUB FCML_TEXT("vpcomnequb")
#define M_VPCOMNEQUD FCML_TEXT("vpcomnequd")
#define M_VPCOMNEQUQ FCML_TEXT("vpcomnequq")
#define M_VPCOMNEQUW FCML_TEXT("vpcomnequw")
#define M_VPCOMNEQW FCML_TEXT("vpcomneqw")
#define M_VPCOMPRESSD FCML_TEXT("vpcompressd")
#define M_VPCOMPRESSQ FCML_TEXT("vpcompressq")
#define M_VPCOMQ FCML_TEXT("vpcomq")
#define M_VPCOMTRUEB FCML_TEXT("vpcomtrueb")
#define M_VPCOMTRUED FCML_TEXT("vpcomtrued")
#define M_VPCOMTRUEQ FCML_TEXT("vpcomtrueq")
#define M_VPCOMTRUEUB FCML_TEXT("vpcomtrueub")
#define M_VPCOMTRUEUD FCML_TEXT("vpcomtrueud")
#define M_VPCOMTRUEUQ FCML_TEXT("vpcomtrueuq")
#define M_VPCOMTRUEUW FCML_TEXT("vpcomtrueuw")
#define M_VPCOMTRUEW FCML_TEXT("vpcomtruew")
#define M_VPCOMUB FCML_TEXT("vpcomub")
#define M_VPCOMUD FCML_TEXT("vpcomud")
#define M_VPCOMUQ FCML_TEXT("vpcomuq")
#define M_VPCOMUW FCML_TEXT("vpcomuw")
#define M_VPCOMW FCML_TEXT("vpcomw")
#define M_VPERM2F128 FCML_TEXT("vperm2f128")
#define M_VPERM2I128 FCML_TEXT("vperm2i128")
#define M_VPERMB FCML_TEXT("vpermb")
#define M_VPERMD FCML_TEXT("vpermd")
#define M_VPERMI2B FCML_TEXT("vpermi2b")
#define M_VPERMI2D FCML_TEXT("vpermi2d")
#define M_VPERMI2PD FCML_TEXT("vpermi2pd")
#define M_VPERMI2PS FCML_TEXT("vpermi2ps")
#define M_VPERMI2Q FCML_TEXT("vpermi2q")
#define M_VPERMI2W FCML_TEXT("vpermi2w")
#define M_VPERMIL2PD FCML_TEXT("vpermil2pd")
#define M_VPERMIL2PS FCML_TEXT("vpermil2ps")
#define M_VPERMILPD FCML_TEXT("vpermilpd")
#define M_VPERMILPS FCML_TEXT("vpermilps")
#define M_VPERMPD FCML_TEXT("vpermpd")
#define M_VPERMPS FCML_TEXT("vpermps")
#define M_VPERMQ FCML_TEXT("vpermq")
#define M_VPERMT2B FCML_TEXT("vpermt2b")
#define M_VPERMT2D FCML_TEXT("vpermt2d")
#define M_VPERMT2PD FCML_TEXT("vpermt2pd")
#define M_VPERMT2PS FCML_TEXT("vpermt2ps")
#define M_VPERMT2Q FCML_TEXT("vpermt2q")
#define M_VPERMT2W FCML_TEXT("vpermt2w")
#define M_VPERMW FCML_TEXT("vpermw")
#define M_VPEXPANDD FCML_TEXT("vpexpandd")
#define M_VPEXPANDQ FCML_TEXT("vpexpandq")
#define M_VPEXTRB FCML_TEXT("vpextrb")
#define M_VPEXTRD FCML_TEXT("vpextrd")
#define M_VPEXTRQ FCML_TEXT("vpextrq")
#define M_VPEXTRW FCML_TEXT("vpextrw")
#define M_VPGATHERDD FCML_TEXT("vpgatherdd")
#define M_VPGATHERDQ FCML_TEXT("vpgatherdq")
#define M_VPGATHERQD FCML_TEXT("vpgatherqd")
#define M_VPGATHERQQ FCML_TEXT("vpgatherqq")
#define M_VPHADDBD FCML_TEXT("vphaddbd")
#define M_VPHADDBQ FCML_TEXT("vphaddbq")
#define M_VPHADDBW FCML_TEXT("vphaddbw")
#define M_VPHADDD FCML_TEXT("vphaddd")
#define M_VPHADDDQ FCML_TEXT("vphadddq")
#define M_VPHADDSW FCML_TEXT("vphaddsw")
#define M_VPHADDUBD FCML_TEXT("vphaddubd")
#define M_VPHADDUBQ FCML_TEXT("vphaddubq")
#define M_VPHADDUBW FCML_TEXT("vphaddubw")
#define M_VPHADDUDQ FCML_TEXT("vphaddudq")
#define M_VPHADDUWD FCML_TEXT("vphadduwd")
#define M_VPHADDUWQ FCML_TEXT("vphadduwq")
#define M_VPHADDW FCML_TEXT("vphaddw")
#define M_VPHADDWD FCML_TEXT("vphaddwd")
#define M_VPHADDWQ FCML_TEXT("vphaddwq")
#define M_VPHMINPOSUW FCML_TEXT("vphminposuw")
#define M_VPHSUBBW FCML_TEXT("vphsubbw")
#define M_VPHSUBD FCML_TEXT("vphsubd")
#define M_VPHSUBDQ FCML_TEXT("vphsubdq")
#define M_VPHSUBSW FCML_TEXT("vphsubsw")
#define M_VPHSUBW FCML_TEXT("vphsubw")
#define M_VPHSUBWD FCML_TEXT("vphsubwd")
#define M_VPINSRB FCML_TEXT("vpinsrb")
#define M_VPINSRD FCML_TEXT("vpinsrd")
#define M_VPINSRQ FCML_TEXT("vpinsrq")
#define M_VPINSRW FCML_TEXT("vpinsrw")
#define M_VPLZCNTD FCML_TEXT("vplzcntd")
#define M_VPLZCNTQ FCML_TEXT("vplzcntq")
#define M_VPMACSDD FCML_TEXT("vpmacsdd")
#define M_VPMACSDQH FCML_TEXT("vpmacsdqh")
#define M_VPMACSDQL FCML_TEXT("vpmacsdql")
#define M_VPMACSSDD FCML_TEXT("vpmacssdd")
#define M_VPMACSSDQH FCML_TEXT("vpmacssdqh")
#define M_VPMACSSDQL FCML_TEXT("vpmacssdql")
#define M_VPMACSSWD FCML_TEXT("vpmacsswd")
#define M_VPMACSSWW FCML_TEXT("vpmacssww")
#define M_VPMACSWD FCML_TEXT("vpmacswd")
#define M_VPMACSWW FCML_TEXT("vpmacsww")
#define M_VPMADCSSWD FCML_TEXT("vpmadcsswd")
#define M_VPMADCSWD FCML_TEXT("vpmadcswd")
#define M_VPMADD52HUQ FCML_TEXT("vpmadd52huq")
#define M_VPMADD52LUQ FCML_TEXT("vpmadd52luq")
#define M_VPMADDUBSW FCML_TEXT("vpmaddubsw")
#define M_VPMADDWD FCML_TEXT("vpmaddwd")
#define M_VPMASKMOV FCML_TEXT("vpmaskmov")
#define M_VPMASKMOVD FCML_TEXT("vpmaskmovd")
#define M_VPMASKMOVQ FCML_TEXT("vpmaskmovq")
#define M_VPMAXSB FCML_TEXT("vpmaxsb")
#define M_VPMAXSD FCML_TEXT("vpmaxsd")
#define M_VPMAXSQ FCML_TEXT("vpmaxsq")
#define M_VPMAXSW FCML_TEXT("vpmaxsw")
#define M_VPMAXUB FCML_TEXT("vpmaxub")
#define M_VPMAXUD FCML_TEXT("vpmaxud")
#define M_VPMAXUQ FCML_TEXT("vpmaxuq")
#define M_VPMAXUW FCML_TEXT("vpmaxuw")
#define M_VPMINSB FCML_TEXT("vpminsb")
#define M_VPMINSD FCML_TEXT("vpminsd")
#define M_VPMINSQ FCML_TEXT("vpminsq")
#define M_VPMINSW FCML_TEXT("vpminsw")
#define M_VPMINUB FCML_TEXT("vpminub")
#define M_VPMINUD FCML_TEXT("vpminud")
#define M_VPMINUQ FCML_TEXT("vpminuq")
#define M_VPMINUW FCML_TEXT("vpminuw")
#define M_VPMOVB2M FCML_TEXT("vpmovb2m")
#define M_VPMOVD2M FCML_TEXT("vpmovd2m")
#define M_VPMOVDB FCML_TEXT("vpmovdb")
#define M_VPMOVDW FCML_TEXT("vpmovdw")
#define M_VPMOVM2B FCML_TEXT("vpmovm2b")
#define M_VPMOVM2D FCML_TEXT("vpmovm2d")
#define M_VPMOVM2Q FCML_TEXT("vpmovm2q")
#define M_VPMOVM2W FCML_TEXT("vpmovm2w")
#define M_VPMOVMSKB FCML_TEXT("vpmovmskb")
#define M_VPMOVQ2M FCML_TEXT("vpmovq2m")
#define M_VPMOVQB FCML_TEXT("vpmovqb")
#define M_VPMOVQD FCML_TEXT("vpmovqd")
#define M_VPMOVQW FCML_TEXT("vpmovqw")
#define M_VPMOVSDB FCML_TEXT("vpmovsdb")
#define M_VPMOVSDW FCML_TEXT("vpmovsdw")
#define M_VPMOVSQB FCML_TEXT("vpmovsqb")
#define M_VPMOVSQD FCML_TEXT("vpmovsqd")
#define M_VPMOVSQW FCML_TEXT("vpmovsqw")
#define M_VPMOVSWB FCML_TEXT("vpmovswb")
#define M_VPMOVSXBD FCML_TEXT("vpmovsxbd")
#define M_VPMOVSXBQ FCML_TEXT("vpmovsxbq")
#define M_VPMOVSXBW FCML_TEXT("vpmovsxbw")
#define M_VPMOVSXDQ FCML_TEXT("vpmovsxdq")
#define M_VPMOVSXWD FCML_TEXT("vpmovsxwd")
#define M_VPMOVSXWQ FCML_TEXT("vpmovsxwq")
#define M_VPMOVUSDB FCML_TEXT("vpmovusdb")
#define M_VPMOVUSDW FCML_TEXT("vpmovusdw")
#define M_VPMOVUSQB FCML_TEXT("vpmovusqb")
#define M_VPMOVUSQD FCML_TEXT("vpmovusqd")
#define M_VPMOVUSQW FCML_TEXT("vpmovusqw")
#define M_VPMOVUSWB FCML_TEXT("vpmovuswb")
#define M_VPMOVW2M FCML_TEXT("vpmovw2m")
#define M_VPMOVWB FCML_TEXT("vpmovwb")
#define M_VPMOVZXBD FCML_TEXT("vpmovzxbd")
#define M_VPMOVZXBQ FCML_TEXT("vpmovzxbq")
#define M_VPMOVZXBW FCML_TEXT("vpmovzxbw")
#define M_VPMOVZXDQ FCML_TEXT("vpmovzxdq")
#define M_VPMOVZXWD FCML_TEXT("vpmovzxwd")
#define M_VPMOVZXWQ FCML_TEXT("vpmovzxwq")
#define M_VPMULDQ FCML_TEXT("vpmuldq")
#define M_VPMULHRSW FCML_TEXT("vpmulhrsw")
#define M_VPMULHUW FCML_TEXT("vpmulhuw")
#define M_VPMULHW FCML_TEXT("vpmulhw")
#define M_VPMULLD FCML_TEXT("vpmulld")
#define M_VPMULLQ FCML_TEXT("vpmullq")
#define M_VPMULLW FCML_TEXT("vpmullw")
#define M_VPMULTISHIFTQB FCML_TEXT("vpmultishiftqb")
#define M_VPMULUDQ FCML_TEXT("vpmuludq")
#define M_VPOR FCML_TEXT("vpor")
#define M_VPORD FCML_TEXT("vpord")
#define M_VPORQ FCML_TEXT("vporq")
#define M_VPPERM FCML_TEXT("vpperm")
#define M_VPROLD FCML_TEXT("vprold")
#define M_VPROLQ FCML_TEXT("vprolq")
#define M_VPROLVD FCML_TEXT("vprolvd")
#define M_VPROLVQ FCML_TEXT("vprolvq")
#define M_VPRORD FCML_TEXT("vprord")
#define M_VPRORQ FCML_TEXT("vprorq")
#define M_VPRORVD FCML_TEXT("vprorvd")
#define M_VPRORVQ FCML_TEXT("vprorvq")
#define M_VPROTB FCML_TEXT("vprotb")
#define M_VPROTD FCML_TEXT("vprotd")
#define M_VPROTQ FCML_TEXT("vprotq")
#define M_VPROTW FCML_TEXT("vprotw")
#define M_VPSADBW FCML_TEXT("vpsadbw")
#define M_VPSCATTERDD FCML_TEXT("vpscatterdd")
#define M_VPSCATTERDQ FCML_TEXT("vpscatterdq")
#define M_VPSCATTERQD FCML_TEXT("vpscatterqd")
#define M_VPSCATTERQQ FCML_TEXT("vpscatterqq")
#define M_VPSHAB FCML_TEXT("vpshab")
#define M_VPSHAD FCML_TEXT("vpshad")
#define M_VPSHAQ FCML_TEXT("vpshaq")
#define M_VPSHAW FCML_TEXT("vpshaw")
#define M_VPSHLB FCML_TEXT("vpshlb")
#define M_VPSHLD FCML_TEXT("vpshld")
#define M_VPSHLQ FCML_TEXT("vpshlq")
#define M_VPSHLW FCML_TEXT("vpshlw")
#define M_VPSHUFB FCML_TEXT("vpshufb")
#define M_VPSHUFD FCML_TEXT("vpshufd")
#define M_VPSHUFHW FCML_TEXT("vpshufhw")
#define M_VPSHUFLW FCML_TEXT("vpshuflw")
#define M_VPSIGNB FCML_TEXT("vpsignb")
#define M_VPSIGND FCML_TEXT("vpsignd")
#define M_VPSIGNW FCML_TEXT("vpsignw")
#define M_VPSLLD FCML_TEXT("vpslld")
#define M_VPSLLDQ FCML_TEXT("vpslldq")
#define M_VPSLLQ FCML_TEXT("vpsllq")
#define M_VPSLLVD FCML_TEXT("vpsllvd")
#define M_VPSLLVQ FCML_TEXT("vpsllvq")
#define M_VPSLLVW FCML_TEXT("vpsllvw")
#define M_VPSLLW FCML_TEXT("vpsllw")
#define M_VPSRAD FCML_TEXT("vpsrad")
#define M_VPSRAQ FCML_TEXT("vpsraq")
#define M_VPSRAVD FCML_TEXT("vpsravd")
#define M_VPSRAVQ FCML_TEXT("vpsravq")
#define M_VPSRAVW FCML_TEXT("vpsravw")
#define M_VPSRAW FCML_TEXT("vpsraw")
#define M_VPSRLD FCML_TEXT("vpsrld")
#define M_VPSRLDQ FCML_TEXT("vpsrldq")
#define M_VPSRLQ FCML_TEXT("vpsrlq")
#define M_VPSRLVD FCML_TEXT("vpsrlvd")
#define M_VPSRLVQ FCML_TEXT("vpsrlvq")
#define M_VPSRLVW FCML_TEXT("vpsrlvw")
#define M_VPSRLW FCML_TEXT("vpsrlw")
#define M_VPSUBB FCML_TEXT("vpsubb")
#define M_VPSUBD FCML_TEXT("vpsubd")
#define M_VPSUBQ FCML_TEXT("vpsubq")
#define M_VPSUBSB FCML_TEXT("vpsubsb")
#define M_VPSUBSW FCML_TEXT("vpsubsw")
#define M_VPSUBUSB FCML_TEXT("vpsubusb")
#define M_VPSUBUSW FCML_TEXT("vpsubusw")
#define M_VPSUBW FCML_TEXT("vpsubw")
#define M_VPTERNLOGD FCML_TEXT("vpternlogd")
#define M_VPTERNLOGQ FCML_TEXT("vpternlogq")
#define M_VPTEST FCML_TEXT("vptest")
#define M_VPTESTMB FCML_TEXT("vptestmb")
#define M_VPTESTMD FCML_TEXT("vptestmd")
#define M_VPTESTMQ FCML_TEXT("vptestmq")
#define M_VPTESTMW FCML_TEXT("vptestmw")
#define M_VPTESTNMB FCML_TEXT("vptestnmb")
#define M_VPTESTNMD FCML_TEXT("vptestnmd")
#define M_VPTESTNMQ FCML_TEXT("vptestnmq")
#define M_VPTESTNMW FCML_TEXT("vptestnmw")
#define M_VPUNPCKHBW FCML_TEXT("vpunpckhbw")
#define M_VPUNPCKHDQ FCML_TEXT("vpunpckhdq")
#define M_VPUNPCKHQDQ FCML_TEXT("vpunpckhqdq")
#define M_VPUNPCKHWD FCML_TEXT("vpunpckhwd")
#define M_VPUNPCKLBW FCML_TEXT("vpunpcklbw")
#define M_VPUNPCKLDQ FCML_TEXT("vpunpckldq")
#define M_VPUNPCKLQDQ FCML_TEXT("vpunpcklqdq")
#define M_VPUNPCKLWD FCML_TEXT("vpunpcklwd")
#define M_VPXOR FCML_TEXT("vpxor")
#define M_VPXORD FCML_TEXT("vpxord")
#define M_VPXORQ FCML_TEXT("vpxorq")
#define M_VRANGEPD FCML_TEXT("vrangepd")
#define M_VRANGEPS FCML_TEXT("vrangeps")
#define M_VRANGESD FCML_TEXT("vrangesd")
#define M_VRANGESS FCML_TEXT("vrangess")
#define M_VRCP14PD FCML_TEXT("vrcp14pd")
#define M_VRCP14PS FCML_TEXT("vrcp14ps")
#define M_VRCP14SD FCML_TEXT("vrcp14sd")
#define M_VRCP14SS FCML_TEXT("vrcp14ss")
#define M_VRCP28PD FCML_TEXT("vrcp28pd")
#define M_VRCP28PS FCML_TEXT("vrcp28ps")
#define M_VRCP28SD FCML_TEXT("vrcp28sd")
#define M_VRCP28SS FCML_TEXT("vrcp28ss")
#define M_VRCPPS FCML_TEXT("vrcpps")
#define M_VRCPSS FCML_TEXT("vrcpss")
#define M_VREDUCEPD FCML_TEXT("vreducepd")
#define M_VREDUCEPS FCML_TEXT("vreduceps")
#define M_VREDUCESD FCML_TEXT("vreducesd")
#define M_VREDUCESS FCML_TEXT("vreducess")
#define M_VRNDSCALEPD FCML_TEXT("vrndscalepd")
#define M_VRNDSCALEPS FCML_TEXT("vrndscaleps")
#define M_VRNDSCALESD FCML_TEXT("vrndscalesd")
#define M_VRNDSCALESS FCML_TEXT("vrndscaless")
#define M_VROUNDPD FCML_TEXT("vroundpd")
#define M_VROUNDPS FCML_TEXT("vroundps")
#define M_VROUNDSD FCML_TEXT("vroundsd")
#define M_VROUNDSS FCML_TEXT("vroundss")
#define M_VRSQRT14PD FCML_TEXT("vrsqrt14pd")
#define M_VRSQRT14PS FCML_TEXT("vrsqrt14ps")
#define M_VRSQRT14SD FCML_TEXT("vrsqrt14sd")
#define M_VRSQRT14SS FCML_TEXT("vrsqrt14ss")
#define M_VRSQRT28PD FCML_TEXT("vrsqrt28pd")
#define M_VRSQRT28PS FCML_TEXT("vrsqrt28ps")
#define M_VRSQRT28SD FCML_TEXT("vrsqrt28sd")
#define M_VRSQRT28SS FCML_TEXT("vrsqrt28ss")
#define M_VRSQRTPS FCML_TEXT("vrsqrtps")
#define M_VRSQRTSS FCML_TEXT("vrsqrtss")
#define M_VSCALEFPD FCML_TEXT("vscalefpd")
#define M_VSCALEFPS FCML_TEXT("vscalefps")
#define M_VSCALEFSD FCML_TEXT("vscalefsd")
#define M_VSCALEFSS FCML_TEXT("vscalefss")
#define M_VSCATTERDPD FCML_TEXT("vscatterdpd")
#define M_VSCATTERDPS FCML_TEXT("vscatterdps")
#define M_VSCATTERPF0DPD FCML_TEXT("vscatterpf0dpd")
#define M_VSCATTERPF0DPS FCML_TEXT("vscatterpf0dps")
#define M_VSCATTERPF0QPD FCML_TEXT("vscatterpf0qpd")
#define M_VSCATTERPF0QPS FCML_TEXT("vscatterpf0qps")
#define M_VSCATTERPF1DPD FCML_TEXT("vscatterpf1dpd")
#define M_VSCATTERPF1DPS FCML_TEXT("vscatterpf1dps")
#define M_VSCATTERPF1QPD FCML_TEXT("vscatterpf1qpd")
#define M_VSCATTERPF1QPS FCML_TEXT("vscatterpf1qps")
#define M_VSCATTERQPD FCML_TEXT("vscatterqpd")
#define M_VSCATTERQPS FCML_TEXT("vscatterqps")
#define M_VSHUFF32X4 FCML_TEXT("vshuff32x4")
#define M_VSHUFF64X2 FCML_TEXT("vshuff64x2")
#define M_VSHUFI32X4 FCML_TEXT("vshufi32x4")
#define M_VSHUFI64X2 FCML_TEXT("vshufi64x2")
#define M_VSHUFPD FCML_TEXT("vshufpd")
#define M_VSHUFPS FCML_TEXT("vshufps")
#define M_VSQRTPD FCML_TEXT("vsqrtpd")
#define M_VSQRTPS FCML_TEXT("vsqrtps")
#define M_VSQRTSD FCML_TEXT("vsqrtsd")
#define M_VSQRTSS FCML_TEXT("vsqrtss")
#define M_VSTMXCSR FCML_TEXT("vstmxcsr")
#define M_VSUBPD FCML_TEXT("vsubpd")
#define M_VSUBPS FCML_TEXT("vsubps")
#define M_VSUBSD FCML_TEXT("vsubsd")
#define M_VSUBSS FCML_TEXT("vsubss")
#define M_VTESTPD FCML_TEXT("vtestpd")
#define M_VTESTPS FCML_TEXT("vtestps")
#define M_VUCOMISD FCML_TEXT("vucomisd")
#define M_VUCOMISS FCML_TEXT("vucomiss")
#define M_VUNPCKHPD FCML_TEXT("vunpckhpd")
#define M_VUNPCKHPS FCML_TEXT("vunpckhps")
#define M_VUNPCKLPD FCML_TEXT("vunpcklpd")
#define M_VUNPCKLPS FCML_TEXT("vunpcklps")
#define M_VXORPD FCML_TEXT("vxorpd")
#define M_VXORPS FCML_TEXT("vxorps")
#define M_VZEROALL FCML_TEXT("vzeroall")
#define M_VZEROUPPER FCML_TEXT("vzeroupper")
#define M_WAIT FCML_TEXT("wait")
#define M_WBINVD FCML_TEXT("wbinvd")
#define M_WRFSBASE FCML_TEXT("wrfsbase")
#define M_WRGSBASE FCML_TEXT("wrgsbase")
#define M_WRMSR FCML_TEXT("wrmsr")
#define M_XABORT FCML_TEXT("xabort")
#define M_XADD FCML_TEXT("xadd")
#define M_XBEGIN FCML_TEXT("xbegin")
#define M_XCHG FCML_TEXT("xchg")
#define M_XEND FCML_TEXT("xend")
#define M_XGETBV FCML_TEXT("xgetbv")
#define M_XLAT FCML_TEXT("xlat")
#define M_XLATB FCML_TEXT("xlatb")
#define M_XOR FCML_TEXT("xor")
#define M_XORB FCML_TEXT("xorb")
#define M_XORL FCML_TEXT("xorl")
#define M_XORPD FCML_TEXT("xorpd")
#define M_XORPS FCML_TEXT("xorps")
#define M_XORQ FCML_TEXT("xorq")
#define M_XORW FCML_TEXT("xorw")
#define M_XRSTOR FCML_TEXT("xrstor")
#define M_XRSTOR64 FCML_TEXT("xrstor64")
#define M_XSAVE FCML_TEXT("xsave")
#define M_XSAVE64 FCML_TEXT("xsave64")
#define M_XSAVEOPT FCML_TEXT("xsaveopt")
#define M_XSAVEOPT64 FCML_TEXT("xsaveopt64")
#define M_XSETBV FCML_TEXT("xsetbv")
#define M_XTEST FCML_TEXT("xtest")

#endif /* FCML_GAS_MNEMONICS_H_ */
