/* -*- c++ -*-
 *
 * main.cpp
 *
 * Copyright (C) 2003 Petter Stokke <ummo@hellokitty.com>
 * Copyright (C) 2003,2004,2007 Sebastian Sauer <mail@dipe.org>
 * Copyright (C) 2006 Christian Muehlhaeuser <chris@chris.de>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 */

#include <stdlib.h>

//#include <dcopclient.h>
#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <kdebug.h>
#include <klocale.h>
#include <kuniqueapplication.h>

#include "kmldonkey.h"

#define KMLDONKEY_VERSION "2.0.5"

int main( int argc, char **argv )
{
    KAboutData about( "kmldonkey", "kmldonkey", ki18n( "KMLDonkey" ), KMLDONKEY_VERSION,
                      ki18n( "An MLDonkey frontend for the KDE desktop." ),
                      KAboutData::License_GPL_V2,
                      ki18n( "Copyright (C) 2003 - 2008 The KMLDonkey Authors" ) );
    about.addAuthor( ki18n("Sebastian Sauer"), ki18n("Maintainer & Developer" ), "mail@dipe.org", 0 );
    about.addAuthor( ki18n("Gioacchino Mazzurco"), ki18n("Developer" ), "gmazzurco89@gmail.com", 0 );
    about.addAuthor( ki18n("Christian Muehlhaeuser"), ki18n("Developer"), "chris@chris.de", 0 );
    about.addAuthor( ki18n("Petter Stokke"), ki18n("Developer & Project Founder"), "ummo@hellokitty.com", 0 );

    KCmdLineArgs::init( argc, argv, &about );
    //KCmdLineArgs::addCmdLineOptions( options );
    KUniqueApplication::addCmdLineOptions();

    if ( !KUniqueApplication::start() )
    {
        QByteArray data;
        QDataStream arg( &data, QIODevice::WriteOnly );
        arg << true;

        /*
        DCOPClient client;
        client.registerAs( "kmldonkeyLauncher" );
        client.send( "kmldonkey", "KMLDonkey", "setShown(bool)", data );
        */
        exit( 0 );
    }

    KUniqueApplication app;
    //app.dcopClient()->registerAs( app.name(), false );
    //KCmdLineArgs *args = KCmdLineArgs::parsedArgs();
    //args->clear();

    KMLDonkey* widget = new KMLDonkey;
    widget->show();
    return app.exec();
}
