/*
 *  Copyright (C) 2012-2018 Team Kodi
 *  This file is part of Kodi - https://kodi.tv
 *
 *  SPDX-License-Identifier: GPL-2.0-or-later
 *  See LICENSES/README.md for more information.
 */

#pragma once

#include <string>
#include <vector>

#include "storage/IStorageProvider.h"

struct udev;
struct udev_monitor;

class CUDevProvider : public IStorageProvider
{
public:
  CUDevProvider();
  ~CUDevProvider() override = default;

  void Initialize() override;
  void Stop() override;

  void GetLocalDrives(VECSOURCES &localDrives) override;
  void GetRemovableDrives(VECSOURCES &removableDrives) override;

  bool Eject(const std::string& mountpath) override;

  std::vector<std::string> GetDiskUsage() override;

  bool PumpDriveChangeEvents(IStorageEventsCallback *callback) override;

private:
  void GetDisks(VECSOURCES& devices, bool removable);

  struct udev         *m_udev;
  struct udev_monitor *m_udevMon;
};
