/* moonshot-identity-manager-app.c generated by valac 0.34.9, the Vala compiler
 * generated from moonshot-identity-manager-app.vala, do not modify */

/*
 * Copyright (c) 2011-2016, JANET(UK)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * 3. Neither the name of JANET(UK) nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
*/

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <string.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <gnome-keyring.h>
#include <gee.h>
#include <stdio.h>
#include <glib/gi18n-lib.h>
#include "config.h"
#include <gobject/gvaluecollector.h>


#define TYPE_IIDENTITY_MANAGER (iidentity_manager_get_type ())
#define IIDENTITY_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IIDENTITY_MANAGER, IIdentityManager))
#define IS_IIDENTITY_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IIDENTITY_MANAGER))
#define IIDENTITY_MANAGER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_IIDENTITY_MANAGER, IIdentityManagerIface))

typedef struct _IIdentityManager IIdentityManager;
typedef struct _IIdentityManagerIface IIdentityManagerIface;

#define TYPE_IIDENTITY_MANAGER_PROXY (iidentity_manager_proxy_get_type ())
typedef GDBusProxy IIdentityManagerProxy;
typedef GDBusProxyClass IIdentityManagerProxyClass;

#define TYPE_IDENTITY_MANAGER_APP (identity_manager_app_get_type ())
#define IDENTITY_MANAGER_APP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IDENTITY_MANAGER_APP, IdentityManagerApp))
#define IDENTITY_MANAGER_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_IDENTITY_MANAGER_APP, IdentityManagerAppClass))
#define IS_IDENTITY_MANAGER_APP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IDENTITY_MANAGER_APP))
#define IS_IDENTITY_MANAGER_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_IDENTITY_MANAGER_APP))
#define IDENTITY_MANAGER_APP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_IDENTITY_MANAGER_APP, IdentityManagerAppClass))

typedef struct _IdentityManagerApp IdentityManagerApp;
typedef struct _IdentityManagerAppClass IdentityManagerAppClass;
typedef struct _IdentityManagerAppPrivate IdentityManagerAppPrivate;

#define TYPE_IDENTITY_MANAGER_MODEL (identity_manager_model_get_type ())
#define IDENTITY_MANAGER_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IDENTITY_MANAGER_MODEL, IdentityManagerModel))
#define IDENTITY_MANAGER_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_IDENTITY_MANAGER_MODEL, IdentityManagerModelClass))
#define IS_IDENTITY_MANAGER_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IDENTITY_MANAGER_MODEL))
#define IS_IDENTITY_MANAGER_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_IDENTITY_MANAGER_MODEL))
#define IDENTITY_MANAGER_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_IDENTITY_MANAGER_MODEL, IdentityManagerModelClass))

typedef struct _IdentityManagerModel IdentityManagerModel;
typedef struct _IdentityManagerModelClass IdentityManagerModelClass;

#define TYPE_ID_CARD (id_card_get_type ())
#define ID_CARD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ID_CARD, IdCard))
#define ID_CARD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ID_CARD, IdCardClass))
#define IS_ID_CARD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ID_CARD))
#define IS_ID_CARD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ID_CARD))
#define ID_CARD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ID_CARD, IdCardClass))

typedef struct _IdCard IdCard;
typedef struct _IdCardClass IdCardClass;

#define TYPE_IDENTITY_MANAGER_VIEW (identity_manager_view_get_type ())
#define IDENTITY_MANAGER_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IDENTITY_MANAGER_VIEW, IdentityManagerView))
#define IDENTITY_MANAGER_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_IDENTITY_MANAGER_VIEW, IdentityManagerViewClass))
#define IS_IDENTITY_MANAGER_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IDENTITY_MANAGER_VIEW))
#define IS_IDENTITY_MANAGER_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_IDENTITY_MANAGER_VIEW))
#define IDENTITY_MANAGER_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_IDENTITY_MANAGER_VIEW, IdentityManagerViewClass))

typedef struct _IdentityManagerView IdentityManagerView;
typedef struct _IdentityManagerViewClass IdentityManagerViewClass;

#define TYPE_MOONSHOT_SERVER (moonshot_server_get_type ())
#define MOONSHOT_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MOONSHOT_SERVER, MoonshotServer))
#define MOONSHOT_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MOONSHOT_SERVER, MoonshotServerClass))
#define IS_MOONSHOT_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MOONSHOT_SERVER))
#define IS_MOONSHOT_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MOONSHOT_SERVER))
#define MOONSHOT_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MOONSHOT_SERVER, MoonshotServerClass))

typedef struct _MoonshotServer MoonshotServer;
typedef struct _MoonshotServerClass MoonshotServerClass;

#define TYPE_MOONSHOT_LOGGER (moonshot_logger_get_type ())
#define MOONSHOT_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MOONSHOT_LOGGER, MoonshotLogger))
#define MOONSHOT_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MOONSHOT_LOGGER, MoonshotLoggerClass))
#define IS_MOONSHOT_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MOONSHOT_LOGGER))
#define IS_MOONSHOT_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MOONSHOT_LOGGER))
#define MOONSHOT_LOGGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MOONSHOT_LOGGER, MoonshotLoggerClass))

typedef struct _MoonshotLogger MoonshotLogger;
typedef struct _MoonshotLoggerClass MoonshotLoggerClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define IIDENTITY_CARD_STORE_TYPE_STORE_TYPE (iidentity_card_store_store_type_get_type ())

#define TYPE_IDENTITY_REQUEST (identity_request_get_type ())
#define IDENTITY_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IDENTITY_REQUEST, IdentityRequest))
#define IDENTITY_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_IDENTITY_REQUEST, IdentityRequestClass))
#define IS_IDENTITY_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IDENTITY_REQUEST))
#define IS_IDENTITY_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_IDENTITY_REQUEST))
#define IDENTITY_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_IDENTITY_REQUEST, IdentityRequestClass))

typedef struct _IdentityRequest IdentityRequest;
typedef struct _IdentityRequestClass IdentityRequestClass;
typedef struct _Block1Data Block1Data;
#define _identity_manager_app_unref0(var) ((var == NULL) ? NULL : (var = (identity_manager_app_unref (var), NULL)))
typedef struct _IdentityRequestPrivate IdentityRequestPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_RULE (rule_get_type ())
typedef struct _Rule Rule;
#define _g_pattern_spec_free0(var) ((var == NULL) ? NULL : (var = (g_pattern_spec_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block2Data Block2Data;
typedef struct _ParamSpecIdentityManagerApp ParamSpecIdentityManagerApp;
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))

struct _IIdentityManagerIface {
	GTypeInterface parent_iface;
	gboolean (*show_ui) (IIdentityManager* self, GError** error);
};

struct _IdentityManagerApp {
	GTypeInstance parent_instance;
	volatile int ref_count;
	IdentityManagerAppPrivate * priv;
	IdentityManagerModel* model;
	IdCard* default_id_card;
	gboolean explicitly_launched;
	IdentityManagerView* view;
};

struct _IdentityManagerAppClass {
	GTypeClass parent_class;
	void (*finalize) (IdentityManagerApp *self);
};

struct _IdentityManagerAppPrivate {
	MoonshotServer* ipc_server;
	gboolean name_is_owned;
	gboolean show_requested;
	gboolean _use_flat_file_store;
	gboolean _headless;
};

typedef enum  {
	IIDENTITY_CARD_STORE_STORE_TYPE_FLAT_FILE,
	IIDENTITY_CARD_STORE_STORE_TYPE_KEYRING
} IIdentityCardStoreStoreType;

struct _Block1Data {
	int _ref_count_;
	IdentityManagerApp* self;
	IdCard* identity;
	IdentityRequest* request;
};

struct _IdentityRequest {
	GObject parent_instance;
	IdentityRequestPrivate * priv;
	IdCard* id_card;
	gboolean complete;
	gboolean select_default;
	gchar* nai;
	gchar* password;
	gchar* service;
	GSList* candidates;
};

struct _IdentityRequestClass {
	GObjectClass parent_class;
};

struct _Rule {
	gchar* pattern;
	gchar* always_confirm;
};

struct _Block2Data {
	int _ref_count_;
	IdentityManagerApp* self;
	gboolean shown;
	gchar* our_name;
};

struct _ParamSpecIdentityManagerApp {
	GParamSpec parent_instance;
};


static gpointer identity_manager_app_parent_class = NULL;
extern MoonshotLogger* identity_manager_app_logger;
MoonshotLogger* identity_manager_app_logger = NULL;
extern gboolean explicitly_launched;
gboolean explicitly_launched = TRUE;
extern gboolean use_flat_file_store;
gboolean use_flat_file_store = FALSE;
extern gboolean gtk_available;

GType iidentity_manager_proxy_get_type (void) G_GNUC_CONST;
guint iidentity_manager_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType iidentity_manager_get_type (void) G_GNUC_CONST;
gboolean iidentity_manager_show_ui (IIdentityManager* self, GError** error);
static void iidentity_manager_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters);
static gboolean iidentity_manager_proxy_show_ui (IIdentityManager* self, GError** error);
static void iidentity_manager_proxy_iidentity_manager_interface_init (IIdentityManagerIface* iface);
static void _dbus_iidentity_manager_show_ui (IIdentityManager* self, GVariant* _parameters_, GDBusMethodInvocation* invocation);
static void iidentity_manager_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data);
static GVariant* iidentity_manager_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data);
static gboolean iidentity_manager_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data);
static void _iidentity_manager_unregister_object (gpointer user_data);
gpointer identity_manager_app_ref (gpointer instance);
void identity_manager_app_unref (gpointer instance);
GParamSpec* param_spec_identity_manager_app (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_identity_manager_app (GValue* value, gpointer v_object);
void value_take_identity_manager_app (GValue* value, gpointer v_object);
gpointer value_get_identity_manager_app (const GValue* value);
GType identity_manager_app_get_type (void) G_GNUC_CONST;
GType identity_manager_model_get_type (void) G_GNUC_CONST;
GType id_card_get_type (void) G_GNUC_CONST;
GType identity_manager_view_get_type (void) G_GNUC_CONST;
GType moonshot_server_get_type (void) G_GNUC_CONST;
guint moonshot_server_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
#define IDENTITY_MANAGER_APP_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_IDENTITY_MANAGER_APP, IdentityManagerAppPrivate))
enum  {
	IDENTITY_MANAGER_APP_DUMMY_PROPERTY
};
GType moonshot_logger_get_type (void) G_GNUC_CONST;
MoonshotLogger* get_logger (const gchar* name);
void identity_manager_app_show (IdentityManagerApp* self);
void identity_manager_view_make_visible (IdentityManagerView* self);
IdentityManagerApp* identity_manager_app_new (gboolean headless, gboolean use_flat_file_store);
IdentityManagerApp* identity_manager_app_construct (GType object_type, gboolean headless, gboolean use_flat_file_store);
static void identity_manager_app_set_headless (IdentityManagerApp* self, gboolean value);
gboolean UserForcesFlatFileStore (void);
static void identity_manager_app_set_use_flat_file_store (IdentityManagerApp* self, gboolean value);
GType iidentity_card_store_store_type_get_type (void) G_GNUC_CONST;
IdentityManagerModel* identity_manager_model_new (IdentityManagerApp* parent_app, IIdentityCardStoreStoreType store_type);
IdentityManagerModel* identity_manager_model_construct (GType object_type, IdentityManagerApp* parent_app, IIdentityCardStoreStoreType store_type);
gboolean identity_manager_model_HasNonTrivialIdentities (IdentityManagerModel* self);
void identity_manager_model_set_store_type (IdentityManagerModel* self, IIdentityCardStoreStoreType type);
IdentityManagerView* identity_manager_view_new (IdentityManagerApp* app, gboolean use_flat_file_store);
IdentityManagerView* identity_manager_view_construct (GType object_type, IdentityManagerApp* app, gboolean use_flat_file_store);
GeeLinkedList* identity_manager_model_get_card_list (IdentityManagerModel* self);
static void identity_manager_app_init_ipc_server (IdentityManagerApp* self);
gboolean identity_manager_app_add_identity (IdentityManagerApp* self, IdCard* id, gboolean force_flat_file_store, GeeArrayList** old_duplicates);
void moonshot_logger_trace (MoonshotLogger* self, const gchar* message, GError* e);
gboolean identity_manager_view_add_identity (IdentityManagerView* self, IdCard* id_card, gboolean force_flat_file_store, GeeArrayList** old_duplicates);
void identity_manager_model_add_card (IdentityManagerModel* self, IdCard* card, gboolean force_flat_file_store, GeeArrayList** old_duplicates);
GType identity_request_get_type (void) G_GNUC_CONST;
void identity_manager_app_select_identity (IdentityManagerApp* self, IdentityRequest* request);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
const gchar* id_card_get_nai (IdCard* self);
const gchar* id_card_get_display_name (IdCard* self);
GeeArrayList* id_card_get_services (IdCard* self);
GType rule_get_type (void) G_GNUC_CONST;
Rule* rule_dup (const Rule* self);
void rule_free (Rule* self);
void rule_copy (const Rule* self, Rule* dest);
void rule_destroy (Rule* self);
Rule* id_card_get_rules (IdCard* self, int* result_length1);
static gboolean identity_manager_app_match_service_pattern (IdentityManagerApp* self, const gchar* service, const gchar* pattern);
IdCard* id_card_new (void);
IdCard* id_card_construct (GType object_type);
void id_card_set_display_name (IdCard* self, const gchar* value);
void id_card_set_username (IdCard* self, const gchar* value);
void id_card_set_issuer (IdCard* self, const gchar* value);
void id_card_set_password (IdCard* self, const gchar* value);
void id_card_set_temporary (IdCard* self, gboolean value);
void identity_manager_view_queue_identity_request (IdentityManagerView* self, IdentityRequest* request);
static gboolean __lambda5_ (Block1Data* _data1_);
IdCard* identity_manager_view_check_add_password (IdentityManagerView* self, IdCard* identity, IdentityRequest* request, IdentityManagerModel* model);
void identity_request_return_identity (IdentityRequest* self, IdCard* id_card, gboolean update_card);
static gboolean ___lambda5__gsource_func (gpointer self);
static void identity_manager_app_bus_acquired_cb (IdentityManagerApp* self, GDBusConnection* conn);
MoonshotServer* moonshot_server_new (IdentityManagerApp* app);
MoonshotServer* moonshot_server_construct (GType object_type, IdentityManagerApp* app);
static void _identity_manager_app_bus_acquired_cb_gbus_acquired_callback (GDBusConnection* connection, const gchar* name, gpointer self);
static void ___lambda23_ (IdentityManagerApp* self, GDBusConnection* conn, const gchar* name);
static void ____lambda23__gbus_name_acquired_callback (GDBusConnection* connection, const gchar* name, gpointer self);
static void ___lambda24_ (IdentityManagerApp* self, GDBusConnection* conn, const gchar* name);
void moonshot_logger_error (MoonshotLogger* self, const gchar* message, GError* e);
static void ____lambda24__gbus_name_lost_callback (GDBusConnection* connection, const gchar* name, gpointer self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void __lambda25_ (Block2Data* _data2_, GDBusConnection* conn, const gchar* name);
static void ___lambda25__gbus_name_acquired_callback (GDBusConnection* connection, const gchar* name, gpointer self);
static void __lambda26_ (Block2Data* _data2_);
static void ___lambda26__gbus_name_lost_callback (GDBusConnection* connection, const gchar* name, gpointer self);
gboolean identity_manager_app_get_use_flat_file_store (IdentityManagerApp* self);
gboolean identity_manager_app_get_headless (IdentityManagerApp* self);
static void identity_manager_app_finalize (IdentityManagerApp* obj);
gint _vala_main (gchar** args, int args_length1);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const GDBusArgInfo _iidentity_manager_dbus_arg_info_show_ui_result = {-1, "result", "b"};
static const GDBusArgInfo * const _iidentity_manager_dbus_arg_info_show_ui_in[] = {NULL};
static const GDBusArgInfo * const _iidentity_manager_dbus_arg_info_show_ui_out[] = {&_iidentity_manager_dbus_arg_info_show_ui_result, NULL};
static const GDBusMethodInfo _iidentity_manager_dbus_method_info_show_ui = {-1, "ShowUi", (GDBusArgInfo **) (&_iidentity_manager_dbus_arg_info_show_ui_in), (GDBusArgInfo **) (&_iidentity_manager_dbus_arg_info_show_ui_out)};
static const GDBusMethodInfo * const _iidentity_manager_dbus_method_info[] = {&_iidentity_manager_dbus_method_info_show_ui, NULL};
static const GDBusSignalInfo * const _iidentity_manager_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _iidentity_manager_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _iidentity_manager_dbus_interface_info = {-1, "org.janet.Moonshot", (GDBusMethodInfo **) (&_iidentity_manager_dbus_method_info), (GDBusSignalInfo **) (&_iidentity_manager_dbus_signal_info), (GDBusPropertyInfo **) (&_iidentity_manager_dbus_property_info)};
static const GDBusInterfaceVTable _iidentity_manager_dbus_interface_vtable = {iidentity_manager_dbus_interface_method_call, iidentity_manager_dbus_interface_get_property, iidentity_manager_dbus_interface_set_property};
const GOptionEntry options[3] = {{"dbus-launched", (gchar) 0, (gint) G_OPTION_FLAG_REVERSE, G_OPTION_ARG_NONE, &explicitly_launched, "launch for dbus rpc use", NULL}, {"flat-file-store", (gchar) 0, 0, G_OPTION_ARG_NONE, &use_flat_file_store, "force use of flat file identity store (used by default only for headle" \
"ss operation)", NULL}, {NULL}};

gboolean iidentity_manager_show_ui (IIdentityManager* self, GError** error) {
#line 41 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 41 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	return IIDENTITY_MANAGER_GET_INTERFACE (self)->show_ui (self, error);
#line 347 "moonshot-identity-manager-app.c"
}


static void iidentity_manager_base_init (IIdentityManagerIface * iface) {
#line 37 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	static gboolean initialized = FALSE;
#line 37 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	if (!initialized) {
#line 37 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		initialized = TRUE;
#line 358 "moonshot-identity-manager-app.c"
	}
}


GType iidentity_manager_get_type (void) {
	static volatile gsize iidentity_manager_type_id__volatile = 0;
	if (g_once_init_enter (&iidentity_manager_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (IIdentityManagerIface), (GBaseInitFunc) iidentity_manager_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType iidentity_manager_type_id;
		iidentity_manager_type_id = g_type_register_static (G_TYPE_INTERFACE, "IIdentityManager", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (iidentity_manager_type_id, G_TYPE_OBJECT);
		g_type_set_qdata (iidentity_manager_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) iidentity_manager_proxy_get_type);
		g_type_set_qdata (iidentity_manager_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.janet.Moonshot");
		g_type_set_qdata (iidentity_manager_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_iidentity_manager_dbus_interface_info));
		g_type_set_qdata (iidentity_manager_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) iidentity_manager_register_object);
		g_once_init_leave (&iidentity_manager_type_id__volatile, iidentity_manager_type_id);
	}
	return iidentity_manager_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (IIdentityManagerProxy, iidentity_manager_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (TYPE_IIDENTITY_MANAGER, iidentity_manager_proxy_iidentity_manager_interface_init) )
static void iidentity_manager_proxy_class_init (IIdentityManagerProxyClass* klass) {
	G_DBUS_PROXY_CLASS (klass)->g_signal = iidentity_manager_proxy_g_signal;
}


static void iidentity_manager_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters) {
}


static void iidentity_manager_proxy_init (IIdentityManagerProxy* self) {
}


static gboolean iidentity_manager_proxy_show_ui (IIdentityManager* self, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gboolean _result = FALSE;
	GVariant* _tmp2_;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.janet.Moonshot", "ShowUi");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		gboolean _tmp0_ = FALSE;
		return _tmp0_;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		gboolean _tmp1_ = FALSE;
		g_object_unref (_reply_message);
		return _tmp1_;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp2_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_get_boolean (_tmp2_);
	g_variant_unref (_tmp2_);
	g_object_unref (_reply_message);
	return _result;
}


static void iidentity_manager_proxy_iidentity_manager_interface_init (IIdentityManagerIface* iface) {
	iface->show_ui = iidentity_manager_proxy_show_ui;
}


static void _dbus_iidentity_manager_show_ui (IIdentityManager* self, GVariant* _parameters_, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gboolean result;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	result = iidentity_manager_show_ui (self, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_boolean (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void iidentity_manager_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "ShowUi") == 0) {
		_dbus_iidentity_manager_show_ui (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}


static GVariant* iidentity_manager_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}


static gboolean iidentity_manager_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}


guint iidentity_manager_register_object (gpointer object, GDBusConnection* connection, const gchar* path, GError** error) {
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_iidentity_manager_dbus_interface_info), &_iidentity_manager_dbus_interface_vtable, data, _iidentity_manager_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}


static void _iidentity_manager_unregister_object (gpointer user_data) {
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}


/** If we're successfully registered with DBus, then show the UI. Otherwise, wait until we're registered. */
void identity_manager_app_show (IdentityManagerApp* self) {
	gboolean _tmp0_ = FALSE;
#line 75 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	g_return_if_fail (self != NULL);
#line 76 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_tmp0_ = self->priv->name_is_owned;
#line 76 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	if (_tmp0_) {
#line 523 "moonshot-identity-manager-app.c"
		IdentityManagerView* _tmp1_ = NULL;
#line 77 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp1_ = self->view;
#line 77 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		if (_tmp1_ != NULL) {
#line 529 "moonshot-identity-manager-app.c"
			IdentityManagerView* _tmp2_ = NULL;
#line 78 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp2_ = self->view;
#line 78 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			identity_manager_view_make_visible (_tmp2_);
#line 535 "moonshot-identity-manager-app.c"
		}
	} else {
#line 82 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		self->priv->show_requested = TRUE;
#line 540 "moonshot-identity-manager-app.c"
	}
}


IdentityManagerApp* identity_manager_app_construct (GType object_type, gboolean headless, gboolean use_flat_file_store) {
	IdentityManagerApp* self = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean keyring_available = FALSE;
	IIdentityCardStoreStoreType store_type = 0;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	IIdentityCardStoreStoreType _tmp12_ = 0;
	IdentityManagerModel* _tmp13_ = NULL;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp15_ = FALSE;
	gboolean _tmp16_ = FALSE;
	gboolean _tmp17_ = FALSE;
	gboolean _tmp23_ = FALSE;
	GeeLinkedList* card_list = NULL;
	IdentityManagerModel* _tmp26_ = NULL;
	GeeLinkedList* _tmp27_ = NULL;
	GeeLinkedList* _tmp28_ = NULL;
	gint _tmp29_ = 0;
	gint _tmp30_ = 0;
#line 91 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	self = (IdentityManagerApp*) g_type_create_instance (object_type);
#line 92 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_tmp0_ = headless;
#line 92 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	identity_manager_app_set_headless (self, _tmp0_);
#line 94 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_tmp1_ = use_flat_file_store;
#line 94 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_tmp2_ = UserForcesFlatFileStore ();
#line 94 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	use_flat_file_store = _tmp1_ | _tmp2_;
#line 95 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_tmp3_ = use_flat_file_store;
#line 95 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	identity_manager_app_set_use_flat_file_store (self, _tmp3_);
#line 98 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_tmp5_ = use_flat_file_store;
#line 98 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	if (!_tmp5_) {
#line 591 "moonshot-identity-manager-app.c"
		gboolean _tmp6_ = FALSE;
#line 98 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp6_ = gnome_keyring_is_available ();
#line 98 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp4_ = _tmp6_;
#line 597 "moonshot-identity-manager-app.c"
	} else {
#line 98 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp4_ = FALSE;
#line 601 "moonshot-identity-manager-app.c"
	}
#line 98 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	keyring_available = _tmp4_;
#line 104 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_tmp9_ = headless;
#line 104 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	if (_tmp9_) {
#line 104 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp8_ = TRUE;
#line 611 "moonshot-identity-manager-app.c"
	} else {
		gboolean _tmp10_ = FALSE;
#line 104 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp10_ = use_flat_file_store;
#line 104 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp8_ = _tmp10_;
#line 618 "moonshot-identity-manager-app.c"
	}
#line 104 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	if (_tmp8_) {
#line 104 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp7_ = TRUE;
#line 624 "moonshot-identity-manager-app.c"
	} else {
		gboolean _tmp11_ = FALSE;
#line 104 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp11_ = keyring_available;
#line 104 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp7_ = !_tmp11_;
#line 631 "moonshot-identity-manager-app.c"
	}
#line 104 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	if (_tmp7_) {
#line 105 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		store_type = IIDENTITY_CARD_STORE_STORE_TYPE_FLAT_FILE;
#line 637 "moonshot-identity-manager-app.c"
	} else {
#line 107 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		store_type = IIDENTITY_CARD_STORE_STORE_TYPE_KEYRING;
#line 641 "moonshot-identity-manager-app.c"
	}
#line 109 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_tmp12_ = store_type;
#line 109 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_tmp13_ = identity_manager_model_new (self, _tmp12_);
#line 109 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_g_object_unref0 (self->model);
#line 109 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	self->model = _tmp13_;
#line 112 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_tmp17_ = headless;
#line 112 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	if (_tmp17_) {
#line 655 "moonshot-identity-manager-app.c"
		gboolean _tmp18_ = FALSE;
#line 112 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp18_ = keyring_available;
#line 112 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp16_ = _tmp18_;
#line 661 "moonshot-identity-manager-app.c"
	} else {
#line 112 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp16_ = FALSE;
#line 665 "moonshot-identity-manager-app.c"
	}
#line 112 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	if (_tmp16_) {
#line 669 "moonshot-identity-manager-app.c"
		gboolean _tmp19_ = FALSE;
#line 112 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp19_ = use_flat_file_store;
#line 112 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp15_ = !_tmp19_;
#line 675 "moonshot-identity-manager-app.c"
	} else {
#line 112 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp15_ = FALSE;
#line 679 "moonshot-identity-manager-app.c"
	}
#line 112 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	if (_tmp15_) {
#line 683 "moonshot-identity-manager-app.c"
		IdentityManagerModel* _tmp20_ = NULL;
		gboolean _tmp21_ = FALSE;
#line 112 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp20_ = self->model;
#line 112 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp21_ = identity_manager_model_HasNonTrivialIdentities (_tmp20_);
#line 112 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp14_ = !_tmp21_;
#line 692 "moonshot-identity-manager-app.c"
	} else {
#line 112 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp14_ = FALSE;
#line 696 "moonshot-identity-manager-app.c"
	}
#line 112 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	if (_tmp14_) {
#line 700 "moonshot-identity-manager-app.c"
		IdentityManagerModel* _tmp22_ = NULL;
#line 113 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp22_ = self->model;
#line 113 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		identity_manager_model_set_store_type (_tmp22_, IIDENTITY_CARD_STORE_STORE_TYPE_KEYRING);
#line 706 "moonshot-identity-manager-app.c"
	}
#line 115 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_tmp23_ = headless;
#line 115 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	if (!_tmp23_) {
#line 712 "moonshot-identity-manager-app.c"
		gboolean _tmp24_ = FALSE;
		IdentityManagerView* _tmp25_ = NULL;
#line 116 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp24_ = use_flat_file_store;
#line 116 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp25_ = identity_manager_view_new (self, _tmp24_);
#line 116 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		g_object_ref_sink (_tmp25_);
#line 116 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_g_object_unref0 (self->view);
#line 116 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		self->view = _tmp25_;
#line 725 "moonshot-identity-manager-app.c"
	}
#line 117 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_tmp26_ = self->model;
#line 117 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_tmp27_ = identity_manager_model_get_card_list (_tmp26_);
#line 117 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	card_list = _tmp27_;
#line 118 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_tmp28_ = card_list;
#line 118 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_tmp29_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp28_);
#line 118 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_tmp30_ = _tmp29_;
#line 118 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	if (_tmp30_ > 0) {
#line 741 "moonshot-identity-manager-app.c"
		GeeLinkedList* _tmp31_ = NULL;
		gpointer _tmp32_ = NULL;
#line 119 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp31_ = card_list;
#line 119 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp32_ = gee_linked_list_last (_tmp31_);
#line 119 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_g_object_unref0 (self->default_id_card);
#line 119 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		self->default_id_card = (IdCard*) _tmp32_;
#line 752 "moonshot-identity-manager-app.c"
	}
#line 121 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	identity_manager_app_init_ipc_server (self);
#line 91 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_g_object_unref0 (card_list);
#line 91 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	return self;
#line 760 "moonshot-identity-manager-app.c"
}


IdentityManagerApp* identity_manager_app_new (gboolean headless, gboolean use_flat_file_store) {
#line 91 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	return identity_manager_app_construct (TYPE_IDENTITY_MANAGER_APP, headless, use_flat_file_store);
#line 767 "moonshot-identity-manager-app.c"
}


gboolean identity_manager_app_add_identity (IdentityManagerApp* self, IdCard* id, gboolean force_flat_file_store, GeeArrayList** old_duplicates) {
	GeeArrayList* _vala_old_duplicates = NULL;
	gboolean result = FALSE;
	IdentityManagerView* _tmp0_ = NULL;
#line 132 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 132 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	g_return_val_if_fail (id != NULL, FALSE);
#line 133 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_tmp0_ = self->view;
#line 133 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	if (_tmp0_ != NULL) {
#line 783 "moonshot-identity-manager-app.c"
		MoonshotLogger* _tmp1_ = NULL;
		IdentityManagerView* _tmp2_ = NULL;
		IdCard* _tmp3_ = NULL;
		gboolean _tmp4_ = FALSE;
		GeeArrayList* _tmp5_ = NULL;
		gboolean _tmp6_ = FALSE;
#line 135 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp1_ = identity_manager_app_logger;
#line 135 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		moonshot_logger_trace (_tmp1_, "add_identity: calling view.add_identity", NULL);
#line 136 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp2_ = self->view;
#line 136 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp3_ = id;
#line 136 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp4_ = force_flat_file_store;
#line 136 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp6_ = identity_manager_view_add_identity (_tmp2_, _tmp3_, _tmp4_, &_tmp5_);
#line 136 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_g_object_unref0 (_vala_old_duplicates);
#line 136 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_vala_old_duplicates = _tmp5_;
#line 136 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		result = _tmp6_;
#line 136 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		if (old_duplicates) {
#line 136 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			*old_duplicates = _vala_old_duplicates;
#line 812 "moonshot-identity-manager-app.c"
		} else {
#line 136 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_g_object_unref0 (_vala_old_duplicates);
#line 816 "moonshot-identity-manager-app.c"
		}
#line 136 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		return result;
#line 820 "moonshot-identity-manager-app.c"
	} else {
		MoonshotLogger* _tmp7_ = NULL;
		IdentityManagerModel* _tmp8_ = NULL;
		IdCard* _tmp9_ = NULL;
		gboolean _tmp10_ = FALSE;
		GeeArrayList* _tmp11_ = NULL;
#line 139 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp7_ = identity_manager_app_logger;
#line 139 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		moonshot_logger_trace (_tmp7_, "add_identity: calling model.add_card", NULL);
#line 140 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp8_ = self->model;
#line 140 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp9_ = id;
#line 140 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp10_ = force_flat_file_store;
#line 140 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		identity_manager_model_add_card (_tmp8_, _tmp9_, _tmp10_, &_tmp11_);
#line 140 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_g_object_unref0 (_vala_old_duplicates);
#line 140 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_vala_old_duplicates = _tmp11_;
#line 141 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		result = TRUE;
#line 141 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		if (old_duplicates) {
#line 141 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			*old_duplicates = _vala_old_duplicates;
#line 849 "moonshot-identity-manager-app.c"
		} else {
#line 141 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_g_object_unref0 (_vala_old_duplicates);
#line 853 "moonshot-identity-manager-app.c"
		}
#line 141 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		return result;
#line 857 "moonshot-identity-manager-app.c"
	}
#line 132 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	if (old_duplicates) {
#line 132 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		*old_duplicates = _vala_old_duplicates;
#line 863 "moonshot-identity-manager-app.c"
	} else {
#line 132 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_g_object_unref0 (_vala_old_duplicates);
#line 867 "moonshot-identity-manager-app.c"
	}
}


static gpointer _g_object_ref0 (gpointer self) {
#line 145 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	return self ? g_object_ref (self) : NULL;
#line 875 "moonshot-identity-manager-app.c"
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
#line 145 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	g_atomic_int_inc (&_data1_->_ref_count_);
#line 145 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	return _data1_;
#line 884 "moonshot-identity-manager-app.c"
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
#line 145 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
#line 893 "moonshot-identity-manager-app.c"
		IdentityManagerApp* self;
#line 145 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		self = _data1_->self;
#line 145 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_g_object_unref0 (_data1_->identity);
#line 145 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_g_object_unref0 (_data1_->request);
#line 145 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_identity_manager_app_unref0 (self);
#line 145 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		g_slice_free (Block1Data, _data1_);
#line 905 "moonshot-identity-manager-app.c"
	}
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
#line 1420 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1421 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	result = self;
#line 1421 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	return result;
#line 918 "moonshot-identity-manager-app.c"
}


static gboolean __lambda5_ (Block1Data* _data1_) {
	IdentityManagerApp* self;
	gboolean result = FALSE;
	IdentityManagerView* _tmp0_ = NULL;
	IdentityRequest* _tmp7_ = NULL;
	IdCard* _tmp8_ = NULL;
#line 243 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	self = _data1_->self;
#line 244 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_tmp0_ = self->view;
#line 244 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	if (_tmp0_ != NULL) {
#line 934 "moonshot-identity-manager-app.c"
		MoonshotLogger* _tmp1_ = NULL;
		IdentityManagerView* _tmp2_ = NULL;
		IdCard* _tmp3_ = NULL;
		IdentityRequest* _tmp4_ = NULL;
		IdentityManagerModel* _tmp5_ = NULL;
		IdCard* _tmp6_ = NULL;
#line 245 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp1_ = identity_manager_app_logger;
#line 245 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		moonshot_logger_trace (_tmp1_, "select_identity (Idle handler): calling check_add_password", NULL);
#line 246 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp2_ = self->view;
#line 246 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp3_ = _data1_->identity;
#line 246 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp4_ = _data1_->request;
#line 246 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp5_ = self->model;
#line 246 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp6_ = identity_manager_view_check_add_password (_tmp2_, _tmp3_, _tmp4_, _tmp5_);
#line 246 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_g_object_unref0 (_data1_->identity);
#line 246 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_data1_->identity = _tmp6_;
#line 959 "moonshot-identity-manager-app.c"
	}
#line 248 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_tmp7_ = _data1_->request;
#line 248 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_tmp8_ = _data1_->identity;
#line 248 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	identity_request_return_identity (_tmp7_, _tmp8_, TRUE);
#line 253 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	result = FALSE;
#line 253 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	return result;
#line 971 "moonshot-identity-manager-app.c"
}


static gboolean ___lambda5__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda5_ (self);
#line 242 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	return result;
#line 980 "moonshot-identity-manager-app.c"
}


void identity_manager_app_select_identity (IdentityManagerApp* self, IdentityRequest* request) {
	Block1Data* _data1_;
	IdentityRequest* _tmp0_ = NULL;
	IdentityRequest* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	IdentityRequest* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	MoonshotLogger* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	IdentityRequest* _tmp8_ = NULL;
	gboolean _tmp9_ = FALSE;
	IdCard* _tmp12_ = NULL;
#line 145 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	g_return_if_fail (self != NULL);
#line 145 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	g_return_if_fail (request != NULL);
#line 145 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_data1_ = g_slice_new0 (Block1Data);
#line 145 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_data1_->_ref_count_ = 1;
#line 145 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_data1_->self = identity_manager_app_ref (self);
#line 145 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_tmp0_ = request;
#line 145 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 145 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_g_object_unref0 (_data1_->request);
#line 145 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_data1_->request = _tmp1_;
#line 146 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_tmp3_ = _data1_->request;
#line 146 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_tmp4_ = _tmp3_->nai;
#line 146 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_tmp2_ = _tmp4_;
#line 146 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	if (_tmp2_ == NULL) {
#line 146 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp2_ = "[null]";
#line 1025 "moonshot-identity-manager-app.c"
	}
#line 146 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_tmp5_ = identity_manager_app_logger;
#line 146 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_tmp6_ = g_strdup_printf ("select_identity: request.nai=%s", _tmp2_);
#line 146 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_tmp7_ = _tmp6_;
#line 146 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	moonshot_logger_trace (_tmp5_, _tmp7_, NULL);
#line 146 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_g_free0 (_tmp7_);
#line 148 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_data1_->identity = NULL;
#line 150 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_tmp8_ = _data1_->request;
#line 150 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_tmp9_ = _tmp8_->select_default;
#line 150 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	if (_tmp9_) {
#line 1045 "moonshot-identity-manager-app.c"
		IdCard* _tmp10_ = NULL;
		IdCard* _tmp11_ = NULL;
#line 152 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp10_ = self->default_id_card;
#line 152 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp11_ = _g_object_ref0 (_tmp10_);
#line 152 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_g_object_unref0 (_data1_->identity);
#line 152 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_data1_->identity = _tmp11_;
#line 1056 "moonshot-identity-manager-app.c"
	}
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_tmp12_ = _data1_->identity;
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	if (_tmp12_ == NULL) {
#line 1062 "moonshot-identity-manager-app.c"
		gboolean _tmp13_ = FALSE;
		IdentityRequest* _tmp14_ = NULL;
		const gchar* _tmp15_ = NULL;
		gboolean has_nai = FALSE;
		gboolean _tmp18_ = FALSE;
		IdentityRequest* _tmp19_ = NULL;
		const gchar* _tmp20_ = NULL;
		gboolean has_srv = FALSE;
		gboolean confirm = FALSE;
		gboolean _tmp69_ = FALSE;
		gboolean _tmp70_ = FALSE;
		IdCard* _tmp71_ = NULL;
		gboolean _tmp90_ = FALSE;
		IdCard* _tmp91_ = NULL;
		gboolean _tmp128_ = FALSE;
		IdCard* _tmp129_ = NULL;
		IdCard* _tmp151_ = NULL;
		gboolean _tmp165_ = FALSE;
		gboolean _tmp166_ = FALSE;
#line 157 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp14_ = _data1_->request;
#line 157 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp15_ = _tmp14_->nai;
#line 157 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		if (_tmp15_ != NULL) {
#line 1088 "moonshot-identity-manager-app.c"
			IdentityRequest* _tmp16_ = NULL;
			const gchar* _tmp17_ = NULL;
#line 157 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp16_ = _data1_->request;
#line 157 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp17_ = _tmp16_->nai;
#line 157 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp13_ = g_strcmp0 (_tmp17_, "") != 0;
#line 1097 "moonshot-identity-manager-app.c"
		} else {
#line 157 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp13_ = FALSE;
#line 1101 "moonshot-identity-manager-app.c"
		}
#line 157 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		has_nai = _tmp13_;
#line 158 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp19_ = _data1_->request;
#line 158 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp20_ = _tmp19_->service;
#line 158 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		if (_tmp20_ != NULL) {
#line 1111 "moonshot-identity-manager-app.c"
			IdentityRequest* _tmp21_ = NULL;
			const gchar* _tmp22_ = NULL;
#line 158 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp21_ = _data1_->request;
#line 158 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp22_ = _tmp21_->service;
#line 158 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp18_ = g_strcmp0 (_tmp22_, "") != 0;
#line 1120 "moonshot-identity-manager-app.c"
		} else {
#line 158 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp18_ = FALSE;
#line 1124 "moonshot-identity-manager-app.c"
		}
#line 158 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		has_srv = _tmp18_;
#line 159 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		confirm = FALSE;
#line 1130 "moonshot-identity-manager-app.c"
		{
			GeeLinkedList* _id_list = NULL;
			IdentityManagerModel* _tmp23_ = NULL;
			GeeLinkedList* _tmp24_ = NULL;
			gint _id_size = 0;
			GeeLinkedList* _tmp25_ = NULL;
			gint _tmp26_ = 0;
			gint _tmp27_ = 0;
			gint _id_index = 0;
#line 161 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp23_ = self->model;
#line 161 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp24_ = identity_manager_model_get_card_list (_tmp23_);
#line 161 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_id_list = _tmp24_;
#line 161 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp25_ = _id_list;
#line 161 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp26_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp25_);
#line 161 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp27_ = _tmp26_;
#line 161 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_id_size = _tmp27_;
#line 161 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_id_index = -1;
#line 161 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			while (TRUE) {
#line 1158 "moonshot-identity-manager-app.c"
				gint _tmp28_ = 0;
				gint _tmp29_ = 0;
				gint _tmp30_ = 0;
				IdCard* id = NULL;
				GeeLinkedList* _tmp31_ = NULL;
				gint _tmp32_ = 0;
				gpointer _tmp33_ = NULL;
				gboolean _tmp34_ = FALSE;
				gboolean _tmp35_ = FALSE;
				gboolean _tmp49_ = FALSE;
#line 161 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
				_tmp28_ = _id_index;
#line 161 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
				_id_index = _tmp28_ + 1;
#line 161 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
				_tmp29_ = _id_index;
#line 161 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
				_tmp30_ = _id_size;
#line 161 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
				if (!(_tmp29_ < _tmp30_)) {
#line 161 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
					break;
#line 1181 "moonshot-identity-manager-app.c"
				}
#line 161 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
				_tmp31_ = _id_list;
#line 161 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
				_tmp32_ = _id_index;
#line 161 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
				_tmp33_ = gee_abstract_list_get ((GeeAbstractList*) _tmp31_, _tmp32_);
#line 161 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
				id = (IdCard*) _tmp33_;
#line 164 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
				_tmp35_ = has_nai;
#line 164 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
				if (_tmp35_) {
#line 1195 "moonshot-identity-manager-app.c"
					IdentityRequest* _tmp36_ = NULL;
					const gchar* _tmp37_ = NULL;
					IdCard* _tmp38_ = NULL;
					const gchar* _tmp39_ = NULL;
					const gchar* _tmp40_ = NULL;
#line 164 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
					_tmp36_ = _data1_->request;
#line 164 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
					_tmp37_ = _tmp36_->nai;
#line 164 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
					_tmp38_ = id;
#line 164 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
					_tmp39_ = id_card_get_nai (_tmp38_);
#line 164 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
					_tmp40_ = _tmp39_;
#line 164 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
					_tmp34_ = g_strcmp0 (_tmp37_, _tmp40_) == 0;
#line 1213 "moonshot-identity-manager-app.c"
				} else {
#line 164 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
					_tmp34_ = FALSE;
#line 1217 "moonshot-identity-manager-app.c"
				}
#line 164 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
				if (_tmp34_) {
#line 1221 "moonshot-identity-manager-app.c"
					MoonshotLogger* _tmp41_ = NULL;
					IdCard* _tmp42_ = NULL;
					const gchar* _tmp43_ = NULL;
					const gchar* _tmp44_ = NULL;
					gchar* _tmp45_ = NULL;
					gchar* _tmp46_ = NULL;
					IdCard* _tmp47_ = NULL;
					IdCard* _tmp48_ = NULL;
#line 166 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
					_tmp41_ = identity_manager_app_logger;
#line 166 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
					_tmp42_ = id;
#line 166 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
					_tmp43_ = id_card_get_display_name (_tmp42_);
#line 166 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
					_tmp44_ = _tmp43_;
#line 166 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
					_tmp45_ = g_strconcat ("select_identity: request has nai; returning ", _tmp44_, NULL);
#line 166 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
					_tmp46_ = _tmp45_;
#line 166 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
					moonshot_logger_trace (_tmp41_, _tmp46_, NULL);
#line 166 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
					_g_free0 (_tmp46_);
#line 167 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
					_tmp47_ = id;
#line 167 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
					_tmp48_ = _g_object_ref0 (_tmp47_);
#line 167 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
					_g_object_unref0 (_data1_->identity);
#line 167 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
					_data1_->identity = _tmp48_;
#line 168 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
					_g_object_unref0 (id);
#line 168 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
					break;
#line 1258 "moonshot-identity-manager-app.c"
				}
#line 172 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
				_tmp49_ = has_srv;
#line 172 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
				if (_tmp49_) {
#line 1264 "moonshot-identity-manager-app.c"
					IdCard* _tmp50_ = NULL;
					GeeArrayList* _tmp51_ = NULL;
					GeeArrayList* _tmp52_ = NULL;
					IdentityRequest* _tmp53_ = NULL;
					const gchar* _tmp54_ = NULL;
					gboolean _tmp55_ = FALSE;
#line 174 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
					_tmp50_ = id;
#line 174 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
					_tmp51_ = id_card_get_services (_tmp50_);
#line 174 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
					_tmp52_ = _tmp51_;
#line 174 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
					_tmp53_ = _data1_->request;
#line 174 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
					_tmp54_ = _tmp53_->service;
#line 174 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
					_tmp55_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp52_, _tmp54_);
#line 174 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
					if (_tmp55_) {
#line 1285 "moonshot-identity-manager-app.c"
						MoonshotLogger* _tmp56_ = NULL;
						IdentityRequest* _tmp57_ = NULL;
						const gchar* _tmp58_ = NULL;
						const gchar* _tmp59_ = NULL;
						IdCard* _tmp60_ = NULL;
						const gchar* _tmp61_ = NULL;
						const gchar* _tmp62_ = NULL;
						const gchar* _tmp63_ = NULL;
						gchar* _tmp64_ = NULL;
						gchar* _tmp65_ = NULL;
						IdentityRequest* _tmp66_ = NULL;
						IdCard* _tmp67_ = NULL;
						IdCard* _tmp68_ = NULL;
#line 175 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
						_tmp56_ = identity_manager_app_logger;
#line 175 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
						_tmp57_ = _data1_->request;
#line 175 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
						_tmp58_ = _tmp57_->service;
#line 175 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
						_tmp59_ = string_to_string (_tmp58_);
#line 175 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
						_tmp60_ = id;
#line 175 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
						_tmp61_ = id_card_get_display_name (_tmp60_);
#line 175 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
						_tmp62_ = _tmp61_;
#line 175 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
						_tmp63_ = string_to_string (_tmp62_);
#line 175 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
						_tmp64_ = g_strconcat ("select_identity: request has service '", _tmp59_, "; matched on '", _tmp63_, "'", NULL);
#line 175 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
						_tmp65_ = _tmp64_;
#line 175 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
						moonshot_logger_trace (_tmp56_, _tmp65_, NULL);
#line 175 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
						_g_free0 (_tmp65_);
#line 176 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
						_tmp66_ = _data1_->request;
#line 176 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
						_tmp67_ = id;
#line 176 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
						_tmp68_ = _g_object_ref0 (_tmp67_);
#line 176 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
						_tmp66_->candidates = g_slist_append (_tmp66_->candidates, _tmp68_);
#line 1331 "moonshot-identity-manager-app.c"
					}
				}
#line 161 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
				_g_object_unref0 (id);
#line 1336 "moonshot-identity-manager-app.c"
			}
#line 161 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_g_object_unref0 (_id_list);
#line 1340 "moonshot-identity-manager-app.c"
		}
#line 182 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp71_ = _data1_->identity;
#line 182 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		if (_tmp71_ == NULL) {
#line 1346 "moonshot-identity-manager-app.c"
			gboolean _tmp72_ = FALSE;
#line 182 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp72_ = has_srv;
#line 182 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp70_ = _tmp72_;
#line 1352 "moonshot-identity-manager-app.c"
		} else {
#line 182 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp70_ = FALSE;
#line 1356 "moonshot-identity-manager-app.c"
		}
#line 182 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		if (_tmp70_) {
#line 1360 "moonshot-identity-manager-app.c"
			IdentityRequest* _tmp73_ = NULL;
			GSList* _tmp74_ = NULL;
			guint _tmp75_ = 0U;
#line 182 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp73_ = _data1_->request;
#line 182 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp74_ = _tmp73_->candidates;
#line 182 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp75_ = g_slist_length (_tmp74_);
#line 182 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp69_ = _tmp75_ > ((guint) 1);
#line 1372 "moonshot-identity-manager-app.c"
		} else {
#line 182 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp69_ = FALSE;
#line 1376 "moonshot-identity-manager-app.c"
		}
#line 182 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		if (_tmp69_) {
#line 1380 "moonshot-identity-manager-app.c"
			MoonshotLogger* _tmp76_ = NULL;
			IdentityRequest* _tmp77_ = NULL;
			const gchar* _tmp78_ = NULL;
			const gchar* _tmp79_ = NULL;
			gchar* _tmp80_ = NULL;
			gchar* _tmp81_ = NULL;
			IdentityRequest* _tmp82_ = NULL;
			GSList* _tmp83_ = NULL;
#line 184 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp76_ = identity_manager_app_logger;
#line 184 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp77_ = _data1_->request;
#line 184 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp78_ = _tmp77_->service;
#line 184 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp79_ = string_to_string (_tmp78_);
#line 184 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp80_ = g_strconcat ("select_identity: multiple candidates; removing service '", _tmp79_, " from all.", NULL);
#line 184 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp81_ = _tmp80_;
#line 184 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			moonshot_logger_trace (_tmp76_, _tmp81_, NULL);
#line 184 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_g_free0 (_tmp81_);
#line 185 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp82_ = _data1_->request;
#line 185 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp83_ = _tmp82_->candidates;
#line 1409 "moonshot-identity-manager-app.c"
			{
				GSList* id_collection = NULL;
				GSList* id_it = NULL;
#line 185 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
				id_collection = _tmp83_;
#line 185 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
				for (id_it = id_collection; id_it != NULL; id_it = id_it->next) {
#line 1417 "moonshot-identity-manager-app.c"
					IdCard* _tmp84_ = NULL;
					IdCard* id = NULL;
#line 185 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
					_tmp84_ = _g_object_ref0 ((IdCard*) id_it->data);
#line 185 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
					id = _tmp84_;
#line 1424 "moonshot-identity-manager-app.c"
					{
						IdCard* _tmp85_ = NULL;
						GeeArrayList* _tmp86_ = NULL;
						GeeArrayList* _tmp87_ = NULL;
						IdentityRequest* _tmp88_ = NULL;
						const gchar* _tmp89_ = NULL;
#line 187 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
						_tmp85_ = id;
#line 187 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
						_tmp86_ = id_card_get_services (_tmp85_);
#line 187 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
						_tmp87_ = _tmp86_;
#line 187 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
						_tmp88_ = _data1_->request;
#line 187 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
						_tmp89_ = _tmp88_->service;
#line 187 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
						gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp87_, _tmp89_);
#line 185 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
						_g_object_unref0 (id);
#line 1445 "moonshot-identity-manager-app.c"
					}
				}
			}
		}
#line 192 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp91_ = _data1_->identity;
#line 192 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		if (_tmp91_ == NULL) {
#line 1454 "moonshot-identity-manager-app.c"
			IdentityRequest* _tmp92_ = NULL;
			GSList* _tmp93_ = NULL;
			guint _tmp94_ = 0U;
#line 192 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp92_ = _data1_->request;
#line 192 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp93_ = _tmp92_->candidates;
#line 192 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp94_ = g_slist_length (_tmp93_);
#line 192 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp90_ = _tmp94_ == ((guint) 0);
#line 1466 "moonshot-identity-manager-app.c"
		} else {
#line 192 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp90_ = FALSE;
#line 1470 "moonshot-identity-manager-app.c"
		}
#line 192 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		if (_tmp90_) {
#line 1474 "moonshot-identity-manager-app.c"
			MoonshotLogger* _tmp95_ = NULL;
#line 194 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp95_ = identity_manager_app_logger;
#line 194 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			moonshot_logger_trace (_tmp95_, "select_identity: No candidates; using service matching rules.", NULL);
#line 1480 "moonshot-identity-manager-app.c"
			{
				GeeLinkedList* _id_list = NULL;
				IdentityManagerModel* _tmp96_ = NULL;
				GeeLinkedList* _tmp97_ = NULL;
				gint _id_size = 0;
				GeeLinkedList* _tmp98_ = NULL;
				gint _tmp99_ = 0;
				gint _tmp100_ = 0;
				gint _id_index = 0;
#line 195 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
				_tmp96_ = self->model;
#line 195 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
				_tmp97_ = identity_manager_model_get_card_list (_tmp96_);
#line 195 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
				_id_list = _tmp97_;
#line 195 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
				_tmp98_ = _id_list;
#line 195 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
				_tmp99_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp98_);
#line 195 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
				_tmp100_ = _tmp99_;
#line 195 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
				_id_size = _tmp100_;
#line 195 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
				_id_index = -1;
#line 195 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
				while (TRUE) {
#line 1508 "moonshot-identity-manager-app.c"
					gint _tmp101_ = 0;
					gint _tmp102_ = 0;
					gint _tmp103_ = 0;
					IdCard* id = NULL;
					GeeLinkedList* _tmp104_ = NULL;
					gint _tmp105_ = 0;
					gpointer _tmp106_ = NULL;
					IdCard* _tmp107_ = NULL;
					Rule* _tmp108_ = NULL;
					gint _tmp108__length1 = 0;
					Rule* _tmp109_ = NULL;
					gint _tmp109__length1 = 0;
#line 195 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
					_tmp101_ = _id_index;
#line 195 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
					_id_index = _tmp101_ + 1;
#line 195 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
					_tmp102_ = _id_index;
#line 195 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
					_tmp103_ = _id_size;
#line 195 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
					if (!(_tmp102_ < _tmp103_)) {
#line 195 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
						break;
#line 1533 "moonshot-identity-manager-app.c"
					}
#line 195 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
					_tmp104_ = _id_list;
#line 195 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
					_tmp105_ = _id_index;
#line 195 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
					_tmp106_ = gee_abstract_list_get ((GeeAbstractList*) _tmp104_, _tmp105_);
#line 195 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
					id = (IdCard*) _tmp106_;
#line 197 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
					_tmp107_ = id;
#line 197 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
					_tmp108_ = id_card_get_rules (_tmp107_, &_tmp108__length1);
#line 197 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
					_tmp109_ = _tmp108_;
#line 197 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
					_tmp109__length1 = _tmp108__length1;
#line 1551 "moonshot-identity-manager-app.c"
					{
						Rule* rule_collection = NULL;
						gint rule_collection_length1 = 0;
						gint _rule_collection_size_ = 0;
						gint rule_it = 0;
#line 197 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
						rule_collection = _tmp109_;
#line 197 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
						rule_collection_length1 = _tmp109__length1;
#line 197 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
						for (rule_it = 0; rule_it < _tmp109__length1; rule_it = rule_it + 1) {
#line 1563 "moonshot-identity-manager-app.c"
							Rule _tmp110_ = {0};
							Rule rule = {0};
#line 197 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
							rule_copy (&rule_collection[rule_it], &_tmp110_);
#line 197 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
							rule = _tmp110_;
#line 1570 "moonshot-identity-manager-app.c"
							{
								IdentityRequest* _tmp111_ = NULL;
								const gchar* _tmp112_ = NULL;
								Rule _tmp113_ = {0};
								const gchar* _tmp114_ = NULL;
								gboolean _tmp115_ = FALSE;
								MoonshotLogger* _tmp116_ = NULL;
								IdCard* _tmp117_ = NULL;
								const gchar* _tmp118_ = NULL;
								const gchar* _tmp119_ = NULL;
								const gchar* _tmp120_ = NULL;
								gchar* _tmp121_ = NULL;
								gchar* _tmp122_ = NULL;
								IdentityRequest* _tmp123_ = NULL;
								IdCard* _tmp124_ = NULL;
								IdCard* _tmp125_ = NULL;
								Rule _tmp126_ = {0};
								const gchar* _tmp127_ = NULL;
#line 199 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
								_tmp111_ = _data1_->request;
#line 199 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
								_tmp112_ = _tmp111_->service;
#line 199 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
								_tmp113_ = rule;
#line 199 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
								_tmp114_ = _tmp113_.pattern;
#line 199 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
								_tmp115_ = identity_manager_app_match_service_pattern (self, _tmp112_, _tmp114_);
#line 199 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
								if (!_tmp115_) {
#line 200 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
									rule_destroy (&rule);
#line 200 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
									continue;
#line 1605 "moonshot-identity-manager-app.c"
								}
#line 202 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
								_tmp116_ = identity_manager_app_logger;
#line 202 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
								_tmp117_ = id;
#line 202 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
								_tmp118_ = id_card_get_display_name (_tmp117_);
#line 202 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
								_tmp119_ = _tmp118_;
#line 202 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
								_tmp120_ = string_to_string (_tmp119_);
#line 202 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
								_tmp121_ = g_strconcat ("select_identity: ID ", _tmp120_, " matched on service matching rules.", NULL);
#line 202 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
								_tmp122_ = _tmp121_;
#line 202 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
								moonshot_logger_trace (_tmp116_, _tmp122_, NULL);
#line 202 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
								_g_free0 (_tmp122_);
#line 203 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
								_tmp123_ = _data1_->request;
#line 203 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
								_tmp124_ = id;
#line 203 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
								_tmp125_ = _g_object_ref0 (_tmp124_);
#line 203 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
								_tmp123_->candidates = g_slist_append (_tmp123_->candidates, _tmp125_);
#line 205 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
								_tmp126_ = rule;
#line 205 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
								_tmp127_ = _tmp126_.always_confirm;
#line 205 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
								if (g_strcmp0 (_tmp127_, "true") == 0) {
#line 206 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
									confirm = TRUE;
#line 1641 "moonshot-identity-manager-app.c"
								}
#line 197 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
								rule_destroy (&rule);
#line 1645 "moonshot-identity-manager-app.c"
							}
						}
					}
#line 195 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
					_g_object_unref0 (id);
#line 1651 "moonshot-identity-manager-app.c"
				}
#line 195 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
				_g_object_unref0 (_id_list);
#line 1655 "moonshot-identity-manager-app.c"
			}
		}
#line 211 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp129_ = _data1_->identity;
#line 211 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		if (_tmp129_ == NULL) {
#line 1662 "moonshot-identity-manager-app.c"
			gboolean _tmp130_ = FALSE;
#line 211 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp130_ = has_nai;
#line 211 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp128_ = _tmp130_;
#line 1668 "moonshot-identity-manager-app.c"
		} else {
#line 211 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp128_ = FALSE;
#line 1672 "moonshot-identity-manager-app.c"
		}
#line 211 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		if (_tmp128_) {
#line 1676 "moonshot-identity-manager-app.c"
			MoonshotLogger* _tmp131_ = NULL;
			gchar** components = NULL;
			IdentityRequest* _tmp132_ = NULL;
			const gchar* _tmp133_ = NULL;
			gchar** _tmp134_ = NULL;
			gchar** _tmp135_ = NULL;
			gint components_length1 = 0;
			gint _components_size_ = 0;
			IdCard* _tmp136_ = NULL;
			IdCard* _tmp137_ = NULL;
			IdentityRequest* _tmp138_ = NULL;
			const gchar* _tmp139_ = NULL;
			IdCard* _tmp140_ = NULL;
			gchar** _tmp141_ = NULL;
			gint _tmp141__length1 = 0;
			const gchar* _tmp142_ = NULL;
			gchar** _tmp143_ = NULL;
			gint _tmp143__length1 = 0;
			IdCard* _tmp147_ = NULL;
			IdentityRequest* _tmp148_ = NULL;
			const gchar* _tmp149_ = NULL;
			IdCard* _tmp150_ = NULL;
#line 212 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp131_ = identity_manager_app_logger;
#line 212 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			moonshot_logger_trace (_tmp131_, "select_identity: Creating temp identity", NULL);
#line 214 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp132_ = _data1_->request;
#line 214 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp133_ = _tmp132_->nai;
#line 214 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp135_ = _tmp134_ = g_strsplit (_tmp133_, "@", 2);
#line 214 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			components = _tmp135_;
#line 214 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			components_length1 = _vala_array_length (_tmp134_);
#line 214 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_components_size_ = components_length1;
#line 215 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp136_ = id_card_new ();
#line 215 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_g_object_unref0 (_data1_->identity);
#line 215 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_data1_->identity = _tmp136_;
#line 216 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp137_ = _data1_->identity;
#line 216 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp138_ = _data1_->request;
#line 216 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp139_ = _tmp138_->nai;
#line 216 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			id_card_set_display_name (_tmp137_, _tmp139_);
#line 217 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp140_ = _data1_->identity;
#line 217 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp141_ = components;
#line 217 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp141__length1 = components_length1;
#line 217 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp142_ = _tmp141_[0];
#line 217 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			id_card_set_username (_tmp140_, _tmp142_);
#line 218 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp143_ = components;
#line 218 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp143__length1 = components_length1;
#line 218 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			if (_tmp143__length1 > 1) {
#line 1745 "moonshot-identity-manager-app.c"
				IdCard* _tmp144_ = NULL;
				gchar** _tmp145_ = NULL;
				gint _tmp145__length1 = 0;
				const gchar* _tmp146_ = NULL;
#line 219 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
				_tmp144_ = _data1_->identity;
#line 219 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
				_tmp145_ = components;
#line 219 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
				_tmp145__length1 = components_length1;
#line 219 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
				_tmp146_ = _tmp145_[1];
#line 219 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
				id_card_set_issuer (_tmp144_, _tmp146_);
#line 1760 "moonshot-identity-manager-app.c"
			}
#line 220 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp147_ = _data1_->identity;
#line 220 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp148_ = _data1_->request;
#line 220 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp149_ = _tmp148_->password;
#line 220 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			id_card_set_password (_tmp147_, _tmp149_);
#line 221 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp150_ = _data1_->identity;
#line 221 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			id_card_set_temporary (_tmp150_, TRUE);
#line 211 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			components = (_vala_array_free (components, components_length1, (GDestroyNotify) g_free), NULL);
#line 1776 "moonshot-identity-manager-app.c"
		}
#line 223 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp151_ = _data1_->identity;
#line 223 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		if (_tmp151_ == NULL) {
#line 1782 "moonshot-identity-manager-app.c"
			IdentityRequest* _tmp152_ = NULL;
			GSList* _tmp153_ = NULL;
			guint _tmp154_ = 0U;
#line 224 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp152_ = _data1_->request;
#line 224 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp153_ = _tmp152_->candidates;
#line 224 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp154_ = g_slist_length (_tmp153_);
#line 224 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			if (_tmp154_ != ((guint) 1)) {
#line 1794 "moonshot-identity-manager-app.c"
				MoonshotLogger* _tmp155_ = NULL;
				IdentityRequest* _tmp156_ = NULL;
				GSList* _tmp157_ = NULL;
				guint _tmp158_ = 0U;
				gchar* _tmp159_ = NULL;
				gchar* _tmp160_ = NULL;
#line 225 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
				_tmp155_ = identity_manager_app_logger;
#line 225 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
				_tmp156_ = _data1_->request;
#line 225 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
				_tmp157_ = _tmp156_->candidates;
#line 225 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
				_tmp158_ = g_slist_length (_tmp157_);
#line 225 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
				_tmp159_ = g_strdup_printf ("select_identity: Have %u candidates; user must make selection.", _tmp158_);
#line 225 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
				_tmp160_ = _tmp159_;
#line 225 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
				moonshot_logger_trace (_tmp155_, _tmp160_, NULL);
#line 225 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
				_g_free0 (_tmp160_);
#line 226 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
				confirm = TRUE;
#line 1819 "moonshot-identity-manager-app.c"
			} else {
				IdentityRequest* _tmp161_ = NULL;
				GSList* _tmp162_ = NULL;
				gconstpointer _tmp163_ = NULL;
				IdCard* _tmp164_ = NULL;
#line 228 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
				_tmp161_ = _data1_->request;
#line 228 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
				_tmp162_ = _tmp161_->candidates;
#line 228 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
				_tmp163_ = g_slist_nth_data (_tmp162_, (guint) 0);
#line 228 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
				_tmp164_ = _g_object_ref0 ((IdCard*) _tmp163_);
#line 228 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
				_g_object_unref0 (_data1_->identity);
#line 228 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
				_data1_->identity = _tmp164_;
#line 1837 "moonshot-identity-manager-app.c"
			}
		}
#line 232 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp166_ = confirm;
#line 232 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		if (_tmp166_) {
#line 1844 "moonshot-identity-manager-app.c"
			IdentityManagerView* _tmp167_ = NULL;
#line 232 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp167_ = self->view;
#line 232 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp165_ = _tmp167_ != NULL;
#line 1850 "moonshot-identity-manager-app.c"
		} else {
#line 232 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp165_ = FALSE;
#line 1854 "moonshot-identity-manager-app.c"
		}
#line 232 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		if (_tmp165_) {
#line 1858 "moonshot-identity-manager-app.c"
			gboolean _tmp168_ = FALSE;
			IdentityManagerView* _tmp169_ = NULL;
			IdentityRequest* _tmp170_ = NULL;
#line 234 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp168_ = self->explicitly_launched;
#line 234 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			if (!_tmp168_) {
#line 235 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
				identity_manager_app_show (self);
#line 1868 "moonshot-identity-manager-app.c"
			}
#line 236 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp169_ = self->view;
#line 236 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp170_ = _data1_->request;
#line 236 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			identity_manager_view_queue_identity_request (_tmp169_, _tmp170_);
#line 237 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			block1_data_unref (_data1_);
#line 237 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_data1_ = NULL;
#line 237 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			return;
#line 1882 "moonshot-identity-manager-app.c"
		}
	}
#line 242 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda5__gsource_func, block1_data_ref (_data1_), block1_data_unref);
#line 256 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	block1_data_unref (_data1_);
#line 256 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_data1_ = NULL;
#line 256 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	return;
#line 1893 "moonshot-identity-manager-app.c"
}


static gboolean identity_manager_app_match_service_pattern (IdentityManagerApp* self, const gchar* service, const gchar* pattern) {
	gboolean result = FALSE;
	GPatternSpec* pspec = NULL;
	const gchar* _tmp0_ = NULL;
	GPatternSpec* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
#line 259 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 259 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	g_return_val_if_fail (service != NULL, FALSE);
#line 259 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	g_return_val_if_fail (pattern != NULL, FALSE);
#line 260 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_tmp0_ = pattern;
#line 260 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_tmp1_ = g_pattern_spec_new (_tmp0_);
#line 260 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	pspec = _tmp1_;
#line 261 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_tmp2_ = service;
#line 261 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_tmp3_ = g_pattern_match_string (pspec, _tmp2_);
#line 261 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	result = _tmp3_;
#line 261 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_g_pattern_spec_free0 (pspec);
#line 261 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	return result;
#line 1926 "moonshot-identity-manager-app.c"
}


static void _identity_manager_app_bus_acquired_cb_gbus_acquired_callback (GDBusConnection* connection, const gchar* name, gpointer self) {
#line 328 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	identity_manager_app_bus_acquired_cb ((IdentityManagerApp*) self, connection);
#line 1933 "moonshot-identity-manager-app.c"
}


static void ___lambda23_ (IdentityManagerApp* self, GDBusConnection* conn, const gchar* name) {
	const gchar* _tmp0_ = NULL;
	GDBusConnection* _tmp1_ = NULL;
	MoonshotLogger* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
#line 332 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	g_return_if_fail (conn != NULL);
#line 332 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	g_return_if_fail (name != NULL);
#line 332 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_tmp1_ = conn;
#line 332 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	if (_tmp1_ == NULL) {
#line 332 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp0_ = "null";
#line 1953 "moonshot-identity-manager-app.c"
	} else {
#line 332 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp0_ = "non-null";
#line 1957 "moonshot-identity-manager-app.c"
	}
#line 332 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_tmp2_ = identity_manager_app_logger;
#line 332 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_tmp3_ = g_strconcat ("init_ipc_server: name_acquired_closure; conn=", _tmp0_, NULL);
#line 332 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_tmp4_ = _tmp3_;
#line 332 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	moonshot_logger_trace (_tmp2_, _tmp4_, NULL);
#line 332 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_g_free0 (_tmp4_);
#line 1969 "moonshot-identity-manager-app.c"
}


static void ____lambda23__gbus_name_acquired_callback (GDBusConnection* connection, const gchar* name, gpointer self) {
#line 328 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	___lambda23_ ((IdentityManagerApp*) self, connection, name);
#line 1976 "moonshot-identity-manager-app.c"
}


static void ___lambda24_ (IdentityManagerApp* self, GDBusConnection* conn, const gchar* name) {
	const gchar* _tmp0_ = NULL;
	GDBusConnection* _tmp1_ = NULL;
	MoonshotLogger* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gboolean shown = FALSE;
	gboolean _tmp11_ = FALSE;
	GError * _inner_error_ = NULL;
#line 333 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	g_return_if_fail (conn != NULL);
#line 333 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	g_return_if_fail (name != NULL);
#line 334 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_tmp1_ = conn;
#line 334 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	if (_tmp1_ == NULL) {
#line 334 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp0_ = "null";
#line 1999 "moonshot-identity-manager-app.c"
	} else {
#line 334 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp0_ = "non-null";
#line 2003 "moonshot-identity-manager-app.c"
	}
#line 334 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_tmp2_ = identity_manager_app_logger;
#line 334 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_tmp3_ = g_strconcat ("init_ipc_server: name_lost_closure; conn=", _tmp0_, NULL);
#line 334 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_tmp4_ = _tmp3_;
#line 334 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	moonshot_logger_trace (_tmp2_, _tmp4_, NULL);
#line 334 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_g_free0 (_tmp4_);
#line 335 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	shown = FALSE;
#line 2017 "moonshot-identity-manager-app.c"
	{
		IIdentityManager* manager = NULL;
		const gchar* _tmp5_ = NULL;
		IIdentityManager* _tmp6_ = NULL;
		gboolean _tmp7_ = FALSE;
		IIdentityManager* _tmp8_ = NULL;
		gboolean _tmp9_ = FALSE;
#line 337 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp5_ = name;
#line 337 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp6_ = g_initable_new (TYPE_IIDENTITY_MANAGER_PROXY, NULL, &_inner_error_, "g-flags", 0, "g-name", _tmp5_, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", "/org/janet/moonshot", "g-interface-name", "org.janet.Moonshot", "g-interface-info", g_type_get_qdata (TYPE_IIDENTITY_MANAGER, g_quark_from_static_string ("vala-dbus-interface-info")), NULL);
#line 337 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		manager = (IIdentityManager*) _tmp6_;
#line 337 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 337 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			if (_inner_error_->domain == G_IO_ERROR) {
#line 2035 "moonshot-identity-manager-app.c"
				goto __catch1_g_io_error;
			}
#line 337 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 337 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			g_clear_error (&_inner_error_);
#line 337 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			return;
#line 2044 "moonshot-identity-manager-app.c"
		}
#line 338 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp8_ = manager;
#line 338 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp9_ = iidentity_manager_show_ui (_tmp8_, &_inner_error_);
#line 338 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp7_ = _tmp9_;
#line 338 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 338 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_g_object_unref0 (manager);
#line 338 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			if (_inner_error_->domain == G_IO_ERROR) {
#line 2058 "moonshot-identity-manager-app.c"
				goto __catch1_g_io_error;
			}
#line 338 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_g_object_unref0 (manager);
#line 338 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 338 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			g_clear_error (&_inner_error_);
#line 338 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			return;
#line 2069 "moonshot-identity-manager-app.c"
		}
#line 338 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		shown = _tmp7_;
#line 336 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_g_object_unref0 (manager);
#line 2075 "moonshot-identity-manager-app.c"
	}
	goto __finally1;
	__catch1_g_io_error:
	{
		GError* e = NULL;
		MoonshotLogger* _tmp10_ = NULL;
#line 336 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		e = _inner_error_;
#line 336 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_inner_error_ = NULL;
#line 340 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp10_ = identity_manager_app_logger;
#line 340 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		moonshot_logger_error (_tmp10_, "init_ipc_server.name_lost_closure: Caught error: ", NULL);
#line 336 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_g_error_free0 (e);
#line 2092 "moonshot-identity-manager-app.c"
	}
	__finally1:
#line 336 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 336 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 336 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		g_clear_error (&_inner_error_);
#line 336 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		return;
#line 2103 "moonshot-identity-manager-app.c"
	}
#line 342 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_tmp11_ = shown;
#line 342 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	if (!_tmp11_) {
#line 2109 "moonshot-identity-manager-app.c"
		MoonshotLogger* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		const gchar* _tmp16_ = NULL;
#line 343 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp12_ = identity_manager_app_logger;
#line 343 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp13_ = name;
#line 343 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp14_ = g_strdup_printf ("init_ipc_server.name_lost_closure: Couldn't own name %s on dbus or sho" \
"w previously launched identity manager", _tmp13_);
#line 343 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp15_ = _tmp14_;
#line 343 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		moonshot_logger_error (_tmp12_, _tmp15_, NULL);
#line 343 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_g_free0 (_tmp15_);
#line 344 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp16_ = name;
#line 344 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		g_error ("moonshot-identity-manager-app.vala:344: Couldn't own name %s on dbus o" \
"r show previously launched identity manager.", _tmp16_);
#line 2131 "moonshot-identity-manager-app.c"
	} else {
		MoonshotLogger* _tmp17_ = NULL;
		FILE* _tmp18_ = NULL;
#line 346 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp17_ = identity_manager_app_logger;
#line 346 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		moonshot_logger_trace (_tmp17_, "init_ipc_server.name_lost_closure: Showed previously launched identity" \
" manager.", NULL);
#line 347 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp18_ = stdout;
#line 347 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		fprintf (_tmp18_, "Showed previously launched identity manager.\n");
#line 348 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		exit (0);
#line 2145 "moonshot-identity-manager-app.c"
	}
}


static void ____lambda24__gbus_name_lost_callback (GDBusConnection* connection, const gchar* name, gpointer self) {
#line 328 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	___lambda24_ ((IdentityManagerApp*) self, connection, name);
#line 2153 "moonshot-identity-manager-app.c"
}


static void identity_manager_app_bus_acquired_cb (IdentityManagerApp* self, GDBusConnection* conn) {
	MoonshotLogger* _tmp0_ = NULL;
	GError * _inner_error_ = NULL;
#line 319 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	g_return_if_fail (self != NULL);
#line 319 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	g_return_if_fail (conn != NULL);
#line 320 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_tmp0_ = identity_manager_app_logger;
#line 320 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	moonshot_logger_trace (_tmp0_, "bus_acquired_cb", NULL);
#line 2168 "moonshot-identity-manager-app.c"
	{
		GDBusConnection* _tmp1_ = NULL;
		MoonshotServer* _tmp2_ = NULL;
#line 322 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp1_ = conn;
#line 322 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp2_ = self->priv->ipc_server;
#line 322 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		moonshot_server_register_object (_tmp2_, _tmp1_, "/org/janet/moonshot", &_inner_error_);
#line 322 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2180 "moonshot-identity-manager-app.c"
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		MoonshotServer* _tmp3_ = NULL;
		MoonshotLogger* _tmp4_ = NULL;
#line 321 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		e = _inner_error_;
#line 321 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_inner_error_ = NULL;
#line 326 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp3_ = moonshot_server_new (self);
#line 326 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_g_object_unref0 (self->priv->ipc_server);
#line 326 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		self->priv->ipc_server = _tmp3_;
#line 327 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp4_ = identity_manager_app_logger;
#line 327 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		moonshot_logger_trace (_tmp4_, "init_ipc_server: Constructed new MoonshotServer", NULL);
#line 328 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		g_bus_own_name_with_closures (G_BUS_TYPE_SESSION, "org.janet.Moonshot", G_BUS_NAME_OWNER_FLAGS_NONE, (GClosure*) ((_identity_manager_app_bus_acquired_cb_gbus_acquired_callback == NULL) ? NULL : g_cclosure_new ((GCallback) _identity_manager_app_bus_acquired_cb_gbus_acquired_callback, identity_manager_app_ref (self), (GClosureNotify) identity_manager_app_unref)), (GClosure*) ((____lambda23__gbus_name_acquired_callback == NULL) ? NULL : g_cclosure_new ((GCallback) ____lambda23__gbus_name_acquired_callback, identity_manager_app_ref (self), (GClosureNotify) identity_manager_app_unref)), (GClosure*) ((____lambda24__gbus_name_lost_callback == NULL) ? NULL : g_cclosure_new ((GCallback) ____lambda24__gbus_name_lost_callback, identity_manager_app_ref (self), (GClosureNotify) identity_manager_app_unref)));
#line 321 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_g_error_free0 (e);
#line 2208 "moonshot-identity-manager-app.c"
	}
	__finally0:
#line 321 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 321 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 321 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		g_clear_error (&_inner_error_);
#line 321 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		return;
#line 2219 "moonshot-identity-manager-app.c"
	}
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
#line 354 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	g_atomic_int_inc (&_data2_->_ref_count_);
#line 354 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	return _data2_;
#line 2229 "moonshot-identity-manager-app.c"
}


static void block2_data_unref (void * _userdata_) {
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
#line 354 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
#line 2238 "moonshot-identity-manager-app.c"
		IdentityManagerApp* self;
#line 354 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		self = _data2_->self;
#line 354 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_g_free0 (_data2_->our_name);
#line 354 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_identity_manager_app_unref0 (self);
#line 354 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		g_slice_free (Block2Data, _data2_);
#line 2248 "moonshot-identity-manager-app.c"
	}
}


static gchar* bool_to_string (gboolean self) {
	gchar* result = NULL;
#line 37 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	if (self) {
#line 2257 "moonshot-identity-manager-app.c"
		gchar* _tmp0_ = NULL;
#line 38 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp0_ = g_strdup ("true");
#line 38 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		result = _tmp0_;
#line 38 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		return result;
#line 2265 "moonshot-identity-manager-app.c"
	} else {
		gchar* _tmp1_ = NULL;
#line 40 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp1_ = g_strdup ("false");
#line 40 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		result = _tmp1_;
#line 40 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		return result;
#line 2274 "moonshot-identity-manager-app.c"
	}
}


static void __lambda25_ (Block2Data* _data2_, GDBusConnection* conn, const gchar* name) {
	IdentityManagerApp* self;
	gchar* _tmp0_ = NULL;
	GDBusConnection* _tmp1_ = NULL;
	MoonshotLogger* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	gboolean _tmp15_ = FALSE;
#line 364 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	self = _data2_->self;
#line 364 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	g_return_if_fail (conn != NULL);
#line 364 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	g_return_if_fail (name != NULL);
#line 366 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_tmp1_ = conn;
#line 366 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	if (_tmp1_ == NULL) {
#line 2302 "moonshot-identity-manager-app.c"
		gchar* _tmp2_ = NULL;
#line 366 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp2_ = g_strdup ("null");
#line 366 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_g_free0 (_tmp0_);
#line 366 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp0_ = _tmp2_;
#line 2310 "moonshot-identity-manager-app.c"
	} else {
		const gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
#line 366 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp3_ = name;
#line 366 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp4_ = g_strconcat ("non-null; name='", _tmp3_, NULL);
#line 366 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp5_ = _tmp4_;
#line 366 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp6_ = g_strconcat (_tmp5_, "'", NULL);
#line 366 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_g_free0 (_tmp0_);
#line 366 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp0_ = _tmp6_;
#line 366 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_g_free0 (_tmp5_);
#line 2330 "moonshot-identity-manager-app.c"
	}
#line 365 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_tmp7_ = identity_manager_app_logger;
#line 365 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_tmp8_ = self->priv->show_requested;
#line 365 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_tmp9_ = bool_to_string (_tmp8_);
#line 365 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_tmp10_ = _tmp9_;
#line 365 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_tmp11_ = g_strconcat ("init_ipc_server: name_acquired_closure; show_requested=", _tmp10_, "; conn=", NULL);
#line 365 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_tmp12_ = _tmp11_;
#line 365 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_tmp13_ = g_strconcat (_tmp12_, _tmp0_, NULL);
#line 365 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_tmp14_ = _tmp13_;
#line 365 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	moonshot_logger_trace (_tmp7_, _tmp14_, NULL);
#line 365 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_g_free0 (_tmp14_);
#line 365 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_g_free0 (_tmp12_);
#line 365 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_g_free0 (_tmp10_);
#line 368 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	self->priv->name_is_owned = TRUE;
#line 371 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_tmp15_ = self->priv->show_requested;
#line 371 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	if (_tmp15_) {
#line 372 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		identity_manager_app_show (self);
#line 373 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		self->priv->show_requested = FALSE;
#line 2366 "moonshot-identity-manager-app.c"
	}
#line 375 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_data2_->shown = TRUE;
#line 364 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_g_free0 (_tmp0_);
#line 2372 "moonshot-identity-manager-app.c"
}


static void ___lambda25__gbus_name_acquired_callback (GDBusConnection* connection, const gchar* name, gpointer self) {
#line 358 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	__lambda25_ (self, connection, name);
#line 2379 "moonshot-identity-manager-app.c"
}


static void __lambda26_ (Block2Data* _data2_) {
	IdentityManagerApp* self;
	MoonshotLogger* _tmp0_ = NULL;
	GError * _inner_error_ = NULL;
#line 379 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	self = _data2_->self;
#line 380 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_tmp0_ = identity_manager_app_logger;
#line 380 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	moonshot_logger_trace (_tmp0_, "init_ipc_server: name_lost_closure", NULL);
#line 386 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	self->priv->name_is_owned = FALSE;
#line 387 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	self->priv->show_requested = FALSE;
#line 2397 "moonshot-identity-manager-app.c"
	{
#line 390 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		if (!_data2_->shown) {
#line 2401 "moonshot-identity-manager-app.c"
			IIdentityManager* manager = NULL;
			IIdentityManager* _tmp1_ = NULL;
			gboolean _tmp2_ = FALSE;
			IIdentityManager* _tmp3_ = NULL;
			gboolean _tmp4_ = FALSE;
#line 391 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp1_ = g_initable_new (TYPE_IIDENTITY_MANAGER_PROXY, NULL, &_inner_error_, "g-flags", 0, "g-name", _data2_->our_name, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", "/org/janet/moonshot", "g-interface-name", "org.janet.Moonshot", "g-interface-info", g_type_get_qdata (TYPE_IIDENTITY_MANAGER, g_quark_from_static_string ("vala-dbus-interface-info")), NULL);
#line 391 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			manager = (IIdentityManager*) _tmp1_;
#line 391 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 391 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
				if (_inner_error_->domain == G_IO_ERROR) {
#line 2415 "moonshot-identity-manager-app.c"
					goto __catch2_g_io_error;
				}
#line 391 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 391 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
				g_clear_error (&_inner_error_);
#line 391 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
				return;
#line 2424 "moonshot-identity-manager-app.c"
			}
#line 392 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp3_ = manager;
#line 392 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp4_ = iidentity_manager_show_ui (_tmp3_, &_inner_error_);
#line 392 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp2_ = _tmp4_;
#line 392 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 392 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
				_g_object_unref0 (manager);
#line 392 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
				if (_inner_error_->domain == G_IO_ERROR) {
#line 2438 "moonshot-identity-manager-app.c"
					goto __catch2_g_io_error;
				}
#line 392 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
				_g_object_unref0 (manager);
#line 392 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 392 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
				g_clear_error (&_inner_error_);
#line 392 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
				return;
#line 2449 "moonshot-identity-manager-app.c"
			}
#line 392 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_data2_->shown = _tmp2_;
#line 390 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_g_object_unref0 (manager);
#line 2455 "moonshot-identity-manager-app.c"
		}
	}
	goto __finally2;
	__catch2_g_io_error:
	{
		GError* e = NULL;
		MoonshotLogger* _tmp5_ = NULL;
		GError* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
#line 389 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		e = _inner_error_;
#line 389 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_inner_error_ = NULL;
#line 395 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp5_ = identity_manager_app_logger;
#line 395 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp6_ = e;
#line 395 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp7_ = _tmp6_->message;
#line 395 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp8_ = g_strconcat ("init_ipc_server.name_lost_closure: Caught IOError: ", _tmp7_, NULL);
#line 395 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp9_ = _tmp8_;
#line 395 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		moonshot_logger_error (_tmp5_, _tmp9_, NULL);
#line 395 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_g_free0 (_tmp9_);
#line 389 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_g_error_free0 (e);
#line 2487 "moonshot-identity-manager-app.c"
	}
	__finally2:
#line 389 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 389 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 389 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		g_clear_error (&_inner_error_);
#line 389 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		return;
#line 2498 "moonshot-identity-manager-app.c"
	}
#line 397 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	if (!_data2_->shown) {
#line 2502 "moonshot-identity-manager-app.c"
		MoonshotLogger* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
#line 398 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp10_ = identity_manager_app_logger;
#line 398 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp11_ = g_strdup_printf ("init_ipc_server.name_lost_closure: Couldn't own name '%s' on dbus or s" \
"how previously launched identity manager", _data2_->our_name);
#line 398 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp12_ = _tmp11_;
#line 398 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		moonshot_logger_error (_tmp10_, _tmp12_, NULL);
#line 398 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_g_free0 (_tmp12_);
#line 399 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		g_error ("moonshot-identity-manager-app.vala:399: Couldn't own name '%s' on dbus" \
" or show previously launched identity manager.", _data2_->our_name);
#line 2518 "moonshot-identity-manager-app.c"
	} else {
		MoonshotLogger* _tmp13_ = NULL;
		FILE* _tmp14_ = NULL;
#line 401 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp13_ = identity_manager_app_logger;
#line 401 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		moonshot_logger_trace (_tmp13_, "init_ipc_server.name_lost_closure: Showed previously launched identity" \
" manager.", NULL);
#line 402 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp14_ = stdout;
#line 402 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		fprintf (_tmp14_, "Showed previously launched identity manager.\n");
#line 403 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		exit (0);
#line 2532 "moonshot-identity-manager-app.c"
	}
}


static void ___lambda26__gbus_name_lost_callback (GDBusConnection* connection, const gchar* name, gpointer self) {
#line 358 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	__lambda26_ (self);
#line 2540 "moonshot-identity-manager-app.c"
}


static void identity_manager_app_init_ipc_server (IdentityManagerApp* self) {
	Block2Data* _data2_;
	MoonshotServer* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 354 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	g_return_if_fail (self != NULL);
#line 354 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_data2_ = g_slice_new0 (Block2Data);
#line 354 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_data2_->_ref_count_ = 1;
#line 354 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_data2_->self = identity_manager_app_ref (self);
#line 355 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_tmp0_ = moonshot_server_new (self);
#line 355 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_g_object_unref0 (self->priv->ipc_server);
#line 355 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	self->priv->ipc_server = _tmp0_;
#line 356 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_data2_->shown = FALSE;
#line 357 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_tmp1_ = g_strdup ("org.janet.Moonshot");
#line 357 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_data2_->our_name = _tmp1_;
#line 358 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	g_bus_own_name_with_closures (G_BUS_TYPE_SESSION, _data2_->our_name, G_BUS_NAME_OWNER_FLAGS_NONE, (GClosure*) ((_identity_manager_app_bus_acquired_cb_gbus_acquired_callback == NULL) ? NULL : g_cclosure_new ((GCallback) _identity_manager_app_bus_acquired_cb_gbus_acquired_callback, identity_manager_app_ref (self), (GClosureNotify) identity_manager_app_unref)), (GClosure*) ((___lambda25__gbus_name_acquired_callback == NULL) ? NULL : g_cclosure_new ((GCallback) ___lambda25__gbus_name_acquired_callback, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref)), (GClosure*) ((___lambda26__gbus_name_lost_callback == NULL) ? NULL : g_cclosure_new ((GCallback) ___lambda26__gbus_name_lost_callback, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref)));
#line 354 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	block2_data_unref (_data2_);
#line 354 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_data2_ = NULL;
#line 2574 "moonshot-identity-manager-app.c"
}


gboolean identity_manager_app_get_use_flat_file_store (IdentityManagerApp* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 57 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 57 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_tmp0_ = self->priv->_use_flat_file_store;
#line 57 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	result = _tmp0_;
#line 57 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	return result;
#line 2589 "moonshot-identity-manager-app.c"
}


static void identity_manager_app_set_use_flat_file_store (IdentityManagerApp* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 57 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	g_return_if_fail (self != NULL);
#line 57 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_tmp0_ = value;
#line 57 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	self->priv->_use_flat_file_store = _tmp0_;
#line 2601 "moonshot-identity-manager-app.c"
}


gboolean identity_manager_app_get_headless (IdentityManagerApp* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 58 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 58 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_tmp0_ = self->priv->_headless;
#line 58 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	result = _tmp0_;
#line 58 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	return result;
#line 2616 "moonshot-identity-manager-app.c"
}


static void identity_manager_app_set_headless (IdentityManagerApp* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 58 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	g_return_if_fail (self != NULL);
#line 58 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_tmp0_ = value;
#line 58 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	self->priv->_headless = _tmp0_;
#line 2628 "moonshot-identity-manager-app.c"
}


static void value_identity_manager_app_init (GValue* value) {
#line 47 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	value->data[0].v_pointer = NULL;
#line 2635 "moonshot-identity-manager-app.c"
}


static void value_identity_manager_app_free_value (GValue* value) {
#line 47 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	if (value->data[0].v_pointer) {
#line 47 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		identity_manager_app_unref (value->data[0].v_pointer);
#line 2644 "moonshot-identity-manager-app.c"
	}
}


static void value_identity_manager_app_copy_value (const GValue* src_value, GValue* dest_value) {
#line 47 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	if (src_value->data[0].v_pointer) {
#line 47 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		dest_value->data[0].v_pointer = identity_manager_app_ref (src_value->data[0].v_pointer);
#line 2654 "moonshot-identity-manager-app.c"
	} else {
#line 47 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		dest_value->data[0].v_pointer = NULL;
#line 2658 "moonshot-identity-manager-app.c"
	}
}


static gpointer value_identity_manager_app_peek_pointer (const GValue* value) {
#line 47 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	return value->data[0].v_pointer;
#line 2666 "moonshot-identity-manager-app.c"
}


static gchar* value_identity_manager_app_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 47 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	if (collect_values[0].v_pointer) {
#line 2673 "moonshot-identity-manager-app.c"
		IdentityManagerApp* object;
		object = collect_values[0].v_pointer;
#line 47 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		if (object->parent_instance.g_class == NULL) {
#line 47 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2680 "moonshot-identity-manager-app.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 47 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2684 "moonshot-identity-manager-app.c"
		}
#line 47 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		value->data[0].v_pointer = identity_manager_app_ref (object);
#line 2688 "moonshot-identity-manager-app.c"
	} else {
#line 47 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		value->data[0].v_pointer = NULL;
#line 2692 "moonshot-identity-manager-app.c"
	}
#line 47 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	return NULL;
#line 2696 "moonshot-identity-manager-app.c"
}


static gchar* value_identity_manager_app_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	IdentityManagerApp** object_p;
	object_p = collect_values[0].v_pointer;
#line 47 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	if (!object_p) {
#line 47 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 2707 "moonshot-identity-manager-app.c"
	}
#line 47 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	if (!value->data[0].v_pointer) {
#line 47 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		*object_p = NULL;
#line 2713 "moonshot-identity-manager-app.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 47 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		*object_p = value->data[0].v_pointer;
#line 2717 "moonshot-identity-manager-app.c"
	} else {
#line 47 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		*object_p = identity_manager_app_ref (value->data[0].v_pointer);
#line 2721 "moonshot-identity-manager-app.c"
	}
#line 47 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	return NULL;
#line 2725 "moonshot-identity-manager-app.c"
}


GParamSpec* param_spec_identity_manager_app (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecIdentityManagerApp* spec;
#line 47 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_IDENTITY_MANAGER_APP), NULL);
#line 47 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 47 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 47 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	return G_PARAM_SPEC (spec);
#line 2739 "moonshot-identity-manager-app.c"
}


gpointer value_get_identity_manager_app (const GValue* value) {
#line 47 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_IDENTITY_MANAGER_APP), NULL);
#line 47 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	return value->data[0].v_pointer;
#line 2748 "moonshot-identity-manager-app.c"
}


void value_set_identity_manager_app (GValue* value, gpointer v_object) {
	IdentityManagerApp* old;
#line 47 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_IDENTITY_MANAGER_APP));
#line 47 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	old = value->data[0].v_pointer;
#line 47 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	if (v_object) {
#line 47 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_IDENTITY_MANAGER_APP));
#line 47 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 47 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		value->data[0].v_pointer = v_object;
#line 47 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		identity_manager_app_ref (value->data[0].v_pointer);
#line 2768 "moonshot-identity-manager-app.c"
	} else {
#line 47 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		value->data[0].v_pointer = NULL;
#line 2772 "moonshot-identity-manager-app.c"
	}
#line 47 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	if (old) {
#line 47 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		identity_manager_app_unref (old);
#line 2778 "moonshot-identity-manager-app.c"
	}
}


void value_take_identity_manager_app (GValue* value, gpointer v_object) {
	IdentityManagerApp* old;
#line 47 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_IDENTITY_MANAGER_APP));
#line 47 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	old = value->data[0].v_pointer;
#line 47 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	if (v_object) {
#line 47 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_IDENTITY_MANAGER_APP));
#line 47 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 47 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		value->data[0].v_pointer = v_object;
#line 2797 "moonshot-identity-manager-app.c"
	} else {
#line 47 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		value->data[0].v_pointer = NULL;
#line 2801 "moonshot-identity-manager-app.c"
	}
#line 47 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	if (old) {
#line 47 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		identity_manager_app_unref (old);
#line 2807 "moonshot-identity-manager-app.c"
	}
}


static void identity_manager_app_class_init (IdentityManagerAppClass * klass) {
	MoonshotLogger* _tmp0_ = NULL;
#line 47 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	identity_manager_app_parent_class = g_type_class_peek_parent (klass);
#line 47 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	((IdentityManagerAppClass *) klass)->finalize = identity_manager_app_finalize;
#line 47 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	g_type_class_add_private (klass, sizeof (IdentityManagerAppPrivate));
#line 48 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_tmp0_ = get_logger ("IdentityManagerApp");
#line 48 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	identity_manager_app_logger = _tmp0_;
#line 2824 "moonshot-identity-manager-app.c"
}


static void identity_manager_app_instance_init (IdentityManagerApp * self) {
#line 47 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	self->priv = IDENTITY_MANAGER_APP_GET_PRIVATE (self);
#line 47 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	self->ref_count = 1;
#line 2833 "moonshot-identity-manager-app.c"
}


static void identity_manager_app_finalize (IdentityManagerApp* obj) {
	IdentityManagerApp * self;
#line 47 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_IDENTITY_MANAGER_APP, IdentityManagerApp);
#line 47 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	g_signal_handlers_destroy (self);
#line 50 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_g_object_unref0 (self->model);
#line 51 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_g_object_unref0 (self->default_id_card);
#line 53 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_g_object_unref0 (self->view);
#line 54 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_g_object_unref0 (self->priv->ipc_server);
#line 2851 "moonshot-identity-manager-app.c"
}


GType identity_manager_app_get_type (void) {
	static volatile gsize identity_manager_app_type_id__volatile = 0;
	if (g_once_init_enter (&identity_manager_app_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_identity_manager_app_init, value_identity_manager_app_free_value, value_identity_manager_app_copy_value, value_identity_manager_app_peek_pointer, "p", value_identity_manager_app_collect_value, "p", value_identity_manager_app_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (IdentityManagerAppClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) identity_manager_app_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (IdentityManagerApp), 0, (GInstanceInitFunc) identity_manager_app_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType identity_manager_app_type_id;
		identity_manager_app_type_id = g_type_register_fundamental (g_type_fundamental_next (), "IdentityManagerApp", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&identity_manager_app_type_id__volatile, identity_manager_app_type_id);
	}
	return identity_manager_app_type_id__volatile;
}


gpointer identity_manager_app_ref (gpointer instance) {
	IdentityManagerApp* self;
	self = instance;
#line 47 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	g_atomic_int_inc (&self->ref_count);
#line 47 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	return instance;
#line 2876 "moonshot-identity-manager-app.c"
}


void identity_manager_app_unref (gpointer instance) {
	IdentityManagerApp* self;
	self = instance;
#line 47 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 47 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		IDENTITY_MANAGER_APP_GET_CLASS (self)->finalize (self);
#line 47 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 2889 "moonshot-identity-manager-app.c"
	}
}


gint _vala_main (gchar** args, int args_length1) {
	gint result = 0;
	gboolean headless = FALSE;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	IdentityManagerApp* app = NULL;
	gboolean _tmp30_ = FALSE;
	gboolean _tmp31_ = FALSE;
	IdentityManagerApp* _tmp32_ = NULL;
	IdentityManagerApp* _tmp33_ = NULL;
	gboolean _tmp34_ = FALSE;
	MoonshotLogger* _tmp35_ = NULL;
	gboolean _tmp36_ = FALSE;
	gchar* _tmp37_ = NULL;
	gchar* _tmp38_ = NULL;
	gchar* _tmp39_ = NULL;
	gchar* _tmp40_ = NULL;
	IdentityManagerApp* _tmp41_ = NULL;
	gboolean _tmp42_ = FALSE;
	gboolean _tmp44_ = FALSE;
	GError * _inner_error_ = NULL;
#line 431 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_tmp0_ = g_getenv ("DISPLAY");
#line 431 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	headless = _tmp0_ == NULL;
#line 434 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_tmp1_ = headless;
#line 434 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	if (_tmp1_) {
#line 2923 "moonshot-identity-manager-app.c"
		{
			GOptionContext* opt_context = NULL;
			GOptionContext* _tmp2_ = NULL;
			GOptionContext* _tmp3_ = NULL;
			GOptionContext* _tmp4_ = NULL;
			GOptionContext* _tmp5_ = NULL;
#line 436 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp2_ = g_option_context_new (NULL);
#line 436 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			opt_context = _tmp2_;
#line 437 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp3_ = opt_context;
#line 437 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			g_option_context_set_help_enabled (_tmp3_, TRUE);
#line 438 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp4_ = opt_context;
#line 438 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			g_option_context_add_main_entries (_tmp4_, options, NULL);
#line 439 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp5_ = opt_context;
#line 439 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			g_option_context_parse (_tmp5_, &args_length1, &args, &_inner_error_);
#line 439 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2948 "moonshot-identity-manager-app.c"
				gint _tmp6_ = 0;
#line 439 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
				_g_option_context_free0 (opt_context);
#line 439 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
				if (_inner_error_->domain == G_OPTION_ERROR) {
#line 2954 "moonshot-identity-manager-app.c"
					goto __catch3_g_option_error;
				}
#line 439 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
				_g_option_context_free0 (opt_context);
#line 439 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 439 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
				g_clear_error (&_inner_error_);
#line 439 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
				return _tmp6_;
#line 2965 "moonshot-identity-manager-app.c"
			}
#line 435 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_g_option_context_free0 (opt_context);
#line 2969 "moonshot-identity-manager-app.c"
		}
		goto __finally3;
		__catch3_g_option_error:
		{
			GError* e = NULL;
			FILE* _tmp7_ = NULL;
			const gchar* _tmp8_ = NULL;
			GError* _tmp9_ = NULL;
			const gchar* _tmp10_ = NULL;
			FILE* _tmp11_ = NULL;
			const gchar* _tmp12_ = NULL;
			gchar** _tmp13_ = NULL;
			gint _tmp13__length1 = 0;
			const gchar* _tmp14_ = NULL;
#line 435 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			e = _inner_error_;
#line 435 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_inner_error_ = NULL;
#line 441 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp7_ = stdout;
#line 441 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp8_ = _ ("error: %s\n");
#line 441 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp9_ = e;
#line 441 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp10_ = _tmp9_->message;
#line 441 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			fprintf (_tmp7_, _tmp8_, _tmp10_);
#line 442 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp11_ = stdout;
#line 442 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp12_ = _ ("Run '%s --help' to see a full list of available options\n");
#line 442 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp13_ = args;
#line 442 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp13__length1 = args_length1;
#line 442 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp14_ = _tmp13_[0];
#line 442 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			fprintf (_tmp11_, _tmp12_, _tmp14_);
#line 443 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			result = -1;
#line 443 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_g_error_free0 (e);
#line 443 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			return result;
#line 3016 "moonshot-identity-manager-app.c"
		}
		__finally3:
#line 435 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 3021 "moonshot-identity-manager-app.c"
			gint _tmp15_ = 0;
#line 435 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 435 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			g_clear_error (&_inner_error_);
#line 435 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			return _tmp15_;
#line 3029 "moonshot-identity-manager-app.c"
		}
#line 445 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		explicitly_launched = FALSE;
#line 3033 "moonshot-identity-manager-app.c"
	} else {
		{
			gboolean _tmp16_ = FALSE;
			const gchar* _tmp17_ = NULL;
			gboolean _tmp18_ = FALSE;
#line 448 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp17_ = _ ("");
#line 448 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp18_ = gtk_init_with_args (&args_length1, &args, _tmp17_, options, NULL, &_inner_error_);
#line 448 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp16_ = _tmp18_;
#line 448 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 3047 "moonshot-identity-manager-app.c"
				goto __catch4_g_error;
			}
#line 448 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			if (!_tmp16_) {
#line 3052 "moonshot-identity-manager-app.c"
				FILE* _tmp19_ = NULL;
				const gchar* _tmp20_ = NULL;
#line 449 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
				_tmp19_ = stdout;
#line 449 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
				_tmp20_ = _ ("unable to initialize window\n");
#line 449 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
				fprintf (_tmp19_, "%s", _tmp20_);
#line 450 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
				result = -1;
#line 450 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
				return result;
#line 3065 "moonshot-identity-manager-app.c"
			}
		}
		goto __finally4;
		__catch4_g_error:
		{
			GError* e = NULL;
			FILE* _tmp21_ = NULL;
			const gchar* _tmp22_ = NULL;
			GError* _tmp23_ = NULL;
			const gchar* _tmp24_ = NULL;
			FILE* _tmp25_ = NULL;
			const gchar* _tmp26_ = NULL;
			gchar** _tmp27_ = NULL;
			gint _tmp27__length1 = 0;
			const gchar* _tmp28_ = NULL;
#line 447 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			e = _inner_error_;
#line 447 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_inner_error_ = NULL;
#line 453 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp21_ = stdout;
#line 453 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp22_ = _ ("error: %s\n");
#line 453 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp23_ = e;
#line 453 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp24_ = _tmp23_->message;
#line 453 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			fprintf (_tmp21_, _tmp22_, _tmp24_);
#line 454 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp25_ = stdout;
#line 454 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp26_ = _ ("Run '%s --help' to see a full list of available options\n");
#line 454 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp27_ = args;
#line 454 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp27__length1 = args_length1;
#line 454 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp28_ = _tmp27_[0];
#line 454 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			fprintf (_tmp25_, _tmp26_, _tmp28_);
#line 455 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			result = -1;
#line 455 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_g_error_free0 (e);
#line 455 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			return result;
#line 3113 "moonshot-identity-manager-app.c"
		}
		__finally4:
#line 447 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 3118 "moonshot-identity-manager-app.c"
			gint _tmp29_ = 0;
#line 447 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 447 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			g_clear_error (&_inner_error_);
#line 447 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			return _tmp29_;
#line 3126 "moonshot-identity-manager-app.c"
		}
#line 457 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		gtk_available = TRUE;
#line 3130 "moonshot-identity-manager-app.c"
	}
#line 468 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
#line 469 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
#line 470 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	textdomain (GETTEXT_PACKAGE);
#line 473 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_tmp30_ = headless;
#line 473 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_tmp31_ = use_flat_file_store;
#line 473 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_tmp32_ = identity_manager_app_new (_tmp30_, _tmp31_);
#line 473 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	app = _tmp32_;
#line 474 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_tmp33_ = app;
#line 474 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_tmp34_ = explicitly_launched;
#line 474 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_tmp33_->explicitly_launched = _tmp34_;
#line 475 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_tmp35_ = identity_manager_app_logger;
#line 475 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_tmp36_ = explicitly_launched;
#line 475 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_tmp37_ = bool_to_string (_tmp36_);
#line 475 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_tmp38_ = _tmp37_;
#line 475 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_tmp39_ = g_strconcat ("main: explicitly_launched=", _tmp38_, NULL);
#line 475 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_tmp40_ = _tmp39_;
#line 475 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	moonshot_logger_trace (_tmp35_, _tmp40_, NULL);
#line 475 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_g_free0 (_tmp40_);
#line 475 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_g_free0 (_tmp38_);
#line 477 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_tmp41_ = app;
#line 477 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_tmp42_ = _tmp41_->explicitly_launched;
#line 477 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	if (_tmp42_) {
#line 3176 "moonshot-identity-manager-app.c"
		IdentityManagerApp* _tmp43_ = NULL;
#line 478 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp43_ = app;
#line 478 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		identity_manager_app_show (_tmp43_);
#line 3182 "moonshot-identity-manager-app.c"
	}
#line 481 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_tmp44_ = headless;
#line 481 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	if (_tmp44_) {
#line 3188 "moonshot-identity-manager-app.c"
		GMainLoop* loop = NULL;
		GMainLoop* _tmp45_ = NULL;
		GMainLoop* _tmp46_ = NULL;
#line 483 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp45_ = g_main_loop_new (NULL, FALSE);
#line 483 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		loop = _tmp45_;
#line 484 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp46_ = loop;
#line 484 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		g_main_loop_run (_tmp46_);
#line 481 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_g_main_loop_unref0 (loop);
#line 3202 "moonshot-identity-manager-app.c"
	} else {
#line 488 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		gtk_main ();
#line 3206 "moonshot-identity-manager-app.c"
	}
#line 491 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	result = 0;
#line 491 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_identity_manager_app_unref0 (app);
#line 491 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	return result;
#line 3214 "moonshot-identity-manager-app.c"
}


int main (int argc, char ** argv) {
#if !GLIB_CHECK_VERSION (2,35,0)
	g_type_init ();
#endif
#line 421 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	return _vala_main (argv, argc);
#line 3224 "moonshot-identity-manager-app.c"
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



