/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 2010 Oracle and/or its affiliates. All rights reserved.
 *
 * Oracle and Java are registered trademarks of Oracle and/or its affiliates.
 * Other names may be trademarks of their respective owners.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 *
 * Contributor(s):
 *
 * Portions Copyrighted 2010 Sun Microsystems, Inc.
 */

package org.netbeans.modules.db.explorer.dlg;

import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

/**
 *
 * @author Jiri Rechtacek
 */
public class ViewProcedureDialog extends javax.swing.JPanel {

    /** Creates new form ViewProcedureDialog */
    private ViewProcedureDialog(String name, String params, String body) {
        initComponents();
        tfName.setText(name);
        taParams.setText(params);
        taBody.setText(body);
    }
    
    public static void showProcedure(String name, String params, String body) {
        ViewProcedureDialog panel = new ViewProcedureDialog(name, params, body);
        panel.setName(NbBundle.getMessage(ViewProcedureDialog.class, "ViewProcedureDialog_Title")); // NOI18N
        NotifyDescriptor nd = new NotifyDescriptor.Message(panel);
        DialogDisplayer.getDefault().notify(nd);
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        lName = new javax.swing.JLabel();
        tfName = new javax.swing.JTextField();
        lParams = new javax.swing.JLabel();
        spParams = new javax.swing.JScrollPane();
        taParams = new javax.swing.JTextArea();
        lBody = new javax.swing.JLabel();
        spBody = new javax.swing.JScrollPane();
        taBody = new javax.swing.JTextArea();

        lName.setLabelFor(tfName);
        org.openide.awt.Mnemonics.setLocalizedText(lName, org.openide.util.NbBundle.getMessage(ViewProcedureDialog.class, "ViewProcedureDialog.lName.text", new Object[] {})); // NOI18N

        tfName.setEditable(false);

        lParams.setLabelFor(taParams);
        org.openide.awt.Mnemonics.setLocalizedText(lParams, org.openide.util.NbBundle.getMessage(ViewProcedureDialog.class, "ViewProcedureDialog.lParams.text", new Object[] {})); // NOI18N

        taParams.setColumns(20);
        taParams.setEditable(false);
        taParams.setRows(5);
        spParams.setViewportView(taParams);
        taParams.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(ViewProcedureDialog.class, "ViewProcedureDialog.taParams.ACD")); // NOI18N

        lBody.setLabelFor(taBody);
        org.openide.awt.Mnemonics.setLocalizedText(lBody, org.openide.util.NbBundle.getMessage(ViewProcedureDialog.class, "ViewProcedureDialog.lBody.text", new Object[] {})); // NOI18N

        taBody.setColumns(20);
        taBody.setEditable(false);
        taBody.setRows(5);
        spBody.setViewportView(taBody);
        taBody.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(ViewProcedureDialog.class, "ViewProcedureDialog.taBody.ACD")); // NOI18N

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(spParams, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, 419, Short.MAX_VALUE)
                    .addComponent(spBody, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, 419, Short.MAX_VALUE)
                    .addGroup(javax.swing.GroupLayout.Alignment.LEADING, layout.createSequentialGroup()
                        .addComponent(lName)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(tfName, javax.swing.GroupLayout.DEFAULT_SIZE, 362, Short.MAX_VALUE))
                    .addComponent(lParams, javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(lBody, javax.swing.GroupLayout.Alignment.LEADING))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(lName)
                    .addComponent(tfName, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(18, 18, 18)
                .addComponent(lParams)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(spParams, javax.swing.GroupLayout.PREFERRED_SIZE, 101, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addComponent(lBody)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(spBody, javax.swing.GroupLayout.PREFERRED_SIZE, 206, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap())
        );

        tfName.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(ViewProcedureDialog.class, "ViewProcedureDialog.tfName.ACD")); // NOI18N
    }// </editor-fold>//GEN-END:initComponents


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel lBody;
    private javax.swing.JLabel lName;
    private javax.swing.JLabel lParams;
    private javax.swing.JScrollPane spBody;
    private javax.swing.JScrollPane spParams;
    private javax.swing.JTextArea taBody;
    private javax.swing.JTextArea taParams;
    private javax.swing.JTextField tfName;
    // End of variables declaration//GEN-END:variables

}
