/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webdav.lib.methods;

import java.io.IOException;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpState;
import org.apache.webdav.lib.methods.XMLResponseMethodBase;

public class SemanticSearchMethod
extends XMLResponseMethodBase {
    protected String prefix = null;
    private String preloadedQuery = null;
    private String result = "NULL";

    public SemanticSearchMethod() {
    }

    public SemanticSearchMethod(String path) {
        super(path);
    }

    public SemanticSearchMethod(String path, String query) {
        this(path);
        this.preloadedQuery = query;
    }

    public String getName() {
        return "SEARCH";
    }

    public void recycle() {
        super.recycle();
        this.prefix = null;
    }

    public void addRequestHeaders(HttpState state, HttpConnection conn) throws IOException, HttpException {
        if (this.getRequestHeader("Content-Type") == null) {
            super.setRequestHeader("Content-Type", "text/xml; charset=utf-8");
        }
        super.addRequestHeaders(state, conn);
    }

    protected String generateRequestBody() {
        if (this.preloadedQuery == null || this.preloadedQuery.trim().length() < 1) {
            System.err.println("Error: No query string received");
            return "";
        }
        return this.preloadedQuery;
    }
}

