/*
 * Decompiled with CFR 0.152.
 */
package org.chefproject.service.test;

import java.util.HashSet;
import javax.servlet.http.HttpSession;
import org.apache.jetspeed.services.statemanager.JetspeedHttpStateManagerService;
import org.apache.jetspeed.services.statemanager.SessionStateBindingListener;
import org.apache.jetspeed.services.statemanager.StateManagerService;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.util.Log;

public class StateManagerTest {
    private static RetireObject M_ro = null;

    public String test(HttpSession session) {
        int i;
        String[] testNames;
        HashSet<String> testSet;
        int i2;
        HashSet<String> namesSet;
        Result rv = new Result();
        rv.msg = new StringBuffer();
        StateManagerService service = (StateManagerService)TurbineServices.getInstance().getService("StateManagerService");
        if (service == null) {
            Log.warn("chef", this + ".doPresence(): missing service: " + "StateManagerService");
            rv.msg.append("missing service: StateManagerService<br/>");
            return rv.msg.toString();
        }
        String keyRoot = "key";
        String key1 = keyRoot + "1";
        String key2 = keyRoot + "2";
        String key3 = "not_a key";
        String attr1 = "attr1";
        String attr2 = "attr2";
        String attr3 = "attr3";
        Object attr = service.getAttribute(key1, attr1);
        rv.test(attr == null, "attribute1 already exists before adding");
        service.setAttribute(key1, attr1, (Object)"test");
        attr = service.getAttribute(key1, attr1);
        rv.test(attr != null, "attribute1 does not exist after adding");
        rv.test(attr instanceof String, "attribute1 not a String");
        rv.test("test".equals(attr), "attribute1 value not correct");
        attr = service.getAttribute(key1, attr2);
        rv.test(attr == null, "attribute2 already exists before adding");
        service.setAttribute(key1, attr2, (Object)"frog");
        attr = service.getAttribute(key1, attr2);
        rv.test(attr != null, "attribute2 does not exist after adding");
        rv.test(attr instanceof String, "attribute2 not a String");
        rv.test("frog".equals(attr), "attribute2 value not correct");
        attr = service.getAttribute(key1, attr3);
        rv.test(attr == null, "attribute3 already exists before adding");
        service.setAttribute(key1, attr3, (Object)"cracker");
        attr = service.getAttribute(key1, attr3);
        rv.test(attr != null, "attribute3 does not exist after adding");
        rv.test(attr instanceof String, "attribute3 not a String");
        rv.test("cracker".equals(attr), "attribute3 value not correct");
        attr = service.getAttribute(key1, attr1);
        rv.test(attr != null, "attribute1 does not exist after adding attr2");
        rv.test(attr instanceof String, "attribute1 not a String after adding attr2/3");
        rv.test("test".equals(attr), "attribute1 value not correct after adding attr2/3");
        String[] names = service.getAttributeNames(key1);
        rv.test(names != null, "names is null");
        if (names != null) {
            rv.test(names.length == 3, "not enough names");
            namesSet = new HashSet<String>();
            i2 = 0;
            while (i2 < names.length) {
                namesSet.add(names[i2]);
                ++i2;
            }
            testSet = new HashSet<String>();
            testNames = new String[]{attr3, attr2, attr1};
            i = 0;
            while (i < testNames.length) {
                testSet.add(testNames[i]);
                ++i;
            }
            rv.test(testSet.equals(namesSet), "names are not correct 1");
        }
        service.removeAttribute(key1, attr1);
        attr = service.getAttribute(key1, attr1);
        rv.test(attr == null, "attribute1 there after removal");
        attr = service.getAttribute(key1, attr2);
        rv.test(attr != null, "attribute2 does not exist after removing attribute1");
        rv.test(attr instanceof String, "attribute2 not a String after removing attribute1");
        rv.test("frog".equals(attr), "attribute2 value not correct after removing attribute1");
        attr = service.getAttribute(key1, attr3);
        rv.test(attr != null, "attribute3 does not exist after removing attribute1");
        rv.test(attr instanceof String, "attribute3 not a String after removing attribute1");
        rv.test("cracker".equals(attr), "attribute3 value not correct after removing attribute1");
        names = service.getAttributeNames(key1);
        rv.test(names != null, "names is null after removing attribute1");
        if (names != null) {
            rv.test(names.length == 2, "not just two names after removing attribute1");
            namesSet = new HashSet();
            i2 = 0;
            while (i2 < names.length) {
                namesSet.add(names[i2]);
                ++i2;
            }
            testSet = new HashSet();
            testNames = new String[]{attr2, attr3};
            i = 0;
            while (i < testNames.length) {
                testSet.add(testNames[i]);
                ++i;
            }
            rv.test(testSet.equals(namesSet), "names are not correct 2");
        }
        service.removeAttribute(key1, "not");
        service.clear(key1);
        attr = service.getAttribute(key1, attr1);
        rv.test(attr == null, "attribute1 there after removal, after clear");
        attr = service.getAttribute(key1, attr2);
        rv.test(attr == null, "attribute2 there after clear");
        attr = service.getAttribute(key1, attr3);
        rv.test(attr == null, "attribute3 there after clear");
        names = service.getAttributeNames(key1);
        rv.test(names == null, "names not null after clear");
        service.clear(key1);
        service.clear(key1);
        attr = service.getAttribute(key1, attr1);
        rv.test(attr == null, "attribute1 already exists before adding #2");
        service.setAttribute(key1, attr1, (Object)"blah");
        attr = service.getAttribute(key1, attr1);
        rv.test(attr != null, "attribute1 does not exist after adding #2)");
        rv.test(attr instanceof String, "attribute1 not a String #2");
        rv.test("blah".equals(attr), "attribute1 value not correct #2");
        attr = service.getAttribute(key2, attr1);
        rv.test(attr == null, "attribute1 / key2 already exists before adding");
        service.setAttribute(key2, attr1, (Object)"ghost");
        attr = service.getAttribute(key2, attr1);
        rv.test(attr != null, "attribute1 / key2 does not exist after adding)");
        rv.test(attr instanceof String, "attribute1 / key2 not a String");
        rv.test("ghost".equals(attr), "attribute1 / key2 value not correct");
        attr = service.getAttribute(key1, attr1);
        rv.test(attr != null, "attribute1 does not exist after adding key2)");
        rv.test(attr instanceof String, "attribute1 not a String key2");
        rv.test("blah".equals(attr), "attribute1 value not correct key2");
        service.setAttribute(key1, attr1, (Object)"t-shirt");
        rv.test(attr != null, "attribute1 does not exist after setting new value)");
        rv.test(attr instanceof String, "attribute1 not a String after setting new value");
        rv.test("blah".equals(attr), "attribute1 value not correct after setting new value");
        attr = service.getAttribute(key2, attr1);
        rv.test(attr != null, "attribute1 / key2 does not exist after setting new value (key1)");
        rv.test(attr instanceof String, "attribute1 / key2 not a String after setting new value (key1)");
        rv.test("ghost".equals(attr), "attribute1 / key2 value not correct after setting new value (key1)");
        names = service.getAttributeNames(key1);
        String[] names2 = service.getAttributeNames(key2);
        rv.test(names != null, "names null #2");
        rv.test(names2 != null, "names2 null");
        if (names != null && names2 != null) {
            rv.test(names.length == 1, "names length not 1 #2");
            rv.test(names2.length == 1, "names2 length not 1");
            rv.test(names[0].equals(names2[0]), "name != names");
        }
        service.removeAttribute(key1, attr1);
        attr = service.getAttribute(key1, attr1);
        rv.test(attr == null, "attribute1 there after removal #2");
        attr = service.getAttribute(key2, attr1);
        rv.test(attr != null, "attribute1 / key2 does not exist after removal #2");
        rv.test(attr instanceof String, "attribute1 / key2 not a String after removal #2");
        rv.test("ghost".equals(attr), "attribute1 / key2 value not correct after removal #2");
        attr = service.getAttribute(key1, attr2);
        rv.test(attr == null, "attribute2 already exists before adding #2");
        service.setAttribute(key1, attr2, (Object)"bird");
        attr = service.getAttribute(key1, attr2);
        rv.test(attr != null, "attribute2 does not exist after adding #2");
        rv.test(attr instanceof String, "attribute2 not a String #2");
        rv.test("bird".equals(attr), "attribute2 value not correct #2");
        attr = service.getAttribute(key2, attr1);
        rv.test(attr != null, "attribute1 / key2 does not exist after adding key1/attr2");
        rv.test(attr instanceof String, "attribute1 / key2 not a String after adding key1/attr2");
        rv.test("ghost".equals(attr), "attribute1 / key2 value not correct after adding key1/attr2");
        names = service.getAttributeNames(key1);
        names2 = service.getAttributeNames(key2);
        rv.test(names != null, "names null #3");
        rv.test(names2 != null, "names2 null #3");
        if (names != null && names2 != null) {
            rv.test(names.length == 1, "names length not 1 #3");
            rv.test(names2.length == 1, "names2 length not 1 #3");
            rv.test(!names[0].equals(names2[0]), "name == names #3");
            rv.test(names[0].equals(attr2), "names not attr2");
            rv.test(names2[0].equals(attr1), "names2 not attr1");
        }
        service.clear(key1);
        attr = service.getAttribute(key1, attr1);
        rv.test(attr == null, "attribute1 there after removal, after clear #2");
        attr = service.getAttribute(key2, attr1);
        rv.test(attr != null, "attribute1 / key2 does not exist after clear key1");
        rv.test(attr instanceof String, "attribute1 / key2 not a String after clear key1");
        rv.test("ghost".equals(attr), "attribute1 / key2 value not correct after clear key1");
        service.clear(key2);
        names = service.getAttributeNames(key2);
        rv.test(names == null, "names not null after clear of key2");
        attr = service.getAttribute(key2, attr1);
        rv.test(attr == null, "attribute1 / key2 there after clearing");
        service.setAttribute(key1, attr3, (Object)"larry");
        service.setAttribute(key2, attr3, (Object)"moe");
        service.setAttribute(key3, attr3, (Object)"jack");
        attr = service.getAttribute(key1, attr3);
        rv.test("larry".equals(attr), "key1 attr3 not larry");
        attr = service.getAttribute(key2, attr3);
        rv.test("moe".equals(attr), "key2 attr3 not moe");
        attr = service.getAttribute(key3, attr3);
        rv.test("jack".equals(attr), "key3 attr3 not jack");
        service.retireState("key");
        attr = service.getAttribute(key1, attr3);
        rv.test(attr == null, "key1 attr3 was not cleared");
        attr = service.getAttribute(key2, attr3);
        rv.test(attr == null, "key2 attr3 was not cleared");
        attr = service.getAttribute(key3, attr3);
        rv.test("jack".equals(attr), "key3 attr3 not jack- was cleared!");
        attr = service.getAttribute(key3.toUpperCase(), attr3);
        rv.test(attr == null, "key3-UPC attr3 found");
        attr = service.getAttribute(key3, attr3.toUpperCase());
        rv.test(attr == null, "key3 attr3-UPC found");
        service.setAttribute(key3, attr3.toUpperCase(), (Object)"brownie");
        attr = service.getAttribute(key3, attr3.toUpperCase());
        rv.test("brownie".equals(attr), "key3 attr3-UPC not correct after adding");
        attr = service.getAttribute(key3, attr3);
        rv.test("jack".equals(attr), "key3 attr3 not correct after adding attr3-UPC");
        names = service.getAttributeNames(key3);
        rv.test(names != null, "names is null key3 UPC test");
        if (names != null) {
            rv.test(names.length == 2, "not just two names key3 UPC test");
            HashSet<String> namesSet2 = new HashSet<String>();
            int i3 = 0;
            while (i3 < names.length) {
                namesSet2.add(names[i3]);
                ++i3;
            }
            HashSet<String> testSet2 = new HashSet<String>();
            String[] testNames2 = new String[]{attr3, attr3.toUpperCase()};
            int i4 = 0;
            while (i4 < testNames2.length) {
                testSet2.add(testNames2[i4]);
                ++i4;
            }
            rv.test(testSet2.equals(namesSet2), "names are not correct key3 UPC test");
        }
        service.removeAttribute(key3, attr3);
        attr = service.getAttribute(key3, attr3);
        rv.test(attr == null, "key3 attr3 found after remove UPC test");
        attr = service.getAttribute(key3, attr3.toUpperCase());
        rv.test(attr != null, "key3 attr3-UPC not found after remove of LC");
        rv.test("brownie".equals(attr), "key3 attr3-UPC not correct after remove of LC");
        service.setAttribute(key3, attr3, (Object)"jill");
        service.setAttribute(key3.toUpperCase(), attr3, (Object)"michigan");
        attr = service.getAttribute(key3, attr3);
        rv.test("jill".equals(attr), "key3 attr3 not correct after adding key3-UPC");
        attr = service.getAttribute(key3.toUpperCase(), attr3);
        rv.test("michigan".equals(attr), "key3-UPC attr3 not correct after adding");
        service.removeAttribute(key3.toUpperCase(), attr3);
        attr = service.getAttribute(key3.toUpperCase(), attr3);
        rv.test(attr == null, "key3-UPC attr3 found after removal");
        attr = service.getAttribute(key3, attr3);
        rv.test("jill".equals(attr), "key3 attr3 not correct after removing key3-UPC");
        service.retireState("");
        names = service.getAttributeNames(key1);
        rv.test(names == null, "key1 still there after full retire");
        names = service.getAttributeNames(key2);
        rv.test(names == null, "key2 still there after full retire");
        names = service.getAttributeNames(key3);
        rv.test(names == null, "key3 still there after full retire");
        attr = service.getAttribute(key3, attr3);
        rv.test(attr == null, "key3 attr3 still there after full retire");
        service.setAttribute(key1, attr2, (Object)"red");
        service.setAttribute(key2, attr2, (Object)"blue");
        service.setAttribute(key1.toUpperCase(), attr2, (Object)"green");
        attr = service.getAttribute(key1, attr2);
        rv.test("red".equals(attr), "key1 attr2 not red");
        attr = service.getAttribute(key2, attr2);
        rv.test("blue".equals(attr), "key2 attr2 not blue");
        attr = service.getAttribute(key1.toUpperCase(), attr2);
        rv.test("green".equals(attr), "key1-UPC attr2 not green");
        service.retireState(keyRoot);
        attr = service.getAttribute(key1, attr2);
        rv.test(attr == null, "key1 attr2 was not cleared after case retire test");
        attr = service.getAttribute(key2, attr2);
        rv.test(attr == null, "key2 attr3 was not cleared after case retire test");
        attr = service.getAttribute(key1.toUpperCase(), attr2);
        rv.test("green".equals(attr), "key1-UPC attr2 not green after case retire test");
        service.retireState("");
        RetireObject r1 = new RetireObject("r1");
        RetireObject r2 = new RetireObject("r2");
        RetireObject r3 = new RetireObject("r3");
        RetireObject r4 = new RetireObject("r4");
        service.setAttribute(key1, attr1, (Object)r1);
        rv.test(r1.hasBound(), "r1 not bound");
        service.setAttribute(key1, attr2, (Object)r2);
        rv.test(r2.hasBound(), "r2 not bound");
        service.removeAttribute(key1, attr1);
        rv.test(r1.hasUnbound(), "r1 not unbound after removal r1");
        rv.test(!r2.hasUnbound(), "r2 is unbound after removal r1");
        service.setAttribute(key1, attr2, (Object)r3);
        rv.test(r3.hasBound(), "r3 not bound");
        rv.test(r1.hasUnbound(), "r1 not unbound after replacement of r2 w/r3");
        rv.test(r2.hasUnbound(), "r2 not unbound after replacement of r2 w/r3");
        rv.test(!r3.hasUnbound(), "r3 is unbound after after replacement of r2 w/r3");
        service.setAttribute(key1, attr1, (Object)r4);
        rv.test(r4.hasBound(), "r4 not bound");
        service.retireState("");
        rv.test(r1.hasUnbound(), "r1 not unbound after retire");
        rv.test(r2.hasUnbound(), "r2 not unbound after retire");
        rv.test(r3.hasUnbound(), "r3 not unbound after retire");
        rv.test(r4.hasUnbound(), "r4 not unbound after retire");
        service.retireState("");
        service.retireState("");
        if (session != null && service instanceof JetspeedHttpStateManagerService) {
            String id = session.getId();
            RetireObject r1b = new RetireObject("r1b");
            RetireObject r2b = new RetireObject("r2b");
            RetireObject r3b = new RetireObject("r3b");
            service.setAttribute(id + key1, attr1, (Object)r1b);
            service.setAttribute(id + key1, attr2, (Object)r2b);
            service.setAttribute(key2, attr3, (Object)r3b);
            rv.test(r1b.hasBound(), "r1b not bound");
            rv.test(r2b.hasBound(), "r2b not bound");
            rv.test(r3b.hasBound(), "r3b not bound");
            session.invalidate();
            rv.test(service.getAttribute(id + key1, attr1) == null, "session+key1 attr1 still there after invalidate");
            rv.test(service.getAttribute(id + key1, attr2) == null, "session+key1 attr2 still there after invalidate");
            rv.test(service.getAttribute(key2, attr3) == null, "key2 attr3 still there after invalidate");
            rv.test(r1b.hasUnbound(), "r1b not unbound after invalidate");
            rv.test(r2b.hasUnbound(), "r2b not unbound after invalidate");
            rv.test(r3b.hasUnbound(), "r3b not unbound after invalidate");
            Log.info("chef", this + ".test(): http session has been invalidated: " + id);
        }
        service.retireState("");
        rv.conclude();
        Log.info("chef", this + ".test(): warning: all states retired:\n" + rv.msg.toString());
        return rv.msg.toString();
    }

    public String test_one(HttpSession session) {
        Result rv = new Result();
        rv.msg = new StringBuffer();
        StateManagerService service = (StateManagerService)TurbineServices.getInstance().getService("StateManagerService");
        if (service == null) {
            Log.warn("chef", this + ".doPresence(): missing service: " + "StateManagerService");
            rv.msg.append("missing service: StateManagerService<br/>");
            return rv.msg.toString();
        }
        String keyRoot = session.getId() + "key";
        String key1 = keyRoot + "1";
        String attr1 = "attr1";
        String attr2 = "attr2";
        service.setAttribute(key1, attr1, (Object)"turbine");
        RetireObject r1c = new RetireObject("r1c");
        service.setAttribute(key1, attr2, (Object)r1c);
        Object attr = service.getAttribute(key1, attr1);
        rv.test("turbine".equals(attr), "attribute1 value not correct");
        attr = service.getAttribute(key1, attr2);
        rv.test(attr instanceof RetireObject, "attribute 2 not correct type");
        if (attr instanceof RetireObject) {
            rv.test(((RetireObject)attr).hasBound(), "attribute 2 not bound");
            rv.test(!((RetireObject)attr).hasUnbound(), "attribute 2 is unbound");
        }
        rv.conclude();
        rv.msg.append("<br/>run the main test from ANOTHER SESSION!, then run the final test from this session<br/>\n");
        return rv.msg.toString();
    }

    public String test_two(HttpSession session) {
        Result rv = new Result();
        rv.msg = new StringBuffer();
        StateManagerService service = (StateManagerService)TurbineServices.getInstance().getService("StateManagerService");
        if (service == null) {
            Log.warn("chef", this + ".doPresence(): missing service: " + "StateManagerService");
            rv.msg.append("missing service: StateManagerService<br/>");
            return rv.msg.toString();
        }
        String keyRoot = session.getId() + "key";
        String key1 = keyRoot + "1";
        String attr1 = "attr1";
        String attr2 = "attr2";
        Object attr = service.getAttribute(key1, attr1);
        rv.test("turbine".equals(attr), "attribute1 value not correct");
        attr = service.getAttribute(key1, attr2);
        rv.test(attr instanceof RetireObject, "attribute 2 not correct type");
        if (attr instanceof RetireObject) {
            rv.test(((RetireObject)attr).hasBound(), "attribute 2 not bound");
            rv.test(!((RetireObject)attr).hasUnbound(), "attribute 2 is unbound");
        }
        rv.conclude();
        return rv.msg.toString();
    }

    public String test_three(HttpSession session) {
        Result rv = new Result();
        rv.msg = new StringBuffer();
        StateManagerService service = (StateManagerService)TurbineServices.getInstance().getService("StateManagerService");
        if (service == null) {
            Log.warn("chef", this + ".doPresence(): missing service: " + "StateManagerService");
            rv.msg.append("missing service: StateManagerService<br/>");
            return rv.msg.toString();
        }
        String keyRoot = session.getId() + "key";
        String key1 = keyRoot + "1";
        String attr1 = "attr1";
        rv.test(M_ro == null, "invalid test run, the M_ro has an object already.");
        M_ro = new RetireObject("three/four");
        service.setAttribute(key1, attr1, (Object)M_ro);
        Object attr = service.getAttribute(key1, attr1);
        rv.test(attr instanceof RetireObject, "attribute 1 not correct type");
        if (attr instanceof RetireObject) {
            rv.test(((RetireObject)attr).hasBound(), "attribute 1 not bound");
            rv.test(!((RetireObject)attr).hasUnbound(), "attribute 1 is unbound");
        }
        rv.conclude();
        rv.msg.append("<br/>wait for timeout, then run test four (or check the logs...)<br/>\n");
        int inactive = session.getMaxInactiveInterval();
        session.setMaxInactiveInterval(5);
        rv.msg.append("<br/>inactive changed from: " + inactive + " to 5 seconds <br/>\n");
        return rv.msg.toString();
    }

    public String test_four(HttpSession session) {
        Result rv = new Result();
        rv.msg = new StringBuffer();
        StateManagerService service = (StateManagerService)TurbineServices.getInstance().getService("StateManagerService");
        if (service == null) {
            Log.warn("chef", this + ".doPresence(): missing service: " + "StateManagerService");
            rv.msg.append("missing service: StateManagerService<br/>");
            return rv.msg.toString();
        }
        String keyRoot = session.getId() + "key";
        String key1 = keyRoot + "1";
        String attr1 = "attr1";
        rv.test(M_ro != null, "invalid test run, M_ro has no object");
        Object attr = service.getAttribute(key1, attr1);
        rv.test(attr == null, "attribute1 still there after timeout");
        rv.test(M_ro.hasUnbound(), "M_ro not unbound");
        rv.conclude();
        return rv.msg.toString();
    }

    public String test_five(HttpSession session) {
        Result rv = new Result();
        rv.msg = new StringBuffer();
        StateManagerService service = (StateManagerService)TurbineServices.getInstance().getService("StateManagerService");
        if (service == null) {
            Log.warn("chef", this + ".doPresence(): missing service: " + "StateManagerService");
            rv.msg.append("missing service: StateManagerService<br/>");
            return rv.msg.toString();
        }
        String key = session.getId() + "key";
        String attr = "attr";
        service.setAttribute(key, attr, (Object)"AccessServlet");
        rv.conclude();
        rv.msg.append("<br/>run the access servlet test now...<br/>\n");
        return rv.msg.toString();
    }

    public String test_six(HttpSession session) {
        String attr;
        Result rv = new Result();
        rv.msg = new StringBuffer();
        StateManagerService service = (StateManagerService)TurbineServices.getInstance().getService("StateManagerService");
        if (service == null) {
            Log.warn("chef", this + ".doPresence(): missing service: " + "StateManagerService");
            rv.msg.append("missing service: StateManagerService<br/>");
            return rv.msg.toString();
        }
        String key = session.getId() + "key";
        String value = (String)service.getAttribute(key, attr = "attr");
        rv.test(value != null, "attribute does not exist");
        rv.test(value instanceof String, "attribute not a String");
        rv.test("AccessServlet".equals(value), "attribute value not correct");
        rv.conclude();
        return rv.msg.toString();
    }

    private class RetireObject
    implements SessionStateBindingListener {
        private boolean m_hasBound = false;
        private boolean m_hasUnbound = false;
        private String m_id = null;

        public boolean hasUnbound() {
            return this.m_hasUnbound;
        }

        public boolean hasBound() {
            return this.m_hasBound;
        }

        public RetireObject(String id) {
            this.m_id = id;
        }

        public void valueBound(String sessionStateKey, String attributeName) {
            this.m_hasBound = true;
            Log.info("chef", "RetireObject: " + this.m_id + " bound");
        }

        public void valueUnbound(String sessionStateKey, String attributeName) {
            this.m_hasUnbound = true;
            Log.info("chef", "RetireObject: " + this.m_id + " Unbound");
            try {
                throw new Exception("test");
            }
            catch (Exception e) {
                Log.info("chef", "path to unbound: ", (Throwable)e);
                return;
            }
        }
    }

    private class Result {
        int tests = 0;
        int passed = 0;
        int failed = 0;
        StringBuffer msg = null;

        private Result() {
        }

        void conclude() {
            this.msg.append("Results: " + this.tests + " tests, " + this.passed + " passed, " + this.failed + " failed\n");
        }

        void test(boolean result, String msg) {
            ++this.tests;
            if (result) {
                ++this.passed;
            } else {
                ++this.failed;
                this.msg.append(msg + "<br/>\n");
            }
        }
    }
}

