<?xml version="1.0" encoding="utf-8"?>
<!--
 Copyright (c) 2013 Mathieu Malaterre <malat@debian.org>

 XSLT script to convert an input JNLP file into an output script wrapper (launcher)
-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
  <xsl:output method="text" indent="no" omit-xml-declaration="yes" encoding="utf-8"/>
  <xsl:strip-space elements="*"/>
  <xsl:param name="pixelmed_version"/>
  <xsl:template match="jnlp">
    <xsl:text>#!/bin/sh
</xsl:text>
<xsl:text># generated by jnlp2script.sh
</xsl:text>
<xsl:text>
# </xsl:text>
    <xsl:value-of select="@codebase"/>
<xsl:text>

java -cp /usr/share/java/pixelmed.jar </xsl:text>
    <xsl:value-of select="resources/j2se/@java-vm-args"/>
<xsl:text> </xsl:text>
    <xsl:value-of select="application-desc/@main-class"/>
<xsl:text> "$@"
</xsl:text>
  </xsl:template>
</xsl:stylesheet>
