//============================================================================
// Copyright 2012-2014 J. Craig Venter Institute
// This file is part of PROVEAN.  PROVEAN is free software: you may
// redistribute it and/or modify it under the terms of the GNU General Public
// License version 3.  PROVEAN is distributed in the hope that it will be
// useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
// Public License for more details. You should have received a copy of the GNU
// General Public License along with this program. If not, see
// http://www.gnu.org/licenses/gpl.txt.
//============================================================================
// Name        : ScoreMatrix.h
// Author      : Yongwook Choi
//============================================================================

#ifndef SCOREMATRIX_H_
#define SCOREMATRIX_H_

#include <string>
#include "Common.h"

using namespace std;


#ifndef AA_INDEX_
#define AA_INDEX_

#define MAX_AA 24
#define NA (MAX_AA+1)
#define UN 22

const char idx2aa[] = "ARNDCQEGHILKMFPSTWYVBZX*";

const int aa2idx[] = {
	NA,NA,NA,NA,NA,NA,NA,NA,NA,NA,NA,NA,NA,NA,NA,NA,
	NA,NA,NA,NA,NA,NA,NA,NA,NA,NA,NA,NA,NA,NA,NA,NA,
	NA,NA,NA,NA,NA,NA,NA,NA,NA,NA,23,NA,NA,NA,NA,NA,
	NA,NA,NA,NA,NA,NA,NA,NA,NA,NA,NA,NA,NA,NA,NA,NA,
	NA, 0,20, 4, 3, 6,13, 7, 8, 9,UN,11,10,12, 2,UN,
	14, 5, 1,15,16,UN,19,17,22,18,21,NA,NA,NA,NA,NA,
	NA, 0,20, 4, 3, 6,13, 7, 8, 9,UN,11,10,12, 2,UN,
	14, 5, 1,15,16,UN,19,17,22,18,21,NA,NA,NA,NA,NA,

	NA,NA,NA,NA,NA,NA,NA,NA,NA,NA,NA,NA,NA,NA,NA,NA,
	NA,NA,NA,NA,NA,NA,NA,NA,NA,NA,NA,NA,NA,NA,NA,NA,
	NA,NA,NA,NA,NA,NA,NA,NA,NA,NA,NA,NA,NA,NA,NA,NA,
	NA,NA,NA,NA,NA,NA,NA,NA,NA,NA,NA,NA,NA,NA,NA,NA,
	NA,NA,NA,NA,NA,NA,NA,NA,NA,NA,NA,NA,NA,NA,NA,NA,
	NA,NA,NA,NA,NA,NA,NA,NA,NA,NA,NA,NA,NA,NA,NA,NA,
	NA,NA,NA,NA,NA,NA,NA,NA,NA,NA,NA,NA,NA,NA,NA,NA,
	NA,NA,NA,NA,NA,NA,NA,NA,NA,NA,NA,NA,NA,NA,NA,NA };

const int matrix_blosum_62[MAX_AA][MAX_AA] = {
		// BLOSUM 62
		{ 4, -1, -2, -2,  0, -1, -1,  0, -2, -1, -1, -1, -1, -2, -1,  1,  0, -3, -2,  0, -2, -1,  0, -4},
		{-1,  5,  0, -2, -3,  1,  0, -2,  0, -3, -2,  2, -1, -3, -2, -1, -1, -3, -2, -3, -1,  0, -1, -4},
		{-2,  0,  6,  1, -3,  0,  0,  0,  1, -3, -3,  0, -2, -3, -2,  1,  0, -4, -2, -3,  3,  0, -1, -4},
		{-2, -2,  1,  6, -3,  0,  2, -1, -1, -3, -4, -1, -3, -3, -1,  0, -1, -4, -3, -3,  4,  1, -1, -4},
		{ 0, -3, -3, -3,  9, -3, -4, -3, -3, -1, -1, -3, -1, -2, -3, -1, -1, -2, -2, -1, -3, -3, -2, -4},
		{-1,  1,  0,  0, -3,  5,  2, -2,  0, -3, -2,  1,  0, -3, -1,  0, -1, -2, -1, -2,  0,  3, -1, -4},
		{-1,  0,  0,  2, -4,  2,  5, -2,  0, -3, -3,  1, -2, -3, -1,  0, -1, -3, -2, -2,  1,  4, -1, -4},
		{ 0, -2,  0, -1, -3, -2, -2,  6, -2, -4, -4, -2, -3, -3, -2,  0, -2, -2, -3, -3, -1, -2, -1, -4},
		{-2,  0,  1, -1, -3,  0,  0, -2,  8, -3, -3, -1, -2, -1, -2, -1, -2, -2,  2, -3,  0,  0, -1, -4},
		{-1, -3, -3, -3, -1, -3, -3, -4, -3,  4,  2, -3,  1,  0, -3, -2, -1, -3, -1,  3, -3, -3, -1, -4},
		{-1, -2, -3, -4, -1, -2, -3, -4, -3,  2,  4, -2,  2,  0, -3, -2, -1, -2, -1,  1, -4, -3, -1, -4},
		{-1,  2,  0, -1, -3,  1,  1, -2, -1, -3, -2,  5, -1, -3, -1,  0, -1, -3, -2, -2,  0,  1, -1, -4},
		{-1, -1, -2, -3, -1,  0, -2, -3, -2,  1,  2, -1,  5,  0, -2, -1, -1, -1, -1,  1, -3, -1, -1, -4},
		{-2, -3, -3, -3, -2, -3, -3, -3, -1,  0,  0, -3,  0,  6, -4, -2, -2,  1,  3, -1, -3, -3, -1, -4},
		{-1, -2, -2, -1, -3, -1, -1, -2, -2, -3, -3, -1, -2, -4,  7, -1, -1, -4, -3, -2, -2, -1, -2, -4},
		{ 1, -1,  1,  0, -1,  0,  0,  0, -1, -2, -2,  0, -1, -2, -1,  4,  1, -3, -2, -2,  0,  0,  0, -4},
		{ 0, -1,  0, -1, -1, -1, -1, -2, -2, -1, -1, -1, -1, -2, -1,  1,  5, -2, -2,  0, -1, -1,  0, -4},
		{-3, -3, -4, -4, -2, -2, -3, -2, -2, -3, -2, -3, -1,  1, -4, -3, -2, 11,  2, -3, -4, -3, -2, -4},
		{-2, -2, -2, -3, -2, -1, -2, -3,  2, -1, -1, -2, -1,  3, -3, -2, -2,  2,  7, -1, -3, -2, -1, -4},
		{ 0, -3, -3, -3, -1, -2, -2, -3, -3,  3,  1, -2,  1, -1, -2, -2,  0, -3, -1,  4, -3, -2, -1, -4},
		{-2, -1,  3,  4, -3,  0,  1, -1,  0, -3, -4,  0, -3, -3, -2,  0, -1, -4, -3, -3,  4,  1, -1, -4},
		{-1,  0,  0,  1, -3,  3,  4, -2,  0, -3, -3,  1, -1, -3, -1,  0, -1, -3, -2, -2,  1,  4, -1, -4},
		{ 0, -1, -1, -1, -2, -1, -1, -1, -1, -1, -1, -1, -1, -1, -2,  0,  0, -2, -1, -1, -1, -1, -1, -4},
		{-4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4,  1},
};

const int matrix_blosum_45[MAX_AA][MAX_AA] = {
		// BLOSUM 45
		{  5, -2, -1, -2, -1, -1, -1,  0, -2, -1, -1, -1, -1, -2, -1,  1,  0, -2, -2,  0, -1, -1, -1, -5},
		{ -2,  7,  0, -1, -3,  1,  0, -2,  0, -3, -2,  3, -1, -2, -2, -1, -1, -2, -1, -2, -1,  1, -1, -5},
		{ -1,  0,  6,  2, -2,  0,  0,  0,  1, -2, -3,  0, -2, -2, -2,  1,  0, -4, -2, -3,  5,  0, -1, -5},
		{ -2, -1,  2,  7, -3,  0,  2, -1,  0, -4, -3,  0, -3, -4, -1,  0, -1, -4, -2, -3,  6,  1, -1, -5},
		{ -1, -3, -2, -3, 12, -3, -3, -3, -3, -3, -2, -3, -2, -2, -4, -1, -1, -5, -3, -1, -2, -3, -1, -5},
		{ -1,  1,  0,  0, -3,  6,  2, -2,  1, -2, -2,  1,  0, -4, -1,  0, -1, -2, -1, -3,  0,  4, -1, -5},
		{ -1,  0,  0,  2, -3,  2,  6, -2,  0, -3, -2,  1, -2, -3,  0,  0, -1, -3, -2, -3,  1,  5, -1, -5},
		{  0, -2,  0, -1, -3, -2, -2,  7, -2, -4, -3, -2, -2, -3, -2,  0, -2, -2, -3, -3, -1, -2, -1, -5},
		{ -2,  0,  1,  0, -3,  1,  0, -2, 10, -3, -2, -1,  0, -2, -2, -1, -2, -3,  2, -3,  0,  0, -1, -5},
		{ -1, -3, -2, -4, -3, -2, -3, -4, -3,  5,  2, -3,  2,  0, -2, -2, -1, -2,  0,  3, -3, -3, -1, -5},
		{ -1, -2, -3, -3, -2, -2, -2, -3, -2,  2,  5, -3,  2,  1, -3, -3, -1, -2,  0,  1, -3, -2, -1, -5},
		{ -1,  3,  0,  0, -3,  1,  1, -2, -1, -3, -3,  5, -1, -3, -1, -1, -1, -2, -1, -2,  0,  1, -1, -5},
		{ -1, -1, -2, -3, -2,  0, -2, -2,  0,  2,  2, -1,  6,  0, -2, -2, -1, -2,  0,  1, -2, -1, -1, -5},
		{ -2, -2, -2, -4, -2, -4, -3, -3, -2,  0,  1, -3,  0,  8, -3, -2, -1,  1,  3,  0, -3, -3, -1, -5},
		{ -1, -2, -2, -1, -4, -1,  0, -2, -2, -2, -3, -1, -2, -3,  9, -1, -1, -3, -3, -3, -2, -1, -1, -5},
		{  1, -1,  1,  0, -1,  0,  0,  0, -1, -2, -3, -1, -2, -2, -1,  4,  2, -4, -2, -1,  0,  0, -1, -5},
		{  0, -1,  0, -1, -1, -1, -1, -2, -2, -1, -1, -1, -1, -1, -1,  2,  5, -3, -1,  0,  0, -1, -1, -5},
		{ -2, -2, -4, -4, -5, -2, -3, -2, -3, -2, -2, -2, -2,  1, -3, -4, -3, 15,  3, -3, -4, -2, -1, -5},
		{ -2, -1, -2, -2, -3, -1, -2, -3,  2,  0,  0, -1,  0,  3, -3, -2, -1,  3,  8, -1, -2, -2, -1, -5},
		{  0, -2, -3, -3, -1, -3, -3, -3, -3,  3,  1, -2,  1,  0, -3, -1,  0, -3, -1,  5, -3, -3, -1, -5},
		{ -1, -1,  5,  6, -2,  0,  1, -1,  0, -3, -3,  0, -2, -3, -2,  0,  0, -4, -2, -3,  5,  1, -1, -5},
		{ -1,  1,  0,  1, -3,  4,  5, -2,  0, -3, -2,  1, -1, -3, -1,  0, -1, -2, -2, -3,  1,  5, -1, -5},
		{ -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -5},
		{ -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5,  1},
};

const int matrix_blosum_80[MAX_AA][MAX_AA] = {
		// BLOSUM 80
		{ 5, -2, -2, -2, -1, -1, -1,  0, -2, -2, -2, -1, -1, -3, -1,  1,  0, -3, -2,  0, -2, -1, -1, -6},
		{-2,  6, -1, -2, -4,  1, -1, -3,  0, -3, -3,  2, -2, -4, -2, -1, -1, -4, -3, -3, -1,  0, -1, -6},
		{-2, -1,  6,  1, -3,  0, -1, -1,  0, -4, -4,  0, -3, -4, -3,  0,  0, -4, -3, -4,  5,  0, -1, -6},
		{-2, -2,  1,  6, -4, -1,  1, -2, -2, -4, -5, -1, -4, -4, -2, -1, -1, -6, -4, -4,  5,  1, -1, -6},
		{-1, -4, -3, -4,  9, -4, -5, -4, -4, -2, -2, -4, -2, -3, -4, -2, -1, -3, -3, -1, -4, -4, -1, -6},
		{-1,  1,  0, -1, -4,  6,  2, -2,  1, -3, -3,  1,  0, -4, -2,  0, -1, -3, -2, -3,  0,  4, -1, -6},
		{-1, -1, -1,  1, -5,  2,  6, -3,  0, -4, -4,  1, -2, -4, -2,  0, -1, -4, -3, -3,  1,  5, -1, -6},
		{ 0, -3, -1, -2, -4, -2, -3,  6, -3, -5, -4, -2, -4, -4, -3, -1, -2, -4, -4, -4, -1, -3, -1, -6},
		{-2,  0,  0, -2, -4,  1,  0, -3,  8, -4, -3, -1, -2, -2, -3, -1, -2, -3,  2, -4, -1,  0, -1, -6},
		{-2, -3, -4, -4, -2, -3, -4, -5, -4,  5,  1, -3,  1, -1, -4, -3, -1, -3, -2,  3, -4, -4, -1, -6},
		{-2, -3, -4, -5, -2, -3, -4, -4, -3,  1,  4, -3,  2,  0, -3, -3, -2, -2, -2,  1, -4, -3, -1, -6},
		{-1,  2,  0, -1, -4,  1,  1, -2, -1, -3, -3,  5, -2, -4, -1, -1, -1, -4, -3, -3, -1,  1, -1, -6},
		{-1, -2, -3, -4, -2,  0, -2, -4, -2,  1,  2, -2,  6,  0, -3, -2, -1, -2, -2,  1, -3, -1, -1, -6},
		{-3, -4, -4, -4, -3, -4, -4, -4, -2, -1,  0, -4,  0,  6, -4, -3, -2,  0,  3, -1, -4, -4, -1, -6},
		{-1, -2, -3, -2, -4, -2, -2, -3, -3, -4, -3, -1, -3, -4,  8, -1, -2, -5, -4, -3, -2, -2, -1, -6},
		{ 1, -1,  0, -1, -2,  0,  0, -1, -1, -3, -3, -1, -2, -3, -1,  5,  1, -4, -2, -2,  0,  0, -1, -6},
		{ 0, -1,  0, -1, -1, -1, -1, -2, -2, -1, -2, -1, -1, -2, -2,  1,  5, -4, -2,  0, -1, -1, -1, -6},
		{-3, -4, -4, -6, -3, -3, -4, -4, -3, -3, -2, -4, -2,  0, -5, -4, -4, 11,  2, -3, -5, -3, -1, -6},
		{-2, -3, -3, -4, -3, -2, -3, -4,  2, -2, -2, -3, -2,  3, -4, -2, -2,  2,  7, -2, -3, -3, -1, -6},
		{ 0, -3, -4, -4, -1, -3, -3, -4, -4,  3,  1, -3,  1, -1, -3, -2,  0, -3, -2,  4, -4, -3, -1, -6},
		{-2, -1,  5,  5, -4,  0,  1, -1, -1, -4, -4, -1, -3, -4, -2,  0, -1, -5, -3, -4,  5,  0, -1, -6},
		{-1,  0,  0,  1, -4,  4,  5, -3,  0, -4, -3,  1, -1, -4, -2,  0, -1, -3, -3, -3,  0,  5, -1, -6},
		{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -6},
		{-6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6,  1},
};

const int matrix_pam_250[MAX_AA][MAX_AA] = {
		// PAM 250
		{  2, -2,  0,  0, -2,  0,  0,  1, -1, -1, -2, -1, -1, -3,  1,  1,  1, -6, -3,  0,  0,  0,  0, -8},
		{ -2,  6,  0, -1, -4,  1, -1, -3,  2, -2, -3,  3,  0, -4,  0,  0, -1,  2, -4, -2, -1,  0, -1, -8},
		{  0,  0,  2,  2, -4,  1,  1,  0,  2, -2, -3,  1, -2, -3,  0,  1,  0, -4, -2, -2,  2,  1,  0, -8},
		{  0, -1,  2,  4, -5,  2,  3,  1,  1, -2, -4,  0, -3, -6, -1,  0,  0, -7, -4, -2,  3,  3, -1, -8},
		{ -2, -4, -4, -5, 12, -5, -5, -3, -3, -2, -6, -5, -5, -4, -3,  0, -2, -8,  0, -2, -4, -5, -3, -8},
		{  0,  1,  1,  2, -5,  4,  2, -1,  3, -2, -2,  1, -1, -5,  0, -1, -1, -5, -4, -2,  1,  3, -1, -8},
		{  0, -1,  1,  3, -5,  2,  4,  0,  1, -2, -3,  0, -2, -5, -1,  0,  0, -7, -4, -2,  3,  3, -1, -8},
		{  1, -3,  0,  1, -3, -1,  0,  5, -2, -3, -4, -2, -3, -5,  0,  1,  0, -7, -5, -1,  0,  0, -1, -8},
		{ -1,  2,  2,  1, -3,  3,  1, -2,  6, -2, -2,  0, -2, -2,  0, -1, -1, -3,  0, -2,  1,  2, -1, -8},
		{ -1, -2, -2, -2, -2, -2, -2, -3, -2,  5,  2, -2,  2,  1, -2, -1,  0, -5, -1,  4, -2, -2, -1, -8},
		{ -2, -3, -3, -4, -6, -2, -3, -4, -2,  2,  6, -3,  4,  2, -3, -3, -2, -2, -1,  2, -3, -3, -1, -8},
		{ -1,  3,  1,  0, -5,  1,  0, -2,  0, -2, -3,  5,  0, -5, -1,  0,  0, -3, -4, -2,  1,  0, -1, -8},
		{ -1,  0, -2, -3, -5, -1, -2, -3, -2,  2,  4,  0,  6,  0, -2, -2, -1, -4, -2,  2, -2, -2, -1, -8},
		{ -3, -4, -3, -6, -4, -5, -5, -5, -2,  1,  2, -5,  0,  9, -5, -3, -3,  0,  7, -1, -4, -5, -2, -8},
		{  1,  0,  0, -1, -3,  0, -1,  0,  0, -2, -3, -1, -2, -5,  6,  1,  0, -6, -5, -1, -1,  0, -1, -8},
		{  1,  0,  1,  0,  0, -1,  0,  1, -1, -1, -3,  0, -2, -3,  1,  2,  1, -2, -3, -1,  0,  0,  0, -8},
		{  1, -1,  0,  0, -2, -1,  0,  0, -1,  0, -2,  0, -1, -3,  0,  1,  3, -5, -3,  0,  0, -1,  0, -8},
		{ -6,  2, -4, -7, -8, -5, -7, -7, -3, -5, -2, -3, -4,  0, -6, -2, -5, 17,  0, -6, -5, -6, -4, -8},
		{ -3, -4, -2, -4,  0, -4, -4, -5,  0, -1, -1, -4, -2,  7, -5, -3, -3,  0, 10, -2, -3, -4, -2, -8},
		{  0, -2, -2, -2, -2, -2, -2, -1, -2,  4,  2, -2,  2, -1, -1, -1,  0, -6, -2,  4, -2, -2, -1, -8},
		{  0, -1,  2,  3, -4,  1,  3,  0,  1, -2, -3,  1, -2, -4, -1,  0,  0, -5, -3, -2,  3,  2, -1, -8},
		{  0,  0,  1,  3, -5,  3,  3,  0,  2, -2, -3,  0, -2, -5,  0,  0, -1, -6, -4, -2,  2,  3, -1, -8},
		{  0, -1,  0, -1, -3, -1, -1, -1, -1, -1, -1, -1, -1, -2, -1,  0,  0, -4, -2, -1, -1, -1, -1, -8},
		{ -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8,  1},
};

const int matrix_pam_160[MAX_AA][MAX_AA] = {
		// PAM 160
		{  2, -2,  0,  0, -2, -1,  0,  1, -2, -1, -2, -2, -1, -3,  1,  1,  1, -5, -3,  0,  0,  0,  0, -7},
		{ -2,  6, -1, -2, -3,  1, -2, -3,  1, -2, -3,  3, -1, -4, -1, -1, -1,  1, -4, -3, -1,  0, -1, -7},
		{  0, -1,  3,  2, -4,  0,  1,  0,  2, -2, -3,  1, -2, -3, -1,  1,  0, -4, -2, -2,  2,  1,  0, -7},
		{  0, -2,  2,  4, -5,  1,  3,  0,  0, -3, -4,  0, -3, -6, -2,  0, -1, -6, -4, -3,  3,  2, -1, -7},
		{ -2, -3, -4, -5,  9, -5, -5, -3, -3, -2, -6, -5, -5, -5, -3,  0, -2, -7,  0, -2, -4, -5, -3, -7},
		{ -1,  1,  0,  1, -5,  5,  2, -2,  2, -2, -2,  0, -1, -5,  0, -1, -1, -5, -4, -2,  1,  3, -1, -7},
		{  0, -2,  1,  3, -5,  2,  4,  0,  0, -2, -3, -1, -2, -5, -1,  0, -1, -7, -4, -2,  2,  3, -1, -7},
		{  1, -3,  0,  0, -3, -2,  0,  4, -3, -3, -4, -2, -3, -4, -1,  1, -1, -7, -5, -2,  0, -1, -1, -7},
		{ -2,  1,  2,  0, -3,  2,  0, -3,  6, -3, -2, -1, -3, -2, -1, -1, -2, -3,  0, -2,  1,  1, -1, -7},
		{ -1, -2, -2, -3, -2, -2, -2, -3, -3,  5,  2, -2,  2,  0, -2, -2,  0, -5, -2,  3, -2, -2, -1, -7},
		{ -2, -3, -3, -4, -6, -2, -3, -4, -2,  2,  5, -3,  3,  1, -3, -3, -2, -2, -2,  1, -4, -3, -2, -7},
		{ -2,  3,  1,  0, -5,  0, -1, -2, -1, -2, -3,  4,  0, -5, -2, -1,  0, -4, -4, -3,  0,  0, -1, -7},
		{ -1, -1, -2, -3, -5, -1, -2, -3, -3,  2,  3,  0,  7,  0, -2, -2, -1, -4, -3,  1, -3, -2, -1, -7},
		{ -3, -4, -3, -6, -5, -5, -5, -4, -2,  0,  1, -5,  0,  7, -4, -3, -3, -1,  5, -2, -4, -5, -3, -7},
		{  1, -1, -1, -2, -3,  0, -1, -1, -1, -2, -3, -2, -2, -4,  5,  1,  0, -5, -5, -2, -1, -1, -1, -7},
		{  1, -1,  1,  0,  0, -1,  0,  1, -1, -2, -3, -1, -2, -3,  1,  2,  1, -2, -3, -1,  0, -1,  0, -7},
		{  1, -1,  0, -1, -2, -1, -1, -1, -2,  0, -2,  0, -1, -3,  0,  1,  3, -5, -3,  0,  0, -1,  0, -7},
		{ -5,  1, -4, -6, -7, -5, -7, -7, -3, -5, -2, -4, -4, -1, -5, -2, -5, 12, -1, -6, -5, -6, -4, -7},
		{ -3, -4, -2, -4,  0, -4, -4, -5,  0, -2, -2, -4, -3,  5, -5, -3, -3, -1,  8, -3, -3, -4, -3, -7},
		{  0, -3, -2, -3, -2, -2, -2, -2, -2,  3,  1, -3,  1, -2, -2, -1,  0, -6, -3,  4, -2, -2, -1, -7},
		{  0, -1,  2,  3, -4,  1,  2,  0,  1, -2, -4,  0, -3, -4, -1,  0,  0, -5, -3, -2,  3,  2, -1, -7},
		{  0,  0,  1,  2, -5,  3,  3, -1,  1, -2, -3,  0, -2, -5, -1, -1, -1, -6, -4, -2,  2,  3, -1, -7},
		{  0, -1,  0, -1, -3, -1, -1, -1, -1, -1, -2, -1, -1, -3, -1,  0,  0, -4, -3, -1, -1, -1, -1, -7},
		{ -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7,  1},
};

const int matrix_rblosum_64[MAX_AA][MAX_AA] = {
		// RBLOSUM 64
		{ 4, -2, -1, -2, -1, -1, -1,  0, -2, -1, -2, -1, -1, -2, -1,  1,  0, -3, -2,  0, -2, -1, -1, -4},
		{-2,  5,  0, -2, -3,  1,  0, -2,  0, -3, -2,  2, -2, -3, -2, -1, -1, -2, -2, -3, -1,  0, -1, -4},
		{-1,  0,  6,  1, -3,  0,  0, -1,  1, -3, -3,  0, -2, -3, -2,  0,  0, -3, -2, -3,  3,  0, -1, -4},
		{-2, -2,  1,  6, -3,  0,  2, -2, -1, -3, -3, -1, -3, -3, -2,  0, -1, -4, -3, -3,  4,  1, -1, -4},
		{-1, -3, -3, -3,  9, -3, -4, -3, -2, -1, -1, -3, -1, -2, -3, -1, -1, -3, -2, -1, -3, -3, -2, -4},
		{-1,  1,  0,  0, -3,  5,  2, -2,  1, -3, -2,  1,  0, -3, -1,  0,  0, -2, -2, -2,  0,  3, -1, -4},
		{-1,  0,  0,  2, -4,  2,  5, -2,  0, -3, -3,  1, -2, -3, -1,  0, -1, -3, -2, -2,  1,  4, -1, -4},
		{ 0, -2, -1, -2, -3, -2, -2,  6, -2, -4, -4, -2, -3, -3, -2, -1, -2, -2, -3, -3, -1, -2, -2, -4},
		{-2,  0,  1, -1, -2,  1,  0, -2,  7, -3, -3, -1, -1, -1, -2, -1, -2, -1,  1, -3,  0,  0, -1, -4},
		{-1, -3, -3, -3, -1, -3, -3, -4, -3,  4,  2, -3,  1,  0, -3, -2, -1, -2, -1,  2, -3, -3, -1, -4},
		{-2, -2, -3, -3, -1, -2, -3, -4, -3,  2,  4, -2,  2,  1, -3, -2, -1, -1, -1,  1, -3, -2, -1, -4},
		{-1,  2,  0, -1, -3,  1,  1, -2, -1, -3, -2,  5, -1, -3, -1,  0, -1, -3, -2, -2,  0,  1, -1, -4},
		{-1, -2, -2, -3, -1,  0, -2, -3, -1,  1,  2, -1,  6,  0, -2, -1, -1, -2, -1,  0, -2, -1, -1, -4},
		{-2, -3, -3, -3, -2, -3, -3, -3, -1,  0,  1, -3,  0,  6, -3, -2, -2,  1,  3, -1, -3, -3, -1, -4},
		{-1, -2, -2, -2, -3, -1, -1, -2, -2, -3, -3, -1, -2, -3,  7, -1, -1, -3, -3, -2, -2, -1, -2, -4},
		{ 1, -1,  0,  0, -1,  0,  0, -1, -1, -2, -2,  0, -1, -2, -1,  4,  1, -3, -2, -2,  0,  0, -1, -4},
		{ 0, -1,  0, -1, -1,  0, -1, -2, -2, -1, -1, -1, -1, -2, -1,  1,  5, -3, -2,  0, -1, -1, -1, -4},
		{-3, -2, -3, -4, -3, -2, -3, -2, -1, -2, -1, -3, -2,  1, -3, -3, -3, 11,  2, -3, -3, -3, -2, -4},
		{-2, -2, -2, -3, -2, -2, -2, -3,  1, -1, -1, -2, -1,  3, -3, -2, -2,  2,  7, -1, -2, -2, -1, -4},
		{ 0, -3, -3, -3, -1, -2, -2, -3, -3,  2,  1, -2,  0, -1, -2, -2,  0, -3, -1,  4, -3, -2, -1, -4},
		{-2, -1,  3,  4, -3,  0,  1, -1,  0, -3, -3,  0, -2, -3, -2,  0, -1, -3, -2, -3,  4,  0, -1, -4},
		{-1,  0,  0,  1, -3,  3,  4, -2,  0, -3, -2,  1, -1, -3, -1,  0, -1, -3, -2, -2,  0,  3, -1, -4},
		{-1, -1, -1, -1, -2, -1, -1, -2, -1, -1, -1, -1, -1, -1, -2, -1, -1, -2, -1, -1, -1, -1, -1, -4},
		{-4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4,  1},
};

#endif /* AA_INDEX_ */

class ScoreMatrix {
public:
	ScoreMatrix();
	virtual ~ScoreMatrix();

	void SetScoreMatrix(string matrix_name, int gap_open, int gap_extend);

	int gap_open_;	// negative
	int gap_extend_;	// negative
	string matrix_name_;
	int matrix_[MAX_AA][MAX_AA];

};

#endif /* SCOREMATRIX_H_ */
