% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SomParam.R
\docType{class}
\name{SomParam-class}
\alias{SomParam-class}
\alias{show,SomParam-method}
\alias{SomParam}
\alias{clusterRows,ANY,SomParam-method}
\title{Clustering with self-organizing maps}
\usage{
SomParam(
  centers,
  dim.ratio = 1,
  topo = "rectangular",
  neighbourhood.fct = "bubble",
  toroidal = FALSE,
  rlen = 100,
  alpha = c(0.05, 0.01),
  radius = NULL,
  dist.fct = "sumofsquares"
)

\S4method{clusterRows}{ANY,SomParam}(x, BLUSPARAM, full = FALSE)
}
\arguments{
\item{centers}{An integer scalar specifying the number of centers.
Alternatively, a function that takes the number of observations and returns the number of centers.}

\item{dim.ratio}{A positive numeric scalar in specifying how \code{centers} should be distributed between the \code{x} and \code{y} dimensions.
Defaults to equal distribution, i.e., both dimensions will be of length equal to the square root of \code{centers}.
Values above 1 will distribute more nodes to \code{x} while values below 1 will distribute mode nodes to \code{y}.}

\item{topo, neighbourhood.fct, toroidal}{Further arguments to pass to the \code{\link[kohonen]{somgrid}} function in the \pkg{kohonen} package.}

\item{rlen, alpha, radius, dist.fct}{Further arguments to pass to the \code{\link[kohonen]{som}} function in the \pkg{kohonen} package.}

\item{x}{A numeric matrix-like object where rows represent observations and columns represent variables.}

\item{BLUSPARAM}{A \linkS4class{SomParam} object.}

\item{full}{Logical scalar indicating whether the full SOM statistics should be returned.}
}
\value{
The \code{SomParam} constructor will return a \linkS4class{SomParam} object with the specified parameters.

The \code{clusterRows} method will return a factor of length equal to \code{nrow(x)} containing the cluster assignments.
If \code{full=TRUE}, a list is returned with \code{clusters} (the factor, as above) and \code{objects}
(a list containing \code{som}, the direct output of \code{\link[kohonen]{som}}).
}
\description{
Use the self-organizing map implementation in the \pkg{kohonen} package to cluster observations into the specified number of nodes.
Note that this requires the installation of the \pkg{kohonen} package.
}
\details{
This class usually requires the user to specify the number of clusters beforehand.
However, we can also allow the number of clusters to vary as a function of the number of observations.
The latter is occasionally useful, e.g., to allow the clustering to automatically become more granular for large datasets.

Note that the final number of clusters may not be exactly equal to \code{centers}, depending on how \code{dim.ratio} is specified.
For example, if \code{centers} is a perfect square and \code{dim.ratio=1}, we will get exactly the requested number of points.

To modify an existing SomParam object \code{x},
users can simply call \code{x[[i]]} or \code{x[[i]] <- value} where \code{i} is any argument used in the constructor.

For \code{radius}, a value of \code{NULL} means that the default argument in the \code{\link[kohonen]{som}} function signature is used.
This is are data-dependent and so cannot be specified during construction of the SomParam object.

For \code{dist.fct}, users can specify any string that can be used in the \code{dist.fcts} arguments in \code{\link[kohonen]{som}}.
In practice, the only real alternative is \code{"manhattan"}.
}
\examples{
clusterRows(iris[,1:4], SomParam(centers=16))
clusterRows(iris[,1:4], SomParam(centers=12, dim.ratio=3/4))

}
\seealso{
\code{\link[kohonen]{som}} from the \pkg{kohonen} package, which does all of the heavy lifting.

\linkS4class{FixedNumberParam}, the parent of the SomParam class.
}
\author{
Aaron Lun
}
