% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BiomartGeneRegionTrack-class.R
\docType{class}
\name{BiomartGeneRegionTrack-class}
\alias{BiomartGeneRegionTrack-class}
\alias{initialize,BiomartGeneRegionTrack-method}
\alias{BiomartGeneRegionTrack}
\alias{subset,BiomartGeneRegionTrack-method}
\title{BiomartGeneRegionTrack class and methods}
\usage{
\S4method{initialize}{BiomartGeneRegionTrack}(
  .Object,
  start = NULL,
  end = NULL,
  biomart,
  filter = list(),
  range,
  genome = NULL,
  chromosome = NULL,
  strand = NULL,
  featureMap = NULL,
  symbol = NULL,
  gene = NULL,
  transcript = NULL,
  entrez = NULL,
  ...
)

BiomartGeneRegionTrack(
  start = NULL,
  end = NULL,
  biomart,
  chromosome = NULL,
  strand,
  genome = NULL,
  stacking = "squish",
  filters = list(),
  featureMap = NULL,
  name = "BiomartGeneRegionTrack",
  symbol = NULL,
  gene = NULL,
  entrez = NULL,
  transcript = NULL,
  ...
)

\S4method{subset}{BiomartGeneRegionTrack}(x, from, to, chromosome, use.defaults = TRUE, ...)
}
\arguments{
\item{.Object}{.Object}

\item{start}{An integer scalar with the genomic start coordinates for the
gene model range.}

\item{end}{An integer scalar with the genomic end coordinates for the gene
model range.}

\item{biomart}{An optional \code{\linkS4class{Mart}} object providing access
to the EBI Biomart webservice. As default the appropriate Ensembl data
source is selected based on the provided genome and chromosome.}

\item{filter}{filter}

\item{range}{range}

\item{genome}{The genome on which the track's ranges are defined. Usually
this is a valid UCSC genome identifier, however this is not being formally
checked at this point. If no mapping from genome to Biomart Ensembl data
source is possible, the \code{biomart} argument needs to be provided by the
user.}

\item{chromosome}{The chromosome on which the track's genomic ranges are
defined. A valid UCSC chromosome identifier. Please note that at this stage
only syntactic checking takes place, i.e., the argument value needs to be a
single integer, numeric character or a character of the form \code{chrx},
where \code{x} may be any possible string. The user has to make sure that
the respective chromosome is indeed defined for the the track's genome.}

\item{strand}{Character scalar, the strand for which to fetch gene
information from Biomart. One in \code{+}, \code{-}, or \code{+-}.}

\item{featureMap}{Named character vector or list to map between the fields
in the Biomart data base and the features as they are used to construct the
track. If multiple values are provided in a single list item, the package
will use the first one that is defined in the selected Biomart.}

\item{symbol, transcript, gene, entrez}{Character vector giving one or several
gene symbols, Ensembl transcript identifiers, Ensembl gene identifiers, or
ENTREZ gene identifiers, respectively. The genomic locus of their gene model
will be fetch from Biomart instead of providing explicit start and end
coordinates.}

\item{\dots}{Additional items which will all be interpreted as further
display parameters. See \code{\link{settings}} and the "Display Parameters"
section below for details.}

\item{stacking}{The stacking type for overlapping items of the track. One in
\code{c(hide, dense, squish, pack,full)}. Currently, only hide (don't show
the track items, squish (make best use of the available space) and dense (no
stacking at all) are implemented.}

\item{filters}{A list of additional filters to be applied in the Biomart
query. See \code{\link{getBM}} for details.}

\item{name}{Character scalar of the track's name used in the title panel
when plotting.}

\item{x}{A valid track object class name, or the object itself, in which
case the class is derived directly from it.}

\item{from, to}{from, to}

\item{use.defaults}{\code{logical}}
}
\value{
The return value of the constructor function is a new object of class
\code{BiomartGeneRegionTrack}.
}
\description{
A class to hold gene model data for a genomic region fetched dynamically
from EBI's Biomart Ensembl data source.
}
\details{
A track containing all gene models in a particular region as fetched from
EBI's Biomart service. Usually the user does not have to take care of the
Biomart connection, which will be established automatically based on the
provided genome and chromosome information. However, for full flexibility a
valid \code{\linkS4class{Mart}} object may be passed on to the constructor.
Please note that this assumes a connection to one of the Ensembl gene data
sources, mapping the available query data back to the internal object slots.
}
\section{Functions}{
\itemize{
\item \code{initialize(BiomartGeneRegionTrack)}: Initialize.

\item \code{BiomartGeneRegionTrack()}: Constructor function for
\code{BiomartGeneRegionTrack-class}.

\item \code{subset(BiomartGeneRegionTrack)}: subset a \code{BiomartGeneRegionTrack}
by coordinates and sort if necessary.

}}
\section{Objects from the class}{


Objects can be created using the constructor function
\code{BiomartGeneRegionTrack}.
}

\examples{
\dontshow{
## Load some sample data
data(bmTrack)
}

## Construct the object
\dontrun{
bmTrack <- BiomartGeneRegionTrack(
    start = 26682683, end = 26711643,
    chromosome = 7, genome = "mm9"
)
}

\dontshow{
## For some annoying reason the postscript device does not know about
## the sans font
if (!interactive()) {
    font <- ps.options()$family
    displayPars(bmTrack) <- list(fontfamily = font, fontfamily.title = font)
}
}

## Plotting
plotTracks(bmTrack)

## Track names
names(bmTrack)
names(bmTrack) <- "foo"
plotTracks(bmTrack)

## Subsetting and splitting
subTrack <- subset(bmTrack, from = 26700000, to = 26705000)
length(subTrack)
subTrack <- bmTrack[transcript(bmTrack) == "ENSMUST00000144140"]
split(bmTrack, transcript(bmTrack))

## Accessors
start(bmTrack)
end(bmTrack)
width(bmTrack)
position(bmTrack)
width(subTrack) <- width(subTrack) + 100

strand(bmTrack)
strand(subTrack) <- "-"

chromosome(bmTrack)
chromosome(subTrack) <- "chrX"

genome(bmTrack)
genome(subTrack) <- "hg19"

range(bmTrack)
ranges(bmTrack)

## Annotation
identifier(bmTrack)
identifier(bmTrack, "lowest")
identifier(subTrack) <- "bar"

feature(bmTrack)
feature(subTrack) <- "foo"

exon(bmTrack)
exon(subTrack) <- letters[1:2]

gene(bmTrack)
gene(subTrack) <- "bar"

symbol(bmTrack)
symbol(subTrack) <- "foo"

transcript(bmTrack)
transcript(subTrack) <- c("foo", "bar")
chromosome(subTrack) <- "chr7"
plotTracks(subTrack)

values(bmTrack)

## Grouping
group(bmTrack)
group(subTrack) <- "Group 1"
transcript(subTrack)
plotTracks(subTrack)

## Stacking
stacking(bmTrack)
stacking(bmTrack) <- "dense"
plotTracks(bmTrack)

## coercion
as(bmTrack, "data.frame")
as(bmTrack, "UCSCData")

## HTML image map
coords(bmTrack)
tags(bmTrack)
bmTrack <- plotTracks(bmTrack)$foo
coords(bmTrack)
tags(bmTrack)
}
\references{
EBI Biomart webservice at \url{http://www.biomart.org}.
}
\seealso{
\code{\linkS4class{DisplayPars}}

\code{\linkS4class{GdObject}}

\code{\linkS4class{GRanges}}

\code{\linkS4class{HighlightTrack}}

\code{\linkS4class{ImageMap}}

\code{\linkS4class{IRanges}}

\code{\linkS4class{RangeTrack}}

\code{\linkS4class{DataTrack}}

\code{\link{collapsing}}

\code{\link{grouping}}

\code{\link{panel.grid}}

\code{\link{plotTracks}}

\code{\link{settings}}
}
\author{
Florian Hahne
}
