% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/H5R.R
\name{H5Rget_region}
\alias{H5Rget_region}
\title{Return selection for a reference to dataset region}
\usage{
H5Rget_region(ref, h5loc)
}
\arguments{
\item{ref}{An object of class \code{H5Ref}.  This function is only valid
for reference of type \code{H5R_DATASET_REGION}, and not \code{H5R_OBJECT}.}

\item{h5loc}{An \code{H5IdComponent} object representing the file containing the
referenced object.}
}
\value{
An object of class \code{H5IdComponent} representing the dataspace of the
dataset that \code{ref} points to.  The dataspace will have the selection set
that matches the selection pointed to by \code{ref}. This should be closed using
\code{\link[=H5Sclose]{H5Sclose()}} when no longer required.
}
\description{
Given a dataset region reference, this function will return the dataspace
and selection required to read the data points indicated by the reference.
}
