% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create.R
\name{create}
\alias{create}
\alias{file_create}
\alias{dir_create}
\alias{link_create}
\title{Create files, directories, or links}
\usage{
file_create(path, ..., mode = "u=rw,go=r")

dir_create(path, ..., mode = "u=rwx,go=rx", recurse = TRUE, recursive)

link_create(path, new_path, symbolic = TRUE)
}
\arguments{
\item{path}{A character vector of one or more paths.}

\item{...}{Additional arguments passed to \code{\link[=path]{path()}}}

\item{mode}{If file/directory is created, what mode should it have?

Links do not have mode; they inherit the mode of the file they link to.}

\item{recurse}{should intermediate directories be created if they do not
exist?}

\item{recursive}{(Deprecated) If \code{TRUE} recurse fully.}

\item{new_path}{The path where the link should be created.}

\item{symbolic}{Boolean value determining if the link should be a symbolic
(the default) or hard link.}
}
\value{
The path to the created object (invisibly).
}
\description{
These functions ensure that \code{path} exists; if it already exists it will
be left unchanged. That means that compared to \code{\link[=file.create]{file.create()}},
\code{file_create()} will not truncate an existing file, and compared to
\code{\link[=dir.create]{dir.create()}}, \code{dir_create()} will silently ignore
existing directories.
}
\examples{
\dontshow{.old_wd <- setwd(tempdir())}
file_create("foo")
is_file("foo")
# dir_create applied to the same path will fail
try(dir_create("foo"))

dir_create("bar")
is_dir("bar")
# file_create applied to the same path will fail
try(file_create("bar"))

# Cleanup
file_delete("foo")
dir_delete("bar")
\dontshow{setwd(.old_wd)}
}
