% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discrete-survival-haplo.R
\name{interval.logitsurv.discrete}
\alias{interval.logitsurv.discrete}
\alias{Interval}
\alias{dInterval}
\alias{simlogitSurvd}
\alias{predictlogitSurvd}
\title{Discrete time to event interval censored data}
\usage{
interval.logitsurv.discrete(
  formula,
  data,
  beta = NULL,
  no.opt = FALSE,
  method = "NR",
  stderr = TRUE,
  weights = NULL,
  offsets = NULL,
  exp.link = 1,
  increment = 1,
  ...
)
}
\arguments{
\item{formula}{formula}

\item{data}{data}

\item{beta}{starting values}

\item{no.opt}{optimization TRUE/FALSE}

\item{method}{NR, nlm}

\item{stderr}{to return only estimate}

\item{weights}{weights following id for GLM}

\item{offsets}{following id  for GLM}

\item{exp.link}{parametrize increments exp(alpha) > 0}

\item{increment}{using increments dG(t)=exp(alpha) as parameters}

\item{...}{Additional arguments to lower level funtions lava::NR  optimizer or nlm}
}
\description{
\deqn{
   logit(P(T >t | x)) = log(G(t)) + x \beta
}
\deqn{
   P(T >t | x) =  \frac{1}{1 + G(t) exp( x \beta) }
}
}
\details{
This is thus also the cumulative odds model, since 
\deqn{
   P(T \leq t | x) =  \frac{G(t) \exp(x \beta) }{1 + G(t) exp( x \beta) }
}

The baseline \eqn{G(t)} is written as \eqn{cumsum(exp(\alpha))} and this is not the standard
parametrization that takes log of \eqn{G(t)} as the parameters.

Input are intervals given by ]t_l,t_r] where t_r can be infinity for right-censored intervals 
When truly discrete ]0,1] will be an observation at 1, and  ]j,j+1] will be an observation at j+1

Likelihood is maximized:
\deqn{
 \prod  P(T_i >t_{il} | x) - P(T_i> t_{ir}| x) 
}
}
\examples{
data(ttpd) 
dtable(ttpd,~entry+time2)
out <- interval.logitsurv.discrete(Interval(entry,time2)~X1+X2+X3+X4,ttpd)
summary(out)

pred <- predictlogitSurvd(out,se=FALSE)
plotSurvd(pred)

}
\author{
Thomas Scheike
}
