#! /usr/bin/env python

'''
Python Interface to SAGA Tools Library
----------
- Category : Terrain Analysis
- Name     : Compound Analyses
- ID       : ta_compound

Description
----------
Terrain Analysis: Compound Analyses.
This library depends on the following SAGA tool libraries:
- ta_channels
- ta_flow
- ta_indices
- ta_lighting
- ta_morphometry
- ta_preproc

'''

from PySAGA.helper import Tool_Wrapper

def Run_Basic_Terrain_Analysis(ELEVATION=None, SHADE=None, SLOPE=None, ASPECT=None, HCURV=None, VCURV=None, CONVERGENCE=None, SINKS=None, FLOW=None, WETNESS=None, LSFACTOR=None, CHANNELS=None, BASINS=None, CHNL_BASE=None, CHNL_DIST=None, VALL_DEPTH=None, RSP=None, THRESHOLD=None, Verbose=2):
    '''
    Basic Terrain Analysis
    ----------
    [ta_compound.0]\n
    A selection of basic parameters and objects to be derived from a Digital Terrain Model using standard settings.\n
    Arguments
    ----------
    - ELEVATION [`input grid`] : Elevation
    - SHADE [`output grid`] : Analytical Hillshading
    - SLOPE [`output grid`] : Slope
    - ASPECT [`output grid`] : Aspect
    - HCURV [`output grid`] : Plan Curvature
    - VCURV [`output grid`] : Profile Curvature
    - CONVERGENCE [`output grid`] : Convergence Index
    - SINKS [`output grid`] : Closed Depressions
    - FLOW [`output grid`] : Total Catchment Area
    - WETNESS [`output grid`] : Topographic Wetness Index
    - LSFACTOR [`output grid`] : LS-Factor
    - CHANNELS [`output shapes`] : Channel Network
    - BASINS [`output shapes`] : Drainage Basins
    - CHNL_BASE [`output grid`] : Channel Network Base Level
    - CHNL_DIST [`output grid`] : Channel Network Distance
    - VALL_DEPTH [`output grid`] : Valley Depth
    - RSP [`output grid`] : Relative Slope Position
    - THRESHOLD [`integer number`] : Channel Density. Minimum: 1 Default: 5 Strahler order to begin a channel.

    - Verbose [`integer number`] : Verbosity level, 0=silent, 1=tool name and success notification, 2=complete tool output.\n
    Returns
    ----------
    `boolean` : `True` on success, `False` on failure.
    '''
    Tool = Tool_Wrapper('ta_compound', '0', 'Basic Terrain Analysis')
    if Tool.is_Okay():
        Tool.Set_Input ('ELEVATION', ELEVATION)
        Tool.Set_Output('SHADE', SHADE)
        Tool.Set_Output('SLOPE', SLOPE)
        Tool.Set_Output('ASPECT', ASPECT)
        Tool.Set_Output('HCURV', HCURV)
        Tool.Set_Output('VCURV', VCURV)
        Tool.Set_Output('CONVERGENCE', CONVERGENCE)
        Tool.Set_Output('SINKS', SINKS)
        Tool.Set_Output('FLOW', FLOW)
        Tool.Set_Output('WETNESS', WETNESS)
        Tool.Set_Output('LSFACTOR', LSFACTOR)
        Tool.Set_Output('CHANNELS', CHANNELS)
        Tool.Set_Output('BASINS', BASINS)
        Tool.Set_Output('CHNL_BASE', CHNL_BASE)
        Tool.Set_Output('CHNL_DIST', CHNL_DIST)
        Tool.Set_Output('VALL_DEPTH', VALL_DEPTH)
        Tool.Set_Output('RSP', RSP)
        Tool.Set_Option('THRESHOLD', THRESHOLD)
        return Tool.Execute(Verbose)
    return False

