# Call for testing Silkaj v0.10.0rc

Hey fellow testers and early-adopters!

We are pleased to announce Silkaj v0.10.0 release candidate, and we would be happy to receive feedback before releasing it as stable.

## Pre-release installation

You can install this pre-release version from PyPI or from a Docker image.
To install the Python package, run following command:

```bash
pip3 install silkaj --user --upgrade --pre
```

To [install and run Silkaj from the Docker image](doc/docker.md):

```bash
sudo docker pull registry.duniter.org/clients/python/silkaj/release/pip:v0.10.0rc0
```

Run Silkaj from outside the image:

```bash
sudo docker run -it registry.duniter.org/clients/python/silkaj/release/pip:v0.10.0rc0 silkaj info
```

## Tests

Please test it globally, and check [v0.10.0 milestone short summary](https://git.duniter.org/clients/python/silkaj/-/milestones/9#code) which contains the changes which have been implemented during this development cycle.
Pay a special attention to the newly introduced revocation command.

Manual tests help us making sure everything works fine in different cases.
Here are some tests we think are necessary.
Make sure you test on Ğ1-Test network to avoid any revocation or loss of money to happen.

### Revocation

`revocation` command handle the revocation document in an extended way.
Check the sub-commands:

```bash
silkaj revocation --help
```

Make sure you are able to create new identities before proceeding.
Create a revocation file with an existing identity.
Verify the generated file, and publish it!

```bash
silkaj --gtest revocation save revocation_test.txt
silkaj --gtest revocation verify revocation_test.txt
silkaj --gtest revocation publish revocation_test.txt
```

Or directly all the previous steps with one command:

```bash
silkaj --gtest revocation revoke
```

### License

Check Ğ1 monetary license get displayed correctly in any language and in any configuration: workstation or headless computers.

```bash
silkaj license
silkaj --g1-license-web license
```

### Network, documents issuance

Silkaj’s network code layer have been completely rewritten, an other HTTP library is used, the asynchronous propery has been dropped, and the documents classes have been refactored.
Try any commands requesting information from the network or try sending any document.

```bash
silkaj info
silkaj -ep <hostname>:<port> membership
```

### Transaction recipients and amounts definition reading from a file

You can now define `recipients.txt` file following this format:

```txt
ABSOLUTE

# moul-test
10 5B8iMAzq1dNmFe3ZxFTBQkqhq4fsztg1gZvxHXCk1XYH:baK

# matograine
20 d88fPFbDdJXJANHH7hedFMaRyGcnVZj9c5cDaE76LRN:FVm
```

And pass it to `silkaj tx` command as follow:

```bash
silkaj --gtest tx -f recipients.txt
```

Check that everything works fine with `RELATIVE` reference.
You can also check broken file, and see if Silkaj reacts properly to any error in the file format definition.

### Others

Feel free to play and look for hidden bugs and/or UI/UX improvements!
We are looking forward for your feedback!

______________________________________________________________________

The stable release is planned for April 16th 2022, which will be released with an announcement listing the new features as well as a detailed changelog.

Silkaj team
