#include <stdarg.h>

/* -------------------------------------------------------------------- */
/* -------------------------------------------------------------------- */
struct charbuf_struct
{
	char 	*buf,
		*ptr;
	int	len;
};

/* -------------------------------------------------------------------- */
/* -------------------------------------------------------------------- */
static int copytobuf(void *cfarg, char *str, int len)
{
	struct 	charbuf_struct 
		*cbuf;
	int	n;


	cbuf = (struct charbuf_struct *)cfarg;

	n = 0;
	while (len--)
	{
		if (cbuf->len == -1)
		{
			*cbuf->ptr++ = *str++;
			n++;
		}
		else
		if (cbuf->len == 0)
		{
			*cbuf->ptr = '\0';
		}
		else
		{	cbuf->len--;
			*cbuf->ptr++ = *str++;
			n++;
		}
	}

	return n;
}


/* -------------------------------------------------------------------- */
/* -------------------------------------------------------------------- */
int libport_vsnprintf(char *buf, int len, char *fmt, va_list args)
{
	struct charbuf_struct cbuf;

	cbuf.buf = buf;
	cbuf.ptr = buf;
	cbuf.len = len;

	return format(copytobuf, &cbuf, len, fmt, args);
}

 

