/*
 * Decompiled with CFR 0.152.
 */
package de.focus_shift.jollyday.core.support;

import java.util.List;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LazyServiceLoaderCache<S> {
    private static final Logger LOG = LoggerFactory.getLogger((String)LazyServiceLoaderCache.class.getName());
    private final Class<S> clz;
    private List<S> services;

    public LazyServiceLoaderCache(Class<S> clz) {
        this.clz = clz;
    }

    public List<S> getServices() {
        if (this.services == null) {
            this.loadServices();
        }
        return this.services;
    }

    private synchronized void loadServices() {
        this.services = new CopyOnWriteArrayList<S>();
        try {
            for (S s : ServiceLoader.load(this.clz)) {
                this.services.add(s);
            }
        }
        catch (ServiceConfigurationError serviceConfigurationError) {
            String message = String.format("Cannot load services of type [%s].%n    %s", this.clz.getName(), serviceConfigurationError.getMessage());
            LOG.warn(message);
        }
    }
}

