"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mockGanttProps = exports.mockEditorProps = exports.MockStateParams = void 0;
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const MockStateParams = exports.MockStateParams = {
  colors: '#6092C0',
  durationField: 'duration',
  labelField: 'spanID',
  legendOrientation: 'v',
  showLegend: true,
  size: 10,
  startTimeField: 'startTime',
  timeFormat: 'hh:mm:ss.SSS A',
  xAxisPosition: 'bottom',
  xAxisShow: true,
  xAxisShowGrid: true,
  xAxisShowLine: true,
  xAxisShowTitle: true,
  xAxisTitle: '',
  xAxisType: 'linear',
  yAxisPosition: 'left',
  yAxisShow: true,
  yAxisShowGrid: false,
  yAxisShowLine: true,
  yAxisShowTitle: true,
  yAxisTitle: ''
};
const MockAggs = {
  indexPattern: {
    fields: [{
      name: 'test-field-1'
    }, {
      name: 'test-field-2'
    }, {
      name: 'test-field-3'
    }, {
      name: 'test-field-4'
    }, {
      name: 'test-field-5'
    }, {
      name: 'test-field-6'
    }, {
      name: 'test-field-7'
    }]
  }
};
const mockEditorProps = setValue => ({
  ...{
    setValue,
    stateParams: MockStateParams,
    aggs: MockAggs
  }
});
exports.mockEditorProps = mockEditorProps;
const mockGanttProps = () => ({
  visData: {
    total: 25,
    source: [{
      spanID: '57f46877f868af92',
      startTime: 1590695963803408,
      duration: 51929
    }, {
      spanID: '68daf6ca76398de9',
      startTime: 1590695963786548,
      duration: 45766
    }, {
      spanID: '439a27333a6e8893',
      startTime: 1590695963786541,
      duration: 45777
    }]
  },
  visParams: MockStateParams
});
exports.mockGanttProps = mockGanttProps;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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