"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.generateTermQuery = exports.generateMustQueries = void 0;
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const generateTermQuery = (key, value) => {
  if (typeof value === 'string' || typeof value === 'number') {
    return {
      term: {
        [key]: {
          value
        }
      }
    };
  }
  return {
    terms: {
      [key]: value
    }
  };
};
exports.generateTermQuery = generateTermQuery;
const generateMustQueries = queries => {
  switch (queries.length) {
    case 0:
      return {
        match_all: {}
      };
    case 1:
      return queries[0];
    default:
      return {
        bool: {
          must: queries
        }
      };
  }
};
exports.generateMustQueries = generateMustQueries;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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