/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.ui.options.filetypes;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.openide.filesystems.declmime.MIMEResolverImpl;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class FileAssociationsModel {
    private static final String MIME_RESOLVERS_PATH = "Services/MIMEResolver";
    private static final String USER_DEFINED = "user-defined-mime-resolver";
    private static final int USER_DEFINED_POSITION = 10;
    private static final Logger LOGGER = Logger.getLogger(FileAssociationsModel.class.getName());
    private HashMap<String, String> extensionToMimeAll = new HashMap();
    private HashMap<String, String> extensionToMimeSystem = new HashMap();
    private HashMap<String, String> extensionToMimeUser = new HashMap();
    private TreeSet<String> mimeTypes = new TreeSet();
    private HashMap<String, MimeItem> mimeToItem = new HashMap();
    private boolean initialized = false;
    private final FileChangeListener mimeResolversListener = new FileChangeAdapter(){

        public void fileDeleted(FileEvent fileEvent) {
            FileAssociationsModel.this.initialized = false;
        }

        public void fileRenamed(FileRenameEvent fileRenameEvent) {
            FileAssociationsModel.this.initialized = false;
        }

        public void fileDataCreated(FileEvent fileEvent) {
            FileAssociationsModel.this.initialized = false;
        }

        public void fileChanged(FileEvent fileEvent) {
            FileAssociationsModel.this.initialized = false;
        }
    };
    private FileObject userDefinedResolverFO;

    FileAssociationsModel() {
        FileObject fileObject = Repository.getDefault().getDefaultFileSystem().findResource(MIME_RESOLVERS_PATH);
        if (fileObject != null) {
            fileObject.addFileChangeListener(FileUtil.weakFileChangeListener((FileChangeListener)this.mimeResolversListener, (Object)fileObject));
        }
    }

    boolean containsExtension(String string) {
        return this.extensionToMimeAll.containsKey(string);
    }

    String getAssociatedAlso(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string3 : this.getExtensions()) {
            if (string3.equals(string) || !this.extensionToMimeAll.get(string3).equals(string2)) continue;
            if (stringBuilder.length() != 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(string3);
        }
        return stringBuilder.toString();
    }

    List<String> getExtensions() {
        this.init();
        ArrayList<String> arrayList = new ArrayList<String>(this.extensionToMimeAll.keySet());
        Collections.sort(arrayList, String.CASE_INSENSITIVE_ORDER);
        return arrayList;
    }

    Set<String> getMimeTypes() {
        this.init();
        return this.mimeTypes;
    }

    private void readMimeTypesFromLoaders() {
        FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
        FileObject[] fileObjectArray = fileSystem.findResource("Loaders").getChildren();
        for (int i = 0; i < fileObjectArray.length; ++i) {
            FileObject fileObject = fileObjectArray[i];
            String string = fileObject.getNameExt();
            FileObject[] fileObjectArray2 = fileObject.getChildren();
            for (int j = 0; j < fileObjectArray2.length; ++j) {
                FileObject fileObject2 = fileObjectArray2[j];
                FileObject fileObject3 = fileObject2.getFileObject("Factories");
                if (fileObject3 == null || fileObject3.getChildren().length <= 0) continue;
                this.mimeTypes.add(string + "/" + fileObject2.getNameExt());
            }
        }
        this.mimeTypes.remove("content/unknown");
    }

    String getMimeType(String string) {
        this.init();
        return this.extensionToMimeAll.get(string);
    }

    MimeItem getMimeItem(String string) {
        return this.mimeToItem.get(this.getMimeType(string));
    }

    void remove(String string) {
        this.extensionToMimeUser.remove(string);
        this.extensionToMimeAll.remove(string);
    }

    void setDefault(String string) {
        this.remove(string);
        this.extensionToMimeAll.put(string, this.extensionToMimeSystem.get(string));
    }

    boolean setMimeType(String string, String string2) {
        String string3 = this.getMimeType(string);
        if (!string2.equals(string3)) {
            LOGGER.fine("setMimeType - " + string + "=" + string2);
            this.extensionToMimeUser.put(string, string2);
            this.extensionToMimeAll.put(string, string2);
            return true;
        }
        return false;
    }

    boolean canBeRestored(String string) {
        return this.extensionToMimeUser.containsKey(string) && this.extensionToMimeSystem.containsKey(string);
    }

    boolean canBeRemoved(String string) {
        return !this.extensionToMimeSystem.containsKey(string);
    }

    private static String getLoaderDisplayName(String string) {
        FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
        FileObject fileObject = fileSystem.findResource("Loaders/" + string + "/Factories");
        if (fileObject != null) {
            FileObject[] fileObjectArray;
            for (FileObject fileObject2 : fileObjectArray = fileObject.getChildren()) {
                String string2;
                String string3 = fileObject2.getNameExt();
                if (string3.equals(string2 = fileSystem.getStatus().annotateName(string3, Collections.singleton(fileObject2)))) continue;
                return string2;
            }
        }
        return null;
    }

    ArrayList<MimeItem> getMimeItems() {
        this.init();
        ArrayList<MimeItem> arrayList = new ArrayList<MimeItem>(this.mimeToItem.values());
        Collections.sort(arrayList);
        return arrayList;
    }

    void store() {
        if (this.userDefinedResolverFO != null) {
            try {
                this.userDefinedResolverFO.delete();
            }
            catch (IOException iOException) {
                LOGGER.log(Level.SEVERE, "Cannot delete resolver " + FileUtil.toFile((FileObject)this.userDefinedResolverFO), iOException);
                return;
            }
        }
        if (this.extensionToMimeUser.isEmpty()) {
            return;
        }
        FileUtil.runAtomicAction((Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Document document = XMLUtil.createDocument((String)"MIME-resolver", null, (String)"-//NetBeans//DTD MIME Resolver 1.0//EN", (String)"http://www.netbeans.org/dtds/mime-resolver-1_0.dtd");
                for (String string : FileAssociationsModel.this.extensionToMimeUser.keySet()) {
                    Element element = document.createElement("file");
                    Element element2 = document.createElement("ext");
                    Element element3 = document.createElement("resolver");
                    element2.setAttribute("name", string);
                    element3.setAttribute("mime", (String)FileAssociationsModel.this.extensionToMimeUser.get(string));
                    element.appendChild(element2);
                    element.appendChild(element3);
                    document.getDocumentElement().appendChild(element);
                }
                Object object = null;
                try {
                    String string;
                    string = Repository.getDefault().getDefaultFileSystem();
                    FileAssociationsModel.this.userDefinedResolverFO = string.findResource(FileAssociationsModel.MIME_RESOLVERS_PATH).createData("user-defined-mime-resolver.xml");
                    FileAssociationsModel.this.userDefinedResolverFO.setAttribute(FileAssociationsModel.USER_DEFINED, (Object)Boolean.TRUE);
                    FileAssociationsModel.this.userDefinedResolverFO.setAttribute("position", (Object)10);
                    object = FileAssociationsModel.this.userDefinedResolverFO.getOutputStream();
                    XMLUtil.write((Document)document, (OutputStream)object, (String)"UTF-8");
                }
                catch (IOException iOException) {
                    LOGGER.log(Level.SEVERE, "Cannot write resolver " + FileUtil.toFile((FileObject)FileAssociationsModel.this.userDefinedResolverFO), iOException);
                }
                finally {
                    if (object != null) {
                        try {
                            ((OutputStream)object).close();
                        }
                        catch (IOException iOException) {
                            LOGGER.log(Level.SEVERE, "Cannot close OutputStreamof file " + FileUtil.toFile((FileObject)FileAssociationsModel.this.userDefinedResolverFO), iOException);
                        }
                    }
                }
            }
        });
    }

    private void init() {
        Object object;
        Object object2;
        if (this.initialized) {
            return;
        }
        LOGGER.fine("FileAssociationsModel.init");
        this.initialized = true;
        FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
        FileObject[] fileObjectArray = fileSystem.findResource(MIME_RESOLVERS_PATH).getChildren();
        TreeMap treeMap = new TreeMap(Collections.reverseOrder());
        for (int i = 0; i < fileObjectArray.length; ++i) {
            Object object3 = fileObjectArray[i];
            Integer n = (Integer)object3.getAttribute("position");
            if (n == null) {
                n = Integer.MAX_VALUE;
            }
            while (treeMap.containsKey(n)) {
                object2 = n;
                n = n - 1;
                object = n;
            }
            treeMap.put(n, object3);
        }
        for (Object object3 : treeMap.values()) {
            boolean bl;
            boolean bl2 = bl = object3.getAttribute(USER_DEFINED) != null;
            if (bl) {
                this.userDefinedResolverFO = object3;
            }
            assert (object3.getPath().startsWith(MIME_RESOLVERS_PATH));
            object2 = MIMEResolverImpl.getExtensionsAndMIMETypes((FileObject)object3);
            object = object2.iterator();
            while (object.hasNext()) {
                String[] stringArray = (String[])object.next();
                String string = stringArray[0];
                String string2 = stringArray[1];
                if (string != null) {
                    this.extensionToMimeAll.put(string, string2);
                    if (bl) {
                        this.extensionToMimeUser.put(string, string2);
                    } else {
                        this.extensionToMimeSystem.put(string, string2);
                    }
                }
                this.mimeTypes.add(string2);
            }
        }
        this.readMimeTypesFromLoaders();
        for (String string : this.mimeTypes) {
            object2 = new MimeItem(string, FileAssociationsModel.getLoaderDisplayName(string));
            this.mimeToItem.put(string, (MimeItem)object2);
        }
        LOGGER.fine("extensionToMimeSystem=" + this.extensionToMimeSystem);
        LOGGER.fine("extensionToMimeUser=" + this.extensionToMimeUser);
    }

    static final class MimeItem
    implements Comparable {
        String mimeType;
        String displayName;

        MimeItem(String string, String string2) {
            this.mimeType = string;
            this.displayName = string2;
        }

        String getMimeType() {
            return this.mimeType;
        }

        public String toString() {
            return this.displayName == null ? this.mimeType : this.displayName + " (" + this.mimeType + ")";
        }

        public int compareTo(Object object) {
            return this.toString().compareToIgnoreCase(object.toString());
        }
    }
}

