/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import org.traccar.Protocol;
import org.traccar.StringProtocolEncoder;
import org.traccar.model.Command;

public class Gps103ProtocolEncoder
extends StringProtocolEncoder
implements StringProtocolEncoder.ValueFormatter {
    public Gps103ProtocolEncoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    public String formatValue(String key, Object value) {
        if (key.equals("frequency")) {
            long frequency = ((Number)value).longValue();
            if (frequency / 60L / 60L > 0L) {
                return String.format("%02dh", frequency / 60L / 60L);
            }
            if (frequency / 60L > 0L) {
                return String.format("%02dm", frequency / 60L);
            }
            return String.format("%02ds", frequency);
        }
        return null;
    }

    @Override
    protected Object encodeCommand(Command command) {
        return switch (command.getType()) {
            case "custom" -> this.formatCommand(command, "**,imei:%s,%s", "uniqueId", "data");
            case "positionStop" -> this.formatCommand(command, "**,imei:%s,D", "uniqueId");
            case "positionSingle" -> this.formatCommand(command, "**,imei:%s,B", "uniqueId");
            case "positionPeriodic" -> this.formatCommand(command, "**,imei:%s,C,%s", this, "uniqueId", "frequency");
            case "engineStop" -> this.formatCommand(command, "**,imei:%s,J", "uniqueId");
            case "engineResume" -> this.formatCommand(command, "**,imei:%s,K", "uniqueId");
            case "alarmArm" -> this.formatCommand(command, "**,imei:%s,L", "uniqueId");
            case "alarmDisarm" -> this.formatCommand(command, "**,imei:%s,M", "uniqueId");
            case "requestPhoto" -> this.formatCommand(command, "**,imei:%s,160", "uniqueId");
            default -> null;
        };
    }
}

