/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.SubnetDescription;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.Outputter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

public class CreateSubnet
extends BaseCmd {
    private static final String VPC_DESC = "The ID of the VPC where you want to create the subnet.";
    private static final String CIDR_DESC = "The CIDR block you want the subnet to cover.";
    private static final String AVAILABILITY_ZONE_DESC = "The availability zone you want the subnet in.";
    private String vpcId;
    private String cidr;
    private String availabilityZone;

    public CreateSubnet(String[] args) {
        super("ec2addsubnet", "ec2-create-subnet");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    @Override
    protected String getOptionString() {
        return "-c VPC -i CIDR -z ZONE";
    }

    private Options getOptions() {
        Options options = new Options();
        OptionBuilder.withLongOpt((String)"vpc");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"VPC");
        OptionBuilder.withDescription((String)this.joinDescription(VPC_DESC));
        options.addOption(OptionBuilder.create((String)"c"));
        OptionBuilder.withLongOpt((String)"cidr");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"CIDR");
        OptionBuilder.withDescription((String)this.joinDescription(CIDR_DESC));
        options.addOption(OptionBuilder.create((String)"i"));
        OptionBuilder.withLongOpt((String)"availability-zone");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"ZONE");
        OptionBuilder.withDescription((String)this.joinDescription(AVAILABILITY_ZONE_DESC));
        options.addOption(OptionBuilder.create((String)"z"));
        return options;
    }

    @Override
    public void printDescription() {
        super.printDescription();
        System.out.println("     Creates a subnet in an existing VPC. If you add more than one subnet to a");
        System.out.println("     VPC. they're set up in a star topology with a router in the middle. The");
        System.out.println("     subnet's CIDR block can be the same as the VPC's CIDR block, or a subset");
        System.out.println("     of the VPC's CIDR block.");
    }

    @Override
    public void printOptions() {
        super.printOptions(true);
        this.printOption("vpc");
        this.printOption("cidr");
        this.printOption("availability-zone");
    }

    @Override
    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        this.validateParameters();
        this.vpcId = this.getOptionValue("vpc");
        this.cidr = this.getOptionValue("cidr");
        this.availabilityZone = this.getOptionValue("availability-zone");
        RequestResultPair rsp = jec2.createSubnet(this.vpcId, this.cidr, this.availabilityZone);
        out.output(System.out, (SubnetDescription)rsp.getResponse());
        out.printRequestId(System.out, (RequestResult)rsp);
        return true;
    }

    protected void validateParameters() {
        this.assertOptionSet("vpc");
        this.assertOptionSet("cidr");
    }

    @Override
    protected void parseOpts(String[] args) {
        super.parseOpts(args);
    }

    public static void main(String[] args) {
        new CreateSubnet(args).invoke();
    }
}

