/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler.vars;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.java.decompiler.main.ClassesProcessor;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.main.collectors.VarNamesCollector;
import org.jetbrains.java.decompiler.modules.decompiler.ExprProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.exps.AssignmentExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.ConstExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.ExitExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.FieldExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.InvocationExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.NewExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.VarExprent;
import org.jetbrains.java.decompiler.modules.decompiler.stats.CatchAllStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.CatchStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.DoStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.IfStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarVersion;
import org.jetbrains.java.decompiler.struct.StructClass;
import org.jetbrains.java.decompiler.struct.StructMethod;
import org.jetbrains.java.decompiler.struct.attr.StructLocalVariableTableAttribute;
import org.jetbrains.java.decompiler.struct.gen.MethodDescriptor;
import org.jetbrains.java.decompiler.struct.gen.VarType;
import org.jetbrains.java.decompiler.struct.gen.generics.GenericType;
import org.jetbrains.java.decompiler.struct.match.IMatchable;
import org.jetbrains.java.decompiler.util.StatementIterator;

public class VarDefinitionHelper {
    private final HashMap<Integer, Statement> mapVarDefStatements = new HashMap();
    private final HashMap<Integer, HashSet<Integer>> mapStatementVars = new HashMap();
    private final HashSet<Integer> implDefVars = new HashSet();
    private final VarProcessor varproc;
    private final Statement root;
    private final StructMethod mt;

    public VarDefinitionHelper(Statement root, StructMethod mt, VarProcessor varproc) {
        this.varproc = varproc;
        this.root = root;
        this.mt = mt;
        VarNamesCollector vc = varproc.getVarNamesCollector();
        boolean thisvar = !mt.hasModifier(8);
        MethodDescriptor md = MethodDescriptor.parseDescriptor(mt.getDescriptor());
        int paramcount = 0;
        if (thisvar) {
            paramcount = 1;
        }
        paramcount += md.params.length;
        int varindex = 0;
        for (int i = 0; i < paramcount; ++i) {
            this.implDefVars.add(varindex);
            VarVersion vpp = new VarVersion(varindex, 0);
            varproc.setVarName(vpp, vc.getFreeName(varindex));
            if (thisvar) {
                if (i == 0) {
                    ++varindex;
                    continue;
                }
                varindex += md.params[i - 1].getStackSize();
                continue;
            }
            varindex += md.params[i].getStackSize();
        }
        if (thisvar) {
            StructClass current_class = (StructClass)DecompilerContext.getProperty("CURRENT_CLASS");
            varproc.getThisVars().put(new VarVersion(0, 0), current_class.qualifiedName);
            varproc.setVarName(new VarVersion(0, 0), "this");
            vc.addName("this");
        }
        this.mergeVars(root);
        LinkedList<Statement> stack = new LinkedList<Statement>();
        stack.add(root);
        while (!stack.isEmpty()) {
            Statement st = (Statement)stack.removeFirst();
            List<VarExprent> lstVars = null;
            if (st.type == Statement.StatementType.CATCH_ALL) {
                lstVars = ((CatchAllStatement)st).getVars();
            } else if (st.type == Statement.StatementType.TRY_CATCH) {
                lstVars = new ArrayList<VarExprent>(((CatchStatement)st).getVars());
                for (Exprent exp : ((CatchStatement)st).getResources()) {
                    lstVars.add((VarExprent)((AssignmentExprent)exp).getLeft());
                }
            }
            if (lstVars != null) {
                for (VarExprent var : lstVars) {
                    this.implDefVars.add(var.getIndex());
                    VarVersion pair = new VarVersion(var);
                    String name = varproc.getAssignedVarName(pair);
                    if (varproc.getVarName(pair) == null) {
                        if (name != null) {
                            varproc.setVarName(pair, name);
                        } else {
                            varproc.setVarName(pair, vc.getFreeName(var.getIndex()));
                        }
                    }
                    var.setDefinition(true);
                }
            }
            stack.addAll(st.getStats());
        }
        this.initStatement(root);
    }

    public void setVarDefinitions() {
        VarNamesCollector vc = this.varproc.getVarNamesCollector();
        for (Map.Entry<Integer, Statement> en : this.mapVarDefStatements.entrySet()) {
            Statement first;
            Statement stat = en.getValue();
            Integer index = en.getKey();
            if (this.implDefVars.contains(index)) continue;
            VarVersion pair = new VarVersion((int)index, 0);
            String name = this.varproc.getAssignedVarName(pair);
            if (name != null) {
                this.varproc.setVarName(pair, name);
            } else {
                this.varproc.setVarName(pair, vc.getFreeName(index));
            }
            if (stat.type == Statement.StatementType.DO) {
                VarExprent var;
                DoStatement dstat = (DoStatement)stat;
                if (dstat.getLoopType() == DoStatement.LoopType.FOR) {
                    if (dstat.getInitExprent() != null && VarDefinitionHelper.setDefinition(dstat.getInitExprent(), index)) continue;
                    List<Exprent> lstSpecial = Arrays.asList(dstat.getConditionExprent(), dstat.getIncExprent());
                    for (VarExprent var2 : VarDefinitionHelper.getAllVars(lstSpecial)) {
                        if (var2.getIndex() != index.intValue()) continue;
                        stat = stat.getParent();
                        break;
                    }
                } else if (dstat.getLoopType() == DoStatement.LoopType.FOREACH && dstat.getInitExprent() != null && dstat.getInitExprent().type == 12 && (var = (VarExprent)dstat.getInitExprent()).getIndex() == index.intValue()) {
                    var.setDefinition(true);
                    continue;
                }
            }
            List<Exprent> lst = (first = this.findFirstBlock(stat, index)) == null ? stat.getVarDefinitions() : (first.getExprents() == null ? first.getVarDefinitions() : first.getExprents());
            boolean defset = false;
            int addindex = 0;
            for (Exprent expr : lst) {
                if (VarDefinitionHelper.setDefinition(expr, index)) {
                    defset = true;
                    break;
                }
                boolean foundvar = false;
                for (Exprent exp : expr.getAllExprents(true)) {
                    if (exp.type != 12 || ((VarExprent)exp).getIndex() != index.intValue()) continue;
                    foundvar = true;
                    break;
                }
                if (foundvar) break;
                ++addindex;
            }
            if (defset) continue;
            VarExprent var = new VarExprent(index, this.varproc.getVarType(new VarVersion((int)index, 0)), this.varproc);
            var.setDefinition(true);
            StructLocalVariableTableAttribute.LocalVariable lv = VarDefinitionHelper.findLVTEntry((int)index, stat);
            if (lv != null) {
                var.setLVTEntry(lv);
            }
            lst.add(addindex, var);
        }
        this.mergeVars(this.root);
        this.propogateLVTs(this.root);
    }

    private static StructLocalVariableTableAttribute.LocalVariable findLVTEntry(int index, Statement stat) {
        for (IMatchable iMatchable : stat.getExprentsOrSequentialObjects()) {
            StructLocalVariableTableAttribute.LocalVariable lvt;
            if (!(iMatchable instanceof Statement ? (lvt = VarDefinitionHelper.findLVTEntry(index, (Statement)iMatchable)) != null : iMatchable instanceof Exprent && (lvt = VarDefinitionHelper.findLVTEntry(index, (Exprent)iMatchable)) != null)) continue;
            return lvt;
        }
        return null;
    }

    private static StructLocalVariableTableAttribute.LocalVariable findLVTEntry(int index, Exprent exp) {
        for (Exprent e : exp.getAllExprents(false)) {
            StructLocalVariableTableAttribute.LocalVariable lvt = VarDefinitionHelper.findLVTEntry(index, e);
            if (lvt == null) continue;
            return lvt;
        }
        if (exp.type != 12) {
            return null;
        }
        VarExprent var = (VarExprent)exp;
        return var.getIndex() == index ? var.getLVTEntry() : null;
    }

    private Statement findFirstBlock(Statement stat, Integer varindex) {
        LinkedList<Statement> stack = new LinkedList<Statement>();
        stack.add(stat);
        block4: while (!stack.isEmpty()) {
            Statement st = (Statement)stack.remove(0);
            if (!stack.isEmpty() && !this.mapStatementVars.get(st.id).contains(varindex)) continue;
            if (st.isLabeled() && !stack.isEmpty()) {
                return st;
            }
            if (st.getExprents() != null) {
                return st;
            }
            stack.clear();
            switch (st.type) {
                case SEQUENCE: {
                    stack.addAll(0, st.getStats());
                    continue block4;
                }
                case IF: 
                case ROOT: 
                case SWITCH: 
                case SYNCHRONIZED: {
                    stack.add(st.getFirst());
                    continue block4;
                }
            }
            return st;
        }
        return null;
    }

    private Set<Integer> initStatement(Statement stat) {
        List<VarExprent> condlst;
        HashMap<Integer, Integer> mapCount = new HashMap<Integer, Integer>();
        if (stat.getExprents() == null) {
            ArrayList childVars = new ArrayList();
            ArrayList<Exprent> currVars = new ArrayList<Exprent>();
            for (IMatchable obj : stat.getSequentialObjects()) {
                if (obj instanceof Statement) {
                    CatchAllStatement fin;
                    Statement st = (Statement)obj;
                    childVars.addAll(this.initStatement(st));
                    if (st.type == Statement.StatementType.DO) {
                        DoStatement dost = (DoStatement)st;
                        if (dost.getLoopType() == DoStatement.LoopType.FOR || dost.getLoopType() == DoStatement.LoopType.FOREACH || dost.getLoopType() == DoStatement.LoopType.DO) continue;
                        currVars.add(dost.getConditionExprent());
                        continue;
                    }
                    if (st.type != Statement.StatementType.CATCH_ALL || !(fin = (CatchAllStatement)st).isFinally() || fin.getMonitor() == null) continue;
                    currVars.add(fin.getMonitor());
                    continue;
                }
                if (!(obj instanceof Exprent)) continue;
                currVars.add((Exprent)obj);
            }
            Iterator<IMatchable> iterator = childVars.iterator();
            while (iterator.hasNext()) {
                Integer index = (Integer)((Object)iterator.next());
                Integer count = (Integer)mapCount.get(index);
                if (count == null) {
                    count = 0;
                }
                mapCount.put(index, count + 1);
            }
            condlst = VarDefinitionHelper.getAllVars(currVars);
        } else {
            condlst = VarDefinitionHelper.getAllVars(stat.getExprents());
        }
        for (VarExprent var : condlst) {
            mapCount.put(var.getIndex(), 2);
        }
        HashSet<Integer> set = new HashSet<Integer>(mapCount.keySet());
        for (Map.Entry en : mapCount.entrySet()) {
            if ((Integer)en.getValue() <= 1) continue;
            this.mapVarDefStatements.put((Integer)en.getKey(), stat);
        }
        this.mapStatementVars.put(stat.id, set);
        return set;
    }

    private static List<VarExprent> getAllVars(List<Exprent> lst) {
        ArrayList<VarExprent> res = new ArrayList<VarExprent>();
        ArrayList<Exprent> listTemp = new ArrayList<Exprent>();
        for (Exprent expr : lst) {
            listTemp.addAll(expr.getAllExprents(true));
            listTemp.add(expr);
        }
        for (Exprent exprent : listTemp) {
            if (exprent.type != 12) continue;
            res.add((VarExprent)exprent);
        }
        return res;
    }

    private static boolean setDefinition(Exprent expr, Integer index) {
        if (expr.type == 2) {
            VarExprent var;
            Exprent left = ((AssignmentExprent)expr).getLeft();
            if (left.type == 12 && (var = (VarExprent)left).getIndex() == index.intValue()) {
                var.setDefinition(true);
                return true;
            }
        }
        return false;
    }

    private void populateTypeBounds() {
        Map<VarVersion, VarType> mapExprentMinTypes = this.varproc.getVarVersions().getTypeProcessor().getMinExprentTypes();
        Map<VarVersion, VarType> mapExprentMaxTypes = this.varproc.getVarVersions().getTypeProcessor().getMaxExprentTypes();
        LinkedList<Statement> stack = new LinkedList<Statement>();
        stack.add(this.root);
        while (!stack.isEmpty()) {
            Statement st = (Statement)stack.removeFirst();
            if (st.getExprents() != null) {
                LinkedList<Exprent> exps = new LinkedList<Exprent>(st.getExprents());
                block4: while (!exps.isEmpty()) {
                    Exprent exp = exps.removeFirst();
                    switch (exp.type) {
                        case 4: 
                        case 5: 
                        case 8: {
                            Exprent instance = null;
                            String target = null;
                            if (exp.type == 8) {
                                instance = ((InvocationExprent)exp).getInstance();
                                target = ((InvocationExprent)exp).getClassName();
                            } else if (exp.type == 5) {
                                instance = ((FieldExprent)exp).getInstance();
                                target = ((FieldExprent)exp).getClassname();
                            } else {
                                ExitExprent exit = (ExitExprent)exp;
                                if (exit.getExitType() == 0) {
                                    instance = exit.getValue();
                                    target = exit.getRetType().getValue();
                                }
                            }
                            if ("java/lang/Object".equals(target) || instance == null || instance.type != 12) continue block4;
                            VarVersion key = ((VarExprent)instance).getVarVersion();
                            VarType newType = new VarType(8, 0, target);
                            VarType oldMin = mapExprentMinTypes.get(key);
                            VarType oldMax = mapExprentMaxTypes.get(key);
                            if (newType.equals(oldMax)) continue block4;
                            if (oldMax != null && oldMax.getType() == 8) {
                                if (!DecompilerContext.getStructContext().instanceOf(newType.getValue(), oldMax.getValue())) continue block4;
                                mapExprentMaxTypes.put(key, newType);
                                break;
                            }
                            mapExprentMaxTypes.put(key, newType);
                            break;
                        }
                        default: {
                            exps.addAll(exp.getAllExprents());
                        }
                    }
                }
            }
            stack.addAll(st.getStats());
        }
    }

    private void mergeVars(Statement stat) {
        HashMap<Integer, VarVersion> parent = new HashMap<Integer, VarVersion>();
        MethodDescriptor md = MethodDescriptor.parseDescriptor(this.mt.getDescriptor());
        int index = 0;
        if (!this.mt.hasModifier(8)) {
            parent.put(index, new VarVersion(index++, 0));
        }
        for (VarType var : md.params) {
            parent.put(index, new VarVersion(index, 0));
            index += var.getStackSize();
        }
        this.populateTypeBounds();
        HashMap<VarVersion, VarVersion> blacklist = new HashMap<VarVersion, VarVersion>();
        VPPEntry remap = this.mergeVars(stat, parent, new HashMap<Integer, VarVersion>(), blacklist);
        while (remap != null) {
            if (!this.remapVar(stat, (VarVersion)remap.getKey(), (VarVersion)remap.getValue())) {
                blacklist.put((VarVersion)remap.getKey(), (VarVersion)remap.getValue());
            }
            remap = this.mergeVars(stat, parent, new HashMap<Integer, VarVersion>(), blacklist);
        }
    }

    private VPPEntry mergeVars(Statement stat, Map<Integer, VarVersion> parent, Map<Integer, VarVersion> leaked, Map<VarVersion, VarVersion> blacklist) {
        Map<Integer, VarVersion> scoped;
        HashMap<Integer, VarVersion> this_vars = new HashMap<Integer, VarVersion>();
        if (!parent.isEmpty()) {
            this_vars.putAll(parent);
        }
        if (!stat.getVarDefinitions().isEmpty()) {
            for (int x = 0; x < stat.getVarDefinitions().size(); ++x) {
                Exprent exp = stat.getVarDefinitions().get(x);
                if (exp.type != 12) continue;
                VarExprent var = (VarExprent)exp;
                int index = this.varproc.getVarOriginalIndex(var.getIndex());
                if (this_vars.containsKey(index)) {
                    stat.getVarDefinitions().remove(x);
                    return new VPPEntry(var, (VarVersion)this_vars.get(index));
                }
                this_vars.put(index, new VarVersion(var));
                leaked.put(index, new VarVersion(var));
            }
        }
        switch (stat.type) {
            case SEQUENCE: 
            case ROOT: 
            case BASIC_BLOCK: 
            case GENERAL: {
                Map<Integer, VarVersion> map = leaked;
                break;
            }
            default: {
                Map<Integer, VarVersion> map = scoped = null;
            }
        }
        if (stat.getExprents() == null) {
            List<IMatchable> objs = stat.getSequentialObjects();
            for (int i = 0; i < objs.size(); ++i) {
                Exprent exprent;
                VPPEntry ret;
                IMatchable obj = objs.get(i);
                if (obj instanceof Statement) {
                    Statement st = (Statement)obj;
                    HashMap<Integer, VarVersion> leaked_n = new HashMap<Integer, VarVersion>();
                    VPPEntry remap = this.mergeVars(st, this_vars, leaked_n, blacklist);
                    if (remap != null) {
                        return remap;
                    }
                    if (leaked_n.isEmpty()) continue;
                    if (stat.type == Statement.StatementType.IF) {
                        IfStatement ifst = (IfStatement)stat;
                        if (obj == ifst.getIfstat() || obj == ifst.getElsestat()) {
                            leaked_n.clear();
                        } else if (obj == ifst.getFirst()) {
                            leaked.putAll(leaked_n);
                        }
                    } else if (stat.type == Statement.StatementType.SWITCH || stat.type == Statement.StatementType.SYNCHRONIZED) {
                        if (obj == stat.getFirst()) {
                            leaked.putAll(leaked_n);
                        } else {
                            leaked_n.clear();
                        }
                    } else if (stat.type == Statement.StatementType.TRY_CATCH || stat.type == Statement.StatementType.CATCH_ALL) {
                        leaked_n.clear();
                    }
                    this_vars.putAll(leaked_n);
                    continue;
                }
                if (!(obj instanceof Exprent) || (ret = this.processExprent(exprent = (Exprent)obj, this_vars, scoped, blacklist)) == null || !VarDefinitionHelper.isVarReadFirst((VarVersion)ret.getValue(), stat, i + 1, new VarExprent[0])) continue;
                return ret;
            }
        } else {
            List<Exprent> exps = stat.getExprents();
            for (int i = 0; i < exps.size(); ++i) {
                VPPEntry ret = this.processExprent(exps.get(i), this_vars, scoped, blacklist);
                if (ret == null || VarDefinitionHelper.isVarReadFirst((VarVersion)ret.getValue(), stat, i + 1, new VarExprent[0])) continue;
                return ret;
            }
        }
        return null;
    }

    private VPPEntry processExprent(Exprent exp, Map<Integer, VarVersion> this_vars, Map<Integer, VarVersion> leaked, Map<VarVersion, VarVersion> blacklist) {
        VarVersion old;
        VarVersion black;
        VarExprent var = null;
        if (exp.type == 2) {
            AssignmentExprent ass = (AssignmentExprent)exp;
            if (ass.getLeft().type != 12) {
                return null;
            }
            var = (VarExprent)ass.getLeft();
        } else if (exp.type == 12) {
            var = (VarExprent)exp;
        }
        if (var == null) {
            return null;
        }
        if (!var.isDefinition()) {
            return null;
        }
        int index = this.varproc.getVarOriginalIndex(var.getIndex());
        VarVersion new_ = this_vars.get(index);
        if (!(new_ == null || (black = blacklist.get(old = new VarVersion(var))) != null && black.equals(new_))) {
            return new VPPEntry(var, this_vars.get(index));
        }
        this_vars.put(index, new VarVersion(var));
        if (leaked != null) {
            leaked.put(index, new VarVersion(var));
        }
        return null;
    }

    private boolean remapVar(Statement stat, VarVersion from, VarVersion to) {
        if (from.equals(to)) {
            throw new IllegalArgumentException("Something went wrong: " + from);
        }
        boolean success = false;
        if (stat.getExprents() == null) {
            for (IMatchable obj : stat.getSequentialObjects()) {
                if (obj instanceof Statement) {
                    success |= this.remapVar((Statement)obj, from, to);
                    continue;
                }
                if (!(obj instanceof Exprent) || !this.remapVar((Exprent)obj, from, to)) continue;
                success = true;
            }
        } else {
            boolean remapped = false;
            for (int x = 0; x < stat.getExprents().size(); ++x) {
                Exprent exp = stat.getExprents().get(x);
                if (!this.remapVar(exp, from, to)) continue;
                remapped = true;
                if (exp.type != 12 || ((VarExprent)exp).isDefinition()) continue;
                stat.getExprents().remove(x);
                --x;
            }
            success |= remapped;
        }
        if (success) {
            Iterator<Exprent> itr = stat.getVarDefinitions().iterator();
            while (itr.hasNext()) {
                VarType merged;
                Exprent exp = itr.next();
                if (exp.type != 12) continue;
                VarExprent var = (VarExprent)exp;
                if (from.equals(var.getVarVersion())) {
                    itr.remove();
                    continue;
                }
                if (to.var != var.getIndex() || to.version != var.getVersion() || (merged = this.getMergedType(from, to)) == null) continue;
                var.setVarType(merged);
            }
        }
        return success;
    }

    private boolean remapVar(Exprent exprent, VarVersion from, VarVersion to) {
        if (exprent == null) {
            return false;
        }
        List<Exprent> lst = exprent.getAllExprents(true);
        lst.add(exprent);
        boolean remapped = false;
        for (Exprent expr : lst) {
            VarType merged;
            VarExprent var;
            VarVersion old;
            if (expr.type == 2) {
                VarType merged2;
                ConstExprent right;
                VarVersion left;
                AssignmentExprent ass = (AssignmentExprent)expr;
                if (ass.getLeft().type != 12 || ass.getRight().type != 3 || !(left = new VarVersion((VarExprent)ass.getLeft())).equals(from) && !left.equals(to) || (right = (ConstExprent)ass.getRight()).getConstType() == VarType.VARTYPE_NULL || (merged2 = this.getMergedType(from, to)) == null) continue;
                right.setConstType(merged2);
                continue;
            }
            if (expr.type != 12 || !(old = new VarVersion(var = (VarExprent)expr)).equals(from) || (merged = this.getMergedType(from, to)) == null) continue;
            var.setIndex(to.var);
            var.setVersion(to.version);
            var.setVarType(merged);
            if (var.isDefinition()) {
                var.setDefinition(false);
            }
            this.varproc.setVarType(to, merged);
            remapped = true;
        }
        return remapped;
    }

    private VarType getMergedType(VarVersion from, VarVersion to) {
        Map<VarVersion, VarType> minTypes = this.varproc.getVarVersions().getTypeProcessor().getMinExprentTypes();
        Map<VarVersion, VarType> maxTypes = this.varproc.getVarVersions().getTypeProcessor().getMaxExprentTypes();
        return VarDefinitionHelper.getMergedType(minTypes.get(from), minTypes.get(to), maxTypes.get(from), maxTypes.get(to));
    }

    private static VarType getMergedType(VarType fromMin, VarType toMin, VarType fromMax, VarType toMax) {
        VarType type;
        if (fromMin != null && fromMin.equals(toMin)) {
            return fromMin;
        }
        VarType varType = fromMin == null ? toMin : (type = toMin == null ? fromMin : VarType.getCommonSupertype(fromMin, toMin));
        if (type == null || fromMin == null || toMin == null) {
            return null;
        }
        if (type.getType() == 8) {
            if (toMax != null) {
                if (fromMax != null) {
                    if (DecompilerContext.getStructContext().instanceOf(fromMax.getValue(), toMax.getValue())) {
                        return fromMax;
                    }
                } else if (DecompilerContext.getStructContext().instanceOf(fromMin.getValue(), toMax.getValue())) {
                    return fromMin;
                }
            } else if (fromMax != null) {
                if (DecompilerContext.getStructContext().instanceOf(fromMax.getValue(), toMin.getValue())) {
                    return fromMax;
                }
            } else if (DecompilerContext.getStructContext().instanceOf(toMin.getValue(), fromMin.getValue())) {
                return toMin;
            }
            return null;
        }
        return type;
    }

    private void propogateLVTs(Statement stat) {
        MethodDescriptor md = MethodDescriptor.parseDescriptor(this.mt.getDescriptor());
        LinkedHashMap<VarVersion, VarInfo> types = new LinkedHashMap<VarVersion, VarInfo>();
        if (this.varproc.hasLVT()) {
            int index = 0;
            if (!this.mt.hasModifier(8)) {
                List<StructLocalVariableTableAttribute.LocalVariable> lvt = this.varproc.getCandidates(index);
                if (lvt != null && !lvt.isEmpty()) {
                    types.put(new VarVersion(index, 0), new VarInfo((StructLocalVariableTableAttribute.LocalVariable)lvt.get(0), null));
                }
                ++index;
            }
            for (VarType var : md.params) {
                List<StructLocalVariableTableAttribute.LocalVariable> lvt = this.varproc.getCandidates(index);
                if (lvt != null && !lvt.isEmpty()) {
                    types.put(new VarVersion(index, 0), new VarInfo(lvt.get(0), null));
                }
                index += var.getStackSize();
            }
        }
        VarDefinitionHelper.findTypes(stat, types);
        LinkedHashMap<VarVersion, String> typeNames = new LinkedHashMap<VarVersion, String>();
        for (Map.Entry entry : types.entrySet()) {
            typeNames.put((VarVersion)entry.getKey(), ((VarInfo)entry.getValue()).getCast());
        }
        Map<VarVersion, String> renames = this.mt.getVariableNamer().rename(typeNames);
        StatementIterator.iterate(this.root, exprent -> {
            NewExprent _new;
            ClassesProcessor.ClassNode child;
            ArrayList<StructMethod> methods = new ArrayList<StructMethod>();
            if (exprent.type == 12) {
                VarExprent var = (VarExprent)exprent;
                if (var.isClassDef() && (child = DecompilerContext.getClassProcessor().getMapRootClasses().get(var.getVarType().getValue())) != null) {
                    methods.addAll(child.classStruct.getMethods());
                }
            } else if (exprent.type == 10 && (_new = (NewExprent)exprent).isAnonymous() && (child = DecompilerContext.getClassProcessor().getMapRootClasses().get(_new.getNewType().getValue())) != null) {
                if (_new.isLambda()) {
                    if (!child.lambdaInformation.is_method_reference) {
                        methods.add(child.classStruct.getMethod(child.lambdaInformation.content_method_name, child.lambdaInformation.content_method_descriptor));
                    }
                } else {
                    methods.addAll(child.classStruct.getMethods());
                }
            }
            for (StructMethod meth : methods) {
                meth.getVariableNamer().addParentContext(this.mt.getVariableNamer());
            }
            return 0;
        });
        if (this.mt.enclosedClasses != null) {
            for (String cls : this.mt.enclosedClasses) {
                StructClass cl = DecompilerContext.getStructContext().getClass(cls);
                for (StructMethod meth : cl.getMethods()) {
                    meth.getVariableNamer().addParentContext(this.mt.getVariableNamer());
                }
            }
        }
        HashMap<VarVersion, StructLocalVariableTableAttribute.LocalVariable> hashMap = new HashMap<VarVersion, StructLocalVariableTableAttribute.LocalVariable>();
        for (Map.Entry e : types.entrySet()) {
            String rename;
            VarVersion idx = (VarVersion)e.getKey();
            if (idx.var == 0 && !this.mt.hasModifier(8)) continue;
            StructLocalVariableTableAttribute.LocalVariable lvt = ((VarInfo)e.getValue()).getLVT();
            String string = rename = renames == null ? null : renames.get(idx);
            if (rename != null) {
                this.varproc.setVarName(idx, rename);
            }
            if (lvt == null) continue;
            if (rename != null) {
                lvt = lvt.rename(rename);
            }
            this.varproc.setVarLVTEntry(idx, lvt);
            hashMap.put(idx, lvt);
        }
        VarDefinitionHelper.applyTypes(stat, hashMap);
    }

    private static void findTypes(Statement stat, Map<VarVersion, VarInfo> types) {
        if (stat == null) {
            return;
        }
        for (Exprent exprent : stat.getVarDefinitions()) {
            VarDefinitionHelper.findTypes(exprent, types);
        }
        for (IMatchable iMatchable : stat.getExprentsOrSequentialObjects()) {
            if (iMatchable instanceof Statement) {
                Statement statement = (Statement)iMatchable;
                VarDefinitionHelper.findTypes(statement, types);
                continue;
            }
            if (!(iMatchable instanceof Exprent)) continue;
            Exprent exprent = (Exprent)iMatchable;
            VarDefinitionHelper.findTypes(exprent, types);
        }
    }

    private static void findTypes(Exprent exp, Map<VarVersion, VarInfo> types) {
        List<Exprent> lst = exp.getAllExprents(true);
        lst.add(exp);
        for (Exprent exprent : lst) {
            if (exprent.type != 12) continue;
            VarExprent var = (VarExprent)exprent;
            VarVersion ver = new VarVersion(var);
            if (var.isDefinition()) {
                types.put(ver, new VarInfo(var.getLVTEntry(), var.getVarType()));
                continue;
            }
            VarInfo existing = types.get(ver);
            if (existing == null) {
                existing = new VarInfo(var.getLVTEntry(), var.getVarType());
            } else if (existing.getLVT() == null && var.getLVTEntry() != null) {
                existing = new VarInfo(var.getLVTEntry(), existing.getType());
            }
            types.put(ver, existing);
        }
    }

    private static void applyTypes(Statement stat, Map<VarVersion, StructLocalVariableTableAttribute.LocalVariable> types) {
        if (stat == null || types.isEmpty()) {
            return;
        }
        for (Exprent exprent : stat.getVarDefinitions()) {
            VarDefinitionHelper.applyTypes(exprent, types);
        }
        for (IMatchable iMatchable : stat.getExprentsOrSequentialObjects()) {
            if (iMatchable instanceof Statement) {
                Statement statement = (Statement)iMatchable;
                VarDefinitionHelper.applyTypes(statement, types);
                continue;
            }
            if (!(iMatchable instanceof Exprent)) continue;
            Exprent exprent = (Exprent)iMatchable;
            VarDefinitionHelper.applyTypes(exprent, types);
        }
    }

    private static void applyTypes(Exprent exprent, Map<VarVersion, StructLocalVariableTableAttribute.LocalVariable> types) {
        if (exprent == null) {
            return;
        }
        List<Exprent> lst = exprent.getAllExprents(true);
        lst.add(exprent);
        for (Exprent expr : lst) {
            VarExprent var;
            StructLocalVariableTableAttribute.LocalVariable lvt;
            if (expr.type != 12 || (lvt = types.get(new VarVersion(var = (VarExprent)expr))) == null) continue;
            var.setLVTEntry(lvt);
        }
    }

    private static boolean isVarReadFirst(VarVersion var, Statement stat, int index, VarExprent ... whitelist) {
        if (stat.getExprents() == null) {
            List<IMatchable> objs = stat.getSequentialObjects();
            for (int x = index; x < objs.size(); ++x) {
                IMatchable obj = objs.get(x);
                if (!(obj instanceof Statement ? VarDefinitionHelper.isVarReadFirst(var, (Statement)obj, 0, whitelist) : obj instanceof Exprent && VarDefinitionHelper.isVarReadFirst(var, (Exprent)obj, whitelist))) continue;
                return true;
            }
        } else {
            for (int x = index; x < stat.getExprents().size(); ++x) {
                if (!VarDefinitionHelper.isVarReadFirst(var, stat.getExprents().get(x), whitelist)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isVarReadFirst(VarVersion target, Exprent exp, VarExprent ... whitelist) {
        AssignmentExprent ass = exp.type == 2 ? (AssignmentExprent)exp : null;
        List<Exprent> lst = exp.getAllExprents(true);
        lst.add(exp);
        for (Exprent ex : lst) {
            VarExprent var;
            if (ex.type != 12 || (var = (VarExprent)ex).getIndex() != target.var || var.getVersion() != target.version) continue;
            boolean allowed = false;
            if (ass != null && var == ass.getLeft()) {
                allowed = true;
            }
            for (VarExprent white : whitelist) {
                if (var != white) continue;
                allowed = true;
                break;
            }
            if (allowed) continue;
            return true;
        }
        return false;
    }

    private static class VPPEntry
    extends AbstractMap.SimpleEntry<VarVersion, VarVersion> {
        private VPPEntry(VarExprent key, VarVersion value) {
            super(new VarVersion(key), value);
        }
    }

    private static class VarInfo {
        private final StructLocalVariableTableAttribute.LocalVariable lvt;
        private final String cast;
        private final VarType type;

        private VarInfo(StructLocalVariableTableAttribute.LocalVariable lvt, VarType type) {
            this.cast = lvt != null && lvt.getSignature() != null ? ExprProcessor.getCastTypeName(GenericType.parse(lvt.getSignature()), false, Collections.emptyList()) : (lvt != null ? ExprProcessor.getCastTypeName(lvt.getVarType(), false, Collections.emptyList()) : (type != null ? ExprProcessor.getCastTypeName(type, false, Collections.emptyList()) : "this"));
            this.lvt = lvt;
            this.type = type;
        }

        public StructLocalVariableTableAttribute.LocalVariable getLVT() {
            return this.lvt;
        }

        public String getCast() {
            return this.cast;
        }

        public VarType getType() {
            return this.type;
        }
    }
}

