/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.xml.analysis.XmlAnalysisBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EscapeCharacterIntentionFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    @FileModifier.SafeFieldForPreview
    private final TextRange range;
    private final String original;
    private final String replacement;

    public EscapeCharacterIntentionFix(@NotNull PsiElement element, @NotNull TextRange rangeWithinElement, @NotNull String original, @NotNull String replacement) {
        if (element == null) {
            EscapeCharacterIntentionFix.$$$reportNull$$$0(0);
        }
        if (rangeWithinElement == null) {
            EscapeCharacterIntentionFix.$$$reportNull$$$0(1);
        }
        if (original == null) {
            EscapeCharacterIntentionFix.$$$reportNull$$$0(2);
        }
        if (replacement == null) {
            EscapeCharacterIntentionFix.$$$reportNull$$$0(3);
        }
        super(element);
        this.range = rangeWithinElement;
        this.original = original;
        this.replacement = replacement;
    }

    @NotNull
    public String getText() {
        String string2 = XmlAnalysisBundle.message("xml.quickfix.escape.character", this.original, this.replacement);
        if (string2 == null) {
            EscapeCharacterIntentionFix.$$$reportNull$$$0(4);
        }
        return string2;
    }

    @NotNull
    public String getFamilyName() {
        String string2 = this.getText();
        if (string2 == null) {
            EscapeCharacterIntentionFix.$$$reportNull$$$0(5);
        }
        return string2;
    }

    public void invoke(@NotNull Project project2, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project2 == null) {
            EscapeCharacterIntentionFix.$$$reportNull$$$0(6);
        }
        if (file == null) {
            EscapeCharacterIntentionFix.$$$reportNull$$$0(7);
        }
        if (startElement == null) {
            EscapeCharacterIntentionFix.$$$reportNull$$$0(8);
        }
        if (endElement == null) {
            EscapeCharacterIntentionFix.$$$reportNull$$$0(9);
        }
        PsiFile topLevelFile = InjectedLanguageManager.getInstance((Project)project2).getTopLevelFile((PsiElement)file);
        Document document = topLevelFile.getViewProvider().getDocument();
        assert (document != null);
        int startOffset = InjectedLanguageManager.getInstance((Project)project2).injectedToHost(startElement, startElement.getTextRange()).getStartOffset();
        document.replaceString(startOffset + this.range.getStartOffset(), startOffset + this.range.getEndOffset(), (CharSequence)this.replacement);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeWithinElement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replacement";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/analysis/EscapeCharacterIntentionFix";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/analysis/EscapeCharacterIntentionFix";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 4, 5 -> new IllegalStateException(string2);
        };
    }
}

