/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.xml;

import com.intellij.lang.ASTNode;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.URLReference;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.xml.XmlElementImpl;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlComment;
import com.intellij.psi.xml.XmlDoctype;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlMarkupDecl;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlDoctypeImpl
extends XmlElementImpl
implements XmlDoctype {
    private static final Logger LOG = Logger.getInstance(XmlDoctypeImpl.class);

    public XmlDoctypeImpl() {
        super(XmlElementType.XML_DOCTYPE);
    }

    @Override
    public void clearCaches() {
        XmlTag rootTag;
        XmlDocument doc = this.getContainingDocument();
        if (doc != null && (rootTag = doc.getRootTag()) instanceof TreeElement) {
            ((TreeElement)rootTag).clearCaches();
        }
        super.clearCaches();
    }

    private XmlDocument getContainingDocument() {
        for (PsiElement elem = this.getParent(); elem != null; elem = elem.getParent()) {
            if (elem instanceof XmlDocument) {
                return (XmlDocument)elem;
            }
            if (elem instanceof PsiFile) break;
        }
        return null;
    }

    @Override
    @Nullable
    public String getDtdUri() {
        PsiElement dtdUrlElement = this.getDtdUrlElement();
        if (dtdUrlElement == null || dtdUrlElement.getTextLength() == 0) {
            return null;
        }
        return XmlDoctypeImpl.extractValue(dtdUrlElement);
    }

    private static String extractValue(PsiElement element) {
        String text2 = element.getText();
        if (!text2.startsWith("\"") && !text2.startsWith("'") && XmlDoctypeImpl.hasInjectedEscapingQuotes(element, text2)) {
            return XmlDoctypeImpl.stripInjectedEscapingQuotes(text2);
        }
        return StringUtil.stripQuotesAroundValue((String)text2);
    }

    private static String stripInjectedEscapingQuotes(String text2) {
        return text2.substring(2, text2.length() - 2);
    }

    private static boolean hasInjectedEscapingQuotes(PsiElement element, String text2) {
        if (text2.startsWith("\\") && text2.length() >= 4) {
            char escapedChar = text2.charAt(1);
            PsiLanguageInjectionHost context = InjectedLanguageManager.getInstance((Project)element.getContainingFile().getProject()).getInjectionHost((PsiElement)element.getContainingFile());
            if (context != null && context.textContains(escapedChar) && context.getText().startsWith(String.valueOf(escapedChar)) && text2.endsWith("\\" + escapedChar)) {
                return true;
            }
        }
        return false;
    }

    @Override
    @Nullable
    public PsiElement getDtdUrlElement() {
        PsiElement docTypeSystem;
        PsiElement docTypePublic;
        ASTNode child = this.getNode().findChildByType(XmlTokenType.XML_DOCTYPE_PUBLIC);
        PsiElement psiElement = docTypePublic = child != null ? child.getPsi() : null;
        if (docTypePublic != null) {
            PsiElement element = docTypePublic.getNextSibling();
            while (element instanceof PsiWhiteSpace || element instanceof XmlComment) {
                element = element.getNextSibling();
            }
            if (element instanceof XmlToken && ((XmlToken)element).getTokenType() == XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN) {
                element = element.getNextSibling();
                while (element instanceof PsiWhiteSpace || element instanceof XmlComment) {
                    element = element.getNextSibling();
                }
                if (element instanceof XmlToken && ((XmlToken)element).getTokenType() == XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN) {
                    return element;
                }
            }
        }
        PsiElement psiElement2 = docTypeSystem = (child = this.getNode().findChildByType(XmlTokenType.XML_DOCTYPE_SYSTEM)) != null ? child.getPsi() : null;
        if (docTypeSystem != null) {
            PsiElement element = docTypeSystem.getNextSibling();
            while (element instanceof PsiWhiteSpace || element instanceof XmlComment) {
                element = element.getNextSibling();
            }
            if (element instanceof XmlToken && ((XmlToken)element).getTokenType() == XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN) {
                return element;
            }
        }
        return null;
    }

    @Override
    public XmlElement getNameElement() {
        ASTNode child = this.getNode().findChildByType(XmlTokenType.XML_NAME);
        return child != null ? (XmlElement)child.getPsi(XmlElement.class) : null;
    }

    @Override
    @Nullable
    public String getPublicId() {
        return this.getSomeId(XmlTokenType.XML_DOCTYPE_PUBLIC);
    }

    @Override
    public String getSystemId() {
        return this.getSomeId(XmlTokenType.XML_DOCTYPE_SYSTEM);
    }

    private String getSomeId(IElementType elementType) {
        PsiElement docTypeSystem;
        ASTNode child = this.getNode().findChildByType(elementType);
        PsiElement psiElement = docTypeSystem = child != null ? child.getPsi() : null;
        if (docTypeSystem != null) {
            PsiElement element = docTypeSystem.getNextSibling();
            while (element instanceof PsiWhiteSpace || element instanceof XmlComment) {
                element = element.getNextSibling();
            }
            if (element instanceof XmlToken && ((XmlToken)element).getTokenType() == XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN && element.getTextLength() != 0) {
                return XmlDoctypeImpl.extractValue(element);
            }
        }
        return null;
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            XmlDoctypeImpl.$$$reportNull$$$0(0);
        }
        if (visitor instanceof XmlElementVisitor) {
            ((XmlElementVisitor)visitor).visitXmlDoctype(this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @Override
    public XmlMarkupDecl getMarkupDecl() {
        for (PsiElement child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof XmlMarkupDecl)) continue;
            return (XmlMarkupDecl)child;
        }
        return null;
    }

    public PsiReference @NotNull [] getReferences() {
        PsiElement dtdUrlElement = this.getDtdUrlElement();
        PsiReference uriRef = null;
        if (dtdUrlElement != null) {
            uriRef = this.createUrlReference(dtdUrlElement);
        }
        Object[] refs = ReferenceProvidersRegistry.getReferencesFromProviders((PsiElement)this);
        Object[] objectArray = uriRef == null ? refs : (PsiReference[])ArrayUtil.mergeArrays((Object[])new PsiReference[]{uriRef}, (Object[])refs);
        if (objectArray == null) {
            XmlDoctypeImpl.$$$reportNull$$$0(1);
        }
        return objectArray;
    }

    protected PsiReference createUrlReference(final PsiElement dtdUrlElement) {
        return new URLReference(this){

            @Override
            @NotNull
            public String getCanonicalText() {
                String string2 = XmlDoctypeImpl.extractValue(dtdUrlElement);
                if (string2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string2;
            }

            @Override
            @NotNull
            public TextRange getRangeInElement() {
                TextRange textRange = TextRange.from((int)(dtdUrlElement.getTextRange().getStartOffset() - XmlDoctypeImpl.this.getTextRange().getStartOffset() + 1), (int)Math.max(dtdUrlElement.getTextRange().getLength() - 2, 0));
                if (textRange == null) {
                    1.$$$reportNull$$$0(1);
                }
                return textRange;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/psi/impl/source/xml/XmlDoctypeImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getCanonicalText";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getRangeInElement";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/xml/XmlDoctypeImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/xml/XmlDoctypeImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1 -> new IllegalStateException(string2);
        };
    }
}

