/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.text.Collator;
import java.util.BitSet;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Filter;
import org.apache.lucene.util.OpenBitSet;

public class RangeFilter
extends Filter {
    private String fieldName;
    private String lowerTerm;
    private String upperTerm;
    private boolean includeLower;
    private boolean includeUpper;
    private Collator collator;

    public RangeFilter(String fieldName, String lowerTerm, String upperTerm, boolean includeLower, boolean includeUpper) {
        this.fieldName = fieldName;
        this.lowerTerm = lowerTerm;
        this.upperTerm = upperTerm;
        this.includeLower = includeLower;
        this.includeUpper = includeUpper;
        if (null == lowerTerm && null == upperTerm) {
            throw new IllegalArgumentException("At least one value must be non-null");
        }
        if (includeLower && null == lowerTerm) {
            throw new IllegalArgumentException("The lower bound must be non-null to be inclusive");
        }
        if (includeUpper && null == upperTerm) {
            throw new IllegalArgumentException("The upper bound must be non-null to be inclusive");
        }
    }

    public RangeFilter(String fieldName, String lowerTerm, String upperTerm, boolean includeLower, boolean includeUpper, Collator collator) {
        this(fieldName, lowerTerm, upperTerm, includeLower, includeUpper);
        this.collator = collator;
    }

    public static RangeFilter Less(String fieldName, String upperTerm) {
        return new RangeFilter(fieldName, null, upperTerm, false, true);
    }

    public static RangeFilter More(String fieldName, String lowerTerm) {
        return new RangeFilter(fieldName, lowerTerm, null, true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BitSet bits(IndexReader reader) throws IOException {
        BitSet bits = new BitSet(reader.maxDoc());
        TermEnum enumerator = null != this.lowerTerm && this.collator == null ? reader.terms(new Term(this.fieldName, this.lowerTerm)) : reader.terms(new Term(this.fieldName));
        try {
            if (enumerator.term() == null) {
                BitSet bitSet = bits;
                return bitSet;
            }
            TermDocs termDocs = reader.termDocs();
            try {
                boolean checkLower;
                if (this.collator == null) {
                    checkLower = false;
                    if (!this.includeLower) {
                        checkLower = true;
                    }
                } else {
                    do {
                        Term term;
                        if ((term = enumerator.term()) == null || !term.field().equals(this.fieldName) || this.lowerTerm != null && !(this.includeLower ? this.collator.compare(term.text(), this.lowerTerm) >= 0 : this.collator.compare(term.text(), this.lowerTerm) > 0) || this.upperTerm != null && !(this.includeUpper ? this.collator.compare(term.text(), this.upperTerm) <= 0 : this.collator.compare(term.text(), this.upperTerm) < 0)) continue;
                        termDocs.seek(enumerator.term());
                        while (termDocs.next()) {
                            bits.set(termDocs.doc());
                        }
                    } while (enumerator.next());
                    return bits;
                }
                do {
                    Term term;
                    if ((term = enumerator.term()) == null) return bits;
                    if (!term.field().equals(this.fieldName)) return bits;
                    if (checkLower && null != this.lowerTerm && term.text().compareTo(this.lowerTerm) <= 0) continue;
                    checkLower = false;
                    if (this.upperTerm != null) {
                        int compare = this.upperTerm.compareTo(term.text());
                        if (compare < 0) return bits;
                        if (!this.includeUpper && compare == 0) {
                            return bits;
                        }
                    }
                    termDocs.seek(enumerator.term());
                    while (termDocs.next()) {
                        bits.set(termDocs.doc());
                    }
                } while (enumerator.next());
                return bits;
            }
            finally {
                termDocs.close();
            }
        }
        finally {
            enumerator.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DocIdSet getDocIdSet(IndexReader reader) throws IOException {
        OpenBitSet bits = new OpenBitSet(reader.maxDoc());
        TermEnum enumerator = null != this.lowerTerm && this.collator == null ? reader.terms(new Term(this.fieldName, this.lowerTerm)) : reader.terms(new Term(this.fieldName));
        try {
            if (enumerator.term() == null) {
                OpenBitSet openBitSet = bits;
                return openBitSet;
            }
            TermDocs termDocs = reader.termDocs();
            try {
                boolean checkLower;
                if (this.collator == null) {
                    checkLower = false;
                    if (!this.includeLower) {
                        checkLower = true;
                    }
                } else {
                    do {
                        Term term;
                        if ((term = enumerator.term()) == null || !term.field().equals(this.fieldName) || this.lowerTerm != null && !(this.includeLower ? this.collator.compare(term.text(), this.lowerTerm) >= 0 : this.collator.compare(term.text(), this.lowerTerm) > 0) || this.upperTerm != null && !(this.includeUpper ? this.collator.compare(term.text(), this.upperTerm) <= 0 : this.collator.compare(term.text(), this.upperTerm) < 0)) continue;
                        termDocs.seek(enumerator.term());
                        while (termDocs.next()) {
                            bits.set(termDocs.doc());
                        }
                    } while (enumerator.next());
                    return bits;
                }
                do {
                    Term term;
                    if ((term = enumerator.term()) == null) return bits;
                    if (!term.field().equals(this.fieldName)) return bits;
                    if (checkLower && null != this.lowerTerm && term.text().compareTo(this.lowerTerm) <= 0) continue;
                    checkLower = false;
                    if (this.upperTerm != null) {
                        int compare = this.upperTerm.compareTo(term.text());
                        if (compare < 0) return bits;
                        if (!this.includeUpper && compare == 0) {
                            return bits;
                        }
                    }
                    termDocs.seek(enumerator.term());
                    while (termDocs.next()) {
                        bits.set(termDocs.doc());
                    }
                } while (enumerator.next());
                return bits;
            }
            finally {
                termDocs.close();
            }
        }
        finally {
            enumerator.close();
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.fieldName);
        buffer.append(":");
        buffer.append(this.includeLower ? "[" : "{");
        if (null != this.lowerTerm) {
            buffer.append(this.lowerTerm);
        }
        buffer.append("-");
        if (null != this.upperTerm) {
            buffer.append(this.upperTerm);
        }
        buffer.append(this.includeUpper ? "]" : "}");
        return buffer.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RangeFilter)) {
            return false;
        }
        RangeFilter other = (RangeFilter)o;
        if (!this.fieldName.equals(other.fieldName) || this.includeLower != other.includeLower || this.includeUpper != other.includeUpper || this.collator != null && !this.collator.equals(other.collator)) {
            return false;
        }
        if (this.lowerTerm != null ? !this.lowerTerm.equals(other.lowerTerm) : other.lowerTerm != null) {
            return false;
        }
        return !(this.upperTerm != null ? !this.upperTerm.equals(other.upperTerm) : other.upperTerm != null);
    }

    public int hashCode() {
        int h = this.fieldName.hashCode();
        h ^= this.lowerTerm != null ? this.lowerTerm.hashCode() : -1225987966;
        h = h << 1 | h >>> 31;
        h ^= this.upperTerm != null ? this.upperTerm.hashCode() : -1849769278;
        h ^= (this.includeLower ? -729499341 : 0) ^ (this.includeUpper ? 1793336236 : 0);
        return h ^= this.collator != null ? this.collator.hashCode() : 0;
    }
}

