/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.logging;

import com.intellij.java.library.JavaLibraryUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.siyeh.ig.callMatcher.CallMatcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UFile;
import org.jetbrains.uast.UIfExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UParameter;
import org.jetbrains.uast.UPolyadicExpression;
import org.jetbrains.uast.UPrefixExpression;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UResolvable;
import org.jetbrains.uast.UResolvableKt;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UastBinaryOperator;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastPrefixOperator;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\u0018\u0000 \u00042\u00020\u0001:\u0002\u0004\u0005B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0006"}, d2={"Lcom/intellij/codeInspection/logging/LoggingUtil;", "", "<init>", "()V", "Companion", "LimitLevelType", "intellij.jvm.analysis.impl"})
@SourceDebugExtension(value={"SMAP\nLoggingUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LoggingUtil.kt\ncom/intellij/codeInspection/logging/LoggingUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,458:1\n1202#2,2:459\n1230#2,4:461\n1202#2,2:465\n1230#2,4:467\n*S KotlinDebug\n*F\n+ 1 LoggingUtil.kt\ncom/intellij/codeInspection/logging/LoggingUtil\n*L\n70#1:459,2\n70#1:461,4\n71#1:465,2\n71#1:467,4\n*E\n"})
public final class LoggingUtil {
    @NotNull
    public static final Companion Companion;
    @NotNull
    public static final String SLF4J_LOGGER = "org.slf4j.Logger";
    @NotNull
    public static final String LOG4J_LOGGER = "org.apache.logging.log4j.Logger";
    @NotNull
    public static final String LOG4J_LOG_BUILDER = "org.apache.logging.log4j.LogBuilder";
    @NotNull
    public static final String SLF4J_EVENT_BUILDER = "org.slf4j.spi.LoggingEventBuilder";
    @NotNull
    private static final String LEGACY_LOG4J_LOGGER = "org.apache.log4j.Logger";
    @NotNull
    private static final String LEGACY_CATEGORY_LOGGER = "org.apache.log4j.Category";
    @NotNull
    private static final String LEGACY_APACHE_COMMON_LOGGER = "org.apache.commons.logging.Log";
    @NotNull
    private static final String LEGACY_JAVA_LOGGER = "java.util.logging.Logger";
    @NotNull
    public static final String AKKA_LOGGING = "akka.event.LoggingAdapter";
    @NotNull
    public static final String IDEA_LOGGER = "com.intellij.openapi.diagnostic.Logger";
    @NotNull
    private static final Set<String> LOGGER_CLASSES;
    @NotNull
    private static final Set<String> LEGACY_LOGGER_CLASSES;
    @NotNull
    private static final CallMatcher.Simple SLF4J_MATCHER;
    @NotNull
    private static final CallMatcher.Simple LOG4J_MATCHER;
    @NotNull
    private static final CallMatcher.Simple LOG4J_BUILDER_MATCHER;
    @NotNull
    private static final CallMatcher.Simple SLF4J_BUILDER_MATCHER;
    @NotNull
    private static final CallMatcher LOG_MATCHERS;
    @NotNull
    private static final CallMatcher LOG_MATCHERS_WITHOUT_BUILDERS;
    @NotNull
    private static final CallMatcher FORMATTED_LOG4J;
    @NotNull
    public static final String LOG_4_J_LOGGER = "org.apache.logging.slf4j.Log4jLogger";
    @NotNull
    private static final CallMatcher LEGACY_LOG_MATCHERS;
    @NotNull
    private static final CallMatcher IDEA_LOG_MATCHER;
    @NotNull
    private static final Set<String> LEGACY_METHODS_WITH_LEVEL;
    @NotNull
    private static final Map<String, Companion.LevelType> LEVEL_MAP;
    @NotNull
    private static final Map<String, Companion.LegacyLevelType> LEGACY_LEVEL_MAP;
    @NotNull
    private static final Set<String> LEVEL_CLASSES;
    @NotNull
    private static final Set<String> LEGACY_LEVEL_CLASSES;
    @NotNull
    private static final Map<String, String> GUARD_MAP;

    static {
        Companion.LegacyLevelType it;
        Map map;
        Iterable $this$associateByTo$iv$iv;
        Companion = new Companion(null);
        Object[] objectArray = new String[]{SLF4J_LOGGER, LOG4J_LOGGER};
        LOGGER_CLASSES = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{LEGACY_LOG4J_LOGGER, LEGACY_CATEGORY_LOGGER, LEGACY_APACHE_COMMON_LOGGER, LEGACY_JAVA_LOGGER};
        LEGACY_LOGGER_CLASSES = SetsKt.setOf((Object[])objectArray);
        String[] stringArray = new String[]{"trace", "debug", "info", "warn", "error"};
        CallMatcher.Simple simple = CallMatcher.instanceCall((String)SLF4J_LOGGER, (String[])stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)simple, (String)"instanceCall(...)");
        SLF4J_MATCHER = simple;
        stringArray = new String[]{"trace", "debug", "info", "warn", "error", "fatal", "log"};
        CallMatcher.Simple simple2 = CallMatcher.instanceCall((String)LOG4J_LOGGER, (String[])stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)simple2, (String)"instanceCall(...)");
        LOG4J_MATCHER = simple2;
        stringArray = new String[]{"log"};
        CallMatcher.Simple simple3 = CallMatcher.instanceCall((String)LOG4J_LOG_BUILDER, (String[])stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)simple3, (String)"instanceCall(...)");
        LOG4J_BUILDER_MATCHER = simple3;
        stringArray = new String[]{"log"};
        CallMatcher.Simple simple4 = CallMatcher.instanceCall((String)SLF4J_EVENT_BUILDER, (String[])stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)simple4, (String)"instanceCall(...)");
        SLF4J_BUILDER_MATCHER = simple4;
        stringArray = new CallMatcher[]{SLF4J_MATCHER, LOG4J_MATCHER, LOG4J_BUILDER_MATCHER, SLF4J_BUILDER_MATCHER};
        CallMatcher callMatcher = CallMatcher.anyOf((CallMatcher[])stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)callMatcher, (String)"anyOf(...)");
        LOG_MATCHERS = callMatcher;
        stringArray = new CallMatcher[]{SLF4J_MATCHER, LOG4J_MATCHER};
        CallMatcher callMatcher2 = CallMatcher.anyOf((CallMatcher[])stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)callMatcher2, (String)"anyOf(...)");
        LOG_MATCHERS_WITHOUT_BUILDERS = callMatcher2;
        stringArray = new String[]{"getFormatterLogger"};
        CallMatcher.Simple simple5 = CallMatcher.staticCall((String)"org.apache.logging.log4j.LogManager", (String[])stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)simple5, (String)"staticCall(...)");
        FORMATTED_LOG4J = (CallMatcher)simple5;
        stringArray = new CallMatcher[4];
        String[] stringArray2 = new String[]{"trace", "debug", "info", "warn", "error", "fatal", "log", "l7dlog"};
        stringArray[0] = CallMatcher.instanceCall((String)LEGACY_LOG4J_LOGGER, (String[])stringArray2);
        stringArray2 = new String[]{"debug", "info", "warn", "error", "fatal", "log", "l7dlog"};
        stringArray[1] = CallMatcher.instanceCall((String)LEGACY_CATEGORY_LOGGER, (String[])stringArray2);
        stringArray2 = new String[]{"trace", "debug", "info", "warn", "error", "fatal"};
        stringArray[2] = CallMatcher.instanceCall((String)LEGACY_APACHE_COMMON_LOGGER, (String[])stringArray2);
        stringArray2 = new String[]{"fine", "log", "finer", "finest", "logp", "logrb", "info", "severe", "warning", "config"};
        stringArray[3] = CallMatcher.instanceCall((String)LEGACY_JAVA_LOGGER, (String[])stringArray2);
        CallMatcher callMatcher3 = CallMatcher.anyOf((CallMatcher[])stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)callMatcher3, (String)"anyOf(...)");
        LEGACY_LOG_MATCHERS = callMatcher3;
        stringArray = new CallMatcher[1];
        stringArray2 = new String[]{"trace", "debug", "info", "warn", "error"};
        stringArray[0] = CallMatcher.instanceCall((String)IDEA_LOGGER, (String[])stringArray2);
        CallMatcher callMatcher4 = CallMatcher.anyOf((CallMatcher[])stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)callMatcher4, (String)"anyOf(...)");
        IDEA_LOG_MATCHER = callMatcher4;
        objectArray = new String[]{"log", "l7dlog", "logp", "logrb"};
        LEGACY_METHODS_WITH_LEVEL = SetsKt.setOf((Object[])objectArray);
        Iterable $this$associateBy$iv = (Iterable)Companion.LevelType.getEntries();
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            Companion.LevelType levelType = (Companion.LevelType)((Object)element$iv$iv);
            map = destination$iv$iv;
            boolean bl = false;
            map.put(it.name(), element$iv$iv);
        }
        LEVEL_MAP = destination$iv$iv;
        $this$associateBy$iv = (Iterable)Companion.LegacyLevelType.getEntries();
        $i$f$associateBy = false;
        capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        $this$associateByTo$iv$iv = $this$associateBy$iv;
        destination$iv$iv = new LinkedHashMap(capacity$iv);
        $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            it = (Companion.LegacyLevelType)((Object)element$iv$iv);
            map = destination$iv$iv;
            boolean bl = false;
            map.put(it.name(), element$iv$iv);
        }
        LEGACY_LEVEL_MAP = destination$iv$iv;
        objectArray = new String[]{"org.apache.logging.log4j.Level", "org.slf4j.event.Level"};
        LEVEL_CLASSES = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{"org.apache.logging.log4j.Level", "org.apache.log4j.Priority", "java.util.logging.Level"};
        LEGACY_LEVEL_CLASSES = SetsKt.setOf((Object[])objectArray);
        objectArray = new Pair[]{new Pair((Object)"isTraceEnabled", (Object)"trace"), new Pair((Object)"isDebugEnabled", (Object)"debug"), new Pair((Object)"isInfoEnabled", (Object)"info"), new Pair((Object)"isWarnEnabled", (Object)"warn"), new Pair((Object)"isErrorEnabled", (Object)"error"), new Pair((Object)"isFatalEnabled", (Object)"fatal")};
        GUARD_MAP = MapsKt.mapOf((Pair[])objectArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\b\n\u0002\b\u0010\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0003mnoB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0000\u00a2\u0006\u0002\b2J\u0019\u00103\u001a\u0004\u0018\u0001042\b\u00105\u001a\u0004\u0018\u00010/H\u0000\u00a2\u0006\u0002\b6J\u0015\u00107\u001a\u00020-2\u0006\u00108\u001a\u00020/H\u0000\u00a2\u0006\u0002\b9J\u001d\u0010:\u001a\u00020-2\u0006\u0010;\u001a\u00020'2\u0006\u0010<\u001a\u00020'H\u0000\u00a2\u0006\u0002\b=J\u001d\u0010>\u001a\u00020-2\u0006\u0010;\u001a\u00020)2\u0006\u0010<\u001a\u00020)H\u0000\u00a2\u0006\u0002\b?J\u0017\u0010@\u001a\u0004\u0018\u00010)2\u0006\u0010A\u001a\u00020BH\u0000\u00a2\u0006\u0002\bCJ\u0017\u0010D\u001a\u0004\u0018\u00010'2\u0006\u0010A\u001a\u00020BH\u0000\u00a2\u0006\u0002\bEJ\u0019\u0010F\u001a\u0004\u0018\u00010B2\b\u00108\u001a\u0004\u0018\u00010/H\u0000\u00a2\u0006\u0002\bGJ\u001e\u0010H\u001a\b\u0012\u0004\u0012\u00020J0I2\u0006\u0010K\u001a\u00020L2\u0006\u0010M\u001a\u00020LH\u0002J\u001a\u0010F\u001a\u0004\u0018\u00010B2\u0006\u0010A\u001a\u00020B2\u0006\u0010N\u001a\u00020LH\u0002J1\u0010O\u001a\u0004\u0018\u0001HP\"\u0004\b\u0000\u0010P2\u0006\u0010Q\u001a\u00020\u00052\u0012\u0010R\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u0002HP0&H\u0002\u00a2\u0006\u0002\u0010SJ\u0014\u0010T\u001a\u0004\u0018\u00010L2\b\u00108\u001a\u0004\u0018\u00010/H\u0002J\u0019\u0010U\u001a\u0004\u0018\u00010)2\b\u00105\u001a\u0004\u0018\u00010/H\u0000\u00a2\u0006\u0002\bVJ#\u0010W\u001a\u0004\u0018\u00010'2\b\u00105\u001a\u0004\u0018\u00010/2\b\b\u0002\u0010X\u001a\u00020-H\u0000\u00a2\u0006\u0002\bYJ?\u0010Z\u001a\u0004\u0018\u0001HP\"\u0004\b\u0000\u0010P2\u0006\u00105\u001a\u00020/2\f\u0010[\u001a\b\u0012\u0004\u0012\u00020\u00050\u00102\u0012\u0010R\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u0002HP0&H\u0002\u00a2\u0006\u0002\u0010\\J1\u0010]\u001a\u0004\u0018\u0001HP\"\u0004\b\u0000\u0010P2\u0006\u0010^\u001a\u00020\u00052\u0012\u0010R\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u0002HP0&H\u0002\u00a2\u0006\u0002\u0010SJ\u001f\u0010_\u001a\u00020`2\u0006\u0010a\u001a\u00020\u00052\b\u0010b\u001a\u0004\u0018\u000104H\u0000\u00a2\u0006\u0002\bcJ\u001b\u0010d\u001a\b\u0012\u0004\u0012\u00020/0I2\u0006\u0010e\u001a\u00020BH\u0000\u00a2\u0006\u0002\bfJ\u0015\u0010g\u001a\u00020-2\u0006\u0010h\u001a\u00020LH\u0000\u00a2\u0006\u0002\biR\u000e\u0010\u0004\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\u00020\u0018X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u0018X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001aR\u0014\u0010\u001d\u001a\u00020\u0018X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001aR\u000e\u0010\u001f\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020\u0018X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u001aR\u0014\u0010\"\u001a\u00020\u0018X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u001aR\u0014\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00050\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020'0&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020)0&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00050\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00050\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010j\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050&\u00a2\u0006\b\n\u0000\u001a\u0004\bk\u0010l\u00a8\u0006p"}, d2={"Lcom/intellij/codeInspection/logging/LoggingUtil$Companion;", "", "<init>", "()V", "SLF4J_LOGGER", "", "LOG4J_LOGGER", "LOG4J_LOG_BUILDER", "SLF4J_EVENT_BUILDER", "LEGACY_LOG4J_LOGGER", "LEGACY_CATEGORY_LOGGER", "LEGACY_APACHE_COMMON_LOGGER", "LEGACY_JAVA_LOGGER", "AKKA_LOGGING", "IDEA_LOGGER", "LOGGER_CLASSES", "", "LEGACY_LOGGER_CLASSES", "SLF4J_MATCHER", "Lcom/siyeh/ig/callMatcher/CallMatcher$Simple;", "LOG4J_MATCHER", "LOG4J_BUILDER_MATCHER", "SLF4J_BUILDER_MATCHER", "LOG_MATCHERS", "Lcom/siyeh/ig/callMatcher/CallMatcher;", "getLOG_MATCHERS$intellij_jvm_analysis_impl", "()Lcom/siyeh/ig/callMatcher/CallMatcher;", "LOG_MATCHERS_WITHOUT_BUILDERS", "getLOG_MATCHERS_WITHOUT_BUILDERS$intellij_jvm_analysis_impl", "FORMATTED_LOG4J", "getFORMATTED_LOG4J$intellij_jvm_analysis_impl", "LOG_4_J_LOGGER", "LEGACY_LOG_MATCHERS", "getLEGACY_LOG_MATCHERS$intellij_jvm_analysis_impl", "IDEA_LOG_MATCHER", "getIDEA_LOG_MATCHER$intellij_jvm_analysis_impl", "LEGACY_METHODS_WITH_LEVEL", "LEVEL_MAP", "", "Lcom/intellij/codeInspection/logging/LoggingUtil$Companion$LevelType;", "LEGACY_LEVEL_MAP", "Lcom/intellij/codeInspection/logging/LoggingUtil$Companion$LegacyLevelType;", "LEVEL_CLASSES", "LEGACY_LEVEL_CLASSES", "skipAccordingLevel", "", "node", "Lorg/jetbrains/uast/UCallExpression;", "myLimitLevelType", "Lcom/intellij/codeInspection/logging/LoggingUtil$LimitLevelType;", "skipAccordingLevel$intellij_jvm_analysis_impl", "getLoggerType", "Lcom/intellij/codeInspection/logging/LoggingUtil$Companion$LoggerType;", "uCall", "getLoggerType$intellij_jvm_analysis_impl", "isGuarded", "call", "isGuarded$intellij_jvm_analysis_impl", "isGuardedIn", "levelFromCondition", "loggerLevel", "isGuardedIn$intellij_jvm_analysis_impl", "isLegacyGuardedIn", "isLegacyGuardedIn$intellij_jvm_analysis_impl", "getLegacyLevelFromCondition", "condition", "Lorg/jetbrains/uast/UExpression;", "getLegacyLevelFromCondition$intellij_jvm_analysis_impl", "getLevelFromCondition", "getLevelFromCondition$intellij_jvm_analysis_impl", "getGuardedCondition", "getGuardedCondition$intellij_jvm_analysis_impl", "getReferencesForVariable", "", "Lorg/jetbrains/uast/UQualifiedReferenceExpression;", "variable", "Lorg/jetbrains/uast/UElement;", "context", "loggerSource", "levelTypeFromGuard", "T", "methodName", "levelMap", "(Ljava/lang/String;Ljava/util/Map;)Ljava/lang/Object;", "getLoggerQualifier", "getLegacyLoggerLevel", "getLegacyLoggerLevel$intellij_jvm_analysis_impl", "getLoggerLevel", "isLog", "getLoggerLevel$intellij_jvm_analysis_impl", "findLevelTypeByFirstArgument", "levelClasses", "(Lorg/jetbrains/uast/UCallExpression;Ljava/util/Set;Ljava/util/Map;)Ljava/lang/Object;", "findLevelTypeByName", "levelName", "countPlaceHolders", "", "text", "loggerType", "countPlaceHolders$intellij_jvm_analysis_impl", "getLoggerCalls", "guardedCondition", "getLoggerCalls$intellij_jvm_analysis_impl", "hasBridgeFromSlf4jToLog4j2", "element", "hasBridgeFromSlf4jToLog4j2$intellij_jvm_analysis_impl", "GUARD_MAP", "getGUARD_MAP", "()Ljava/util/Map;", "LoggerType", "LevelType", "LegacyLevelType", "intellij.jvm.analysis.impl"})
    @SourceDebugExtension(value={"SMAP\nLoggingUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LoggingUtil.kt\ncom/intellij/codeInspection/logging/LoggingUtil$Companion\n+ 2 UastUtils.kt\norg/jetbrains/uast/UastUtils__UastUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 UastContext.kt\norg/jetbrains/uast/UastContextKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,458:1\n18#2:459\n18#2:460\n18#2:465\n2632#3,3:461\n1611#3,9:466\n1863#3:475\n1864#3:477\n1620#3:478\n774#3:479\n865#3,2:480\n774#3:482\n865#3,2:483\n171#4:464\n1#5:476\n*S KotlinDebug\n*F\n+ 1 LoggingUtil.kt\ncom/intellij/codeInspection/logging/LoggingUtil$Companion\n*L\n167#1:459\n170#1:460\n410#1:465\n338#1:461,3\n415#1:466,9\n415#1:475\n415#1:477\n415#1:478\n416#1:479\n416#1:480,2\n417#1:482\n417#1:483,2\n392#1:464\n415#1:476\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CallMatcher getLOG_MATCHERS$intellij_jvm_analysis_impl() {
            return LOG_MATCHERS;
        }

        @NotNull
        public final CallMatcher getLOG_MATCHERS_WITHOUT_BUILDERS$intellij_jvm_analysis_impl() {
            return LOG_MATCHERS_WITHOUT_BUILDERS;
        }

        @NotNull
        public final CallMatcher getFORMATTED_LOG4J$intellij_jvm_analysis_impl() {
            return FORMATTED_LOG4J;
        }

        @NotNull
        public final CallMatcher getLEGACY_LOG_MATCHERS$intellij_jvm_analysis_impl() {
            return LEGACY_LOG_MATCHERS;
        }

        @NotNull
        public final CallMatcher getIDEA_LOG_MATCHER$intellij_jvm_analysis_impl() {
            return IDEA_LOG_MATCHER;
        }

        public final boolean skipAccordingLevel$intellij_jvm_analysis_impl(@NotNull UCallExpression node, @NotNull LimitLevelType myLimitLevelType) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)((Object)myLimitLevelType), (String)"myLimitLevelType");
            if (myLimitLevelType != LimitLevelType.ALL) {
                LevelType loggerLevel = com.intellij.codeInspection.logging.LoggingUtil$Companion.getLoggerLevel$intellij_jvm_analysis_impl$default(this, node, false, 2, null);
                if (loggerLevel == null) {
                    return true;
                }
                LevelType levelType = loggerLevel;
                boolean notSkip = switch (WhenMappings.$EnumSwitchMapping$0[levelType.ordinal()]) {
                    case 1 -> false;
                    case 2 -> false;
                    case 3 -> {
                        if (myLimitLevelType.ordinal() == LimitLevelType.WARN_AND_LOWER.ordinal()) {
                            yield true;
                        }
                        yield false;
                    }
                    case 4 -> {
                        if (myLimitLevelType.ordinal() <= LimitLevelType.INFO_AND_LOWER.ordinal()) {
                            yield true;
                        }
                        yield false;
                    }
                    case 5 -> {
                        if (myLimitLevelType.ordinal() <= LimitLevelType.DEBUG_AND_LOWER.ordinal()) {
                            yield true;
                        }
                        yield false;
                    }
                    case 6 -> {
                        if (myLimitLevelType.ordinal() <= LimitLevelType.TRACE.ordinal()) {
                            yield true;
                        }
                        yield false;
                    }
                    default -> throw new NoWhenBranchMatchedException();
                };
                return !notSkip;
            }
            return false;
        }

        @Nullable
        public final LoggerType getLoggerType$intellij_jvm_analysis_impl(@Nullable UCallExpression uCall) {
            return SLF4J_MATCHER.uCallMatches(uCall) ? LoggerType.SLF4J_LOGGER_TYPE : (LOG4J_MATCHER.uCallMatches(uCall) ? LoggerType.LOG4J_LOGGER_TYPE : (LOG4J_BUILDER_MATCHER.uCallMatches(uCall) ? LoggerType.LOG4J_BUILDER_TYPE : (SLF4J_BUILDER_MATCHER.uCallMatches(uCall) ? LoggerType.SLF4J_BUILDER_TYPE : null)));
        }

        public final boolean isGuarded$intellij_jvm_analysis_impl(@NotNull UCallExpression call) {
            Intrinsics.checkNotNullParameter((Object)call, (String)"call");
            LevelType levelType = com.intellij.codeInspection.logging.LoggingUtil$Companion.getLoggerLevel$intellij_jvm_analysis_impl$default(this, call, false, 2, null);
            if (levelType == null) {
                return false;
            }
            LevelType loggerLevel = levelType;
            UExpression uExpression = this.getGuardedCondition$intellij_jvm_analysis_impl(call);
            if (uExpression == null) {
                return false;
            }
            UExpression guardedCondition = uExpression;
            LevelType levelType2 = this.getLevelFromCondition$intellij_jvm_analysis_impl(guardedCondition);
            if (levelType2 == null) {
                return false;
            }
            LevelType levelFromCondition = levelType2;
            return this.isGuardedIn$intellij_jvm_analysis_impl(levelFromCondition, loggerLevel);
        }

        public final boolean isGuardedIn$intellij_jvm_analysis_impl(@NotNull LevelType levelFromCondition, @NotNull LevelType loggerLevel) {
            Intrinsics.checkNotNullParameter((Object)((Object)levelFromCondition), (String)"levelFromCondition");
            Intrinsics.checkNotNullParameter((Object)((Object)loggerLevel), (String)"loggerLevel");
            return levelFromCondition == loggerLevel;
        }

        public final boolean isLegacyGuardedIn$intellij_jvm_analysis_impl(@NotNull LegacyLevelType levelFromCondition, @NotNull LegacyLevelType loggerLevel) {
            Intrinsics.checkNotNullParameter((Object)((Object)levelFromCondition), (String)"levelFromCondition");
            Intrinsics.checkNotNullParameter((Object)((Object)loggerLevel), (String)"loggerLevel");
            return levelFromCondition == loggerLevel;
        }

        @Nullable
        public final LegacyLevelType getLegacyLevelFromCondition$intellij_jvm_analysis_impl(@NotNull UExpression condition) {
            Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
            if (condition instanceof UCallExpression) {
                String string = ((UCallExpression)condition).getMethodName();
                if (string == null) {
                    return null;
                }
                String methodName = string;
                if (Intrinsics.areEqual((Object)"isEnabledFor", (Object)methodName) || Intrinsics.areEqual((Object)"isLoggable", (Object)methodName)) {
                    return (LegacyLevelType)((Object)this.findLevelTypeByFirstArgument((UCallExpression)condition, LEGACY_LEVEL_CLASSES, LEGACY_LEVEL_MAP));
                }
                return (LegacyLevelType)((Object)this.levelTypeFromGuard(methodName, LEGACY_LEVEL_MAP));
            }
            if (condition instanceof UQualifiedReferenceExpression) {
                if (((UQualifiedReferenceExpression)condition).getSelector() instanceof UCallExpression) {
                    return this.getLegacyLevelFromCondition$intellij_jvm_analysis_impl(((UQualifiedReferenceExpression)condition).getSelector());
                }
                String string = ((UQualifiedReferenceExpression)condition).getResolvedName();
                if (string == null) {
                    return null;
                }
                String methodName = string;
                return (LegacyLevelType)((Object)this.levelTypeFromGuard(methodName, LEGACY_LEVEL_MAP));
            }
            return null;
        }

        @Nullable
        public final LevelType getLevelFromCondition$intellij_jvm_analysis_impl(@NotNull UExpression condition) {
            Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
            if (condition instanceof UCallExpression) {
                String string = ((UCallExpression)condition).getMethodName();
                if (string == null) {
                    return null;
                }
                String methodName = string;
                if (Intrinsics.areEqual((Object)"isEnabled", (Object)methodName) || Intrinsics.areEqual((Object)"isEnabledForLevel", (Object)methodName)) {
                    return (LevelType)((Object)this.findLevelTypeByFirstArgument((UCallExpression)condition, LEVEL_CLASSES, LEVEL_MAP));
                }
                return (LevelType)((Object)this.levelTypeFromGuard(methodName, LEVEL_MAP));
            }
            if (condition instanceof UQualifiedReferenceExpression) {
                if (((UQualifiedReferenceExpression)condition).getSelector() instanceof UCallExpression) {
                    return this.getLevelFromCondition$intellij_jvm_analysis_impl(((UQualifiedReferenceExpression)condition).getSelector());
                }
                String string = ((UQualifiedReferenceExpression)condition).getResolvedName();
                if (string == null) {
                    return null;
                }
                String methodName = string;
                return (LevelType)((Object)this.levelTypeFromGuard(methodName, LEVEL_MAP));
            }
            return null;
        }

        @Nullable
        public final UExpression getGuardedCondition$intellij_jvm_analysis_impl(@Nullable UCallExpression call) {
            if (call == null) {
                return null;
            }
            UElement uElement = this.getLoggerQualifier(call);
            if (uElement == null) {
                return null;
            }
            UElement loggerSource = uElement;
            UElement $this$getParentOfType_u24default$iv = (UElement)call;
            boolean strict$iv = true;
            boolean $i$f$getParentOfType = false;
            UIfExpression uIfExpression = (UIfExpression)UastUtils.getParentOfType((UElement)$this$getParentOfType_u24default$iv, UIfExpression.class, (boolean)strict$iv);
            if (uIfExpression == null) {
                return null;
            }
            UIfExpression ifExpression = uIfExpression;
            while (this.getReferencesForVariable(loggerSource, (UElement)ifExpression.getCondition()).isEmpty()) {
                $this$getParentOfType_u24default$iv = (UElement)ifExpression;
                strict$iv = true;
                $i$f$getParentOfType = false;
                if ((UIfExpression)UastUtils.getParentOfType((UElement)$this$getParentOfType_u24default$iv, UIfExpression.class, (boolean)strict$iv) != null) continue;
                return null;
            }
            UExpression condition = UastUtils.skipParenthesizedExprDown((UExpression)ifExpression.getCondition());
            if (condition instanceof UPrefixExpression) {
                if (!Intrinsics.areEqual((Object)((UPrefixExpression)condition).getOperator(), (Object)UastPrefixOperator.LOGICAL_NOT)) {
                    return null;
                }
                UExpression elseExpression = ifExpression.getElseExpression();
                if (elseExpression == null || !UastUtils.isPsiAncestor$default((UElement)((UElement)elseExpression), (UElement)((UElement)call), (boolean)false, (int)4, null)) {
                    return null;
                }
                condition = ((UPrefixExpression)condition).getOperand();
            } else {
                UExpression thenExpression = ifExpression.getThenExpression();
                if (thenExpression == null || !UastUtils.isPsiAncestor$default((UElement)((UElement)thenExpression), (UElement)((UElement)call), (boolean)false, (int)4, null)) {
                    return null;
                }
            }
            return this.getGuardedCondition(condition, loggerSource);
        }

        private final List<UQualifiedReferenceExpression> getReferencesForVariable(UElement variable, UElement context) {
            PsiElement psiElement = variable.getSourcePsi();
            if (psiElement == null) {
                return CollectionsKt.emptyList();
            }
            PsiElement sourcePsi = psiElement;
            List result = new ArrayList();
            AbstractUastVisitor visitor2 = new AbstractUastVisitor(sourcePsi, result){
                final /* synthetic */ PsiElement $sourcePsi;
                final /* synthetic */ List<UQualifiedReferenceExpression> $result;
                {
                    this.$sourcePsi = $sourcePsi;
                    this.$result = $result;
                }

                public boolean visitQualifiedReferenceExpression(UQualifiedReferenceExpression node) {
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    UExpression selector = node.getReceiver();
                    UResolvable uResolvable = selector instanceof UResolvable ? (UResolvable)selector : null;
                    if (uResolvable == null || (uResolvable = UResolvableKt.resolveToUElement((UResolvable)uResolvable)) == null) {
                        return true;
                    }
                    UResolvable resolveToUElement = uResolvable;
                    if (this.$sourcePsi.isEquivalentTo(resolveToUElement.getSourcePsi())) {
                        this.$result.add(node);
                    }
                    return true;
                }
            };
            context.accept((UastVisitor)visitor2);
            return result;
        }

        private final UExpression getGuardedCondition(UExpression condition, UElement loggerSource) {
            if (condition instanceof UCallExpression) {
                UExpression uExpression = ((UCallExpression)condition).getReceiver();
                UResolvable uResolvable = uExpression instanceof UResolvable ? (UResolvable)uExpression : null;
                if (!Intrinsics.areEqual((Object)(uResolvable != null && (uResolvable = UResolvableKt.resolveToUElement((UResolvable)uResolvable)) != null ? uResolvable.getSourcePsi() : null), (Object)loggerSource.getSourcePsi())) {
                    return null;
                }
                return condition;
            }
            if (condition instanceof UQualifiedReferenceExpression) {
                UExpression uExpression = ((UQualifiedReferenceExpression)condition).getReceiver();
                UResolvable uResolvable = uExpression instanceof UResolvable ? (UResolvable)uExpression : null;
                if (!Intrinsics.areEqual((Object)(uResolvable != null && (uResolvable = UResolvableKt.resolveToUElement((UResolvable)uResolvable)) != null ? uResolvable.getSourcePsi() : null), (Object)loggerSource.getSourcePsi())) {
                    return null;
                }
                if (((UQualifiedReferenceExpression)condition).getSelector() instanceof UCallExpression) {
                    return this.getGuardedCondition(((UQualifiedReferenceExpression)condition).getSelector(), loggerSource);
                }
                return condition;
            }
            if (condition instanceof UPolyadicExpression && Intrinsics.areEqual((Object)((UPolyadicExpression)condition).getOperator(), (Object)UastBinaryOperator.LOGICAL_AND)) {
                for (UExpression operand : ((UPolyadicExpression)condition).getOperands()) {
                    UExpression nestedCondition = this.getGuardedCondition(operand, loggerSource);
                    if (nestedCondition == null) continue;
                    return nestedCondition;
                }
            }
            return null;
        }

        private final <T> T levelTypeFromGuard(String methodName, Map<String, ? extends T> levelMap) {
            if (!StringsKt.startsWith$default((String)methodName, (String)"is", (boolean)false, (int)2, null) || !StringsKt.endsWith$default((String)methodName, (String)"Enabled", (boolean)false, (int)2, null)) {
                return null;
            }
            String string = methodName.substring(2, methodName.length() - 7);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String string2 = string.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
            String levelInfo = string2;
            return levelMap.get(levelInfo);
        }

        private final UElement getLoggerQualifier(UCallExpression call) {
            UExpression receiver;
            if (call == null) {
                return null;
            }
            UExpression uExpression = call.getReceiver();
            Object object = receiver = uExpression != null ? UastUtils.skipParenthesizedExprDown((UExpression)uExpression) : null;
            if (receiver instanceof UCallExpression) {
                receiver = ((UCallExpression)receiver).getReceiver();
            }
            if (receiver instanceof UQualifiedReferenceExpression) {
                receiver = ((UQualifiedReferenceExpression)receiver).getReceiver();
            }
            if (receiver instanceof USimpleNameReferenceExpression) {
                UElement resolvedReceiver = UResolvableKt.resolveToUElement((UResolvable)((UResolvable)receiver));
                if (resolvedReceiver instanceof UVariable) {
                    UElement uElement = resolvedReceiver;
                    UVariable uVariable = uElement instanceof UVariable ? (UVariable)uElement : null;
                    if (uVariable == null) {
                        return null;
                    }
                    UVariable loggerVariable = uVariable;
                    PsiType type = loggerVariable.getType();
                    String string = type.getCanonicalText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCanonicalText(...)");
                    String canonicalText = string;
                    if (LOGGER_CLASSES.contains(canonicalText) || LEGACY_LOGGER_CLASSES.contains(canonicalText)) {
                        return (UElement)loggerVariable;
                    }
                    if (type.equalsToText(LoggingUtil.SLF4J_EVENT_BUILDER) || type.equalsToText(LoggingUtil.LOG4J_LOG_BUILDER)) {
                        UExpression uExpression2 = loggerVariable.getUastInitializer();
                        UQualifiedReferenceExpression uQualifiedReferenceExpression = uExpression2 instanceof UQualifiedReferenceExpression ? (UQualifiedReferenceExpression)uExpression2 : null;
                        if (uQualifiedReferenceExpression == null) {
                            return null;
                        }
                        UQualifiedReferenceExpression uastInitializer = uQualifiedReferenceExpression;
                        UExpression uExpression3 = uastInitializer.getSelector();
                        return this.getLoggerQualifier(uExpression3 instanceof UCallExpression ? (UCallExpression)uExpression3 : null);
                    }
                }
                if (resolvedReceiver instanceof UMethod) {
                    if (!((UMethod)resolvedReceiver).getUastParameters().isEmpty()) {
                        return null;
                    }
                    Object object2 = ((UMethod)resolvedReceiver).getReturnType();
                    if (object2 == null || (object2 = object2.getCanonicalText()) == null) {
                        return null;
                    }
                    Object methodType = object2;
                    if (LOGGER_CLASSES.contains(methodType) || LEGACY_LOGGER_CLASSES.contains(methodType)) {
                        return resolvedReceiver;
                    }
                }
            }
            return null;
        }

        @Nullable
        public final LegacyLevelType getLegacyLoggerLevel$intellij_jvm_analysis_impl(@Nullable UCallExpression uCall) {
            LegacyLevelType levelTypeFromLog;
            if (uCall == null) {
                return null;
            }
            String methodName = uCall.getMethodName();
            if (CollectionsKt.contains((Iterable)LEGACY_METHODS_WITH_LEVEL, (Object)methodName) && (levelTypeFromLog = (LegacyLevelType)((Object)this.findLevelTypeByFirstArgument(uCall, LEGACY_LEVEL_CLASSES, LEGACY_LEVEL_MAP))) != null) {
                return levelTypeFromLog;
            }
            if (methodName == null) {
                return null;
            }
            return (LegacyLevelType)((Object)this.findLevelTypeByName(methodName, LEGACY_LEVEL_MAP));
        }

        @Nullable
        public final LevelType getLoggerLevel$intellij_jvm_analysis_impl(@Nullable UCallExpression uCall, boolean isLog) {
            if (uCall == null) {
                return null;
            }
            String levelName = uCall.getMethodName();
            if (isLog || Intrinsics.areEqual((Object)"log", (Object)levelName)) {
                LevelType loggerLevel;
                LevelType levelTypeFromAtLevel;
                UCallExpression nextCall;
                LevelType levelTypeFromLog = (LevelType)((Object)this.findLevelTypeByFirstArgument(uCall, LEVEL_CLASSES, LEVEL_MAP));
                if (levelTypeFromLog != null) {
                    return levelTypeFromLog;
                }
                UExpression uExpression = uCall.getReceiver();
                if (uExpression == null) {
                    return null;
                }
                UExpression receiver = uExpression;
                if (receiver instanceof UQualifiedReferenceExpression) {
                    receiver = ((UQualifiedReferenceExpression)receiver).getSelector();
                } else if (receiver instanceof USimpleNameReferenceExpression) {
                    UElement uElement = UResolvableKt.resolveToUElement((UResolvable)((UResolvable)receiver));
                    UVariable uVariable = uElement instanceof UVariable ? (UVariable)uElement : null;
                    if (uVariable == null) {
                        return null;
                    }
                    UVariable variable = uVariable;
                    uElement = variable.getUastInitializer();
                    UQualifiedReferenceExpression uQualifiedReferenceExpression = uElement instanceof UQualifiedReferenceExpression ? (UQualifiedReferenceExpression)uElement : null;
                    if (uQualifiedReferenceExpression == null || (uQualifiedReferenceExpression = uQualifiedReferenceExpression.getSelector()) == null) {
                        return null;
                    }
                    receiver = uQualifiedReferenceExpression;
                }
                UExpression uExpression2 = receiver;
                UCallExpression uCallExpression = nextCall = uExpression2 instanceof UCallExpression ? (UCallExpression)uExpression2 : null;
                if (Intrinsics.areEqual((Object)"atLevel", (Object)(uCallExpression != null ? uCallExpression.getMethodName() : null)) && (levelTypeFromAtLevel = (LevelType)((Object)this.findLevelTypeByFirstArgument(nextCall, LEVEL_CLASSES, LEVEL_MAP))) != null) {
                    return levelTypeFromAtLevel;
                }
                LevelType levelType = loggerLevel = this.getLoggerLevel$intellij_jvm_analysis_impl(nextCall, true);
                if (levelType != null) {
                    return levelType;
                }
                UCallExpression uCallExpression2 = nextCall;
                String string = levelName = uCallExpression2 != null ? uCallExpression2.getMethodName() : null;
            }
            if (levelName == null) {
                return null;
            }
            return (LevelType)((Object)this.findLevelTypeByName(levelName, LEVEL_MAP));
        }

        public static /* synthetic */ LevelType getLoggerLevel$intellij_jvm_analysis_impl$default(Companion companion, UCallExpression uCallExpression, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = false;
            }
            return companion.getLoggerLevel$intellij_jvm_analysis_impl(uCallExpression, bl);
        }

        private final <T> T findLevelTypeByFirstArgument(UCallExpression uCall, Set<String> levelClasses, Map<String, ? extends T> levelMap) {
            UExpression firstArgument;
            List valueArguments = uCall.getValueArguments();
            if (!((Collection)valueArguments).isEmpty() && (firstArgument = (UExpression)valueArguments.get(0)) instanceof UReferenceExpression) {
                boolean bl;
                block8: {
                    UElement uElement = UResolvableKt.resolveToUElement((UResolvable)((UResolvable)uCall));
                    UMethod uMethod = uElement instanceof UMethod ? (UMethod)uElement : null;
                    if (uMethod == null) {
                        return null;
                    }
                    UMethod method = uMethod;
                    List parameters = method.getUastParameters();
                    if (parameters.isEmpty()) {
                        return null;
                    }
                    UParameter firstParameter = (UParameter)parameters.get(0);
                    Iterable $this$none$iv = levelClasses;
                    boolean $i$f$none = false;
                    if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$none$iv) {
                            String it = (String)element$iv;
                            boolean bl2 = false;
                            if (!InheritanceUtil.isInheritor((PsiType)firstParameter.getType(), (String)it)) continue;
                            bl = false;
                            break block8;
                        }
                        bl = true;
                    }
                }
                if (bl) {
                    return null;
                }
                UElement uElement = UResolvableKt.resolveToUElement((UResolvable)((UResolvable)firstArgument));
                UField uField = uElement instanceof UField ? (UField)uElement : null;
                if (uField == null) {
                    return null;
                }
                UField levelField = uField;
                String string = levelField.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                return this.findLevelTypeByName(string, levelMap);
            }
            return null;
        }

        private final <T> T findLevelTypeByName(String levelName, Map<String, ? extends T> levelMap) {
            T result;
            String string = levelName.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
            String convertedLevelName = string;
            T t = result = levelMap.get(convertedLevelName);
            if (t != null) {
                return t;
            }
            if (StringsKt.startsWith$default((String)convertedLevelName, (String)"AT", (boolean)false, (int)2, null)) {
                String string2 = convertedLevelName.substring(2);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                convertedLevelName = string2;
                result = levelMap.get(convertedLevelName);
                if (result != null) {
                    return result;
                }
            }
            return null;
        }

        public final int countPlaceHolders$intellij_jvm_analysis_impl(@NotNull String text, @Nullable LoggerType loggerType) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            int count = 0;
            boolean placeHolder = false;
            boolean escaped = false;
            int n = text.length();
            for (int i = 0; i < n; ++i) {
                char c = text.charAt(i);
                if (c == '\\' && (loggerType == LoggerType.SLF4J_LOGGER_TYPE || loggerType == LoggerType.SLF4J_BUILDER_TYPE)) {
                    escaped = !escaped;
                    continue;
                }
                if (c == '{') {
                    if (escaped) continue;
                    placeHolder = true;
                    continue;
                }
                if (c == '}') {
                    if (placeHolder) {
                        ++count;
                    }
                    placeHolder = false;
                    escaped = false;
                    continue;
                }
                placeHolder = false;
                escaped = false;
            }
            return count;
        }

        @NotNull
        public final List<UCallExpression> getLoggerCalls$intellij_jvm_analysis_impl(@NotNull UExpression guardedCondition) {
            Intrinsics.checkNotNullParameter((Object)guardedCondition, (String)"guardedCondition");
            PsiElement psiElement = guardedCondition.getSourcePsi();
            if (psiElement == null) {
                return CollectionsKt.emptyList();
            }
            PsiElement sourcePsi = psiElement;
            Object object = CachedValuesManager.getManager((Project)sourcePsi.getProject()).getCachedValue((UserDataHolder)sourcePsi, () -> Companion.getLoggerCalls$lambda$4(sourcePsi));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCachedValue(...)");
            return (List)object;
        }

        public final boolean hasBridgeFromSlf4jToLog4j2$intellij_jvm_analysis_impl(@NotNull UElement element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            UFile uFile = UastUtils.getContainingUFile((UElement)element);
            if (uFile == null) {
                return true;
            }
            UFile file = uFile;
            PsiFile sourcePsi = file.getSourcePsi();
            Project project = sourcePsi.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Project project2 = project;
            return JavaLibraryUtil.hasLibraryClass((Project)project2, (String)LoggingUtil.LOG_4_J_LOGGER);
        }

        @NotNull
        public final Map<String, String> getGUARD_MAP() {
            return GUARD_MAP;
        }

        /*
         * WARNING - void declaration
         */
        private static final CachedValueProvider.Result getLoggerCalls$lambda$4(PsiElement $sourcePsi) {
            UCallExpression it;
            Iterable $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            void $this$mapNotNullTo$iv$iv;
            UIfExpression uIfExpression;
            UElement qualifier;
            UExpression guarded;
            Object[] objectArray = new Object[]{PsiModificationTracker.MODIFICATION_COUNT};
            CachedValueProvider.Result result = CachedValueProvider.Result.create((Object)CollectionsKt.emptyList(), (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)result, (String)"create(...)");
            CachedValueProvider.Result emptyResult = result;
            PsiElement $this$toUElementOfType$iv = $sourcePsi;
            boolean $i$f$toUElementOfType22 = false;
            UExpression $i$f$toUElementOfType22 = guarded = (UExpression)UastContextKt.toUElement((PsiElement)$this$toUElementOfType$iv, UExpression.class);
            if ($i$f$toUElementOfType22 instanceof USimpleNameReferenceExpression) {
                UElement uElement = ((USimpleNameReferenceExpression)guarded).getUastParent();
                UQualifiedReferenceExpression uQualifiedReferenceExpression = uElement instanceof UQualifiedReferenceExpression ? (UQualifiedReferenceExpression)uElement : null;
                var6_8 = uQualifiedReferenceExpression != null ? uQualifiedReferenceExpression.getReceiver() : null;
                UResolvable uResolvable = var6_8 instanceof UResolvable ? (UResolvable)var6_8 : null;
                v3 = uResolvable != null ? UResolvableKt.resolveToUElement((UResolvable)uResolvable) : null;
            } else if ($i$f$toUElementOfType22 instanceof UQualifiedReferenceExpression) {
                var6_8 = ((UQualifiedReferenceExpression)guarded).getReceiver();
                UResolvable uResolvable = var6_8 instanceof UResolvable ? (UResolvable)var6_8 : null;
                v3 = uResolvable != null ? UResolvableKt.resolveToUElement((UResolvable)uResolvable) : null;
            } else if ($i$f$toUElementOfType22 instanceof UCallExpression) {
                var6_8 = ((UCallExpression)guarded).getReceiver();
                UResolvable uResolvable = var6_8 instanceof UResolvable ? (UResolvable)var6_8 : null;
                v3 = uResolvable != null ? UResolvableKt.resolveToUElement((UResolvable)uResolvable) : null;
            } else {
                v3 = qualifier = null;
            }
            if (qualifier == null) {
                return emptyResult;
            }
            UExpression uExpression = guarded;
            if (uExpression != null) {
                UElement $this$getParentOfType_u24default$iv = (UElement)uExpression;
                boolean strict$iv = true;
                boolean $i$f$getParentOfType = false;
                v7 = (UIfExpression)UastUtils.getParentOfType((UElement)$this$getParentOfType_u24default$iv, UIfExpression.class, (boolean)strict$iv);
            } else {
                v7 = uIfExpression = null;
            }
            if (uIfExpression == null) {
                return emptyResult;
            }
            List<UQualifiedReferenceExpression> referencesForVariable = Companion.getReferencesForVariable(qualifier, (UElement)uIfExpression);
            Iterable $this$mapNotNull$iv = referencesForVariable;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                UCallExpression it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                UQualifiedReferenceExpression it2 = (UQualifiedReferenceExpression)element$iv$iv;
                boolean bl2 = false;
                UExpression uExpression2 = it2.getSelector();
                if ((uExpression2 instanceof UCallExpression ? (UCallExpression)uExpression2 : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            $this$mapNotNull$iv = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            $this$mapNotNullTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (UCallExpression)element$iv$iv;
                boolean bl = false;
                PsiElement psiElement = it.getSourcePsi();
                if (!((psiElement != null ? psiElement.getContainingFile() : null) != null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            $i$f$filter = false;
            $this$filterTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (UCallExpression)element$iv$iv;
                boolean bl = false;
                if (!(Companion.getLOG_MATCHERS$intellij_jvm_analysis_impl().uCallMatches(it) || Companion.getLEGACY_LOG_MATCHERS$intellij_jvm_analysis_impl().uCallMatches(it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List filtered = (List)destination$iv$iv;
            Object[] objectArray2 = new Object[]{PsiModificationTracker.MODIFICATION_COUNT};
            return CachedValueProvider.Result.create((Object)filtered, (Object[])objectArray2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u000f\b\u0080\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000f\u00a8\u0006\u0010"}, d2={"Lcom/intellij/codeInspection/logging/LoggingUtil$Companion$LegacyLevelType;", "", "<init>", "(Ljava/lang/String;I)V", "FATAL", "ERROR", "SEVERE", "WARN", "WARNING", "INFO", "DEBUG", "TRACE", "CONFIG", "FINE", "FINER", "FINEST", "intellij.jvm.analysis.impl"})
        public static final class LegacyLevelType
        extends Enum<LegacyLevelType> {
            public static final /* enum */ LegacyLevelType FATAL = new LegacyLevelType();
            public static final /* enum */ LegacyLevelType ERROR = new LegacyLevelType();
            public static final /* enum */ LegacyLevelType SEVERE = new LegacyLevelType();
            public static final /* enum */ LegacyLevelType WARN = new LegacyLevelType();
            public static final /* enum */ LegacyLevelType WARNING = new LegacyLevelType();
            public static final /* enum */ LegacyLevelType INFO = new LegacyLevelType();
            public static final /* enum */ LegacyLevelType DEBUG = new LegacyLevelType();
            public static final /* enum */ LegacyLevelType TRACE = new LegacyLevelType();
            public static final /* enum */ LegacyLevelType CONFIG = new LegacyLevelType();
            public static final /* enum */ LegacyLevelType FINE = new LegacyLevelType();
            public static final /* enum */ LegacyLevelType FINER = new LegacyLevelType();
            public static final /* enum */ LegacyLevelType FINEST = new LegacyLevelType();
            private static final /* synthetic */ LegacyLevelType[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            public static LegacyLevelType[] values() {
                return (LegacyLevelType[])$VALUES.clone();
            }

            public static LegacyLevelType valueOf(String value) {
                return Enum.valueOf(LegacyLevelType.class, value);
            }

            @NotNull
            public static EnumEntries<LegacyLevelType> getEntries() {
                return $ENTRIES;
            }

            static {
                $VALUES = legacyLevelTypeArray = new LegacyLevelType[]{LegacyLevelType.FATAL, LegacyLevelType.ERROR, LegacyLevelType.SEVERE, LegacyLevelType.WARN, LegacyLevelType.WARNING, LegacyLevelType.INFO, LegacyLevelType.DEBUG, LegacyLevelType.TRACE, LegacyLevelType.CONFIG, LegacyLevelType.FINE, LegacyLevelType.FINER, LegacyLevelType.FINEST};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\t\b\u0080\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Lcom/intellij/codeInspection/logging/LoggingUtil$Companion$LevelType;", "", "<init>", "(Ljava/lang/String;I)V", "FATAL", "ERROR", "WARN", "INFO", "DEBUG", "TRACE", "intellij.jvm.analysis.impl"})
        public static final class LevelType
        extends Enum<LevelType> {
            public static final /* enum */ LevelType FATAL = new LevelType();
            public static final /* enum */ LevelType ERROR = new LevelType();
            public static final /* enum */ LevelType WARN = new LevelType();
            public static final /* enum */ LevelType INFO = new LevelType();
            public static final /* enum */ LevelType DEBUG = new LevelType();
            public static final /* enum */ LevelType TRACE = new LevelType();
            private static final /* synthetic */ LevelType[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            public static LevelType[] values() {
                return (LevelType[])$VALUES.clone();
            }

            public static LevelType valueOf(String value) {
                return Enum.valueOf(LevelType.class, value);
            }

            @NotNull
            public static EnumEntries<LevelType> getEntries() {
                return $ENTRIES;
            }

            static {
                $VALUES = levelTypeArray = new LevelType[]{LevelType.FATAL, LevelType.ERROR, LevelType.WARN, LevelType.INFO, LevelType.DEBUG, LevelType.TRACE};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0080\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/codeInspection/logging/LoggingUtil$Companion$LoggerType;", "", "<init>", "(Ljava/lang/String;I)V", "SLF4J_LOGGER_TYPE", "SLF4J_BUILDER_TYPE", "LOG4J_LOGGER_TYPE", "LOG4J_BUILDER_TYPE", "intellij.jvm.analysis.impl"})
        public static final class LoggerType
        extends Enum<LoggerType> {
            public static final /* enum */ LoggerType SLF4J_LOGGER_TYPE = new LoggerType();
            public static final /* enum */ LoggerType SLF4J_BUILDER_TYPE = new LoggerType();
            public static final /* enum */ LoggerType LOG4J_LOGGER_TYPE = new LoggerType();
            public static final /* enum */ LoggerType LOG4J_BUILDER_TYPE = new LoggerType();
            private static final /* synthetic */ LoggerType[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            public static LoggerType[] values() {
                return (LoggerType[])$VALUES.clone();
            }

            public static LoggerType valueOf(String value) {
                return Enum.valueOf(LoggerType.class, value);
            }

            @NotNull
            public static EnumEntries<LoggerType> getEntries() {
                return $ENTRIES;
            }

            static {
                $VALUES = loggerTypeArray = new LoggerType[]{LoggerType.SLF4J_LOGGER_TYPE, LoggerType.SLF4J_BUILDER_TYPE, LoggerType.LOG4J_LOGGER_TYPE, LoggerType.LOG4J_BUILDER_TYPE};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }

        @Metadata(mv={2, 0, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[LevelType.values().length];
                try {
                    nArray[LevelType.FATAL.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[LevelType.ERROR.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[LevelType.WARN.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[LevelType.INFO.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[LevelType.DEBUG.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[LevelType.TRACE.ordinal()] = 6;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\b\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lcom/intellij/codeInspection/logging/LoggingUtil$LimitLevelType;", "", "<init>", "(Ljava/lang/String;I)V", "ALL", "WARN_AND_LOWER", "INFO_AND_LOWER", "DEBUG_AND_LOWER", "TRACE", "intellij.jvm.analysis.impl"})
    public static final class LimitLevelType
    extends Enum<LimitLevelType> {
        public static final /* enum */ LimitLevelType ALL = new LimitLevelType();
        public static final /* enum */ LimitLevelType WARN_AND_LOWER = new LimitLevelType();
        public static final /* enum */ LimitLevelType INFO_AND_LOWER = new LimitLevelType();
        public static final /* enum */ LimitLevelType DEBUG_AND_LOWER = new LimitLevelType();
        public static final /* enum */ LimitLevelType TRACE = new LimitLevelType();
        private static final /* synthetic */ LimitLevelType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static LimitLevelType[] values() {
            return (LimitLevelType[])$VALUES.clone();
        }

        public static LimitLevelType valueOf(String value) {
            return Enum.valueOf(LimitLevelType.class, value);
        }

        @NotNull
        public static EnumEntries<LimitLevelType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = limitLevelTypeArray = new LimitLevelType[]{LimitLevelType.ALL, LimitLevelType.WARN_AND_LOWER, LimitLevelType.INFO_AND_LOWER, LimitLevelType.DEBUG_AND_LOWER, LimitLevelType.TRACE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

