/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.intentions.elements;

import com.intellij.lang.jvm.actions.CreateFieldRequest;
import com.intellij.lang.jvm.actions.ExpectedType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.annotator.intentions.elements.JvmPsiUtilKt;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrEnumConstant;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.TypeConstraint;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a\u0010\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0000\u001a\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u001a*\u0010\r\u001a\u00020\n2\u0010\u0010\u000e\u001a\f\u0012\u0004\u0012\u00020\u00100\u000fj\u0002`\u00112\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u00a8\u0006\u0012"}, d2={"renderConstant", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/typedef/members/GrEnumConstant;", "project", "Lcom/intellij/openapi/project/Project;", "text", "", "renderParameters", "targetClass", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/typedef/GrTypeDefinition;", "canCreateEnumConstant", "", "request", "Lcom/intellij/lang/jvm/actions/CreateFieldRequest;", "checkExpectedTypes", "types", "", "Lcom/intellij/lang/jvm/actions/ExpectedType;", "Lcom/intellij/lang/jvm/actions/ExpectedTypes;", "intellij.groovy"})
@SourceDebugExtension(value={"SMAP\nCreateEnumConstantAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CreateEnumConstantAction.kt\norg/jetbrains/plugins/groovy/annotator/intentions/elements/CreateEnumConstantActionKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,99:1\n4135#2,11:100\n1755#3,3:111\n*S KotlinDebug\n*F\n+ 1 CreateEnumConstantAction.kt\norg/jetbrains/plugins/groovy/annotator/intentions/elements/CreateEnumConstantActionKt\n*L\n85#1:100,11\n95#1:111,3\n*E\n"})
public final class CreateEnumConstantActionKt {
    @NotNull
    public static final GrEnumConstant renderConstant(@NotNull Project project, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        GroovyPsiElementFactory groovyPsiElementFactory = GroovyPsiElementFactory.getInstance(project);
        Intrinsics.checkNotNullExpressionValue((Object)groovyPsiElementFactory, (String)"getInstance(...)");
        GroovyPsiElementFactory elementFactory = groovyPsiElementFactory;
        GrEnumConstant grEnumConstant = elementFactory.createEnumConstantFromText(text);
        Intrinsics.checkNotNullExpressionValue((Object)grEnumConstant, (String)"createEnumConstantFromText(...)");
        return grEnumConstant;
    }

    @NotNull
    public static final String renderParameters(@NotNull GrTypeDefinition targetClass) {
        Intrinsics.checkNotNullParameter((Object)targetClass, (String)"targetClass");
        PsiMethod[] psiMethodArray = targetClass.getConstructors();
        Intrinsics.checkNotNullExpressionValue((Object)psiMethodArray, (String)"getConstructors(...)");
        PsiMethod psiMethod = (PsiMethod)ArraysKt.firstOrNull((Object[])psiMethodArray);
        if (psiMethod == null) {
            return "";
        }
        PsiMethod constructor = psiMethod;
        Object[] objectArray = constructor.getParameterList().getParameters();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getParameters(...)");
        Object[] parameters = objectArray;
        return ArraysKt.joinToString$default((Object[])parameters, (CharSequence)",", null, null, (int)0, null, CreateEnumConstantActionKt::renderParameters$lambda$0, (int)30, null);
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean canCreateEnumConstant(@NotNull GrTypeDefinition targetClass, @NotNull CreateFieldRequest request) {
        void $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)targetClass, (String)"targetClass");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (!targetClass.isEnum()) {
            return false;
        }
        GrField[] grFieldArray = targetClass.getFields();
        Intrinsics.checkNotNullExpressionValue((Object)grFieldArray, (String)"getFields(...)");
        Object[] $this$filterIsInstance$iv = grFieldArray;
        boolean $i$f$filterIsInstance = false;
        Object[] objectArray = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof GrEnumConstant)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        GrEnumConstant lastConstant = (GrEnumConstant)CollectionsKt.lastOrNull((List)((List)destination$iv$iv));
        if (lastConstant != null && PsiTreeUtil.hasErrorElements((PsiElement)lastConstant)) {
            return false;
        }
        List list = request.getFieldType();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getFieldType(...)");
        Project project = targetClass.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return CreateEnumConstantActionKt.checkExpectedTypes(list, targetClass, project);
    }

    private static final boolean checkExpectedTypes(List<? extends ExpectedType> types, GrTypeDefinition targetClass, Project project) {
        boolean bl;
        block4: {
            List<TypeConstraint> constraints = JvmPsiUtilKt.createConstraints(project, types);
            if (constraints.isEmpty()) {
                return true;
            }
            PsiClassType psiClassType = GroovyPsiElementFactory.getInstance(project).createType(targetClass);
            Intrinsics.checkNotNullExpressionValue((Object)psiClassType, (String)"createType(...)");
            PsiClassType enumType = psiClassType;
            Iterable $this$any$iv = constraints;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    TypeConstraint it = (TypeConstraint)element$iv;
                    boolean bl2 = false;
                    if (!it.satisfied((PsiType)enumType, targetClass)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final CharSequence renderParameters$lambda$0(PsiParameter it) {
        String string = it.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }
}

