/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.streams.trace.dsl.impl.java;

import com.intellij.debugger.streams.trace.dsl.ArrayVariable;
import com.intellij.debugger.streams.trace.dsl.CodeBlock;
import com.intellij.debugger.streams.trace.dsl.CompositeCodeBlock;
import com.intellij.debugger.streams.trace.dsl.Convertable;
import com.intellij.debugger.streams.trace.dsl.Expression;
import com.intellij.debugger.streams.trace.dsl.ForLoopBody;
import com.intellij.debugger.streams.trace.dsl.IfBranch;
import com.intellij.debugger.streams.trace.dsl.Lambda;
import com.intellij.debugger.streams.trace.dsl.LambdaBody;
import com.intellij.debugger.streams.trace.dsl.ListVariable;
import com.intellij.debugger.streams.trace.dsl.MapVariable;
import com.intellij.debugger.streams.trace.dsl.StatementFactory;
import com.intellij.debugger.streams.trace.dsl.TryBlock;
import com.intellij.debugger.streams.trace.dsl.Types;
import com.intellij.debugger.streams.trace.dsl.Variable;
import com.intellij.debugger.streams.trace.dsl.VariableDeclaration;
import com.intellij.debugger.streams.trace.dsl.impl.AssignmentStatement;
import com.intellij.debugger.streams.trace.dsl.impl.TextExpression;
import com.intellij.debugger.streams.trace.dsl.impl.VariableImpl;
import com.intellij.debugger.streams.trace.dsl.impl.java.JavaArrayVariable;
import com.intellij.debugger.streams.trace.dsl.impl.java.JavaAssignmentStatement;
import com.intellij.debugger.streams.trace.dsl.impl.java.JavaCodeBlock;
import com.intellij.debugger.streams.trace.dsl.impl.java.JavaForEachLoop;
import com.intellij.debugger.streams.trace.dsl.impl.java.JavaForLoop;
import com.intellij.debugger.streams.trace.dsl.impl.java.JavaForLoopBody;
import com.intellij.debugger.streams.trace.dsl.impl.java.JavaIfBranch;
import com.intellij.debugger.streams.trace.dsl.impl.java.JavaLambda;
import com.intellij.debugger.streams.trace.dsl.impl.java.JavaLambdaBody;
import com.intellij.debugger.streams.trace.dsl.impl.java.JavaListVariable;
import com.intellij.debugger.streams.trace.dsl.impl.java.JavaMapVariable;
import com.intellij.debugger.streams.trace.dsl.impl.java.JavaTryBlock;
import com.intellij.debugger.streams.trace.dsl.impl.java.JavaTypes;
import com.intellij.debugger.streams.trace.dsl.impl.java.JavaVariableDeclaration;
import com.intellij.debugger.streams.trace.impl.handler.PeekCall;
import com.intellij.debugger.streams.trace.impl.handler.type.GenericType;
import com.intellij.debugger.streams.wrapper.IntermediateStreamCall;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00a4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000fH\u0016J \u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u0015H\u0016J(\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u0015H\u0016J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016J\u0018\u0010#\u001a\u00020$2\u0006\u0010!\u001a\u00020\"2\u0006\u0010%\u001a\u00020 H\u0016J\u0018\u0010&\u001a\u00020\u000f2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\"H\u0016J\u0018\u0010*\u001a\u00020\u00132\u0006\u0010+\u001a\u00020\u00132\u0006\u0010,\u001a\u00020\u0013H\u0016J\u0018\u0010-\u001a\u00020\u00132\u0006\u0010+\u001a\u00020\u00132\u0006\u0010,\u001a\u00020\u0013H\u0016J\u0018\u0010.\u001a\u00020\u00132\u0006\u0010+\u001a\u00020\u00132\u0006\u0010,\u001a\u00020\u0013H\u0016J\u0018\u0010/\u001a\u0002002\u0006\u0010\u001d\u001a\u00020\u00132\u0006\u00101\u001a\u00020\u000bH\u0016J\u0018\u00102\u001a\u0002032\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u00104\u001a\u00020\u0013H\u0016J(\u00105\u001a\u0002062\u0006\u00107\u001a\u00020(2\u0006\u00108\u001a\u00020(2\u0006\u0010)\u001a\u00020\"2\u0006\u00109\u001a\u00020\u0011H\u0016J\u0018\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020(2\u0006\u0010)\u001a\u00020\"H\u0016J\u0010\u0010=\u001a\u00020\u00182\u0006\u0010>\u001a\u00020\u000bH\u0016J\u0010\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020\u000bH\u0016J\b\u0010B\u001a\u00020\rH\u0016J\b\u0010C\u001a\u00020\u0013H\u0016J\b\u0010D\u001a\u00020\u0013H\u0016J)\u0010E\u001a\u00020\u00132\u0006\u0010<\u001a\u00020(2\u0012\u0010F\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130G\"\u00020\u0013H\u0016\u00a2\u0006\u0002\u0010HJ\u0018\u0010I\u001a\u00020\u00132\u0006\u0010<\u001a\u00020(2\u0006\u0010J\u001a\u00020\u0013H\u0016J)\u0010K\u001a\u00020\u00132\u0006\u0010<\u001a\u00020(2\u0012\u0010F\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130G\"\u00020\u0013H\u0016\u00a2\u0006\u0002\u0010HJ\u0018\u0010L\u001a\u00020M2\u0006\u0010N\u001a\u00020(2\u0006\u0010O\u001a\u00020\"H\u0016J\u0018\u0010P\u001a\u00020Q2\u0006\u0010<\u001a\u00020(2\u0006\u0010)\u001a\u00020\"H\u0016J\u0010\u0010R\u001a\u00020\u00132\u0006\u00104\u001a\u00020\u0013H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006S"}, d2={"Lcom/intellij/debugger/streams/trace/dsl/impl/java/JavaStatementFactory;", "Lcom/intellij/debugger/streams/trace/dsl/StatementFactory;", "<init>", "()V", "types", "Lcom/intellij/debugger/streams/trace/dsl/Types;", "getTypes", "()Lcom/intellij/debugger/streams/trace/dsl/Types;", "createEmptyCompositeCodeBlock", "Lcom/intellij/debugger/streams/trace/dsl/CompositeCodeBlock;", "createEmptyCodeBlock", "Lcom/intellij/debugger/streams/trace/dsl/CodeBlock;", "createVariableDeclaration", "Lcom/intellij/debugger/streams/trace/dsl/VariableDeclaration;", "variable", "Lcom/intellij/debugger/streams/trace/dsl/Variable;", "isMutable", "", "init", "Lcom/intellij/debugger/streams/trace/dsl/Expression;", "createEmptyForLoopBody", "Lcom/intellij/debugger/streams/trace/dsl/ForLoopBody;", "iterateVariable", "createForEachLoop", "Lcom/intellij/debugger/streams/trace/dsl/Convertable;", "collection", "loopBody", "createForLoop", "initialization", "condition", "afterThought", "createEmptyLambdaBody", "Lcom/intellij/debugger/streams/trace/dsl/LambdaBody;", "argName", "", "createLambda", "Lcom/intellij/debugger/streams/trace/dsl/Lambda;", "lambdaBody", "createVariable", "type", "Lcom/intellij/debugger/streams/trace/impl/handler/type/GenericType;", "name", "and", "left", "right", "equals", "same", "createIfBranch", "Lcom/intellij/debugger/streams/trace/dsl/IfBranch;", "thenBlock", "createAssignmentStatement", "Lcom/intellij/debugger/streams/trace/dsl/impl/AssignmentStatement;", "expression", "createMapVariable", "Lcom/intellij/debugger/streams/trace/dsl/MapVariable;", "keyType", "valueType", "linked", "createArrayVariable", "Lcom/intellij/debugger/streams/trace/dsl/ArrayVariable;", "elementType", "createScope", "codeBlock", "createTryBlock", "Lcom/intellij/debugger/streams/trace/dsl/TryBlock;", "block", "createTimeVariableDeclaration", "currentTimeExpression", "updateCurrentTimeExpression", "createNewArrayExpression", "args", "", "(Lcom/intellij/debugger/streams/trace/impl/handler/type/GenericType;[Lcom/intellij/debugger/streams/trace/dsl/Expression;)Lcom/intellij/debugger/streams/trace/dsl/Expression;", "createNewSizedArray", "size", "createNewListExpression", "createPeekCall", "Lcom/intellij/debugger/streams/wrapper/IntermediateStreamCall;", "elementsType", "lambda", "createListVariable", "Lcom/intellij/debugger/streams/trace/dsl/ListVariable;", "not", "intellij.java.debugger.streams"})
public class JavaStatementFactory
implements StatementFactory {
    @NotNull
    private final Types types = JavaTypes.INSTANCE;

    @Override
    @NotNull
    public Types getTypes() {
        return this.types;
    }

    @Override
    @NotNull
    public CompositeCodeBlock createEmptyCompositeCodeBlock() {
        return new JavaCodeBlock(this);
    }

    @Override
    @NotNull
    public CodeBlock createEmptyCodeBlock() {
        return new JavaCodeBlock(this);
    }

    @Override
    @NotNull
    public VariableDeclaration createVariableDeclaration(@NotNull Variable variable, boolean isMutable) {
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        return new JavaVariableDeclaration(variable, isMutable, null, 4, null);
    }

    @Override
    @NotNull
    public VariableDeclaration createVariableDeclaration(@NotNull Variable variable, @NotNull Expression init, boolean isMutable) {
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        Intrinsics.checkNotNullParameter((Object)init, (String)"init");
        return new JavaVariableDeclaration(variable, isMutable, Convertable.toCode$default(init, 0, 1, null));
    }

    @Override
    @NotNull
    public ForLoopBody createEmptyForLoopBody(@NotNull Variable iterateVariable) {
        Intrinsics.checkNotNullParameter((Object)iterateVariable, (String)"iterateVariable");
        return new JavaForLoopBody((StatementFactory)this, iterateVariable);
    }

    @Override
    @NotNull
    public Convertable createForEachLoop(@NotNull Variable iterateVariable, @NotNull Expression collection, @NotNull ForLoopBody loopBody) {
        Intrinsics.checkNotNullParameter((Object)iterateVariable, (String)"iterateVariable");
        Intrinsics.checkNotNullParameter((Object)collection, (String)"collection");
        Intrinsics.checkNotNullParameter((Object)loopBody, (String)"loopBody");
        return new JavaForEachLoop(iterateVariable, collection, loopBody);
    }

    @Override
    @NotNull
    public Convertable createForLoop(@NotNull VariableDeclaration initialization, @NotNull Expression condition, @NotNull Expression afterThought, @NotNull ForLoopBody loopBody) {
        Intrinsics.checkNotNullParameter((Object)initialization, (String)"initialization");
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        Intrinsics.checkNotNullParameter((Object)afterThought, (String)"afterThought");
        Intrinsics.checkNotNullParameter((Object)loopBody, (String)"loopBody");
        return new JavaForLoop(initialization, condition, afterThought, loopBody);
    }

    @Override
    @NotNull
    public LambdaBody createEmptyLambdaBody(@NotNull String argName) {
        Intrinsics.checkNotNullParameter((Object)argName, (String)"argName");
        return new JavaLambdaBody((StatementFactory)this, new TextExpression(argName));
    }

    @Override
    @NotNull
    public Lambda createLambda(@NotNull String argName, @NotNull LambdaBody lambdaBody) {
        Intrinsics.checkNotNullParameter((Object)argName, (String)"argName");
        Intrinsics.checkNotNullParameter((Object)lambdaBody, (String)"lambdaBody");
        boolean bl = lambdaBody instanceof JavaLambdaBody;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        return new JavaLambda(argName, (JavaLambdaBody)lambdaBody);
    }

    @Override
    @NotNull
    public Variable createVariable(@NotNull GenericType type, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return new VariableImpl(type, name);
    }

    @Override
    @NotNull
    public Expression and(@NotNull Expression left, @NotNull Expression right) {
        Intrinsics.checkNotNullParameter((Object)left, (String)"left");
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        return new TextExpression(Convertable.toCode$default(left, 0, 1, null) + " && " + Convertable.toCode$default(right, 0, 1, null));
    }

    @Override
    @NotNull
    public Expression equals(@NotNull Expression left, @NotNull Expression right) {
        Intrinsics.checkNotNullParameter((Object)left, (String)"left");
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        return new TextExpression("java.util.Objects.equals(" + Convertable.toCode$default(left, 0, 1, null) + ", " + Convertable.toCode$default(right, 0, 1, null));
    }

    @Override
    @NotNull
    public Expression same(@NotNull Expression left, @NotNull Expression right) {
        Intrinsics.checkNotNullParameter((Object)left, (String)"left");
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        return new TextExpression(Convertable.toCode$default(left, 0, 1, null) + " == " + Convertable.toCode$default(right, 0, 1, null));
    }

    @Override
    @NotNull
    public IfBranch createIfBranch(@NotNull Expression condition, @NotNull CodeBlock thenBlock) {
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        Intrinsics.checkNotNullParameter((Object)thenBlock, (String)"thenBlock");
        return new JavaIfBranch(condition, thenBlock, this);
    }

    @Override
    @NotNull
    public AssignmentStatement createAssignmentStatement(@NotNull Variable variable, @NotNull Expression expression) {
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        return new JavaAssignmentStatement(variable, expression);
    }

    @Override
    @NotNull
    public MapVariable createMapVariable(@NotNull GenericType keyType, @NotNull GenericType valueType, @NotNull String name, boolean linked) {
        Intrinsics.checkNotNullParameter((Object)keyType, (String)"keyType");
        Intrinsics.checkNotNullParameter((Object)valueType, (String)"valueType");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return new JavaMapVariable(linked ? this.getTypes().linkedMap(keyType, valueType) : this.getTypes().map(keyType, valueType), name);
    }

    @Override
    @NotNull
    public ArrayVariable createArrayVariable(@NotNull GenericType elementType, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)elementType, (String)"elementType");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return new JavaArrayVariable(this.getTypes().array(elementType), name);
    }

    @Override
    @NotNull
    public Convertable createScope(@NotNull CodeBlock codeBlock) {
        Intrinsics.checkNotNullParameter((Object)codeBlock, (String)"codeBlock");
        return new Convertable(codeBlock){
            final /* synthetic */ CodeBlock $codeBlock;
            {
                this.$codeBlock = $codeBlock;
            }

            public String toCode(int indent) {
                return this.withIndent("{\n", indent) + this.$codeBlock.toCode(indent + 1) + this.withIndent("}", indent);
            }
        };
    }

    @Override
    @NotNull
    public TryBlock createTryBlock(@NotNull CodeBlock block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        return new JavaTryBlock(block, this);
    }

    @Override
    @NotNull
    public VariableDeclaration createTimeVariableDeclaration() {
        return new JavaVariableDeclaration(this.createVariable(this.getTypes().getTIME(), "time"), false, this.getTypes().getTIME().getDefaultValue());
    }

    @Override
    @NotNull
    public Expression currentTimeExpression() {
        return new TextExpression("time").call("get", new Expression[0]);
    }

    @Override
    @NotNull
    public Expression updateCurrentTimeExpression() {
        return new TextExpression("time").call("incrementAndGet", new Expression[0]);
    }

    @Override
    @NotNull
    public Expression createNewArrayExpression(@NotNull GenericType elementType, Expression ... args) {
        Intrinsics.checkNotNullParameter((Object)elementType, (String)"elementType");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        String elements = ArraysKt.joinToString$default((Object[])args, (CharSequence)", ", null, null, (int)0, null, JavaStatementFactory::createNewArrayExpression$lambda$0, (int)30, null);
        return new TextExpression("new " + elementType.getVariableTypeName() + "[] { " + elements + " }");
    }

    @Override
    @NotNull
    public Expression createNewSizedArray(@NotNull GenericType elementType, @NotNull Expression size) {
        Intrinsics.checkNotNullParameter((Object)elementType, (String)"elementType");
        Intrinsics.checkNotNullParameter((Object)size, (String)"size");
        return new TextExpression("new " + elementType.getVariableTypeName() + "[" + Convertable.toCode$default(size, 0, 1, null) + "]");
    }

    @Override
    @NotNull
    public Expression createNewListExpression(@NotNull GenericType elementType, Expression ... args) {
        Intrinsics.checkNotNullParameter((Object)elementType, (String)"elementType");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        if (args.length == 0) {
            return new TextExpression(this.getTypes().list(elementType).getDefaultValue());
        }
        return new TextExpression("java.util.Arrays.asList(" + ArraysKt.joinToString$default((Object[])args, (CharSequence)", ", null, null, (int)0, null, JavaStatementFactory::createNewListExpression$lambda$1, (int)30, null) + ")");
    }

    @Override
    @NotNull
    public IntermediateStreamCall createPeekCall(@NotNull GenericType elementsType, @NotNull String lambda) {
        Intrinsics.checkNotNullParameter((Object)elementsType, (String)"elementsType");
        Intrinsics.checkNotNullParameter((Object)lambda, (String)"lambda");
        return new PeekCall(lambda, elementsType);
    }

    @Override
    @NotNull
    public ListVariable createListVariable(@NotNull GenericType elementType, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)elementType, (String)"elementType");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return new JavaListVariable(this.getTypes().list(elementType), name);
    }

    @Override
    @NotNull
    public Expression not(@NotNull Expression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        return new TextExpression("!" + Convertable.toCode$default(expression, 0, 1, null));
    }

    private static final CharSequence createNewArrayExpression$lambda$0(Expression it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Convertable.toCode$default(it, 0, 1, null);
    }

    private static final CharSequence createNewListExpression$lambda$1(Expression it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Convertable.toCode$default(it, 0, 1, null);
    }
}

