/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.projectStructure.scope;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.impl.ProjectFileIndexImpl;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.impl.VirtualFileEnumeration;
import com.intellij.psi.search.impl.VirtualFileEnumerationAware;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.projectStructure.scope.RootUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b'\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0015\u001a\u00020\u0011H$J\u0011\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0015\u001a\u00020\u0011H\u0096\u0002J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u0011H\u0016J\n\u0010\u001c\u001a\u0004\u0018\u00010\bH\u0016J\n\u0010\u001d\u001a\u0004\u0018\u00010\bH\u0014R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0018\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/idea/base/projectStructure/scope/AbstractVirtualFileRootsScope;", "Lcom/intellij/psi/search/GlobalSearchScope;", "Lcom/intellij/psi/search/impl/VirtualFileEnumerationAware;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "virtualFileEnumeration", "Lcom/intellij/psi/search/impl/VirtualFileEnumeration;", "vfsModificationCount", "", "myProjectFileIndex", "Lcom/intellij/openapi/roots/impl/ProjectFileIndexImpl;", "getMyProjectFileIndex", "()Lcom/intellij/openapi/roots/impl/ProjectFileIndexImpl;", "roots", "Lit/unimi/dsi/fastutil/objects/Object2IntMap;", "Lcom/intellij/openapi/vfs/VirtualFile;", "getRoots", "()Lit/unimi/dsi/fastutil/objects/Object2IntMap;", "getFileRoot", "file", "contains", "", "compare", "", "file1", "file2", "extractFileEnumeration", "computeFileEnumeration", "kotlin.base.project-structure"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nAbstractVirtualFileRootsScope.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractVirtualFileRootsScope.kt\norg/jetbrains/kotlin/idea/base/projectStructure/scope/AbstractVirtualFileRootsScope\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,74:1\n1#2:75\n*E\n"})
public abstract class AbstractVirtualFileRootsScope
extends GlobalSearchScope
implements VirtualFileEnumerationAware {
    @Nullable
    private volatile VirtualFileEnumeration virtualFileEnumeration;
    private volatile long vfsModificationCount;
    @NotNull
    private final ProjectFileIndexImpl myProjectFileIndex;

    public AbstractVirtualFileRootsScope(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        Intrinsics.checkNotNull((Object)projectFileIndex, (String)"null cannot be cast to non-null type com.intellij.openapi.roots.impl.ProjectFileIndexImpl");
        this.myProjectFileIndex = (ProjectFileIndexImpl)projectFileIndex;
    }

    @NotNull
    protected final ProjectFileIndexImpl getMyProjectFileIndex() {
        return this.myProjectFileIndex;
    }

    @NotNull
    protected abstract Object2IntMap<VirtualFile> getRoots();

    @Nullable
    protected abstract VirtualFile getFileRoot(@NotNull VirtualFile var1);

    public boolean contains(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        VirtualFile virtualFile = this.getFileRoot(file);
        if (virtualFile == null) {
            return false;
        }
        VirtualFile root = virtualFile;
        return this.getRoots().containsKey((Object)root);
    }

    public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)file1, (String)"file1");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file2");
        VirtualFile r1 = this.getFileRoot(file1);
        VirtualFile r2 = this.getFileRoot(file2);
        if (Comparing.equal((Object)r1, (Object)r2)) {
            return 0;
        }
        if (r1 == null) {
            return -1;
        }
        if (r2 == null) {
            return 1;
        }
        Object2IntMap<VirtualFile> roots = this.getRoots();
        int i1 = roots.getInt((Object)r1);
        int i2 = roots.getInt((Object)r2);
        if (i1 == 0 && i2 == 0) {
            return 0;
        }
        if (i1 > 0 && i2 > 0) {
            return i2 - i1;
        }
        return i1 > 0 ? 1 : -1;
    }

    @Nullable
    public VirtualFileEnumeration extractFileEnumeration() {
        VirtualFileEnumeration virtualFileEnumeration;
        long currentVfsStamp = VirtualFileManager.VFS_STRUCTURE_MODIFICATIONS.getModificationCount();
        if (currentVfsStamp != this.vfsModificationCount) {
            this.virtualFileEnumeration = this.computeFileEnumeration();
            this.vfsModificationCount = currentVfsStamp;
        }
        VirtualFileEnumeration it = virtualFileEnumeration = this.virtualFileEnumeration;
        boolean bl = false;
        return !Intrinsics.areEqual((Object)it, (Object)VirtualFileEnumeration.EMPTY) ? virtualFileEnumeration : null;
    }

    @Nullable
    protected VirtualFileEnumeration computeFileEnumeration() {
        Set set = this.getRoots().keySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"<get-keys>(...)");
        return RootUtilsKt.computeFileEnumerationUnderRoots(set);
    }
}

