/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core.script.configuration.loader;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.util.ProjectStructureUtils;
import org.jetbrains.kotlin.idea.core.script.configuration.cache.ScriptConfigurationSnapshot;
import org.jetbrains.kotlin.idea.core.script.configuration.loader.ScriptConfigurationLoader;
import org.jetbrains.kotlin.idea.core.script.configuration.loader.ScriptConfigurationLoadingContext;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.scripting.definitions.ScriptDefinition;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J(\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/configuration/loader/ScriptOutsiderFileConfigurationLoader;", "Lorg/jetbrains/kotlin/idea/core/script/configuration/loader/ScriptConfigurationLoader;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "loadDependencies", "", "isFirstLoad", "ktFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "scriptDefinition", "Lorg/jetbrains/kotlin/scripting/definitions/ScriptDefinition;", "context", "Lorg/jetbrains/kotlin/idea/core/script/configuration/loader/ScriptConfigurationLoadingContext;", "kotlin.base.scripting"})
public final class ScriptOutsiderFileConfigurationLoader
implements ScriptConfigurationLoader {
    @NotNull
    private final Project project;

    public ScriptOutsiderFileConfigurationLoader(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Override
    public boolean loadDependencies(boolean isFirstLoad, @NotNull KtFile ktFile2, @NotNull ScriptDefinition scriptDefinition, @NotNull ScriptConfigurationLoadingContext context2) {
        Intrinsics.checkNotNullParameter((Object)ktFile2, (String)"ktFile");
        Intrinsics.checkNotNullParameter((Object)((Object)scriptDefinition), (String)"scriptDefinition");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (!isFirstLoad) {
            return false;
        }
        VirtualFile virtualFile = ktFile2.getOriginalFile().getVirtualFile();
        Intrinsics.checkNotNull((Object)virtualFile);
        VirtualFile virtualFile2 = ProjectStructureUtils.getOutsiderFileOrigin(this.project, virtualFile);
        if (virtualFile2 == null) {
            return false;
        }
        VirtualFile fileOrigin = virtualFile2;
        ScriptConfigurationSnapshot original = context2.getCachedConfiguration(fileOrigin);
        if (original != null) {
            context2.saveNewConfiguration(virtualFile, new ScriptConfigurationSnapshot(original.getInputs(), CollectionsKt.emptyList(), original.getConfiguration()));
        }
        return true;
    }
}

