/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.psi.KotlinPsiModificationUtils;
import org.jetbrains.kotlin.lexer.KtToken;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtOperationExpression;
import org.jetbrains.kotlin.psi.KtPrefixExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0000\u001a\f\u0010\u0003\u001a\u00020\u0004*\u00020\u0001H\u0002\u001a\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\t"}, d2={"getElementForLineMark", "Lcom/intellij/psi/PsiElement;", "callElement", "getLineNumber", "", "getCallNameFromPsi", "Lorg/jetbrains/kotlin/name/Name;", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "kotlin.idea"})
public final class KotlinRecursiveCallLineMarkerProviderKt {
    @NotNull
    public static final PsiElement getElementForLineMark(@NotNull PsiElement callElement) {
        Intrinsics.checkNotNullParameter((Object)callElement, (String)"callElement");
        return callElement instanceof KtSimpleNameExpression ? ((KtSimpleNameExpression)callElement).getReferencedNameElement() : (PsiElement)SequencesKt.last((Sequence)SequencesKt.generateSequence((Object)callElement, KotlinRecursiveCallLineMarkerProviderKt::getElementForLineMark$lambda$0));
    }

    private static final int getLineNumber(PsiElement $this$getLineNumber) {
        Document document = PsiDocumentManager.getInstance((Project)$this$getLineNumber.getProject()).getDocument($this$getLineNumber.getContainingFile());
        Intrinsics.checkNotNull((Object)document);
        return document.getLineNumber($this$getLineNumber.getTextOffset());
    }

    private static final Name getCallNameFromPsi(KtElement element) {
        KtElement ktElement = element;
        if (ktElement instanceof KtSimpleNameExpression) {
            Lazy identifier = LazyKt.lazy(() -> KotlinRecursiveCallLineMarkerProviderKt.getCallNameFromPsi$lambda$1(element));
            PsiElement elementParent = element.getParent();
            if (elementParent instanceof KtCallExpression) {
                return (Name)identifier.getValue();
            }
            if (elementParent instanceof KtOperationExpression) {
                KtSimpleNameExpression ktSimpleNameExpression = ((KtOperationExpression)elementParent).getOperationReference();
                Intrinsics.checkNotNullExpressionValue((Object)ktSimpleNameExpression, (String)"getOperationReference(...)");
                KtSimpleNameExpression operationReference = ktSimpleNameExpression;
                if (Intrinsics.areEqual((Object)element, (Object)operationReference)) {
                    Name name2;
                    IElementType node = operationReference.getReferencedNameElementType();
                    if (node instanceof KtToken) {
                        Name conventionName = elementParent instanceof KtPrefixExpression ? OperatorConventions.getNameForOperationSymbol((KtToken)((KtToken)node), (boolean)true, (boolean)false) : OperatorConventions.getNameForOperationSymbol((KtToken)((KtToken)node));
                        name2 = conventionName;
                        if (name2 == null) {
                            Object object = identifier.getValue();
                            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-value>(...)");
                            name2 = (Name)object;
                        }
                    } else {
                        name2 = (Name)identifier.getValue();
                    }
                    return name2;
                }
            }
        } else {
            if (ktElement instanceof KtArrayAccessExpression) {
                return OperatorNameConventions.GET;
            }
            if (ktElement instanceof KtThisExpression && ((KtThisExpression)element).getParent() instanceof KtCallExpression) {
                return OperatorNameConventions.INVOKE;
            }
        }
        return null;
    }

    private static final PsiElement getElementForLineMark$lambda$0(PsiElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getFirstChild();
    }

    private static final Name getCallNameFromPsi$lambda$1(KtElement $element) {
        String string = ((KtSimpleNameExpression)$element).getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return Name.identifier((String)KotlinPsiModificationUtils.unquoteKotlinIdentifier(string));
    }

    public static final /* synthetic */ int access$getLineNumber(PsiElement $receiver) {
        return KotlinRecursiveCallLineMarkerProviderKt.getLineNumber($receiver);
    }

    public static final /* synthetic */ Name access$getCallNameFromPsi(KtElement element) {
        return KotlinRecursiveCallLineMarkerProviderKt.getCallNameFromPsi(element);
    }
}

