/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.k2.codeinsight.inspections.declarations;

import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.session.KaSessionProvider;
import org.jetbrains.kotlin.analysis.api.symbols.KaCallableSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaDeclarationSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaFunctionSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaValueParameterSymbol;
import org.jetbrains.kotlin.analysis.api.types.KaType;
import org.jetbrains.kotlin.idea.base.analysis.api.utils.ShortenUtilsKt;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.applicable.inspections.KotlinApplicableInspectionBase;
import org.jetbrains.kotlin.idea.codeinsight.api.applicable.inspections.KotlinModCommandQuickFix;
import org.jetbrains.kotlin.idea.codeinsight.utils.TypeUtilsKt;
import org.jetbrains.kotlin.idea.k2.codeinsight.generate.GenerateEqualsAndHashCodeUtils;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtClassOrObjectKt;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.VisitorWrappersKt;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0002\u001a\u001bB\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u0003H\u0014J\u001e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b2\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u0003H\u0014J \u0010\f\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\u0002H\u0016J\u001b\u0010\u0013\u001a\u0004\u0018\u00010\u00032\u0006\u0010\b\u001a\u00020\u0002H\u0016R\u00020\u0014\u00a2\u0006\u0002\u0010\u0015J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/inspections/declarations/ArrayInDataClassInspection;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/applicable/inspections/KotlinApplicableInspectionBase$Simple;", "Lorg/jetbrains/kotlin/psi/KtParameter;", "Lorg/jetbrains/kotlin/idea/k2/codeinsight/inspections/declarations/ArrayInDataClassInspection$Context;", "<init>", "()V", "getProblemDescription", "", "element", "context", "createQuickFix", "Lorg/jetbrains/kotlin/idea/codeinsight/api/applicable/inspections/KotlinModCommandQuickFix;", "buildVisitor", "Lorg/jetbrains/kotlin/psi/KtVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "isApplicableByPsi", "prepareContext", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/psi/KtParameter;)Lorg/jetbrains/kotlin/idea/k2/codeinsight/inspections/declarations/ArrayInDataClassInspection$Context;", "checkOverriddenEqualsAndHashCode", "Lorg/jetbrains/kotlin/idea/k2/codeinsight/inspections/declarations/ArrayInDataClassInspection$EqualsHashCodeOverrides;", "klass", "Lorg/jetbrains/kotlin/psi/KtClass;", "Context", "EqualsHashCodeOverrides", "kotlin.code-insight.inspections.k2"})
@SourceDebugExtension(value={"SMAP\nArrayInDataClassInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ArrayInDataClassInspection.kt\norg/jetbrains/kotlin/idea/k2/codeinsight/inspections/declarations/ArrayInDataClassInspection\n+ 2 analyze.kt\norg/jetbrains/kotlin/analysis/api/AnalyzeKt\n+ 3 KaSessionProvider.kt\norg/jetbrains/kotlin/analysis/api/session/KaSessionProvider\n+ 4 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n*L\n1#1,133:1\n28#2,2:134\n36#3,9:136\n47#3,2:146\n119#4:145\n*S KotlinDebug\n*F\n+ 1 ArrayInDataClassInspection.kt\norg/jetbrains/kotlin/idea/k2/codeinsight/inspections/declarations/ArrayInDataClassInspection\n*L\n102#1:134,2\n102#1:136,9\n102#1:146,2\n103#1:145\n*E\n"})
public final class ArrayInDataClassInspection
extends KotlinApplicableInspectionBase.Simple<KtParameter, Context> {
    @Override
    @NotNull
    protected String getProblemDescription(@NotNull KtParameter element, @NotNull Context context2) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return KotlinBundle.message((String)"array.property.in.data.class.it.s.recommended.to.override.equals.hashcode", (Object[])new Object[0]);
    }

    @Override
    @NotNull
    protected KotlinModCommandQuickFix<KtParameter> createQuickFix(@NotNull KtParameter element, @NotNull Context context2) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return new KotlinModCommandQuickFix<KtParameter>(context2){
            final /* synthetic */ Context $context;
            {
                this.$context = $context;
            }

            public String getFamilyName() {
                return KotlinBundle.message((String)"generate.equals.and.hashcode.fix.text", (Object[])new Object[0]);
            }

            protected void applyFix(Project project, KtParameter element, ModPsiUpdater updater2) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                Intrinsics.checkNotNullParameter((Object)updater2, (String)"updater");
                Context $this$applyFix_u24lambda_u240 = this.$context;
                boolean bl = false;
                KtPsiFactory psiFactory = new KtPsiFactory(project, true);
                KtClass ktClass = KtPsiUtilKt.containingClass((KtElement)((KtElement)element));
                if (ktClass == null) {
                    return;
                }
                KtClass containingClass = ktClass;
                if ($this$applyFix_u24lambda_u240.getEquals() != null) {
                    this.generateFunctionDeclarationInClass(psiFactory, containingClass, $this$applyFix_u24lambda_u240.getEquals());
                }
                if ($this$applyFix_u24lambda_u240.getHashCode() != null) {
                    this.generateFunctionDeclarationInClass(psiFactory, containingClass, $this$applyFix_u24lambda_u240.getHashCode());
                }
            }

            private final void generateFunctionDeclarationInClass(KtPsiFactory factory2, KtClass containingClass, String text) {
                PsiElement anchor$iv;
                KtNamedFunction function = factory2.createFunction(text);
                KtClassOrObject this_$iv = (KtClassOrObject)containingClass;
                boolean $i$f$addDeclaration = false;
                KtClassBody body$iv = KtClassOrObjectKt.getOrCreateBody((KtClassOrObject)this_$iv);
                PsiElement psiElement = body$iv.getRBrace();
                if (psiElement == null) {
                    PsiElement psiElement2 = body$iv.getLastChild();
                    psiElement = psiElement2;
                    Intrinsics.checkNotNull((Object)psiElement2);
                }
                Class[] classArray = new Class[]{PsiWhiteSpace.class};
                PsiElement psiElement3 = anchor$iv = PsiTreeUtil.skipSiblingsBackward((PsiElement)psiElement, (Class[])classArray);
                PsiElement psiElement4 = (psiElement3 != null ? psiElement3.getNextSibling() : null) instanceof PsiErrorElement ? body$iv.addBefore((PsiElement)((KtDeclaration)function), anchor$iv) : body$iv.addAfter((PsiElement)((KtDeclaration)function), anchor$iv);
                if (psiElement4 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtNamedFunction");
                }
                ShortenUtilsKt.shortenReferences$default((KtElement)((KtDeclaration)((KtNamedFunction)psiElement4)), null, null, null, 14, null);
            }
        };
    }

    @Override
    @NotNull
    public KtVisitor<?, ?> buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return (KtVisitor)VisitorWrappersKt.classVisitor(arg_0 -> ArrayInDataClassInspection.buildVisitor$lambda$0(this, holder, isOnTheFly, arg_0));
    }

    @Override
    public boolean isApplicableByPsi(@NotNull KtParameter element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return element.hasValOrVar();
    }

    @Override
    @Nullable
    public Context prepareContext(@NotNull KaSession $context_receiver_0, @NotNull KtParameter element) {
        Intrinsics.checkNotNullParameter((Object)$context_receiver_0, (String)"$context_receiver_0");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        KaType parameterType = $context_receiver_0.getSymbol(element).getReturnType();
        if (!$context_receiver_0.isArrayOrPrimitiveArray(parameterType)) {
            return null;
        }
        KtClass ktClass = KtPsiUtilKt.containingClass((KtElement)((KtElement)element));
        if (ktClass == null) {
            return null;
        }
        KtClass containingClass = ktClass;
        return switch (WhenMappings.$EnumSwitchMapping$0[this.checkOverriddenEqualsAndHashCode(containingClass).ordinal()]) {
            case 1 -> null;
            case 2 -> {
                String text = GenerateEqualsAndHashCodeUtils.INSTANCE.generateHashCode(containingClass);
                yield new Context(null, text);
            }
            case 3 -> {
                String text = GenerateEqualsAndHashCodeUtils.INSTANCE.generateEquals(containingClass);
                yield new Context(text, null);
            }
            case 4 -> {
                String equalsText = GenerateEqualsAndHashCodeUtils.INSTANCE.generateEquals(containingClass);
                String hashCodeText = GenerateEqualsAndHashCodeUtils.INSTANCE.generateHashCode(containingClass);
                yield new Context(equalsText, hashCodeText);
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final EqualsHashCodeOverrides checkOverriddenEqualsAndHashCode(KtClass klass) {
        boolean overriddenEquals = false;
        boolean overriddenHashCode = false;
        for (KtDeclaration declaration : klass.getDeclarations()) {
            if (!(declaration instanceof KtFunction) || !declaration.hasModifier(KtTokens.OVERRIDE_KEYWORD)) continue;
            if (Intrinsics.areEqual((Object)((KtFunction)declaration).getNameAsName(), (Object)OperatorNameConventions.EQUALS) && ((KtFunction)declaration).getValueParameters().size() == 1) {
                void this_$iv$iv;
                KtElement useSiteElement$iv = (KtElement)declaration;
                boolean $i$f$analyze = false;
                Project project = useSiteElement$iv.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                KaSessionProvider kaSessionProvider = KaSessionProvider.Companion.getInstance(project);
                boolean $i$f$analyze2 = false;
                KaSession analysisSession$iv$iv = this_$iv$iv.getAnalysisSession(useSiteElement$iv);
                this_$iv$iv.beforeEnteringAnalysis(analysisSession$iv$iv, useSiteElement$iv);
                try {
                    Unit unit;
                    Object lock$iv$iv;
                    Object object = lock$iv$iv = new Object();
                    synchronized (object) {
                        Object object2;
                        KaType parameterType;
                        boolean bl = false;
                        KaSession $this$checkOverriddenEqualsAndHashCode_u24lambda_u241 = analysisSession$iv$iv;
                        boolean bl2 = false;
                        KaDeclarationSymbol $this$safeAs$iv = $this$checkOverriddenEqualsAndHashCode_u24lambda_u241.getSymbol(declaration);
                        boolean $i$f$safeAs = false;
                        KaDeclarationSymbol kaDeclarationSymbol = $this$safeAs$iv;
                        if (!(kaDeclarationSymbol instanceof KaFunctionSymbol)) {
                            kaDeclarationSymbol = null;
                        }
                        KaType kaType = parameterType = (object2 = (KaFunctionSymbol)kaDeclarationSymbol) != null && (object2 = ((KaFunctionSymbol)object2).getValueParameters()) != null && (object2 = (KaValueParameterSymbol)CollectionsKt.singleOrNull((List)object2)) != null ? ((KaCallableSymbol)object2).getReturnType() : null;
                        boolean bl3 = kaType != null ? TypeUtilsKt.isNullableAnyType($this$checkOverriddenEqualsAndHashCode_u24lambda_u241, kaType) : false;
                        if (bl3) {
                            overriddenEquals = true;
                        }
                        unit = Unit.INSTANCE;
                    }
                    Unit unit2 = unit;
                }
                finally {
                    this_$iv$iv.afterLeavingAnalysis(analysisSession$iv$iv, useSiteElement$iv);
                }
            }
            if (!Intrinsics.areEqual((Object)((KtFunction)declaration).getNameAsName(), (Object)OperatorNameConventions.HASH_CODE) || ((KtFunction)declaration).getValueParameters().size() != 0) continue;
            overriddenHashCode = true;
        }
        return EqualsHashCodeOverrides.Companion.of(overriddenEquals, overriddenHashCode);
    }

    private static final Unit buildVisitor$lambda$0(ArrayInDataClassInspection this$0, ProblemsHolder $holder, boolean $isOnTheFly, KtClass klass) {
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        if (!klass.isData()) {
            return Unit.INSTANCE;
        }
        KtPrimaryConstructor ktPrimaryConstructor = klass.getPrimaryConstructor();
        if (ktPrimaryConstructor == null) {
            return Unit.INSTANCE;
        }
        KtPrimaryConstructor constructor = ktPrimaryConstructor;
        for (KtParameter parameter : constructor.getValueParameters()) {
            Intrinsics.checkNotNull((Object)parameter);
            this$0.visitTargetElement((KtElement)parameter, $holder, $isOnTheFly);
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u001b\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/inspections/declarations/ArrayInDataClassInspection$Context;", "", "equals", "", "hashCode", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getEquals", "()Ljava/lang/String;", "getHashCode", "kotlin.code-insight.inspections.k2"})
    public static final class Context {
        @Nullable
        private final String equals;
        @Nullable
        private final String hashCode;

        public Context(@Nullable String equals, @Nullable String hashCode) {
            this.equals = equals;
            this.hashCode = hashCode;
        }

        @Nullable
        public final String getEquals() {
            return this.equals;
        }

        @Nullable
        public final String getHashCode() {
            return this.hashCode;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\b\b\u0082\u0081\u0002\u0018\u0000 \b2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\bB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/inspections/declarations/ArrayInDataClassInspection$EqualsHashCodeOverrides;", "", "<init>", "(Ljava/lang/String;I)V", "HAS_EQUALS_AND_HASHCODE", "HAS_EQUALS", "HAS_HASHCODE", "HAS_NONE", "Companion", "kotlin.code-insight.inspections.k2"})
    private static final class EqualsHashCodeOverrides
    extends Enum<EqualsHashCodeOverrides> {
        @NotNull
        public static final Companion Companion;
        public static final /* enum */ EqualsHashCodeOverrides HAS_EQUALS_AND_HASHCODE;
        public static final /* enum */ EqualsHashCodeOverrides HAS_EQUALS;
        public static final /* enum */ EqualsHashCodeOverrides HAS_HASHCODE;
        public static final /* enum */ EqualsHashCodeOverrides HAS_NONE;
        private static final /* synthetic */ EqualsHashCodeOverrides[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static EqualsHashCodeOverrides[] values() {
            return (EqualsHashCodeOverrides[])$VALUES.clone();
        }

        public static EqualsHashCodeOverrides valueOf(String value) {
            return Enum.valueOf(EqualsHashCodeOverrides.class, value);
        }

        @NotNull
        public static EnumEntries<EqualsHashCodeOverrides> getEntries() {
            return $ENTRIES;
        }

        static {
            HAS_EQUALS_AND_HASHCODE = new EqualsHashCodeOverrides();
            HAS_EQUALS = new EqualsHashCodeOverrides();
            HAS_HASHCODE = new EqualsHashCodeOverrides();
            HAS_NONE = new EqualsHashCodeOverrides();
            $VALUES = equalsHashCodeOverridesArray = new EqualsHashCodeOverrides[]{EqualsHashCodeOverrides.HAS_EQUALS_AND_HASHCODE, EqualsHashCodeOverrides.HAS_EQUALS, EqualsHashCodeOverrides.HAS_HASHCODE, EqualsHashCodeOverrides.HAS_NONE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/inspections/declarations/ArrayInDataClassInspection$EqualsHashCodeOverrides$Companion;", "", "<init>", "()V", "of", "Lorg/jetbrains/kotlin/idea/k2/codeinsight/inspections/declarations/ArrayInDataClassInspection$EqualsHashCodeOverrides;", "hasEquals", "", "hasHashCode", "kotlin.code-insight.inspections.k2"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final EqualsHashCodeOverrides of(boolean hasEquals, boolean hasHashCode) {
                return hasEquals && hasHashCode ? HAS_EQUALS_AND_HASHCODE : (hasEquals ? HAS_EQUALS : (hasHashCode ? HAS_HASHCODE : HAS_NONE));
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[EqualsHashCodeOverrides.values().length];
            try {
                nArray[EqualsHashCodeOverrides.HAS_EQUALS_AND_HASHCODE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EqualsHashCodeOverrides.HAS_EQUALS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EqualsHashCodeOverrides.HAS_HASHCODE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EqualsHashCodeOverrides.HAS_NONE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

