/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.k2.refactoring.move.ui;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.move.MoveCallback;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.ui.dsl.builder.ButtonKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.RowLayout;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.reflect.KMutableProperty0;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.core.PackageUtilsKt;
import org.jetbrains.kotlin.idea.k2.refactoring.move.descriptor.K2MoveDescriptor;
import org.jetbrains.kotlin.idea.k2.refactoring.move.descriptor.K2MoveOperationDescriptor;
import org.jetbrains.kotlin.idea.k2.refactoring.move.descriptor.K2MoveSourceDescriptor;
import org.jetbrains.kotlin.idea.k2.refactoring.move.descriptor.K2MoveTargetDescriptor;
import org.jetbrains.kotlin.idea.k2.refactoring.move.ui.K2MoveSourceModel;
import org.jetbrains.kotlin.idea.k2.refactoring.move.ui.K2MoveTargetModel;
import org.jetbrains.kotlin.idea.k2.refactoring.move.ui.MoveUiUtilKt;
import org.jetbrains.kotlin.idea.refactoring.KotlinCommonRefactoringSettings;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 (2\u00020\u0001:\u0004%&'(B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\"\u001a\u0006\u0012\u0002\b\u00030#H'J\b\u0010$\u001a\u00020\u0017H\u0016R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0016\u0010\b\u001a\u0006\u0012\u0002\b\u00030\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0012\u0010\f\u001a\u00020\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0013R\u0012\u0010\u0016\u001a\u00020\u0017X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0013R\u0011\u0010\u001c\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0013R\u0014\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!\u0082\u0001\u0002)*\u00a8\u0006+"}, d2={"Lorg/jetbrains/kotlin/idea/k2/refactoring/move/ui/K2MoveModel;", "", "<init>", "()V", "project", "Lcom/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "source", "Lorg/jetbrains/kotlin/idea/k2/refactoring/move/ui/K2MoveSourceModel;", "getSource", "()Lorg/jetbrains/kotlin/idea/k2/refactoring/move/ui/K2MoveSourceModel;", "target", "Lorg/jetbrains/kotlin/idea/k2/refactoring/move/ui/K2MoveTargetModel;", "getTarget", "()Lorg/jetbrains/kotlin/idea/k2/refactoring/move/ui/K2MoveTargetModel;", "searchForText", "Lorg/jetbrains/kotlin/idea/k2/refactoring/move/ui/K2MoveModel$Setting;", "getSearchForText", "()Lorg/jetbrains/kotlin/idea/k2/refactoring/move/ui/K2MoveModel$Setting;", "searchInComments", "getSearchInComments", "inSourceRoot", "", "getInSourceRoot", "()Z", "searchReferences", "getSearchReferences", "mppDeclarations", "getMppDeclarations", "moveCallBack", "Lcom/intellij/refactoring/move/MoveCallback;", "getMoveCallBack", "()Lcom/intellij/refactoring/move/MoveCallback;", "toDescriptor", "Lorg/jetbrains/kotlin/idea/k2/refactoring/move/descriptor/K2MoveOperationDescriptor;", "isValidRefactoring", "Setting", "Files", "Declarations", "Companion", "Lorg/jetbrains/kotlin/idea/k2/refactoring/move/ui/K2MoveModel$Declarations;", "Lorg/jetbrains/kotlin/idea/k2/refactoring/move/ui/K2MoveModel$Files;", "kotlin.refactorings.move.k2"})
public abstract class K2MoveModel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Setting searchForText = Setting.SEARCH_FOR_TEXT;
    @NotNull
    private final Setting searchInComments = Setting.SEARCH_IN_COMMENTS;
    @NotNull
    private final Setting searchReferences = Setting.SEARCH_REFERENCES;
    @NotNull
    private final Setting mppDeclarations = Setting.MPP_DECLARATIONS;

    private K2MoveModel() {
    }

    @NotNull
    public abstract Project getProject();

    @NotNull
    public abstract K2MoveSourceModel<?> getSource();

    @NotNull
    public abstract K2MoveTargetModel getTarget();

    @NotNull
    public final Setting getSearchForText() {
        return this.searchForText;
    }

    @NotNull
    public final Setting getSearchInComments() {
        return this.searchInComments;
    }

    public abstract boolean getInSourceRoot();

    @NotNull
    public final Setting getSearchReferences() {
        return this.searchReferences;
    }

    @NotNull
    public final Setting getMppDeclarations() {
        return this.mppDeclarations;
    }

    @Nullable
    public abstract MoveCallback getMoveCallBack();

    @RequiresReadLock
    @NotNull
    public abstract K2MoveOperationDescriptor<?> toDescriptor();

    public boolean isValidRefactoring() {
        return !((Collection)this.getSource().getElements()).isEmpty();
    }

    public /* synthetic */ K2MoveModel(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\b\u001a\u0010\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n0\t*\b\u0012\u0004\u0012\u00020\f0\tH\u0002J?\u0010\r\u001a\u0004\u0018\u00010\u000e2\u000e\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\f2\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u00132\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u0015\u00a2\u0006\u0002\u0010\u0016R\u0014\u0010\u0004\u001a\u00020\u00058CX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/k2/refactoring/move/ui/K2MoveModel$Companion;", "", "<init>", "()V", "MOVE_DECLARATIONS", "", "getMOVE_DECLARATIONS", "()Ljava/lang/String;", "fileElements", "", "Lcom/intellij/psi/PsiFileSystemItem;", "kotlin.jvm.PlatformType", "Lcom/intellij/psi/PsiElement;", "create", "Lorg/jetbrains/kotlin/idea/k2/refactoring/move/ui/K2MoveModel;", "elements", "", "targetContainer", "editor", "Lcom/intellij/openapi/editor/Editor;", "moveCallBack", "Lcom/intellij/refactoring/move/MoveCallback;", "([Lcom/intellij/psi/PsiElement;Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/editor/Editor;Lcom/intellij/refactoring/move/MoveCallback;)Lorg/jetbrains/kotlin/idea/k2/refactoring/move/ui/K2MoveModel;", "kotlin.refactorings.move.k2"})
    @SourceDebugExtension(value={"SMAP\nK2MoveModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 K2MoveModel.kt\norg/jetbrains/kotlin/idea/k2/refactoring/move/ui/K2MoveModel$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n+ 5 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n*L\n1#1,338:1\n1557#2:339\n1628#2,3:340\n1755#2,2:346\n1757#2:349\n1755#2,3:350\n1755#2,3:353\n1368#2:356\n1454#2,2:357\n808#2,11:359\n1456#2,3:370\n1734#2,3:373\n295#2,2:376\n1755#2,3:380\n1734#2,3:383\n3829#3:343\n4344#3,2:344\n67#4:348\n21#5,2:378\n*S KotlinDebug\n*F\n+ 1 K2MoveModel.kt\norg/jetbrains/kotlin/idea/k2/refactoring/move/ui/K2MoveModel$Companion\n*L\n213#1:339\n213#1:340,3\n254#1:346,2\n254#1:349\n262#1:350,3\n274#1:353,3\n282#1:356\n282#1:357,2\n284#1:359,11\n282#1:370,3\n301#1:373,3\n310#1:376,2\n235#1:380,3\n241#1:383,3\n223#1:343\n223#1:344,2\n254#1:348\n313#1:378,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nls
        private final String getMOVE_DECLARATIONS() {
            return KotlinBundle.message((String)"text.move.declarations", (Object[])new Object[0]);
        }

        /*
         * WARNING - void declaration
         */
        private final List<PsiFileSystemItem> fileElements(List<? extends PsiElement> $this$fileElements) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = $this$fileElements;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                PsiElement psiElement = (PsiElement)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it instanceof PsiDirectory ? (PsiFileSystemItem)it : (PsiFileSystemItem)it.getContainingFile());
            }
            return (List)destination$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final K2MoveModel create(@NotNull PsiElement[] elements, @Nullable PsiElement targetContainer, @Nullable Editor editor, @Nullable MoveCallback moveCallBack2) {
            K2MoveModel k2MoveModel;
            boolean bl;
            boolean inSourceRoot;
            List declarationsFromFiles;
            List elementsToMove;
            PsiElement project;
            block46: {
                void $this$flatMapTo$iv$iv;
                boolean bl2;
                String message2;
                Object element$iv2;
                boolean $i$f$any;
                Iterable $this$any$iv;
                Object object;
                block44: {
                    boolean bl3;
                    block43: {
                        Iterator $this$filterTo$iv$iv;
                        Intrinsics.checkNotNullParameter((Object)elements, (String)"elements");
                        PsiElement psiElement = (PsiElement)ArraysKt.firstOrNull((Object[])elements);
                        if (psiElement == null || (psiElement = psiElement.getProject()) == null) {
                            throw new IllegalStateException("Elements not part of project".toString());
                        }
                        project = psiElement;
                        PsiElement[] $this$filter$iv = elements;
                        boolean $i$f$filter = false;
                        PsiElement[] psiElementArray = $this$filter$iv;
                        Collection destination$iv$iv = new ArrayList();
                        boolean $i$f$filterTo = false;
                        int n = ((void)$this$filterTo$iv$iv).length;
                        for (int j = 0; j < n; ++j) {
                            boolean bl4;
                            void element$iv$iv;
                            void elem = element$iv$iv = $this$filterTo$iv$iv[j];
                            boolean bl5 = false;
                            object = elem;
                            if (object instanceof PsiDirectory || object instanceof PsiFile) {
                                bl4 = true;
                            } else {
                                PsiElement container;
                                KClass[] kClassArray = new KClass[]{Reflection.getOrCreateKotlinClass(PsiFile.class), Reflection.getOrCreateKotlinClass(KtNamedDeclaration.class)};
                                if (PsiTreeUtilKt.parentOfTypes$default((PsiElement)elem, (KClass[])kClassArray, (boolean)false, (int)2, null) == null) {
                                    throw new IllegalStateException("Element not in Kotlin file".toString());
                                }
                                bl4 = !ArraysKt.contains((Object[])elements, (Object)container);
                            }
                            if (!bl4) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        elementsToMove = (List)destination$iv$iv;
                        if (!CommonRefactoringUtil.checkReadOnlyStatusRecursively((Project)project, (Collection)ArraysKt.toList((Object[])elements), (boolean)true)) {
                            return null;
                        }
                        $this$any$iv = elementsToMove;
                        $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl3 = false;
                        } else {
                            for (Object element$iv2 : $this$any$iv) {
                                void $this$parentOfType$iv;
                                PsiElement it = (PsiElement)element$iv2;
                                boolean bl6 = false;
                                PsiElement psiElement2 = it;
                                boolean withSelf$iv = false;
                                boolean $i$f$parentOfType = false;
                                if (!(PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv, KtNamedDeclaration.class, (boolean)true) != null)) continue;
                                bl3 = true;
                                break block43;
                            }
                            bl3 = false;
                        }
                    }
                    if (bl3) {
                        message2 = RefactoringBundle.getCannotRefactorMessage((String)KotlinBundle.message((String)"text.move.declaration.no.support.for.nested.declarations", (Object[])new Object[0]));
                        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message2, (String)this.getMOVE_DECLARATIONS(), null);
                        return null;
                    }
                    $this$any$iv = elementsToMove;
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl2 = false;
                    } else {
                        for (Object element$iv2 : $this$any$iv) {
                            PsiElement it = (PsiElement)element$iv2;
                            boolean bl7 = false;
                            if (!(it instanceof KtEnumEntry)) continue;
                            bl2 = true;
                            break block44;
                        }
                        bl2 = false;
                    }
                }
                if (bl2) {
                    message2 = RefactoringBundle.getCannotRefactorMessage((String)KotlinBundle.message((String)"text.move.declaration.no.support.for.enums", (Object[])new Object[0]));
                    CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message2, (String)this.getMOVE_DECLARATIONS(), null);
                    return null;
                }
                if (org.jetbrains.kotlin.idea.k2.refactoring.move.ui.K2MoveModel$Companion.create$isMultiFileMove(elementsToMove) && targetContainer != null && !(targetContainer instanceof PsiDirectory)) {
                    message2 = RefactoringBundle.getCannotRefactorMessage((String)KotlinBundle.message((String)"text.move.file.no.support.for.file.target", (Object[])new Object[0]));
                    CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message2, (String)this.getMOVE_DECLARATIONS(), null);
                    return null;
                }
                if (org.jetbrains.kotlin.idea.k2.refactoring.move.ui.K2MoveModel$Companion.create$isMultiFileMove(elementsToMove)) {
                    boolean bl8;
                    block45: {
                        $this$any$iv = elementsToMove;
                        $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl8 = false;
                        } else {
                            for (Object element$iv2 : $this$any$iv) {
                                PsiElement it = (PsiElement)element$iv2;
                                boolean bl9 = false;
                                if (!(it instanceof KtNamedDeclaration && !org.jetbrains.kotlin.idea.k2.refactoring.move.ui.K2MoveModel$Companion.create$isSingleClassContainer(it))) continue;
                                bl8 = true;
                                break block45;
                            }
                            bl8 = false;
                        }
                    }
                    if (bl8) {
                        message2 = RefactoringBundle.getCannotRefactorMessage((String)KotlinBundle.message((String)"text.move.declaration.no.support.for.multi.file", (Object[])new Object[0]));
                        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message2, (String)this.getMOVE_DECLARATIONS(), null);
                        return null;
                    }
                }
                Iterable $this$flatMap$iv = elementsToMove;
                boolean $i$f$flatMap = false;
                element$iv2 = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                    List list2;
                    PsiElement elem = (PsiElement)element$iv$iv;
                    boolean bl10 = false;
                    object = elem;
                    if (object instanceof KtFile) {
                        void $this$filterIsInstanceTo$iv$iv;
                        Iterable $this$filterIsInstance$iv = ((KtFile)elem).getDeclarations();
                        boolean $i$f$filterIsInstance = false;
                        Iterable iterable = $this$filterIsInstance$iv;
                        Collection destination$iv$iv2 = new ArrayList();
                        boolean $i$f$filterIsInstanceTo = false;
                        for (Object element$iv$iv2 : $this$filterIsInstanceTo$iv$iv) {
                            if (!(element$iv$iv2 instanceof KtNamedDeclaration)) continue;
                            destination$iv$iv2.add(element$iv$iv2);
                        }
                        list2 = (List)destination$iv$iv2;
                    } else {
                        list2 = object instanceof KtNamedDeclaration ? CollectionsKt.listOf((Object)elem) : CollectionsKt.emptyList();
                    }
                    Iterable list$iv$iv = list2;
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                declarationsFromFiles = (List)destination$iv$iv;
                inSourceRoot = org.jetbrains.kotlin.idea.k2.refactoring.move.ui.K2MoveModel$Companion.create$inSourceRoot((Project)project, targetContainer, elementsToMove);
                Iterable $this$all$iv = elementsToMove;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv3 : $this$all$iv) {
                        PsiElement it = (PsiElement)element$iv3;
                        boolean bl11 = false;
                        if (it instanceof KtFile) continue;
                        bl = false;
                        break block46;
                    }
                    bl = true;
                }
            }
            if (bl && targetContainer instanceof PsiDirectory || org.jetbrains.kotlin.idea.k2.refactoring.move.ui.K2MoveModel$Companion.create$isMultiFileMove(elementsToMove) || declarationsFromFiles.isEmpty()) {
                K2MoveTargetModel.SourceDirectory sourceDirectory;
                source = new K2MoveSourceModel.FileSource(CollectionsKt.toSet((Iterable)this.fileElements(elementsToMove)));
                if (targetContainer instanceof PsiDirectory) {
                    FqName pkg = PackageUtilsKt.getFqNameWithImplicitPrefixOrRoot((PsiDirectory)targetContainer);
                    sourceDirectory = new K2MoveTargetModel.SourceDirectory(pkg, (PsiDirectory)targetContainer);
                } else {
                    KtElement ktElement;
                    Object v11;
                    PsiDirectory directory;
                    block48: {
                        PsiElement psiElement;
                        Object v8;
                        block47: {
                            Iterable $this$firstOrNull$iv = elementsToMove;
                            boolean $i$f$firstOrNull = false;
                            for (Object element$iv : $this$firstOrNull$iv) {
                                PsiElement it = (PsiElement)element$iv;
                                boolean bl12 = false;
                                if (!(it.getContainingFile() != null)) continue;
                                v8 = element$iv;
                                break block47;
                            }
                            v8 = null;
                        }
                        if ((psiElement = (PsiElement)v8) == null || (psiElement = psiElement.getContainingFile()) == null) {
                            throw new IllegalStateException("No default target found".toString());
                        }
                        PsiElement file = psiElement;
                        PsiDirectory psiDirectory = file.getContainingDirectory();
                        if (psiDirectory == null) {
                            throw new IllegalStateException("No default target found".toString());
                        }
                        directory = psiDirectory;
                        Iterable $this$firstIsInstanceOrNull$iv = elementsToMove;
                        boolean $i$f$firstIsInstanceOrNull = false;
                        for (Object element$iv : $this$firstIsInstanceOrNull$iv) {
                            if (!(element$iv instanceof KtElement)) continue;
                            v11 = element$iv;
                            break block48;
                        }
                        v11 = null;
                    }
                    if ((ktElement = (KtElement)v11) == null || (ktElement = ktElement.getContainingKtFile()) == null || (ktElement = ktElement.getPackageFqName()) == null) {
                        ktElement = FqName.ROOT;
                    }
                    KtElement pkgName = ktElement;
                    sourceDirectory = new K2MoveTargetModel.SourceDirectory((FqName)pkgName, directory);
                }
                K2MoveTargetModel.SourceDirectory target = sourceDirectory;
                k2MoveModel = new Files((Project)project, (K2MoveSourceModel.FileSource)source, target, inSourceRoot, moveCallBack2);
            } else if (targetContainer instanceof KtFile || org.jetbrains.kotlin.idea.k2.refactoring.move.ui.K2MoveModel$Companion.create$isSingleClassContainer(targetContainer) || org.jetbrains.kotlin.idea.k2.refactoring.move.ui.K2MoveModel$Companion.create$isSingleFileMove(elementsToMove)) {
                K2MoveTargetModel.File file;
                PsiFile targetFile;
                source = new K2MoveSourceModel.ElementSource(CollectionsKt.toSet((Iterable)declarationsFromFiles));
                PsiElement psiElement = targetContainer;
                Object object = targetFile = psiElement != null ? psiElement.getContainingFile() : null;
                if (targetFile instanceof KtFile) {
                    file = K2MoveTargetModel.Companion.File((KtFile)targetFile);
                } else if (targetContainer instanceof PsiDirectory) {
                    FqName pkg = PackageUtilsKt.getFqNameWithImplicitPrefixOrRoot((PsiDirectory)targetContainer);
                    file = new K2MoveTargetModel.File(org.jetbrains.kotlin.idea.k2.refactoring.move.ui.K2MoveModel$Companion.create$sourceFileName(elementsToMove), pkg, (PsiDirectory)targetContainer);
                } else {
                    Object object2 = CollectionsKt.firstOrNull((List)elementsToMove);
                    Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtElement");
                    KtElement firstElem = (KtElement)object2;
                    KtFile ktFile2 = firstElem.getContainingKtFile();
                    Intrinsics.checkNotNullExpressionValue((Object)ktFile2, (String)"getContainingKtFile(...)");
                    KtFile containingFile = ktFile2;
                    PsiDirectory psiDirectory = containingFile.getContainingDirectory();
                    if (psiDirectory == null) {
                        throw new IllegalStateException("No directory found".toString());
                    }
                    PsiDirectory psiDirectory2 = psiDirectory;
                    file = new K2MoveTargetModel.File(org.jetbrains.kotlin.idea.k2.refactoring.move.ui.K2MoveModel$Companion.create$sourceFileName(elementsToMove), containingFile.getPackageFqName(), psiDirectory2);
                }
                K2MoveTargetModel.File target = file;
                k2MoveModel = new Declarations((Project)project, (K2MoveSourceModel.ElementSource)source, target, inSourceRoot, moveCallBack2);
            } else {
                throw new IllegalStateException("Unsupported move operation".toString());
            }
            return k2MoveModel;
        }

        public static /* synthetic */ K2MoveModel create$default(Companion companion, PsiElement[] psiElementArray, PsiElement psiElement, Editor editor, MoveCallback moveCallback, int n, Object object) {
            if ((n & 4) != 0) {
                editor = null;
            }
            if ((n & 8) != 0) {
                moveCallback = null;
            }
            return companion.create(psiElementArray, psiElement, editor, moveCallback);
        }

        private static final boolean create$inSourceRoot(Project project, PsiElement $targetContainer, List<? extends PsiElement> declarations2) {
            boolean bl;
            ProjectFileIndex fileIndex;
            block6: {
                ProjectFileIndex projectFileIndex = ProjectFileIndex.getInstance((Project)project);
                Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"getInstance(...)");
                fileIndex = projectFileIndex;
                Iterable $this$any$iv = CollectionsKt.toSet((Iterable)Companion.fileElements(declarations2));
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        PsiFileSystemItem it = (PsiFileSystemItem)element$iv;
                        boolean bl2 = false;
                        if (!(!fileIndex.isInSourceContent(it.getVirtualFile()))) continue;
                        bl = true;
                        break block6;
                    }
                    bl = false;
                }
            }
            if (bl) {
                return false;
            }
            if ($targetContainer == null || $targetContainer instanceof PsiDirectory) {
                return true;
            }
            PsiFile psiFile = $targetContainer.getContainingFile();
            if (psiFile == null || (psiFile = psiFile.getVirtualFile()) == null) {
                return false;
            }
            PsiFile targetFile = psiFile;
            return fileIndex.isInSourceContent((VirtualFile)targetFile);
        }

        private static final boolean create$isSingleFileMove(List<? extends PsiElement> movedElements) {
            boolean bl;
            block3: {
                Iterable $this$all$iv = movedElements;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        PsiElement it = (PsiElement)element$iv;
                        boolean bl2 = false;
                        if (it instanceof KtNamedDeclaration) continue;
                        bl = false;
                        break block3;
                    }
                    bl = true;
                }
            }
            return bl || CollectionsKt.singleOrNull(movedElements) instanceof KtFile;
        }

        private static final boolean create$isMultiFileMove(List<? extends PsiElement> movedElements) {
            return CollectionsKt.toSet((Iterable)Companion.fileElements(movedElements)).size() > 1;
        }

        private static final boolean create$isSingleClassContainer(PsiElement $this$create_u24isSingleClassContainer) {
            if (!($this$create_u24isSingleClassContainer instanceof KtClassOrObject)) {
                return false;
            }
            PsiElement psiElement = ((KtClassOrObject)$this$create_u24isSingleClassContainer).getParent();
            KtFile ktFile2 = psiElement instanceof KtFile ? (KtFile)psiElement : null;
            if (ktFile2 == null) {
                return false;
            }
            KtFile file = ktFile2;
            return Intrinsics.areEqual((Object)$this$create_u24isSingleClassContainer, (Object)CollectionsKt.singleOrNull((List)file.getDeclarations()));
        }

        private static final String create$sourceFileName(List<? extends PsiElement> elementsToMove) {
            Object object;
            KtElement firstElem;
            Object object2 = CollectionsKt.firstOrNull(elementsToMove);
            Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtElement");
            KtElement ktElement = firstElem = (KtElement)object2;
            if (ktElement instanceof KtFile) {
                String string = ((KtFile)firstElem).getName();
                object = string;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            } else if (ktElement instanceof KtNamedDeclaration) {
                LanguageFileType languageFileType = KotlinLanguage.INSTANCE.getAssociatedFileType();
                object = ((KtNamedDeclaration)firstElem).getName() + "." + (languageFileType != null ? languageFileType.getDefaultExtension() : null);
            } else {
                throw new IllegalStateException("Element to move should be a file or declaration".toString());
            }
            return object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\f\u0010\u0018\u001a\u00020\t*\u00020\u0019H\u0002J\b\u0010\u001a\u001a\u00020\tH\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0016\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/idea/k2/refactoring/move/ui/K2MoveModel$Declarations;", "Lorg/jetbrains/kotlin/idea/k2/refactoring/move/ui/K2MoveModel;", "project", "Lcom/intellij/openapi/project/Project;", "source", "Lorg/jetbrains/kotlin/idea/k2/refactoring/move/ui/K2MoveSourceModel$ElementSource;", "target", "Lorg/jetbrains/kotlin/idea/k2/refactoring/move/ui/K2MoveTargetModel$File;", "inSourceRoot", "", "moveCallBack", "Lcom/intellij/refactoring/move/MoveCallback;", "<init>", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/kotlin/idea/k2/refactoring/move/ui/K2MoveSourceModel$ElementSource;Lorg/jetbrains/kotlin/idea/k2/refactoring/move/ui/K2MoveTargetModel$File;ZLcom/intellij/refactoring/move/MoveCallback;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getSource", "()Lorg/jetbrains/kotlin/idea/k2/refactoring/move/ui/K2MoveSourceModel$ElementSource;", "getTarget", "()Lorg/jetbrains/kotlin/idea/k2/refactoring/move/ui/K2MoveTargetModel$File;", "getInSourceRoot", "()Z", "getMoveCallBack", "()Lcom/intellij/refactoring/move/MoveCallback;", "isTargetFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "isValidRefactoring", "toDescriptor", "Lorg/jetbrains/kotlin/idea/k2/refactoring/move/descriptor/K2MoveOperationDescriptor$Declarations;", "kotlin.refactorings.move.k2"})
    @SourceDebugExtension(value={"SMAP\nK2MoveModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 K2MoveModel.kt\norg/jetbrains/kotlin/idea/k2/refactoring/move/ui/K2MoveModel$Declarations\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,338:1\n1557#2:339\n1628#2,3:340\n*S KotlinDebug\n*F\n+ 1 K2MoveModel.kt\norg/jetbrains/kotlin/idea/k2/refactoring/move/ui/K2MoveModel$Declarations\n*L\n187#1:339\n187#1:340,3\n*E\n"})
    public static final class Declarations
    extends K2MoveModel {
        @NotNull
        private final Project project;
        @NotNull
        private final K2MoveSourceModel.ElementSource source;
        @NotNull
        private final K2MoveTargetModel.File target;
        private final boolean inSourceRoot;
        @Nullable
        private final MoveCallback moveCallBack;

        public Declarations(@NotNull Project project, @NotNull K2MoveSourceModel.ElementSource source, @NotNull K2MoveTargetModel.File target, boolean inSourceRoot, @Nullable MoveCallback moveCallBack2) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            super(null);
            this.project = project;
            this.source = source;
            this.target = target;
            this.inSourceRoot = inSourceRoot;
            this.moveCallBack = moveCallBack2;
        }

        public /* synthetic */ Declarations(Project project, K2MoveSourceModel.ElementSource elementSource, K2MoveTargetModel.File file, boolean bl, MoveCallback moveCallback, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 0x10) != 0) {
                moveCallback = null;
            }
            this(project, elementSource, file, bl, moveCallback);
        }

        @Override
        @NotNull
        public Project getProject() {
            return this.project;
        }

        @NotNull
        public K2MoveSourceModel.ElementSource getSource() {
            return this.source;
        }

        @Override
        @NotNull
        public K2MoveTargetModel.File getTarget() {
            return this.target;
        }

        @Override
        public boolean getInSourceRoot() {
            return this.inSourceRoot;
        }

        @Override
        @Nullable
        public MoveCallback getMoveCallBack() {
            return this.moveCallBack;
        }

        private final boolean isTargetFile(KtFile $this$isTargetFile) {
            return Intrinsics.areEqual((Object)$this$isTargetFile.getContainingDirectory(), (Object)this.getTarget().getDirectory()) && Intrinsics.areEqual((Object)$this$isTargetFile.getPackageFqName(), (Object)this.getTarget().getPkgName()) && Intrinsics.areEqual((Object)$this$isTargetFile.getName(), (Object)this.getTarget().getFileName());
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean isValidRefactoring() {
            void $this$mapTo$iv$iv;
            if (!super.isValidRefactoring()) {
                return false;
            }
            if (!MoveUiUtilKt.isValidKotlinFile(this.getTarget().getFileName())) {
                return false;
            }
            Iterable $this$map$iv = this.getSource().getElements();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                KtNamedDeclaration ktNamedDeclaration = (KtNamedDeclaration)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getContainingFile());
            }
            List files2 = (List)destination$iv$iv;
            if (files2.size() != 1) return true;
            Object object = CollectionsKt.single((List)files2);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
            if (this.isTargetFile((KtFile)object)) return false;
            return true;
        }

        @NotNull
        public K2MoveOperationDescriptor.Declarations toDescriptor() {
            return K2MoveOperationDescriptor.Companion.Declarations(this.getProject(), (Collection<? extends KtNamedDeclaration>)this.getSource().getElements(), this.getTarget().getDirectory(), this.getTarget().getFileName(), this.getTarget().getPkgName(), this.getSearchForText().getState(), this.getInSourceRoot() ? this.getSearchReferences().getState() : false, this.getSearchInComments().getState(), true, this.getMppDeclarations().getState(), this.getMoveCallBack());
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\f\u0010\u0018\u001a\u00020\t*\u00020\u0019H\u0002J\b\u0010\u001a\u001a\u00020\tH\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0016\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/idea/k2/refactoring/move/ui/K2MoveModel$Files;", "Lorg/jetbrains/kotlin/idea/k2/refactoring/move/ui/K2MoveModel;", "project", "Lcom/intellij/openapi/project/Project;", "source", "Lorg/jetbrains/kotlin/idea/k2/refactoring/move/ui/K2MoveSourceModel$FileSource;", "target", "Lorg/jetbrains/kotlin/idea/k2/refactoring/move/ui/K2MoveTargetModel$SourceDirectory;", "inSourceRoot", "", "moveCallBack", "Lcom/intellij/refactoring/move/MoveCallback;", "<init>", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/kotlin/idea/k2/refactoring/move/ui/K2MoveSourceModel$FileSource;Lorg/jetbrains/kotlin/idea/k2/refactoring/move/ui/K2MoveTargetModel$SourceDirectory;ZLcom/intellij/refactoring/move/MoveCallback;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getSource", "()Lorg/jetbrains/kotlin/idea/k2/refactoring/move/ui/K2MoveSourceModel$FileSource;", "getTarget", "()Lorg/jetbrains/kotlin/idea/k2/refactoring/move/ui/K2MoveTargetModel$SourceDirectory;", "getInSourceRoot", "()Z", "getMoveCallBack", "()Lcom/intellij/refactoring/move/MoveCallback;", "isAlreadyInTarget", "Lcom/intellij/psi/PsiFile;", "isValidRefactoring", "toDescriptor", "Lorg/jetbrains/kotlin/idea/k2/refactoring/move/descriptor/K2MoveOperationDescriptor$Files;", "kotlin.refactorings.move.k2"})
    @SourceDebugExtension(value={"SMAP\nK2MoveModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 K2MoveModel.kt\norg/jetbrains/kotlin/idea/k2/refactoring/move/ui/K2MoveModel$Files\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,338:1\n1734#2,3:339\n*S KotlinDebug\n*F\n+ 1 K2MoveModel.kt\norg/jetbrains/kotlin/idea/k2/refactoring/move/ui/K2MoveModel$Files\n*L\n142#1:339,3\n*E\n"})
    public static final class Files
    extends K2MoveModel {
        @NotNull
        private final Project project;
        @NotNull
        private final K2MoveSourceModel.FileSource source;
        @NotNull
        private final K2MoveTargetModel.SourceDirectory target;
        private final boolean inSourceRoot;
        @Nullable
        private final MoveCallback moveCallBack;

        public Files(@NotNull Project project, @NotNull K2MoveSourceModel.FileSource source, @NotNull K2MoveTargetModel.SourceDirectory target, boolean inSourceRoot, @Nullable MoveCallback moveCallBack2) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            super(null);
            this.project = project;
            this.source = source;
            this.target = target;
            this.inSourceRoot = inSourceRoot;
            this.moveCallBack = moveCallBack2;
        }

        public /* synthetic */ Files(Project project, K2MoveSourceModel.FileSource fileSource, K2MoveTargetModel.SourceDirectory sourceDirectory, boolean bl, MoveCallback moveCallback, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 0x10) != 0) {
                moveCallback = null;
            }
            this(project, fileSource, sourceDirectory, bl, moveCallback);
        }

        @Override
        @NotNull
        public Project getProject() {
            return this.project;
        }

        @NotNull
        public K2MoveSourceModel.FileSource getSource() {
            return this.source;
        }

        @Override
        @NotNull
        public K2MoveTargetModel.SourceDirectory getTarget() {
            return this.target;
        }

        @Override
        public boolean getInSourceRoot() {
            return this.inSourceRoot;
        }

        @Override
        @Nullable
        public MoveCallback getMoveCallBack() {
            return this.moveCallBack;
        }

        private final boolean isAlreadyInTarget(PsiFile $this$isAlreadyInTarget) {
            PsiFile psiFile;
            return Intrinsics.areEqual((Object)$this$isAlreadyInTarget.getParent(), (Object)this.getTarget().getDirectory()) && ((psiFile = $this$isAlreadyInTarget) instanceof PsiJavaFile ? Intrinsics.areEqual((Object)((PsiJavaFile)$this$isAlreadyInTarget).getPackageName(), (Object)this.getTarget().getPkgName().asString()) : (psiFile instanceof KtFile ? Intrinsics.areEqual((Object)((KtFile)$this$isAlreadyInTarget).getPackageFqName(), (Object)this.getTarget().getPkgName()) : true));
        }

        @Override
        public boolean isValidRefactoring() {
            boolean bl;
            block4: {
                if (!super.isValidRefactoring()) {
                    return false;
                }
                Iterable $this$all$iv = this.getSource().getElements();
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        PsiFileSystemItem it = (PsiFileSystemItem)element$iv;
                        boolean bl2 = false;
                        if (it instanceof PsiFile && this.isAlreadyInTarget((PsiFile)it)) continue;
                        bl = false;
                        break block4;
                    }
                    bl = true;
                }
            }
            return !bl;
        }

        @NotNull
        public K2MoveOperationDescriptor.Files toDescriptor() {
            K2MoveSourceDescriptor.FileSource srcDescr = this.getSource().toDescriptor();
            K2MoveTargetDescriptor.Directory targetDescr = this.getTarget().toDescriptor();
            boolean searchReferences = this.getInSourceRoot() ? this.getSearchReferences().getState() : false;
            K2MoveDescriptor.Files moveDescriptor = new K2MoveDescriptor.Files(this.getProject(), srcDescr, targetDescr);
            K2MoveOperationDescriptor.Files operationDescriptor = new K2MoveOperationDescriptor.Files(this.getProject(), CollectionsKt.listOf((Object)moveDescriptor), this.getSearchForText().getState(), searchReferences, this.getSearchInComments().getState(), true, this.getMoveCallBack());
            return operationDescriptor;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0016\b\u0002\u0012\u000b\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\fR\u0013\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000b\u001a\u00020\fX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/k2/refactoring/move/ui/K2MoveModel$Setting;", "", "text", "", "Lcom/intellij/openapi/util/NlsContexts$Checkbox;", "<init>", "(Ljava/lang/String;ILjava/lang/String;)V", "SEARCH_FOR_TEXT", "SEARCH_IN_COMMENTS", "SEARCH_REFERENCES", "MPP_DECLARATIONS", "state", "", "getState", "()Z", "setState", "(Z)V", "createComboBox", "", "panel", "Lcom/intellij/ui/dsl/builder/Panel;", "enabled", "kotlin.refactorings.move.k2"})
    public static final abstract class Setting
    extends Enum<Setting> {
        @NotNull
        private final String text;
        public static final /* enum */ Setting SEARCH_FOR_TEXT = new SEARCH_FOR_TEXT("SEARCH_FOR_TEXT", 0);
        public static final /* enum */ Setting SEARCH_IN_COMMENTS = new SEARCH_IN_COMMENTS("SEARCH_IN_COMMENTS", 1);
        public static final /* enum */ Setting SEARCH_REFERENCES = new SEARCH_REFERENCES("SEARCH_REFERENCES", 2);
        public static final /* enum */ Setting MPP_DECLARATIONS = new MPP_DECLARATIONS("MPP_DECLARATIONS", 3);
        private static final /* synthetic */ Setting[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private Setting(String text) {
            this.text = text;
        }

        public abstract boolean getState();

        public abstract void setState(boolean var1);

        public final void createComboBox(@NotNull Panel panel, boolean enabled) {
            Intrinsics.checkNotNullParameter((Object)panel, (String)"panel");
            Panel.row$default((Panel)panel, null, arg_0 -> Setting.createComboBox$lambda$0(this, enabled, arg_0), (int)1, null).layout(RowLayout.PARENT_GRID);
        }

        public static /* synthetic */ void createComboBox$default(Setting setting2, Panel panel, boolean bl, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createComboBox");
            }
            if ((n & 2) != 0) {
                bl = true;
            }
            setting2.createComboBox(panel, bl);
        }

        public static Setting[] values() {
            return (Setting[])$VALUES.clone();
        }

        public static Setting valueOf(String value) {
            return Enum.valueOf(Setting.class, value);
        }

        @NotNull
        public static EnumEntries<Setting> getEntries() {
            return $ENTRIES;
        }

        private static final Unit createComboBox$lambda$0(Setting this$0, boolean $enabled, Row $this$row) {
            Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
            Cell checkBox = $this$row.checkBox(this$0.text).enabled($enabled);
            Cell cell = $enabled ? ButtonKt.bindSelected((Cell)checkBox, (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl((Object)this$0){

                public Object get() {
                    return ((Setting)((Object)this.receiver)).getState();
                }

                public void set(Object value) {
                    ((Setting)((Object)this.receiver)).setState((Boolean)value);
                }
            })) : ButtonKt.selected((Cell)checkBox, (boolean)false);
            return Unit.INSTANCE;
        }

        public /* synthetic */ Setting(String $enum$name, int $enum$ordinal, String text, DefaultConstructorMarker $constructor_marker) {
            this(text);
        }

        static {
            $VALUES = settingArray = new Setting[]{Setting.SEARCH_FOR_TEXT, Setting.SEARCH_IN_COMMENTS, Setting.SEARCH_REFERENCES, Setting.MPP_DECLARATIONS};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0013\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001R$\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u00038V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"org/jetbrains/kotlin/idea/k2/refactoring/move/ui/K2MoveModel.Setting.MPP_DECLARATIONS", "Lorg/jetbrains/kotlin/idea/k2/refactoring/move/ui/K2MoveModel$Setting;", "value", "", "state", "getState", "()Z", "setState", "(Z)V", "kotlin.refactorings.move.k2"})
        static final class MPP_DECLARATIONS
        extends Setting {
            /*
             * WARNING - void declaration
             */
            MPP_DECLARATIONS() {
                void var1_1;
            }

            @Override
            public boolean getState() {
                return KotlinCommonRefactoringSettings.Companion.getInstance().getMOVE_MPP_DECLARATIONS();
            }

            @Override
            public void setState(boolean value) {
                KotlinCommonRefactoringSettings.Companion.getInstance().setMOVE_MPP_DECLARATIONS(value);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0013\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001R$\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u00038V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"org/jetbrains/kotlin/idea/k2/refactoring/move/ui/K2MoveModel.Setting.SEARCH_FOR_TEXT", "Lorg/jetbrains/kotlin/idea/k2/refactoring/move/ui/K2MoveModel$Setting;", "value", "", "state", "getState", "()Z", "setState", "(Z)V", "kotlin.refactorings.move.k2"})
        static final class SEARCH_FOR_TEXT
        extends Setting {
            /*
             * WARNING - void declaration
             */
            SEARCH_FOR_TEXT() {
                void var1_1;
            }

            @Override
            public boolean getState() {
                return KotlinCommonRefactoringSettings.Companion.getInstance().getMOVE_SEARCH_FOR_TEXT();
            }

            @Override
            public void setState(boolean value) {
                KotlinCommonRefactoringSettings.Companion.getInstance().setMOVE_SEARCH_FOR_TEXT(value);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0013\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001R$\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u00038V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"org/jetbrains/kotlin/idea/k2/refactoring/move/ui/K2MoveModel.Setting.SEARCH_IN_COMMENTS", "Lorg/jetbrains/kotlin/idea/k2/refactoring/move/ui/K2MoveModel$Setting;", "value", "", "state", "getState", "()Z", "setState", "(Z)V", "kotlin.refactorings.move.k2"})
        static final class SEARCH_IN_COMMENTS
        extends Setting {
            /*
             * WARNING - void declaration
             */
            SEARCH_IN_COMMENTS() {
                void var1_1;
            }

            @Override
            public boolean getState() {
                return KotlinCommonRefactoringSettings.Companion.getInstance().getMOVE_SEARCH_IN_COMMENTS();
            }

            @Override
            public void setState(boolean value) {
                KotlinCommonRefactoringSettings.Companion.getInstance().setMOVE_SEARCH_IN_COMMENTS(value);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0013\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001R$\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u00038V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"org/jetbrains/kotlin/idea/k2/refactoring/move/ui/K2MoveModel.Setting.SEARCH_REFERENCES", "Lorg/jetbrains/kotlin/idea/k2/refactoring/move/ui/K2MoveModel$Setting;", "value", "", "state", "getState", "()Z", "setState", "(Z)V", "kotlin.refactorings.move.k2"})
        static final class SEARCH_REFERENCES
        extends Setting {
            /*
             * WARNING - void declaration
             */
            SEARCH_REFERENCES() {
                void var1_1;
            }

            @Override
            public boolean getState() {
                return KotlinCommonRefactoringSettings.Companion.getInstance().getMOVE_SEARCH_REFERENCES();
            }

            @Override
            public void setState(boolean value) {
                KotlinCommonRefactoringSettings.Companion.getInstance().setMOVE_SEARCH_REFERENCES(value);
            }
        }
    }
}

