/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.introduce.extractionEngine;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.ToolsImpl;
import com.intellij.openapi.project.Project;
import com.intellij.profile.codeInspection.ProjectInspectionProfileManager;
import com.intellij.psi.PsiElement;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.idea.base.codeInsight.KotlinNameSuggester;
import org.jetbrains.kotlin.idea.base.psi.unifier.KotlinPsiRange;
import org.jetbrains.kotlin.idea.core.UtilsKt;
import org.jetbrains.kotlin.idea.inspections.PublicApiImplicitTypeInspection;
import org.jetbrains.kotlin.idea.inspections.UseExpressionBodyInspection;
import org.jetbrains.kotlin.idea.intentions.RemoveExplicitTypeArgumentsIntention;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractionEngine.ExtractFunctionGenerator;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractionEngine.ExtractNameSuggester;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractionEngine.ExtractUtilKt;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractionEngine.ExtractionData;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractionEngine.ExtractionGeneratorConfiguration;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractionEngine.ExtractionResult;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractionEngine.IExtractableCodeDescriptor;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractionEngine.IExtractionData;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractionEngine.IExtractionGeneratorConfiguration;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractionEngine.IExtractionNameSuggester;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractionEngine.KotlinTypeDescriptor;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractionEngine.TypeDescriptor;
import org.jetbrains.kotlin.idea.search.usagesSearch.SearchHelpersKt;
import org.jetbrains.kotlin.idea.util.ScopeUtils;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtTypeArgumentList;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u001a\u0010\u000e\u001a\u00020\u000f*\b\u0012\u0004\u0012\u00020\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\u0004\u0018\u00010\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00020\u0016H\u0002J\u0016\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00020\u0010H\u0002J\u0010\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J4\u0010 \u001a\u00020\u0003*\b\u0012\u0004\u0012\u00020\u00020\u00102\u0006\u0010!\u001a\u00020\"2\u0018\u0010#\u001a\u0014\u0012\u0004\u0012\u00020%\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0&0$H\u0016R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/introduce/extractionEngine/Generator;", "Lorg/jetbrains/kotlin/idea/refactoring/introduce/extractionEngine/ExtractFunctionGenerator;", "Lorg/jetbrains/kotlin/types/KotlinType;", "Lorg/jetbrains/kotlin/idea/refactoring/introduce/extractionEngine/ExtractionResult;", "<init>", "()V", "nameGenerator", "Lorg/jetbrains/kotlin/idea/refactoring/introduce/extractionEngine/IExtractionNameSuggester;", "getNameGenerator", "()Lorg/jetbrains/kotlin/idea/refactoring/introduce/extractionEngine/IExtractionNameSuggester;", "createTypeDescriptor", "Lorg/jetbrains/kotlin/idea/refactoring/introduce/extractionEngine/TypeDescriptor;", "data", "Lorg/jetbrains/kotlin/idea/refactoring/introduce/extractionEngine/IExtractionData;", "collapseBody", "", "Lorg/jetbrains/kotlin/idea/refactoring/introduce/extractionEngine/IExtractionGeneratorConfiguration;", "body", "Lorg/jetbrains/kotlin/psi/KtBlockExpression;", "getPublicApiInspectionIfEnabled", "Lorg/jetbrains/kotlin/idea/inspections/PublicApiImplicitTypeInspection;", "descriptor", "Lorg/jetbrains/kotlin/idea/refactoring/introduce/extractionEngine/IExtractableCodeDescriptor;", "useExplicitReturnType", "", "config", "checkTypeArgumentsAreRedundant", "args", "Lorg/jetbrains/kotlin/psi/KtTypeArgumentList;", "resolveNameConflict", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "createExtractionResult", "declaration", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "duplicatesReplacer", "", "Lorg/jetbrains/kotlin/idea/base/psi/unifier/KotlinPsiRange;", "Lkotlin/Function0;", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nextractorUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 extractorUtil.kt\norg/jetbrains/kotlin/idea/refactoring/introduce/extractionEngine/Generator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,140:1\n1#2:141\n*E\n"})
final class Generator
extends ExtractFunctionGenerator<KotlinType, ExtractionResult> {
    @NotNull
    public static final Generator INSTANCE = new Generator();
    @NotNull
    private static final IExtractionNameSuggester<KotlinType> nameGenerator = ExtractNameSuggester.INSTANCE;

    private Generator() {
    }

    @Override
    @NotNull
    public IExtractionNameSuggester<KotlinType> getNameGenerator() {
        return nameGenerator;
    }

    @Override
    @NotNull
    public TypeDescriptor<KotlinType> createTypeDescriptor(@NotNull IExtractionData data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return new KotlinTypeDescriptor((ExtractionData)data);
    }

    @Override
    public void collapseBody(@NotNull IExtractionGeneratorConfiguration<KotlinType> $this$collapseBody, @NotNull KtBlockExpression body2) {
        Intrinsics.checkNotNullParameter($this$collapseBody, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)body2, (String)"body");
        List list2 = body2.getStatements();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getStatements(...)");
        KtExpression bodyExpression = (KtExpression)CollectionsKt.singleOrNull((List)list2);
        PsiElement psiElement = body2.getParent();
        Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtDeclarationWithBody");
        KtDeclarationWithBody bodyOwner = (KtDeclarationWithBody)psiElement;
        UseExpressionBodyInspection useExpressionBodyInspection = new UseExpressionBodyInspection();
        if (bodyExpression != null && useExpressionBodyInspection.isActiveFor(bodyOwner)) {
            useExpressionBodyInspection.simplify(bodyOwner, !this.useExplicitReturnType($this$collapseBody));
        }
    }

    private final PublicApiImplicitTypeInspection getPublicApiInspectionIfEnabled(IExtractableCodeDescriptor<KotlinType> descriptor2) {
        Project project = descriptor2.getExtractionData().getProject();
        ProjectInspectionProfileManager inspectionProfileManager = ProjectInspectionProfileManager.Companion.getInstance(project);
        InspectionProfileImpl inspectionProfile = inspectionProfileManager.getCurrentProfile();
        ToolsImpl toolsImpl = inspectionProfile.getToolsOrNull("PublicApiImplicitType", project);
        if (toolsImpl == null || (toolsImpl = toolsImpl.getDefaultState()) == null) {
            return null;
        }
        ToolsImpl state = toolsImpl;
        if (!state.isEnabled() || Intrinsics.areEqual((Object)state.getLevel(), (Object)HighlightDisplayLevel.DO_NOT_SHOW)) {
            return null;
        }
        InspectionProfileEntry inspectionProfileEntry = state.getTool().getTool();
        return inspectionProfileEntry instanceof PublicApiImplicitTypeInspection ? (PublicApiImplicitTypeInspection)inspectionProfileEntry : null;
    }

    private final boolean useExplicitReturnType(IExtractionGeneratorConfiguration<KotlinType> config2) {
        KtClassOrObject targetClass;
        IExtractableCodeDescriptor<KotlinType> descriptor2 = config2.getDescriptor();
        if (FlexibleTypesKt.isFlexible((KotlinType)descriptor2.getReturnType())) {
            return true;
        }
        PublicApiImplicitTypeInspection publicApiImplicitTypeInspection = this.getPublicApiInspectionIfEnabled(descriptor2);
        if (publicApiImplicitTypeInspection == null) {
            return false;
        }
        PublicApiImplicitTypeInspection inspection = publicApiImplicitTypeInspection;
        PsiElement psiElement = descriptor2.getExtractionData().getTargetSibling().getParent();
        KtClassBody ktClassBody = psiElement instanceof KtClassBody ? (KtClassBody)psiElement : null;
        PsiElement psiElement2 = ktClassBody != null ? ktClassBody.getParent() : null;
        KtClassOrObject ktClassOrObject = targetClass = psiElement2 instanceof KtClassOrObject ? (KtClassOrObject)psiElement2 : null;
        if (targetClass != null && targetClass.isLocal() || ExtractUtilKt.isLocal(descriptor2.getExtractionData())) {
            return false;
        }
        KtModifierKeywordToken ktModifierKeywordToken = descriptor2.getVisibility();
        if (ktModifierKeywordToken == null) {
            ktModifierKeywordToken = KtTokens.DEFAULT_VISIBILITY_KEYWORD;
        }
        KtModifierKeywordToken ktModifierKeywordToken2 = ktModifierKeywordToken;
        Intrinsics.checkNotNull((Object)ktModifierKeywordToken2);
        DescriptorVisibility visibility = UtilsKt.toVisibility(ktModifierKeywordToken2);
        return visibility.isPublicAPI() ? true : (inspection.reportInternal && Intrinsics.areEqual((Object)visibility, (Object)DescriptorVisibilities.INTERNAL) ? true : inspection.reportPrivate && Intrinsics.areEqual((Object)visibility, (Object)DescriptorVisibilities.PRIVATE));
    }

    @Override
    public boolean checkTypeArgumentsAreRedundant(@NotNull KtTypeArgumentList args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return RemoveExplicitTypeArgumentsIntention.Companion.isApplicableTo(args, false);
    }

    @Override
    public void resolveNameConflict(@NotNull KtProperty property) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        DeclarationDescriptor declarationDescriptor = SearchHelpersKt.getDescriptor((KtDeclaration)property);
        PropertyDescriptor propertyDescriptor = declarationDescriptor instanceof PropertyDescriptor ? (PropertyDescriptor)declarationDescriptor : null;
        if (propertyDescriptor != null) {
            PropertyDescriptor it = propertyDescriptor;
            boolean bl2 = false;
            bl = DescriptorUtils.isOverride((CallableMemberDescriptor)((CallableMemberDescriptor)it));
        } else {
            bl = false;
        }
        if (bl) {
            LexicalScope scope = ScopeUtils.getResolutionScope((KtElement)property);
            String string = property.getName();
            Intrinsics.checkNotNull((Object)string);
            String newName = KotlinNameSuggester.Companion.suggestNameByName(string, (Function1<? super String, Boolean>)((Function1)arg_0 -> Generator.resolveNameConflict$lambda$1(property, scope, arg_0)));
            property.setName(newName);
        }
    }

    @Override
    @NotNull
    public ExtractionResult createExtractionResult(@NotNull IExtractionGeneratorConfiguration<KotlinType> $this$createExtractionResult, @NotNull KtNamedDeclaration declaration, @NotNull Map<KotlinPsiRange, ? extends Function0<Unit>> duplicatesReplacer) {
        Intrinsics.checkNotNullParameter($this$createExtractionResult, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter(duplicatesReplacer, (String)"duplicatesReplacer");
        return new ExtractionResult((ExtractionGeneratorConfiguration)$this$createExtractionResult, declaration, duplicatesReplacer);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean resolveNameConflict$lambda$1(KtProperty $property, LexicalScope $scope, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (Intrinsics.areEqual((Object)it, (Object)$property.getName())) return false;
        Name name2 = Name.identifier((String)it);
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
        if (!ScopeUtils.getAllAccessibleVariables($scope, name2).isEmpty()) return false;
        return true;
    }
}

