/*
 * Decompiled with CFR 0.152.
 */
package tech.units.indriya.internal.simplify;

import java.util.Arrays;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.BinaryOperator;
import javax.measure.UnitConverter;
import tech.units.indriya.AbstractConverter;
import tech.units.indriya.internal.simplify.ArrayAdapter;
import tech.units.indriya.internal.simplify.BitScanner;
import tech.units.indriya.internal.simplify.Simplifier;

final class SimplificationWorker {
    private final BiPredicate<AbstractConverter, AbstractConverter> simpleComposeTest;
    private final BinaryOperator<AbstractConverter> simpleComposeAction;
    private AbstractConverter[] arrayOfConverters;

    public SimplificationWorker(BiPredicate<AbstractConverter, AbstractConverter> simpleComposeTest, BinaryOperator<AbstractConverter> simpleComposeAction) {
        this.simpleComposeTest = simpleComposeTest;
        this.simpleComposeAction = simpleComposeAction;
    }

    public AbstractConverter simplify(List<? extends UnitConverter> conversionSteps) {
        this.arrayOfConverters = conversionSteps.toArray(new AbstractConverter[0]);
        SimplificationWorker.sortToNormalFormOrder(this.arrayOfConverters);
        while (this.trySimplify() > 0) {
            SimplificationWorker.sortToNormalFormOrder(this.arrayOfConverters);
        }
        return SimplificationWorker.sequenceToConverter(this.arrayOfConverters);
    }

    private int trySimplify() {
        ArrayAdapter<AbstractConverter> adapter = ArrayAdapter.of(this.arrayOfConverters);
        int simplificationCount = adapter.visitSequentialPairsAndSimplify((a, b) -> {
            if (a.isIdentity()) {
                return b;
            }
            if (b.isIdentity()) {
                return a;
            }
            return this.simpleComposeTest.test((AbstractConverter)a, (AbstractConverter)b) ? (AbstractConverter)this.simpleComposeAction.apply((AbstractConverter)a, b) : null;
        });
        if (simplificationCount > 0) {
            this.arrayOfConverters = adapter.removeNulls(simplificationCount);
        }
        return simplificationCount;
    }

    private static void sortToNormalFormOrder(AbstractConverter[] arrayOfConverters) {
        BitScanner bitScanner = BitScanner.of(arrayOfConverters, UnitConverter::isLinear);
        bitScanner.visitBitSequences((fromIndex, toIndex) -> Arrays.sort(arrayOfConverters, fromIndex, toIndex, (a, b) -> {
            if (a.isIdentity()) {
                if (b.isIdentity()) {
                    return Simplifier.isNormalFormOrderWhenIdentity(a, b) ? -1 : 1;
                }
                return -1;
            }
            if (b.isIdentity()) {
                return 1;
            }
            return Simplifier.isNormalFormOrderWhenCommutative(a, b) ? -1 : 1;
        }));
    }

    private static AbstractConverter sequenceToConverter(AbstractConverter[] sequence2) {
        if (sequence2 == null || sequence2.length == 0) {
            return AbstractConverter.IDENTITY;
        }
        if (sequence2.length == 1) {
            AbstractConverter singleton = sequence2[0];
            return singleton;
        }
        AbstractConverter.Pair start = new AbstractConverter.Pair(sequence2[0], sequence2[1]);
        return Arrays.stream(sequence2).skip(2L).reduce(start, (tree, next) -> new AbstractConverter.Pair((UnitConverter)tree, (UnitConverter)next));
    }
}

