/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.space;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.NoSuchElementException;
import org.eclipse.sisu.inject.DeferredClass;
import org.eclipse.sisu.space.ClassSpace;
import org.eclipse.sisu.space.NamedClass;
import org.eclipse.sisu.space.ResourceEnumeration;
import org.eclipse.sisu.space.Tokens;
import org.osgi.framework.Bundle;

public final class BundleClassSpace
implements ClassSpace {
    private static final URL[] NO_URLS = new URL[0];
    private static final Enumeration<URL> NO_ENTRIES = Collections.enumeration(Collections.emptySet());
    private final Bundle bundle;
    private URL[] bundleClassPath;

    public BundleClassSpace(Bundle bundle) {
        this.bundle = bundle;
    }

    @Override
    public Class<?> loadClass(String name) {
        try {
            return this.bundle.loadClass(name);
        }
        catch (Exception e) {
            throw new TypeNotPresentException(name, e);
        }
        catch (LinkageError e) {
            throw new TypeNotPresentException(name, e);
        }
    }

    @Override
    public DeferredClass<?> deferLoadClass(String name) {
        return new NamedClass(this, name);
    }

    @Override
    public URL getResource(String name) {
        return this.bundle.getResource(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) {
        try {
            Enumeration<URL> resources = this.bundle.getResources(name);
            return null != resources ? resources : NO_ENTRIES;
        }
        catch (IOException e) {
            return NO_ENTRIES;
        }
    }

    @Override
    public Enumeration<URL> findEntries(String path, String glob, boolean recurse) {
        URL[] classPath = this.getBundleClassPath();
        Enumeration<URL> entries2 = this.bundle.findEntries(null != path ? path : "/", glob, recurse);
        if (classPath.length > 0) {
            return new ChainedEnumeration<URL>(entries2, new ResourceEnumeration(path, glob, recurse, classPath));
        }
        return null != entries2 ? entries2 : NO_ENTRIES;
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    public int hashCode() {
        return this.bundle.hashCode();
    }

    public boolean equals(Object rhs) {
        if (this == rhs) {
            return true;
        }
        if (rhs instanceof BundleClassSpace) {
            return this.bundle.equals((Object)((BundleClassSpace)rhs).bundle);
        }
        return false;
    }

    public String toString() {
        return this.bundle.toString();
    }

    private synchronized URL[] getBundleClassPath() {
        if (null == this.bundleClassPath) {
            String path = (String)this.bundle.getHeaders().get("Bundle-ClassPath");
            if (null == path) {
                this.bundleClassPath = NO_URLS;
            } else {
                ArrayList<URL> classPath = new ArrayList<URL>();
                HashSet<String> visited = new HashSet<String>();
                visited.add(".");
                for (String entry : Tokens.splitByComma(path)) {
                    URL url;
                    if (!visited.add(entry) || null == (url = this.bundle.getEntry(entry))) continue;
                    classPath.add(url);
                }
                this.bundleClassPath = classPath.isEmpty() ? NO_URLS : classPath.toArray(new URL[classPath.size()]);
            }
        }
        return this.bundleClassPath;
    }

    private static final class ChainedEnumeration<T>
    implements Enumeration<T> {
        private final Enumeration<T>[] enumerations;
        private int index;

        ChainedEnumeration(Enumeration<T> ... enumerations) {
            this.enumerations = enumerations;
        }

        @Override
        public boolean hasMoreElements() {
            while (this.index < this.enumerations.length) {
                if (null != this.enumerations[this.index] && this.enumerations[this.index].hasMoreElements()) {
                    return true;
                }
                ++this.index;
            }
            return false;
        }

        @Override
        public T nextElement() {
            if (this.hasMoreElements()) {
                return this.enumerations[this.index].nextElement();
            }
            throw new NoSuchElementException();
        }
    }
}

