/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui.cloneDialog;

import com.intellij.openapi.vcs.ui.cloneDialog.VcsCloneDialogExtensionStatusLine;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.components.panels.VerticalLayout;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.cloneDialog.VcsCloneDialogUiSpec;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.accessibility.AccessibleContext;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\f\u001a\u00020\rH\u0002J\u0013\u0010\u000e\u001a\u00020\r2\u000b\u0010\u000f\u001a\u00070\u0010\u00a2\u0006\u0002\b\u0011J\u000e\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0014J\u0014\u0010\u0015\u001a\u00020\r2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017J\u000e\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u001bJ\b\u0010\u001c\u001a\u00020\u001dH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\t0\bj\b\u0012\u0004\u0012\u00020\t`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/util/ui/cloneDialog/VcsCloneDialogExtensionListItem;", "Ljavax/swing/JPanel;", "<init>", "()V", "iconLabel", "Ljavax/swing/JLabel;", "titleLabel", "labelsPool", "Ljava/util/ArrayList;", "Lcom/intellij/ui/SimpleColoredComponent;", "Lkotlin/collections/ArrayList;", "additionalLinesPanel", "relayout", "", "setTitle", "title", "", "Lorg/jetbrains/annotations/Nls;", "setIcon", "icon", "Ljavax/swing/Icon;", "setAdditionalStatusLines", "additionalLines", "", "Lcom/intellij/openapi/vcs/ui/cloneDialog/VcsCloneDialogExtensionStatusLine;", "setTitleForeground", "foreground", "Ljava/awt/Color;", "getAccessibleContext", "Ljavax/accessibility/AccessibleContext;", "intellij.platform.vcs.impl"})
@ApiStatus.Internal
public class VcsCloneDialogExtensionListItem
extends JPanel {
    @NotNull
    private final JLabel iconLabel = new JLabel();
    @NotNull
    private final JLabel titleLabel = new JLabel();
    @NotNull
    private final ArrayList<SimpleColoredComponent> labelsPool = new ArrayList();
    @NotNull
    private final JPanel additionalLinesPanel = new JPanel((LayoutManager)new VerticalLayout(0, 2));

    public VcsCloneDialogExtensionListItem() {
        super(new GridBagLayout());
        this.setBorder((Border)JBUI.Borders.empty((int)8, (int)10));
        this.relayout();
    }

    private final void relayout() {
        GridBag gbc = new GridBag().nextLine().next().insets((Insets)JBUI.insetsRight((int)6)).weightx(0.0).anchor(21).fillCellNone();
        this.add((Component)this.iconLabel, gbc);
        gbc = gbc.next().weightx(1.0).insets((Insets)JBInsets.emptyInsets()).fillCellHorizontally();
        this.titleLabel.setFont((Font)JBUI.Fonts.label().asBold());
        this.add((Component)this.titleLabel, gbc);
        gbc = gbc.nextLine().next().next().insets((Insets)JBInsets.emptyInsets()).fillCellHorizontally();
        this.add((Component)this.additionalLinesPanel, gbc);
    }

    public final void setTitle(@NotNull String title) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        this.titleLabel.setText(title);
    }

    public final void setIcon(@NotNull Icon icon) {
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        float scale = VcsCloneDialogUiSpec.ExtensionsList.INSTANCE.getIconSize().getFloat() / (float)icon.getIconWidth();
        this.iconLabel.setIcon(IconUtil.scale((Icon)icon, null, (float)scale));
    }

    public final void setAdditionalStatusLines(@NotNull List<VcsCloneDialogExtensionStatusLine> additionalLines) {
        Intrinsics.checkNotNullParameter(additionalLines, (String)"additionalLines");
        this.additionalLinesPanel.removeAll();
        while (this.labelsPool.size() < additionalLines.size()) {
            this.labelsPool.add(new SimpleColoredComponent());
        }
        Iterator iterator = ((Iterable)additionalLines).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            SimpleColoredComponent component;
            int index = n++;
            VcsCloneDialogExtensionStatusLine line = (VcsCloneDialogExtensionStatusLine)iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)this.labelsPool.get(index), (String)"get(...)");
            component.setIpad((Insets)JBInsets.emptyInsets());
            component.clear();
            component.append(line.getText(), line.getAttribute(), (Object)line.getActionListener());
            this.additionalLinesPanel.add((Component)component);
        }
    }

    public final void setTitleForeground(@NotNull Color foreground) {
        Intrinsics.checkNotNullParameter((Object)foreground, (String)"foreground");
        this.titleLabel.setForeground(foreground);
    }

    @Override
    @NotNull
    public AccessibleContext getAccessibleContext() {
        AccessibleContext accessibleContext = this.titleLabel.getAccessibleContext();
        Intrinsics.checkNotNullExpressionValue((Object)accessibleContext, (String)"getAccessibleContext(...)");
        return accessibleContext;
    }
}

