/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrStarProjection;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypeProjection;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.utils.DFS;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u001c\u0010\u0007\u001a\u00020\u0005*\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a\u0014\u0010\r\u001a\u00020\u0005*\u00020\u000e2\u0006\u0010\t\u001a\u00020\nH\u0000\u001a\f\u0010\u000f\u001a\u00020\u0005*\u00020\u000eH\u0000\u001a\f\u0010\u0010\u001a\u00020\u0005*\u00020\bH\u0002\"\u001a\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0003\"\u0018\u0010\u0004\u001a\u00020\u0005*\u00020\u00018@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0006\u00a8\u0006\u0011"}, d2={"superClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "getSuperClass", "(Lorg/jetbrains/kotlin/ir/declarations/IrClass;)Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "isCollectionSubClass", "", "(Lorg/jetbrains/kotlin/ir/declarations/IrClass;)Z", "isArrayOrNullableArrayOf", "Lorg/jetbrains/kotlin/ir/types/IrType;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "element", "Lorg/jetbrains/kotlin/ir/symbols/IrClassifierSymbol;", "isGenericToArray", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "isNonGenericToArray", "isArrayOrNullableArray", "backend.jvm.lower"})
@SourceDebugExtension(value={"SMAP\nToArrayLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ToArrayLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/ToArrayLoweringKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,169:1\n1611#2,9:170\n1863#2:179\n1864#2:182\n1620#2:183\n1#3:180\n1#3:181\n*S KotlinDebug\n*F\n+ 1 ToArrayLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/ToArrayLoweringKt\n*L\n142#1:170,9\n142#1:179\n142#1:182\n142#1:183\n142#1:181\n*E\n"})
public final class ToArrayLoweringKt {
    /*
     * WARNING - void declaration
     */
    private static final IrClass getSuperClass(IrClass $this$superClass) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = $this$superClass.getSuperTypes();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            IrClass irClass;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            IrType it = (IrType)element$iv$iv;
            boolean bl2 = false;
            if (IrTypesKt.getClass(it) != null) {
                IrClass irClass2;
                IrClass superClass = irClass2;
                boolean bl3 = false;
                irClass = IrUtilsKt.isClass(superClass) ? irClass2 : null;
            } else {
                irClass = null;
            }
            if (irClass == null) continue;
            IrClass it$iv$iv = irClass;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (IrClass)CollectionsKt.singleOrNull((List)destination$iv$iv);
    }

    public static final boolean isCollectionSubClass(@NotNull IrClass $this$isCollectionSubClass) {
        Intrinsics.checkNotNullParameter($this$isCollectionSubClass, "<this>");
        Boolean bl = DFS.ifAny((Collection)$this$isCollectionSubClass.getSuperTypes(), ToArrayLoweringKt::_get_isCollectionSubClass_$lambda$2, ToArrayLoweringKt::_get_isCollectionSubClass_$lambda$3);
        Intrinsics.checkNotNullExpressionValue(bl, "ifAny(...)");
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isArrayOrNullableArrayOf(IrType $this$isArrayOrNullableArrayOf, JvmBackendContext context, IrClassifierSymbol element) {
        IrClassifierSymbol irClassifierSymbol;
        if (!($this$isArrayOrNullableArrayOf instanceof IrSimpleType)) return false;
        if (!IrTypePredicatesKt.isArray($this$isArrayOrNullableArrayOf)) {
            if (!IrTypePredicatesKt.isNullableArray($this$isArrayOrNullableArrayOf)) return false;
        }
        if (((IrSimpleType)$this$isArrayOrNullableArrayOf).getArguments().size() != 1) return false;
        IrTypeArgument it = ((IrSimpleType)$this$isArrayOrNullableArrayOf).getArguments().get(0);
        if (it instanceof IrStarProjection) {
            irClassifierSymbol = context.getIrBuiltIns().getAnyClass();
        } else {
            if (!(it instanceof IrTypeProjection)) throw new NoWhenBranchMatchedException();
            irClassifierSymbol = ((IrTypeProjection)it).getVariance() == Variance.IN_VARIANCE ? (IrClassifierSymbol)context.getIrBuiltIns().getAnyClass() : IrTypesKt.getClassifierOrNull(((IrTypeProjection)it).getType());
        }
        if (!Intrinsics.areEqual(element, irClassifierSymbol)) return false;
        return true;
    }

    public static final boolean isGenericToArray(@NotNull IrSimpleFunction $this$isGenericToArray, @NotNull JvmBackendContext context) {
        Intrinsics.checkNotNullParameter($this$isGenericToArray, "<this>");
        Intrinsics.checkNotNullParameter(context, "context");
        return Intrinsics.areEqual($this$isGenericToArray.getName().asString(), "toArray") && $this$isGenericToArray.getTypeParameters().size() == 1 && $this$isGenericToArray.getValueParameters().size() == 1 && $this$isGenericToArray.getExtensionReceiverParameter() == null && ToArrayLoweringKt.isArrayOrNullableArrayOf($this$isGenericToArray.getReturnType(), context, $this$isGenericToArray.getTypeParameters().get(0).getSymbol()) && ToArrayLoweringKt.isArrayOrNullableArrayOf($this$isGenericToArray.getValueParameters().get(0).getType(), context, $this$isGenericToArray.getTypeParameters().get(0).getSymbol());
    }

    public static final boolean isNonGenericToArray(@NotNull IrSimpleFunction $this$isNonGenericToArray) {
        Intrinsics.checkNotNullParameter($this$isNonGenericToArray, "<this>");
        return Intrinsics.areEqual($this$isNonGenericToArray.getName().asString(), "toArray") && $this$isNonGenericToArray.getTypeParameters().isEmpty() && $this$isNonGenericToArray.getValueParameters().isEmpty() && $this$isNonGenericToArray.getExtensionReceiverParameter() == null && ToArrayLoweringKt.isArrayOrNullableArray($this$isNonGenericToArray.getReturnType());
    }

    private static final boolean isArrayOrNullableArray(IrType $this$isArrayOrNullableArray) {
        return $this$isArrayOrNullableArray instanceof IrSimpleType && (IrTypePredicatesKt.isArray($this$isArrayOrNullableArray) || IrTypePredicatesKt.isNullableArray($this$isArrayOrNullableArray));
    }

    private static final Iterable _get_isCollectionSubClass_$lambda$2(IrType it) {
        Intrinsics.checkNotNull(it);
        Object object = IrTypesKt.getClass(it);
        return object != null && (object = ((IrClass)object).getSuperTypes()) != null ? (Iterable)object : (Iterable)CollectionsKt.emptyList();
    }

    private static final Boolean _get_isCollectionSubClass_$lambda$3(IrType it) {
        Intrinsics.checkNotNull(it);
        return IrTypePredicatesKt.isCollection(it);
    }

    public static final /* synthetic */ IrClass access$getSuperClass(IrClass $receiver) {
        return ToArrayLoweringKt.getSuperClass($receiver);
    }
}

